/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.history;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.Splitter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.ui.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.ui.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryControl;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryEntry;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryNode;
import org.eclipse.ltk.ui.refactoring.history.IRefactoringHistoryControl;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryContentProvider;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryLabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.UIJob;

public class RefactoringHistoryControl
extends Composite
implements IRefactoringHistoryControl {
    private final Set fCheckedDescriptors = new HashSet();
    protected final RefactoringHistoryControlConfiguration fControlConfiguration;
    private Text fDetailField = null;
    private Label fDetailLabel = null;
    protected CompareViewerPane fHistoryPane = null;
    protected TreeViewer fHistoryViewer = null;
    private final Set fSelectedDescriptors = new HashSet();
    private Label fSelectionLabel = null;
    private Splitter fSplitterControl = null;

    public RefactoringHistoryControl(Composite parent, RefactoringHistoryControlConfiguration configuration) {
        super(parent, 0);
        Assert.isNotNull((Object)configuration);
        this.fControlConfiguration = configuration;
    }

    public final void addCheckStateListener(ICheckStateListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.fHistoryViewer instanceof RefactoringHistoryTreeViewer) {
            RefactoringHistoryTreeViewer viewer = (RefactoringHistoryTreeViewer)this.fHistoryViewer;
            viewer.addCheckStateListener(listener);
        }
    }

    public final void addSelectionChangedListener(ISelectionChangedListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.fHistoryViewer != null) {
            this.fHistoryViewer.addSelectionChangedListener(listener);
        }
    }

    protected void createBottomButtonBar(Composite parent) {
    }

    public void createControl() {
        RefactoringCore.getHistoryService().connect();
        GridLayout layout = new GridLayout(this.getContainerColumns(), false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        this.fSplitterControl = new Splitter((Composite)this, 512);
        this.fSplitterControl.setLayoutData((Object)new GridData(1808));
        this.createRightButtonBar(this);
        Composite leftPane = new Composite((Composite)this.fSplitterControl, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 2;
        layout.verticalSpacing = 2;
        leftPane.setLayout((Layout)layout);
        this.fHistoryPane = new CompareViewerPane(leftPane, 0x800800);
        this.fHistoryPane.setTopLeft((Control)new RefactoringHistoryLabel((Composite)this.fHistoryPane, 0));
        this.fHistoryPane.setText(this.getHistoryPaneText());
        this.fHistoryPane.setLayoutData((Object)new GridData(1808));
        this.fHistoryViewer = this.createHistoryViewer((Composite)this.fHistoryPane);
        if (!this.fControlConfiguration.isTimeDisplayed()) {
            this.fHistoryViewer.setAutoExpandLevel(-1);
        }
        this.fHistoryViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.fHistoryViewer.setUseHashlookup(true);
        this.fHistoryViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.fHistoryViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.fHistoryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public final void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    RefactoringHistoryControl.this.handleSelectionChanged((IStructuredSelection)selection);
                }
            }
        });
        this.fHistoryPane.setContent(this.fHistoryViewer.getControl());
        this.createToolBar((ViewForm)this.fHistoryPane);
        this.createDetailPane((Composite)this.fSplitterControl);
        MouseAdapter listener = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                Control content = RefactoringHistoryControl.this.fHistoryPane.getContent();
                if (content != null && content.getBounds().contains(event.x, event.y)) {
                    return;
                }
                Composite control = RefactoringHistoryControl.this.fHistoryPane.getParent().getParent();
                if (control instanceof Splitter) {
                    ((Splitter)control).setMaximizedControl((Control)RefactoringHistoryControl.this.fHistoryPane.getParent());
                }
            }
        };
        this.addMouseListener((MouseListener)listener);
        this.fHistoryPane.getTopLeft().addMouseListener((MouseListener)listener);
        this.fSplitterControl.setWeights(new int[]{65, 35});
        this.createBottomButtonBar(this);
        Dialog.applyDialogFont((Control)this);
    }

    protected void createDetailLabel(Composite parent) {
        Assert.isNotNull((Object)parent);
        this.fDetailLabel = new Label(parent, 16704);
        this.fDetailLabel.setText(RefactoringUIMessages.RefactoringHistoryControl_comment_viewer_label);
        GridData data = new GridData(32);
        data.horizontalSpan = 1;
        this.fDetailLabel.setLayoutData((Object)data);
    }

    protected Composite createDetailPane(Composite parent) {
        Assert.isNotNull((Object)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(this.getDetailColumns(), true);
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.createDetailLabel(composite);
        this.createSelectionLabel(composite);
        this.fDetailField = new Text(composite, 8391434);
        this.fDetailField.setText(this.fControlConfiguration.getCommentCaption());
        GridData data = new GridData(1808);
        data.horizontalSpan = this.getDetailColumns();
        this.fDetailField.setLayoutData((Object)data);
        return composite;
    }

    protected TreeViewer createHistoryViewer(Composite parent) {
        Assert.isNotNull((Object)parent);
        if (this.fControlConfiguration.isCheckableViewer()) {
            return new RefactoringHistoryTreeViewer(parent, 768);
        }
        return new TreeViewer(parent, 768);
    }

    protected void createRightButtonBar(Composite parent) {
    }

    protected void createSelectionLabel(Composite parent) {
        Assert.isNotNull((Object)parent);
        this.fSelectionLabel = new Label(parent, 131392);
        GridData data = new GridData(128);
        data.horizontalSpan = 1;
        this.fSelectionLabel.setLayoutData((Object)data);
    }

    protected void createToolBar(ViewForm parent) {
    }

    public final void dispose() {
        RefactoringCore.getHistoryService().disconnect();
        super.dispose();
    }

    public final RefactoringDescriptorProxy[] getCheckedDescriptors() {
        if (this.fHistoryViewer instanceof RefactoringHistoryTreeViewer) {
            return this.fCheckedDescriptors.toArray(new RefactoringDescriptorProxy[this.fCheckedDescriptors.size()]);
        }
        return this.getSelectedDescriptors();
    }

    protected int getContainerColumns() {
        return 2;
    }

    protected RefactoringHistoryContentProvider getContentProvider() {
        return this.fControlConfiguration.getContentProvider();
    }

    public final Control getControl() {
        return this;
    }

    private Collection getCoveredDescriptors(Object element) {
        Assert.isNotNull((Object)element);
        HashSet set = new HashSet();
        this.getCoveredDescriptors(element, set);
        return set;
    }

    private void getCoveredDescriptors(Object element, Set set) {
        Assert.isNotNull((Object)element);
        Assert.isNotNull((Object)set);
        RefactoringHistoryContentProvider provider = (RefactoringHistoryContentProvider)this.fHistoryViewer.getContentProvider();
        if (provider != null) {
            if (element instanceof RefactoringHistoryEntry) {
                RefactoringHistoryEntry entry = (RefactoringHistoryEntry)element;
                RefactoringDescriptorProxy proxy = entry.getDescriptor();
                set.add(proxy);
            } else {
                Object[] children = provider.getChildren(element);
                int index = 0;
                while (index < children.length) {
                    Object child = children[index];
                    if (child instanceof RefactoringHistoryNode) {
                        this.getCoveredDescriptors(child, set);
                    }
                    ++index;
                }
            }
        }
    }

    protected int getDetailColumns() {
        return 2;
    }

    private String getHistoryPaneText() {
        String text = null;
        IProject project = this.fControlConfiguration.getProject();
        text = project != null ? Messages.format(this.fControlConfiguration.getProjectPattern(), BasicElementLabels.getResourceName((IResource)project)) : this.fControlConfiguration.getWorkspaceCaption();
        return text;
    }

    public final RefactoringHistory getInput() {
        return (RefactoringHistory)this.fHistoryViewer.getInput();
    }

    protected RefactoringHistoryLabelProvider getLabelProvider() {
        return this.fControlConfiguration.getLabelProvider();
    }

    public final RefactoringDescriptorProxy[] getSelectedDescriptors() {
        return this.fSelectedDescriptors.toArray(new RefactoringDescriptorProxy[this.fSelectedDescriptors.size()]);
    }

    protected void handleCheckStateChanged() {
        RefactoringHistory history;
        if (this.fSelectionLabel != null && (history = this.getInput()) != null) {
            int total = history.getDescriptors().length;
            int checked = this.fCheckedDescriptors.size();
            if (this.fSelectionLabel.isEnabled()) {
                if (total > 0 && this.fControlConfiguration.isCheckableViewer()) {
                    this.fSelectionLabel.setText(Messages.format(RefactoringUIMessages.RefactoringHistoryControl_selection_pattern, new String[]{String.valueOf(checked), String.valueOf(total)}));
                } else {
                    this.fSelectionLabel.setText(RefactoringUIMessages.RefactoringHistoryControl_no_selection);
                }
            } else {
                this.fSelectionLabel.setText("");
            }
        }
    }

    protected void handleSelectionChanged(IStructuredSelection selection) {
        Assert.isNotNull((Object)selection);
        this.fSelectedDescriptors.clear();
        Object[] elements = selection.toArray();
        int index = 0;
        while (index < elements.length) {
            Object element = elements[index];
            if (element instanceof RefactoringHistoryEntry) {
                RefactoringHistoryEntry entry = (RefactoringHistoryEntry)element;
                RefactoringDescriptorProxy proxy = entry.getDescriptor();
                this.fSelectedDescriptors.add(proxy);
            } else if (element instanceof RefactoringHistoryNode) {
                RefactoringHistoryNode node = (RefactoringHistoryNode)element;
                this.fSelectedDescriptors.addAll(this.getCoveredDescriptors(node));
            }
            ++index;
        }
        if (elements.length == 1 && elements[0] instanceof RefactoringHistoryEntry) {
            RefactoringHistoryEntry entry = (RefactoringHistoryEntry)elements[0];
            final RefactoringDescriptorProxy proxy = entry.getDescriptor();
            UIJob job = new UIJob(RefactoringUIMessages.RefactoringHistoryControl_resolving_information){

                public final IStatus runInUIThread(IProgressMonitor monitor) {
                    RefactoringDescriptor descriptor = proxy.requestDescriptor(monitor);
                    if (descriptor != null) {
                        String comment = descriptor.getComment();
                        if ("".equals(comment)) {
                            comment = RefactoringUIMessages.RefactoringHistoryControl_no_comment;
                        }
                        RefactoringHistoryControl.this.fDetailField.setText(comment);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        } else {
            this.fDetailField.setText(this.fControlConfiguration.getCommentCaption());
        }
    }

    public void reconcileCheckState() {
        RefactoringHistory history = this.getInput();
        if (history != null && this.fHistoryViewer instanceof RefactoringHistoryTreeViewer) {
            ((RefactoringHistoryTreeViewer)this.fHistoryViewer).reconcileCheckState(history);
        }
    }

    public void reconcileSelectionState() {
        Object[] nodes = new RefactoringHistoryNode[this.fSelectedDescriptors.size()];
        int index = 0;
        Iterator iterator = this.fSelectedDescriptors.iterator();
        while (iterator.hasNext()) {
            RefactoringDescriptorProxy descriptor = (RefactoringDescriptorProxy)iterator.next();
            nodes[index] = new RefactoringHistoryEntry(null, descriptor);
            this.fHistoryViewer.expandToLevel(nodes[index], -1);
            ++index;
        }
        this.fHistoryViewer.setSelection((ISelection)new StructuredSelection(nodes), true);
    }

    public final void removeCheckStateListener(ICheckStateListener listener) {
        Assert.isNotNull((Object)listener);
        Assert.isNotNull((Object)listener);
        if (this.fHistoryViewer instanceof RefactoringHistoryTreeViewer) {
            RefactoringHistoryTreeViewer viewer = (RefactoringHistoryTreeViewer)this.fHistoryViewer;
            viewer.removeCheckStateListener(listener);
        }
    }

    public final void removeSelectionChangedListener(ISelectionChangedListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.fHistoryViewer != null) {
            this.fHistoryViewer.removeSelectionChangedListener(listener);
        }
    }

    public final void setCheckedDescriptors(RefactoringDescriptorProxy[] descriptors) {
        Assert.isNotNull((Object)descriptors);
        if (this.fHistoryViewer instanceof RefactoringHistoryTreeViewer) {
            this.fCheckedDescriptors.clear();
            this.fCheckedDescriptors.addAll(Arrays.asList(descriptors));
            RefactoringHistoryTreeViewer viewer = (RefactoringHistoryTreeViewer)this.fHistoryViewer;
            RefactoringHistory history = this.getInput();
            if (history != null) {
                viewer.reconcileCheckState(history);
            }
            this.handleCheckStateChanged();
        } else {
            this.setSelectedDescriptors(descriptors);
        }
    }

    protected void setExpandedState() {
        RefactoringHistoryContentProvider provider = (RefactoringHistoryContentProvider)this.fHistoryViewer.getContentProvider();
        if (provider != null) {
            this.handleCheckStateChanged();
            Object[] roots = provider.getRootElements();
            if (roots != null) {
                int index = 0;
                while (index < roots.length) {
                    if (!(roots[index] instanceof RefactoringHistoryEntry)) {
                        this.fHistoryViewer.setExpandedState(roots[index], true);
                        return;
                    }
                    ++index;
                }
            }
        }
    }

    protected void setHistoryControlEnablement() {
        RefactoringDescriptorProxy[] proxies;
        boolean enable = false;
        RefactoringHistory history = (RefactoringHistory)this.fHistoryViewer.getInput();
        if (history != null && (proxies = history.getDescriptors()).length > 0) {
            enable = true;
        }
        if (this.fDetailField != null) {
            this.fDetailField.setEnabled(enable);
        }
        if (this.fDetailLabel != null) {
            this.fDetailLabel.setEnabled(enable);
        }
        if (this.fHistoryPane != null) {
            this.fHistoryPane.setEnabled(enable);
        }
        if (this.fSelectionLabel != null) {
            this.fSelectionLabel.setEnabled(enable);
        }
        if (enable) {
            this.fDetailField.setText(this.fControlConfiguration.getCommentCaption());
            if (this.fSelectionLabel != null) {
                this.fSelectionLabel.setText(RefactoringUIMessages.RefactoringHistoryControl_no_selection);
            }
        } else {
            this.fDetailField.setText("");
            if (this.fSelectionLabel != null) {
                this.fSelectionLabel.setText("");
            }
        }
    }

    public void setInput(RefactoringHistory history) {
        RefactoringHistoryContentProvider provider;
        this.fHistoryViewer.setInput((Object)history);
        this.fSelectedDescriptors.clear();
        this.fCheckedDescriptors.clear();
        if (history != null && (provider = (RefactoringHistoryContentProvider)this.fHistoryViewer.getContentProvider()) != null) {
            provider.inputChanged((Viewer)this.fHistoryViewer, null, history);
            this.setHistoryControlEnablement();
        }
    }

    public final void setSelectedDescriptors(RefactoringDescriptorProxy[] descriptors) {
        Assert.isNotNull((Object)descriptors);
        if (this.fHistoryViewer != null) {
            this.fSelectedDescriptors.clear();
            this.fSelectedDescriptors.addAll(Arrays.asList(descriptors));
            Object[] nodes = new RefactoringHistoryNode[descriptors.length];
            int index = 0;
            while (index < descriptors.length) {
                nodes[index] = new RefactoringHistoryEntry(null, descriptors[index]);
                ++index;
            }
            this.fHistoryViewer.setSelection((ISelection)new StructuredSelection(nodes));
        }
    }

    protected final class RefactoringHistoryLabel
    extends CLabel {
        public RefactoringHistoryLabel(Composite parent, int style) {
            super(parent, style);
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            return super.computeSize(wHint, Math.max(24, hHint), changed);
        }

        public Color getForeground() {
            if (this.isEnabled()) {
                return super.getForeground();
            }
            return this.getDisplay().getSystemColor(18);
        }
    }

    protected final class RefactoringHistoryTreeViewer
    extends CheckboxTreeViewer {
        public RefactoringHistoryTreeViewer(Composite parent, int style) {
            super(parent, style);
            this.addCheckStateListener(new ICheckStateListener(this){
                final /* synthetic */ RefactoringHistoryTreeViewer this$1;
                {
                    this.this$1 = refactoringHistoryTreeViewer;
                }

                public final void checkStateChanged(CheckStateChangedEvent event) {
                    RefactoringHistoryTreeViewer.access$0(this.this$1, event.getElement(), event.getChecked());
                    RefactoringHistoryTreeViewer.access$3(this.this$1).handleCheckStateChanged();
                }
            });
            this.addTreeListener(new ITreeViewerListener(this){
                final /* synthetic */ RefactoringHistoryTreeViewer this$1;
                {
                    this.this$1 = refactoringHistoryTreeViewer;
                }

                public final void treeCollapsed(TreeExpansionEvent event) {
                }

                public final void treeExpanded(TreeExpansionEvent event) {
                    BusyIndicator.showWhile((Display)RefactoringHistoryTreeViewer.access$3(this.this$1).getDisplay(), (Runnable)new Runnable(this, event){
                        final /* synthetic */ 2 this$2;
                        private final /* synthetic */ TreeExpansionEvent val$event;
                        {
                            this.this$2 = var1_1;
                            this.val$event = treeExpansionEvent;
                        }

                        public final void run() {
                            Object element = this.val$event.getElement();
                            if (2.access$0(this.this$2).getGrayed(element)) {
                                RefactoringHistory history = RefactoringHistoryTreeViewer.access$3(2.access$0(this.this$2)).getInput();
                                if (history != null) {
                                    RefactoringHistoryTreeViewer.access$1(2.access$0(this.this$2), history);
                                }
                            } else if (2.access$0(this.this$2).getChecked(element)) {
                                RefactoringHistoryTreeViewer.access$2(2.access$0(this.this$2), element, false);
                                2.access$0(this.this$2).setSubtreeChecked(element, true);
                            }
                        }
                    });
                }

                static /* synthetic */ RefactoringHistoryTreeViewer access$0(2 var0) {
                    return var0.this$1;
                }
            });
        }

        private Object[] getChildren(Object element) {
            return ((RefactoringHistoryContentProvider)this.getContentProvider()).getChildren(element);
        }

        private void reconcileCheckState(Object element) {
            Object[] children = this.getChildren(element);
            int index = 0;
            while (index < children.length) {
                this.reconcileCheckState(children[index]);
                ++index;
            }
            int checkCount = 0;
            Collection collection = RefactoringHistoryControl.this.getCoveredDescriptors(element);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                RefactoringDescriptorProxy proxy = (RefactoringDescriptorProxy)iterator.next();
                if (!RefactoringHistoryControl.this.fCheckedDescriptors.contains(proxy)) continue;
                ++checkCount;
            }
            this.setElementChecked(element, checkCount > 0);
            this.setElementGrayed(element, checkCount != 0 && checkCount != collection.size());
        }

        private void reconcileCheckState(Object element, boolean checked) {
            if (element instanceof RefactoringHistoryEntry) {
                RefactoringHistoryEntry entry = (RefactoringHistoryEntry)element;
                RefactoringDescriptorProxy proxy = entry.getDescriptor();
                if (checked) {
                    RefactoringHistoryControl.this.fCheckedDescriptors.add(proxy);
                } else {
                    RefactoringHistoryControl.this.fCheckedDescriptors.remove(proxy);
                }
            } else if (element instanceof RefactoringHistoryNode) {
                Collection collection = RefactoringHistoryControl.this.getCoveredDescriptors(element);
                if (checked) {
                    RefactoringHistoryControl.this.fCheckedDescriptors.addAll(collection);
                } else {
                    RefactoringHistoryControl.this.fCheckedDescriptors.removeAll(collection);
                }
            }
            RefactoringHistoryControl.this.reconcileCheckState();
        }

        private void setElementChecked(Object element, boolean checked) {
            Widget widget = this.findItem(element);
            if (widget instanceof TreeItem) {
                TreeItem item = (TreeItem)widget;
                item.setChecked(checked);
            }
        }

        private void setElementGrayed(Object element, boolean grayed) {
            Widget widget = this.findItem(element);
            if (widget instanceof TreeItem) {
                TreeItem item = (TreeItem)widget;
                item.setGrayed(grayed);
            }
        }

        private void setSubTreeGrayed(Object element, boolean grayed) {
            this.setElementGrayed(element, grayed);
            Object[] children = this.getChildren(element);
            int index = 0;
            while (index < children.length) {
                this.setSubTreeGrayed(children[index], grayed);
                ++index;
            }
        }

        static /* synthetic */ void access$0(RefactoringHistoryTreeViewer refactoringHistoryTreeViewer, Object object, boolean bl) {
            refactoringHistoryTreeViewer.reconcileCheckState(object, bl);
        }

        static /* synthetic */ void access$2(RefactoringHistoryTreeViewer refactoringHistoryTreeViewer, Object object, boolean bl) {
            refactoringHistoryTreeViewer.setSubTreeGrayed(object, bl);
        }

        static /* synthetic */ RefactoringHistoryControl access$3(RefactoringHistoryTreeViewer refactoringHistoryTreeViewer) {
            return refactoringHistoryTreeViewer.RefactoringHistoryControl.this;
        }
    }
}

