/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.engine;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.engine.DebugHelper;
import org.eclipse.equinox.internal.p2.engine.ParameterizedProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.Messages;
import org.eclipse.equinox.internal.provisional.p2.engine.Operand;
import org.eclipse.equinox.internal.provisional.p2.engine.Phase;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.engine.Touchpoint;
import org.eclipse.osgi.util.NLS;

public class EngineSession {
    private static final String ENGINE_SESSION = "enginesession";
    private static final String EMPTY_STRING = "";
    private List phaseActionRecordsPairs = new ArrayList();
    private Phase currentPhase;
    boolean currentPhaseActive;
    private List currentActionRecords;
    private ActionsRecord currentRecord;
    private IProfile profile;
    private File profileDataDirectory;
    private ProvisioningContext context;
    private Set touchpoints = new HashSet();

    public EngineSession(IProfile profile, File profileDataDirectory, ProvisioningContext context) {
        this.profile = profile;
        this.profileDataDirectory = profileDataDirectory;
        this.context = context;
    }

    public File getProfileDataDirectory() {
        return this.profileDataDirectory;
    }

    IStatus prepare(IProgressMonitor monitor) {
        monitor.subTask(Messages.preparing);
        MultiStatus status = new MultiStatus("org.eclipse.equinox.p2.engine", 0, null, null);
        Iterator iterator = this.touchpoints.iterator();
        while (iterator.hasNext()) {
            Touchpoint touchpoint = (Touchpoint)iterator.next();
            try {
                status.add(touchpoint.prepare(this.profile));
            }
            catch (RuntimeException e) {
                status.add((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", NLS.bind((String)Messages.touchpoint_prepare_error, (Object)touchpoint.getClass().getName()), (Throwable)e));
            }
            catch (LinkageError e) {
                status.add((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", NLS.bind((String)Messages.touchpoint_prepare_error, (Object)touchpoint.getClass().getName()), (Throwable)e));
            }
        }
        if (status.matches(4)) {
            MultiStatus result = new MultiStatus("org.eclipse.equinox.p2.engine", 4, NLS.bind((String)Messages.session_prepare_error, (Object)this.profile.getProfileId()), null);
            result.merge((IStatus)status);
            return result;
        }
        return status;
    }

    IStatus commit(IProgressMonitor monitor) {
        monitor.subTask(Messages.committing);
        MultiStatus status = new MultiStatus("org.eclipse.equinox.p2.engine", 0, null, null);
        this.phaseActionRecordsPairs.clear();
        Iterator iterator = this.touchpoints.iterator();
        while (iterator.hasNext()) {
            Touchpoint touchpoint = (Touchpoint)iterator.next();
            try {
                IStatus result = touchpoint.commit(this.profile);
                if (result.isOK()) continue;
                status.add(result);
            }
            catch (RuntimeException e) {
                status.add((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", NLS.bind((String)Messages.touchpoint_commit_error, (Object)touchpoint.getClass().getName()), (Throwable)e));
            }
            catch (LinkageError e) {
                status.add((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", NLS.bind((String)Messages.touchpoint_commit_error, (Object)touchpoint.getClass().getName()), (Throwable)e));
            }
        }
        if (status.matches(4)) {
            MultiStatus result = new MultiStatus("org.eclipse.equinox.p2.engine", 4, NLS.bind((String)Messages.session_commit_error, (Object)this.profile.getProfileId()), null);
            result.merge((IStatus)status);
            return result;
        }
        return status;
    }

    IStatus rollback(IProgressMonitor monitor, int severity) {
        IStatus result;
        if (severity == 8) {
            monitor.subTask(Messages.rollingback_cancel);
        }
        if (severity == 4) {
            monitor.subTask(Messages.rollingback_error);
        }
        MultiStatus status = new MultiStatus("org.eclipse.equinox.p2.engine", 0, null, null);
        if (this.currentPhaseActive) {
            try {
                result = this.rollBackPhase(this.currentPhase, this.currentActionRecords);
                if (!result.isOK()) {
                    status.add(result);
                }
            }
            catch (RuntimeException e) {
                status.add((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", NLS.bind((String)Messages.phase_undo_error, (Object)this.currentPhase.getClass().getName()), (Throwable)e));
            }
            catch (LinkageError e) {
                status.add((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", NLS.bind((String)Messages.phase_undo_error, (Object)this.currentPhase.getClass().getName()), (Throwable)e));
            }
            this.currentPhaseActive = false;
            this.currentActionRecords = null;
            this.currentRecord = null;
        }
        this.currentPhase = null;
        ListIterator it = this.phaseActionRecordsPairs.listIterator(this.phaseActionRecordsPairs.size());
        while (it.hasPrevious()) {
            Object[] pair = (Object[])it.previous();
            Phase phase = (Phase)pair[0];
            List actionRecords = (List)pair[1];
            try {
                IStatus result2 = this.rollBackPhase(phase, actionRecords);
                if (result2.isOK()) continue;
                status.add(result2);
            }
            catch (RuntimeException e) {
                status.add((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", NLS.bind((String)Messages.phase_undo_error, (Object)phase.getClass().getName()), (Throwable)e));
            }
            catch (LinkageError e) {
                status.add((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", NLS.bind((String)Messages.phase_undo_error, (Object)phase.getClass().getName()), (Throwable)e));
            }
        }
        this.phaseActionRecordsPairs.clear();
        Iterator iterator = this.touchpoints.iterator();
        while (iterator.hasNext()) {
            Touchpoint touchpoint = (Touchpoint)iterator.next();
            try {
                IStatus result3 = touchpoint.rollback(this.profile);
                if (result3.isOK()) continue;
                status.add(result3);
            }
            catch (RuntimeException e) {
                status.add((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", NLS.bind((String)Messages.touchpoint_rollback_error, (Object)touchpoint.getClass().getName()), (Throwable)e));
            }
            catch (LinkageError e) {
                status.add((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", NLS.bind((String)Messages.touchpoint_rollback_error, (Object)touchpoint.getClass().getName()), (Throwable)e));
            }
        }
        if (status.matches(4)) {
            result = new MultiStatus("org.eclipse.equinox.p2.engine", 4, NLS.bind((String)Messages.session_commit_error, (Object)this.profile.getProfileId()), null);
            result.merge((IStatus)status);
            return result;
        }
        return status;
    }

    private IStatus rollBackPhase(Phase phase, List actionRecords) {
        MultiStatus result = new MultiStatus("org.eclipse.equinox.p2.engine", 0, null, null);
        if (!this.currentPhaseActive) {
            phase.prePerform(result, this, this.profile, this.context, (IProgressMonitor)new NullProgressMonitor());
        }
        ListIterator it = actionRecords.listIterator(actionRecords.size());
        while (it.hasPrevious()) {
            ActionsRecord record = (ActionsRecord)it.previous();
            ProvisioningAction[] actions = record.actions.toArray(new ProvisioningAction[record.actions.size()]);
            try {
                phase.undo(result, this, this.profile, record.operand, actions, this.context);
            }
            catch (RuntimeException e) {
                result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", NLS.bind((String)Messages.phase_undo_operand_error, (Object)phase.getClass().getName(), (Object)record.operand), (Throwable)e));
            }
            catch (LinkageError e) {
                result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", NLS.bind((String)Messages.phase_undo_operand_error, (Object)phase.getClass().getName(), (Object)record.operand), (Throwable)e));
            }
        }
        phase.postPerform(result, this.profile, this.context, (IProgressMonitor)new NullProgressMonitor());
        return result;
    }

    void recordPhaseEnter(Phase phase) {
        if (phase == null) {
            throw new IllegalArgumentException(Messages.null_phase);
        }
        if (this.currentPhase != null) {
            throw new IllegalStateException(Messages.phase_started);
        }
        this.currentPhase = phase;
        if (DebugHelper.DEBUG_ENGINE_SESSION) {
            EngineSession.debugPhaseEnter(phase);
        }
    }

    void recordPhaseStart(Phase phase) {
        if (phase == null) {
            throw new IllegalArgumentException(Messages.null_phase);
        }
        if (this.currentPhase != phase) {
            throw new IllegalArgumentException(Messages.not_current_phase);
        }
        this.currentPhaseActive = true;
        this.currentActionRecords = new ArrayList();
    }

    void recordPhaseEnd(Phase phase) {
        if (this.currentPhase == null) {
            throw new IllegalStateException(Messages.phase_not_started);
        }
        if (this.currentPhase != phase) {
            throw new IllegalArgumentException(Messages.not_current_phase);
        }
        this.phaseActionRecordsPairs.add(new Object[]{this.currentPhase, this.currentActionRecords});
        this.currentActionRecords = null;
        this.currentPhaseActive = false;
    }

    void recordPhaseExit(Phase phase) {
        if (this.currentPhase == null) {
            throw new IllegalStateException(Messages.phase_not_started);
        }
        if (this.currentPhase != phase) {
            throw new IllegalArgumentException(Messages.not_current_phase);
        }
        this.currentPhase = null;
        if (DebugHelper.DEBUG_ENGINE_SESSION) {
            EngineSession.debugPhaseExit(phase);
        }
    }

    void recordOperandStart(Operand operand) {
        if (operand == null) {
            throw new IllegalArgumentException(Messages.null_operand);
        }
        if (this.currentRecord != null) {
            throw new IllegalStateException(Messages.operand_started);
        }
        this.currentRecord = new ActionsRecord(operand);
        this.currentActionRecords.add(this.currentRecord);
        if (DebugHelper.DEBUG_ENGINE_SESSION) {
            EngineSession.debugOperandStart(operand);
        }
    }

    void recordOperandEnd(Operand operand) {
        if (this.currentRecord == null) {
            throw new IllegalStateException(Messages.operand_not_started);
        }
        if (this.currentRecord.operand != operand) {
            throw new IllegalArgumentException(Messages.not_current_operand);
        }
        this.currentRecord = null;
        if (DebugHelper.DEBUG_ENGINE_SESSION) {
            EngineSession.debugOperandEnd(operand);
        }
    }

    void recordActionExecute(ProvisioningAction action, Map parameters) {
        if (action == null) {
            throw new IllegalArgumentException(Messages.null_action);
        }
        this.currentRecord.actions.add(action);
        Touchpoint touchpoint = action.getTouchpoint();
        if (touchpoint != null) {
            this.touchpoints.add(touchpoint);
        }
        if (DebugHelper.DEBUG_ENGINE_SESSION) {
            EngineSession.debugActionExecute(action, parameters);
        }
    }

    public void recordActionUndo(ProvisioningAction action, Map parameters) {
        if (DebugHelper.DEBUG_ENGINE_SESSION) {
            EngineSession.debugActionUndo(action, parameters);
        }
    }

    public String getContextString(Phase phase, Operand operand, ProvisioningAction action) {
        if (action instanceof ParameterizedProvisioningAction) {
            ParameterizedProvisioningAction parameterizedAction = (ParameterizedProvisioningAction)action;
            action = parameterizedAction.getAction();
        }
        String message = NLS.bind((String)Messages.session_context, (Object[])new Object[]{this.profile.getProfileId(), phase.getClass().getName(), operand.toString(), this.getCurrentActionId()});
        return message;
    }

    public String getContextString() {
        String message = NLS.bind((String)Messages.session_context, (Object[])new Object[]{this.profile.getProfileId(), this.getCurrentPhaseId(), this.getCurrentOperandId(), this.getCurrentActionId()});
        return message;
    }

    private Object getCurrentActionId() {
        if (this.currentRecord == null || this.currentRecord.actions.isEmpty()) {
            return EMPTY_STRING;
        }
        Object currentAction = this.currentRecord.actions.get(this.currentRecord.actions.size() - 1);
        if (currentAction instanceof ParameterizedProvisioningAction) {
            ParameterizedProvisioningAction parameterizedAction = (ParameterizedProvisioningAction)currentAction;
            currentAction = parameterizedAction.getAction();
        }
        return currentAction.getClass().getName();
    }

    private String getCurrentPhaseId() {
        if (this.currentPhase == null) {
            return EMPTY_STRING;
        }
        return this.currentPhase.getClass().getName();
    }

    private String getCurrentOperandId() {
        if (this.currentRecord == null) {
            return EMPTY_STRING;
        }
        return this.currentRecord.operand.toString();
    }

    private static void debugPhaseEnter(Phase phase) {
        DebugHelper.debug(ENGINE_SESSION, "Entering phase: " + phase.getClass().getName());
    }

    private static void debugPhaseExit(Phase phase) {
        DebugHelper.debug(ENGINE_SESSION, "Exiting phase: " + phase.getClass().getName());
    }

    private static void debugOperandStart(Operand operand) {
        DebugHelper.debug(ENGINE_SESSION, "Starting processing of operand: " + operand.toString());
    }

    private static void debugOperandEnd(Operand operand) {
        DebugHelper.debug(ENGINE_SESSION, "Ending processing of operand: " + operand.toString());
    }

    private static void debugActionExecute(ProvisioningAction action, Map parameters) {
        DebugHelper.debug(ENGINE_SESSION, "Executing action: " + DebugHelper.formatAction(action, parameters));
    }

    private static void debugActionUndo(ProvisioningAction action, Map parameters) {
        DebugHelper.debug(ENGINE_SESSION, "Undoing action: " + DebugHelper.formatAction(action, parameters));
    }

    private static class ActionsRecord {
        Operand operand;
        List actions = new ArrayList();

        ActionsRecord(Operand operand) {
            this.operand = operand;
        }
    }
}

