/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.dialog.component;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.dialog.AttributeDialog;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.model.IAttribute;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class AttributeSettingPanel
extends Composite {
    private List<EditAttribute> attributeList = null;
    private static final int EDIT_COLUMN = 0;
    private List<IAttribute> deletedAttributes = new ArrayList<IAttribute>();
    private int selectedIndex = -1;
    private TableEditor tableEditor = null;
    private Table attributeTable = null;
    private Composite controlComposite = null;
    private Button newButton = null;
    private Button deleteButton = null;
    private Button upButton = null;
    private Button downButton = null;
    private Button descButton = null;

    public AttributeSettingPanel(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridData gridData12 = new GridData();
        gridData12.grabExcessVerticalSpace = false;
        gridData12.verticalAlignment = 4;
        gridData12.horizontalAlignment = 1;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.attributeTable = new Table((Composite)this, 65536);
        this.tableEditor = new TableEditor(this.attributeTable);
        this.tableEditor.grabHorizontal = true;
        this.tableEditor.horizontalAlignment = 16384;
        this.tableEditor.minimumWidth = 50;
        this.attributeTable.setHeaderVisible(true);
        this.attributeTable.setLayoutData((Object)gridData12);
        this.attributeTable.setLayoutData((Object)gridData);
        this.attributeTable.setLinesVisible(true);
        this.attributeTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                System.out.println("select");
                AttributeSettingPanel.this.selectedIndex = AttributeSettingPanel.this.attributeTable.getSelectionIndex();
                if (AttributeSettingPanel.this.selectedIndex == -1) {
                    return;
                }
                System.out.println(AttributeSettingPanel.this.selectedIndex);
                Control oldEditor = AttributeSettingPanel.this.tableEditor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                TableItem item = (TableItem)e.item;
                final Text text = new Text((Composite)AttributeSettingPanel.this.attributeTable, 0);
                text.setText(item.getText(0));
                text.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        TableItem item = AttributeSettingPanel.this.tableEditor.getItem();
                        String editValue = text.getText();
                        if (editValue == null) {
                            editValue = "";
                        }
                        item.setText(0, editValue);
                        EditAttribute ea = (EditAttribute)AttributeSettingPanel.this.attributeList.get(AttributeSettingPanel.this.selectedIndex);
                        ea.setName(editValue);
                        text.dispose();
                    }
                });
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        TableItem item = AttributeSettingPanel.this.tableEditor.getItem();
                        String editValue = text.getText();
                        if (editValue == null) {
                            editValue = "";
                        }
                        item.setText(0, editValue);
                        EditAttribute ea = (EditAttribute)AttributeSettingPanel.this.attributeList.get(AttributeSettingPanel.this.selectedIndex);
                        ea.setName(editValue);
                    }
                });
                text.selectAll();
                text.setFocus();
                AttributeSettingPanel.this.tableEditor.setEditor((Control)text, item, 0);
            }
        });
        TableColumn tableColumn = new TableColumn(this.attributeTable, 0);
        tableColumn.setWidth(200);
        tableColumn.setText("\u30a2\u30c8\u30ea\u30d3\u30e5\u30fc\u30c8");
        this.setLayout((Layout)gridLayout);
        this.createControlComposite();
        this.setSize(new Point(301, 150));
    }

    private void createControlComposite() {
        GridData gridData5 = new GridData();
        gridData5.horizontalAlignment = 4;
        gridData5.verticalAlignment = 2;
        GridData gridData4 = new GridData();
        gridData4.widthHint = 60;
        GridData gridData3 = new GridData();
        gridData3.widthHint = 60;
        GridData gridData2 = new GridData();
        gridData2.widthHint = 60;
        GridData gridData1 = new GridData();
        gridData1.widthHint = 60;
        this.controlComposite = new Composite((Composite)this, 0);
        this.controlComposite.setLayout((Layout)new GridLayout());
        this.newButton = new Button(this.controlComposite, 0);
        this.newButton.setText("\u65b0\u898f");
        this.newButton.setLayoutData((Object)gridData1);
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditAttribute ea = new EditAttribute();
                ea.setName("\u30a2\u30c8\u30ea\u30d3\u30e5\u30fc\u30c8" + String.valueOf(AttributeSettingPanel.this.attributeList.size() + 1));
                AttributeSettingPanel.this.attributeList.add(ea);
                TableItem item = new TableItem(AttributeSettingPanel.this.attributeTable, 0);
                item.setText(ea.getName());
                AttributeSettingPanel.this.selectedIndex = AttributeSettingPanel.this.attributeList.size() - 1;
                AttributeSettingPanel.this.updateSelection();
            }
        });
        this.upButton = new Button(this.controlComposite, 0);
        this.upButton.setText("\u4e0a\u3078");
        this.upButton.setLayoutData((Object)gridData2);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AttributeSettingPanel.this.selectedIndex == -1 || AttributeSettingPanel.this.selectedIndex == 0) {
                    return;
                }
                EditAttribute move = (EditAttribute)AttributeSettingPanel.this.attributeList.remove(AttributeSettingPanel.this.selectedIndex);
                AttributeSettingPanel attributeSettingPanel = AttributeSettingPanel.this;
                attributeSettingPanel.selectedIndex = attributeSettingPanel.selectedIndex - 1;
                AttributeSettingPanel.this.attributeList.add(AttributeSettingPanel.this.selectedIndex, move);
                AttributeSettingPanel.this.updateAttributeTable();
                AttributeSettingPanel.this.updateSelection();
            }
        });
        this.downButton = new Button(this.controlComposite, 0);
        this.downButton.setText("\u4e0b\u3078");
        this.downButton.setLayoutData((Object)gridData3);
        this.descButton = new Button(this.controlComposite, 0);
        this.descButton.setText("\u8a73\u7d30");
        this.descButton.setLayoutData((Object)gridData5);
        this.descButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AttributeSettingPanel.this.selectedIndex == -1) {
                    System.out.println("not shousai selected");
                    return;
                }
                EditAttribute edit = (EditAttribute)AttributeSettingPanel.this.attributeList.get(AttributeSettingPanel.this.selectedIndex);
                AttributeDialog dialog = new AttributeDialog(AttributeSettingPanel.this.getShell(), edit);
                System.out.println("open");
                if (dialog.open() == 0) {
                    AttributeSettingPanel.this.updateAttributeTable();
                    AttributeSettingPanel.this.updateSelection();
                }
            }
        });
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AttributeSettingPanel.this.selectedIndex == -1 || AttributeSettingPanel.this.selectedIndex == AttributeSettingPanel.this.attributeList.size() - 1) {
                    return;
                }
                EditAttribute move = (EditAttribute)AttributeSettingPanel.this.attributeList.remove(AttributeSettingPanel.this.selectedIndex);
                AttributeSettingPanel attributeSettingPanel = AttributeSettingPanel.this;
                attributeSettingPanel.selectedIndex = attributeSettingPanel.selectedIndex + 1;
                AttributeSettingPanel.this.attributeList.add(AttributeSettingPanel.this.selectedIndex, move);
                AttributeSettingPanel.this.updateAttributeTable();
                AttributeSettingPanel.this.updateSelection();
            }
        });
        this.deleteButton = new Button(this.controlComposite, 0);
        this.deleteButton.setText("\u524a\u9664");
        this.deleteButton.setLayoutData((Object)gridData4);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AttributeSettingPanel.this.selectedIndex == -1) {
                    return;
                }
                EditAttribute deleted = (EditAttribute)AttributeSettingPanel.this.attributeList.remove(AttributeSettingPanel.this.selectedIndex);
                AttributeSettingPanel.this.deletedAttributes.add(deleted.getOriginalAttribute());
                if (AttributeSettingPanel.this.attributeList.size() <= AttributeSettingPanel.this.selectedIndex) {
                    AttributeSettingPanel attributeSettingPanel = AttributeSettingPanel.this;
                    attributeSettingPanel.selectedIndex = attributeSettingPanel.selectedIndex - 1;
                }
                AttributeSettingPanel.this.updateAttributeTable();
                AttributeSettingPanel.this.updateSelection();
            }
        });
    }

    public void setAttributeTableRow(List<EditAttribute> attributeList) {
        this.attributeList = attributeList;
        this.updateAttributeTable();
    }

    private void updateAttributeTable() {
        this.attributeTable.removeAll();
        for (EditAttribute ea : this.attributeList) {
            TableItem item = new TableItem(this.attributeTable, 0);
            item.setText(0, ea.getName());
        }
    }

    private void updateSelection() {
        this.attributeTable.select(this.selectedIndex);
    }

    public List<EditAttribute> getAttributeList() {
        return this.attributeList;
    }

    public List<IAttribute> getDeletedAttributeList() {
        return this.deletedAttributes;
    }
}

