/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.dialog;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.dialog.component.AttributeSettingPanel;
import jp.sourceforge.tmdmaker.dialog.component.EntityNameAndTypeSettingPanel;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.Laputa;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LaputaEditDialog
extends Dialog {
    private EntityNameAndTypeSettingPanel panel1;
    private AttributeSettingPanel panel2;
    private List<EditAttribute> editAttributeList = new ArrayList<EditAttribute>();
    private Laputa original;
    private Laputa editedValueEntity;
    private List<IAttribute> newAttributeOrder = new ArrayList<IAttribute>();
    private List<IAttribute> addAttributes = new ArrayList<IAttribute>();
    private List<IAttribute> editAttributes = new ArrayList<IAttribute>();
    private List<IAttribute> deleteAttributes = new ArrayList<IAttribute>();

    public LaputaEditDialog(Shell parentShell, Laputa original) {
        super(parentShell);
        this.original = original;
        for (IAttribute a : this.original.getAttributes()) {
            this.editAttributeList.add(new EditAttribute(a));
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("\u30e9\u30d4\u30e5\u30bf\u7de8\u96c6");
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        this.panel1 = new EntityNameAndTypeSettingPanel(composite, 0);
        GridData gridData = new GridData(768);
        this.panel1.setLayoutData(gridData);
        gridData = new GridData(768);
        this.panel2 = new AttributeSettingPanel(composite, 0);
        this.panel2.setLayoutData(gridData);
        composite.pack();
        this.initializeValue();
        return composite;
    }

    private void initializeValue() {
        this.panel1.setEditIdentifier(new EditAttribute(this.original.getIdentifier()));
        this.panel1.setIdentifierNameText(this.original.getIdentifier().getName());
        this.panel1.setEntityNameText(this.original.getName());
        this.panel1.selectEntityTypeCombo(this.original.getEntityType());
        this.panel1.selectAutoCreateCheckBox(this.original.getIdentifier().getName(), this.original.getName());
        this.panel1.setEntityTypeComboEnabled(this.original.isEntityTypeEditable());
        this.panel2.setAttributeTableRow(this.editAttributeList);
    }

    protected void okPressed() {
        this.editedValueEntity = new Laputa();
        Identifier newIdentifier = new Identifier(this.panel1.getIdentifierName());
        EditAttribute editIdentifier = this.panel1.getEditIdentifier();
        editIdentifier.copyTo(newIdentifier);
        this.editedValueEntity.setIdentifier(newIdentifier);
        this.editedValueEntity.setName(this.panel1.getEntityName());
        this.editedValueEntity.setEntityType(this.panel1.getSelectedType());
        this.createEditAttributeResult();
        super.okPressed();
    }

    public List<EditAttribute> getEditAttributeList() {
        return this.editAttributeList;
    }

    public Laputa getEditedValueEntity() {
        return this.editedValueEntity;
    }

    public List<IAttribute> getAddAttributes() {
        return this.addAttributes;
    }

    public List<IAttribute> getEditAttributes() {
        return this.editAttributes;
    }

    public List<IAttribute> getDeleteAttributes() {
        return this.deleteAttributes;
    }

    private void createEditAttributeResult() {
        for (EditAttribute ea : this.editAttributeList) {
            IAttribute originalAttribute = ea.getOriginalAttribute();
            if (ea.isAdded()) {
                ea.copyToOriginal();
                this.addAttributes.add(ea.getOriginalAttribute());
            } else if (ea.isNameChanged()) {
                this.editAttributes.add(originalAttribute);
            }
            this.newAttributeOrder.add(originalAttribute);
        }
        this.deleteAttributes = this.panel2.getDeletedAttributeList();
        this.editedValueEntity.setAttributes(this.newAttributeOrder);
    }
}

