/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.dialog;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.dialog.component.AttributeSettingPanel;
import jp.sourceforge.tmdmaker.dialog.component.EntityNameAndTypeSettingPanel;
import jp.sourceforge.tmdmaker.dialog.component.ImplementInfoSettingPanel;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.model.Entity;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.Identifier;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class EntityEditDialog
extends Dialog {
    private EntityNameAndTypeSettingPanel panel1;
    private AttributeSettingPanel panel2;
    private ImplementInfoSettingPanel panel3;
    private List<EditAttribute> editAttributeList = new ArrayList<EditAttribute>();
    private Entity original;
    private Entity editedValueEntity;
    private List<IAttribute> newAttributeOrder = new ArrayList<IAttribute>();
    private List<IAttribute> addAttributes = new ArrayList<IAttribute>();
    private List<IAttribute> editAttributes = new ArrayList<IAttribute>();
    private List<IAttribute> deleteAttributes = new ArrayList<IAttribute>();

    public EntityEditDialog(Shell parentShell, Entity original) {
        super(parentShell);
        this.original = original;
        for (IAttribute a : this.original.getAttributes()) {
            this.editAttributeList.add(new EditAttribute(a));
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u7de8\u96c6");
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        this.panel1 = new EntityNameAndTypeSettingPanel(composite, 0);
        GridData gridData = new GridData(768);
        this.panel1.setLayoutData(gridData);
        this.panel3 = new ImplementInfoSettingPanel(composite, 0);
        gridData = new GridData(768);
        this.panel3.setLayoutData(gridData);
        gridData = new GridData(768);
        this.panel2 = new AttributeSettingPanel(composite, 0);
        this.panel2.setLayoutData(gridData);
        composite.pack();
        this.initializeValue();
        return composite;
    }

    private void initializeValue() {
        this.panel1.setEditIdentifier(new EditAttribute(this.original.getIdentifier()));
        this.panel1.setIdentifierNameText(this.original.getIdentifier().getName());
        this.panel1.setEntityNameText(this.original.getName());
        this.panel1.selectEntityTypeCombo(this.original.getEntityType());
        this.panel1.selectAutoCreateCheckBox(this.original.getIdentifier().getName(), this.original.getName());
        this.panel1.setEntityTypeComboEnabled(this.original.isEntityTypeEditable());
        this.panel3.initializeValue(this.original.isNotImplement(), this.original.getImplementName());
        this.panel2.setAttributeTableRow(this.editAttributeList);
    }

    protected void okPressed() {
        this.editedValueEntity = new Entity();
        Identifier newIdentifier = new Identifier(this.panel1.getIdentifierName());
        EditAttribute editIdentifier = this.panel1.getEditIdentifier();
        editIdentifier.copyTo(newIdentifier);
        this.editedValueEntity.setIdentifier(newIdentifier);
        this.editedValueEntity.setName(this.panel1.getEntityName());
        this.editedValueEntity.setEntityType(this.panel1.getSelectedType());
        this.editedValueEntity.setNotImplement(this.panel3.isNotImplement());
        this.editedValueEntity.setImplementName(this.panel3.getImplementName());
        this.createEditAttributeResult();
        super.okPressed();
    }

    public List<EditAttribute> getEditAttributeList() {
        return this.editAttributeList;
    }

    public Entity getEditedValueEntity() {
        return this.editedValueEntity;
    }

    public List<IAttribute> getAddAttributes() {
        return this.addAttributes;
    }

    public List<IAttribute> getEditAttributes() {
        return this.editAttributes;
    }

    public List<IAttribute> getDeleteAttributes() {
        return this.deleteAttributes;
    }

    private void createEditAttributeResult() {
        for (EditAttribute ea : this.editAttributeList) {
            IAttribute originalAttribute = ea.getOriginalAttribute();
            if (ea.isAdded()) {
                ea.copyToOriginal();
                this.addAttributes.add(ea.getOriginalAttribute());
            } else if (ea.isNameChanged()) {
                this.editAttributes.add(originalAttribute);
            }
            this.newAttributeOrder.add(originalAttribute);
        }
        this.deleteAttributes = this.panel2.getDeletedAttributeList();
        this.editedValueEntity.setAttributes(this.newAttributeOrder);
    }
}

