/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.EventObject;
import java.util.List;
import jp.sourceforge.tmdmaker.TMDContextMenuProvider;
import jp.sourceforge.tmdmaker.TMDPlugin;
import jp.sourceforge.tmdmaker.XStreamSerializer;
import jp.sourceforge.tmdmaker.action.DatabaseSelectAction;
import jp.sourceforge.tmdmaker.action.DiagramImageSaveAction;
import jp.sourceforge.tmdmaker.action.GenerateAction;
import jp.sourceforge.tmdmaker.action.ImplementInfoEditAction;
import jp.sourceforge.tmdmaker.action.MultivalueAndCreateAction;
import jp.sourceforge.tmdmaker.action.MultivalueOrCreateAction;
import jp.sourceforge.tmdmaker.action.SubsetCreateAction;
import jp.sourceforge.tmdmaker.action.VirtualEntityCreateAction;
import jp.sourceforge.tmdmaker.action.VirtualSupersetCreateAction;
import jp.sourceforge.tmdmaker.dialog.EntityCreateDialog;
import jp.sourceforge.tmdmaker.dialog.RelationshipEditDialog;
import jp.sourceforge.tmdmaker.editpart.TMDEditPartFactory;
import jp.sourceforge.tmdmaker.generate.Generator;
import jp.sourceforge.tmdmaker.generate.GeneratorProvider;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.Entity;
import jp.sourceforge.tmdmaker.model.Event2EventRelationship;
import jp.sourceforge.tmdmaker.model.Version;
import jp.sourceforge.tmdmaker.model.command.ConnectionCreateCommand;
import jp.sourceforge.tmdmaker.model.command.ModelAddCommand;
import jp.sourceforge.tmdmaker.tool.MovableSelectionTool;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.editparts.FreeformGraphicalRootEditPart;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.GraphicalEditorWithPalette;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TMDEditor
extends GraphicalEditorWithPalette {
    private static Logger logger = LoggerFactory.getLogger(TMDEditor.class);

    public TMDEditor() {
        logger.debug("{} is instanciate.", TMDEditor.class);
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    protected void initializeGraphicalViewer() {
        logger.debug(((Object)((Object)this)).getClass() + "#initializeGraphicalViewer()");
        GraphicalViewer viewer = this.getGraphicalViewer();
        IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
        Diagram diagram = null;
        try {
            diagram = (Diagram)XStreamSerializer.deserialize(file.getContents(), ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            TMDPlugin.showErrorDialog("\u8aad\u307f\u8fbc\u307f\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", e);
            diagram = new Diagram();
        }
        Version version = this.getPluginVersion();
        diagram.setVersion(version.getValue());
        viewer.setContents((Object)diagram);
    }

    private Version getPluginVersion() {
        Bundle bundle = TMDPlugin.getDefault().getBundle();
        return new Version((String)bundle.getHeaders().get("Bundle-Version"));
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.setPartName(input.getName());
    }

    protected PaletteRoot getPaletteRoot() {
        logger.debug("getPaletteRoot() called");
        PaletteRoot root = new PaletteRoot();
        PaletteGroup toolGroup = new PaletteGroup("\u30c4\u30fc\u30eb");
        SelectionToolEntry tool = new SelectionToolEntry();
        tool.setToolClass(MovableSelectionTool.class);
        toolGroup.add((PaletteEntry)tool);
        root.setDefaultEntry((ToolEntry)tool);
        tool = new MarqueeToolEntry();
        toolGroup.add((PaletteEntry)tool);
        PaletteDrawer drawer = new PaletteDrawer("\u4f5c\u6210");
        ImageDescriptor descriptor = TMDPlugin.getImageDescriptor("icons/new_entity.gif");
        CreationToolEntry creationEntry = new CreationToolEntry("\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3", "\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3", (CreationFactory)new SimpleFactory(Entity.class), descriptor, descriptor);
        drawer.add((PaletteEntry)creationEntry);
        descriptor = TMDPlugin.getImageDescriptor("icons/new_relationship.gif");
        ConnectionCreationToolEntry connxCCreationEntry = new ConnectionCreationToolEntry("\u30ea\u30ec\u30fc\u30b7\u30e7\u30f3\u30b7\u30c3\u30d7", "\u30ea\u30ec\u30fc\u30b7\u30e7\u30f3\u30b7\u30c3\u30d7", null, descriptor, descriptor);
        drawer.add((PaletteEntry)connxCCreationEntry);
        root.add((PaletteEntry)toolGroup);
        root.add((PaletteEntry)drawer);
        return root;
    }

    public void doSave(IProgressMonitor monitor) {
        logger.debug("doSave() called");
        Diagram diagram = (Diagram)this.getGraphicalViewer().getContents().getModel();
        IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
        try {
            file.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
        }
        catch (CoreException e) {
            TMDPlugin.showErrorDialog("\u4fdd\u5b58\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", e);
            logger.warn("IFile#deleteMarkers()." + (Object)((Object)e));
        }
        try {
            file.setContents(XStreamSerializer.serializeStream(diagram, ((Object)((Object)this)).getClass().getClassLoader()), true, true, monitor);
        }
        catch (UnsupportedEncodingException e) {
            TMDPlugin.showErrorDialog("\u4fdd\u5b58\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", e);
            logger.warn("IFile#setContents().", (Throwable)e);
        }
        catch (CoreException e) {
            TMDPlugin.showErrorDialog("\u4fdd\u5b58\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", e);
            logger.warn("IFile#setContents().", (Throwable)e);
        }
        this.getCommandStack().markSaveLocation();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        Shell shell = this.getSite().getWorkbenchWindow().getShell();
        SaveAsDialog dialog = new SaveAsDialog(shell);
        dialog.setOriginalFile(((IFileEditorInput)this.getEditorInput()).getFile());
        dialog.open();
        IPath path = dialog.getResult();
        if (path == null) {
            return;
        }
        final IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        try {
            new ProgressMonitorDialog(shell).run(false, false, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) {
                    Diagram diagram = (Diagram)TMDEditor.this.getGraphicalViewer().getContents().getModel();
                    try {
                        file.create(XStreamSerializer.serializeStream(diagram, ((Object)((Object)this)).getClass().getClassLoader()), true, monitor);
                    }
                    catch (UnsupportedEncodingException e) {
                        TMDPlugin.showErrorDialog("\u4fdd\u5b58\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", e);
                        logger.warn("IFile#setContents().", (Throwable)e);
                    }
                    catch (CoreException e) {
                        TMDPlugin.showErrorDialog("\u4fdd\u5b58\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", e);
                        logger.warn("IFile#setContents().", (Throwable)e);
                    }
                    TMDEditor.this.getCommandStack().markSaveLocation();
                }
            });
            this.setInput((IEditorInput)new FileEditorInput(file));
        }
        catch (InterruptedException e) {
            logger.warn("ProgressMonitorDialog#run().", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.warn("ProgressMonitorDialog#run().", (Throwable)e);
        }
    }

    public void commandStackChanged(EventObject event) {
        this.firePropertyChange(257);
        super.commandStackChanged(event);
    }

    protected void createActions() {
        logger.debug("createAction() called");
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        List selectionActions = this.getSelectionActions();
        SubsetCreateAction action1 = new SubsetCreateAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action1);
        selectionActions.add(action1.getId());
        action1.setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
        MultivalueOrCreateAction action2 = new MultivalueOrCreateAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action2);
        selectionActions.add(action2.getId());
        action2.setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
        MultivalueAndCreateAction action3 = new MultivalueAndCreateAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action3);
        selectionActions.add(action3.getId());
        action3.setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
        VirtualEntityCreateAction action4 = new VirtualEntityCreateAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action4);
        selectionActions.add(action4.getId());
        action4.setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
        VirtualSupersetCreateAction action5 = new VirtualSupersetCreateAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action5);
        selectionActions.add(action5.getId());
        action5.setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
        ImplementInfoEditAction action6 = new ImplementInfoEditAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action6);
        selectionActions.add(action6.getId());
        action6.setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
        AlignmentAction action = null;
        action = new AlignmentAction((IWorkbenchPart)this, 1);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 2);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 4);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 8);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 16);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 32);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
    }

    protected void configureGraphicalViewer() {
        logger.debug("configureGraphicalViewer() called");
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setRootEditPart((RootEditPart)new FreeformGraphicalRootEditPart());
        viewer.setEditPartFactory((EditPartFactory)new TMDEditPartFactory());
        TMDContextMenuProvider provider = new TMDContextMenuProvider((EditPartViewer)viewer, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)provider);
        ActionRegistry registry = this.getActionRegistry();
        DiagramImageSaveAction action6 = new DiagramImageSaveAction(viewer, (IWorkbenchPart)this);
        registry.registerAction((IAction)action6);
        List selectionActions = this.getSelectionActions();
        for (Generator generator : GeneratorProvider.getGenerators()) {
            GenerateAction act = new GenerateAction(this, viewer, generator);
            registry.registerAction((IAction)act);
            selectionActions.add(act.getId());
        }
        DatabaseSelectAction action8 = new DatabaseSelectAction(viewer);
        registry.registerAction((IAction)action8);
        this.getCommandStack().addCommandStackEventListener((CommandStackEventListener)new ModelAddCommandStackEventListener());
        this.getCommandStack().addCommandStackEventListener(new CommandStackEventListener(){

            public void stackChanged(CommandStackEvent event) {
                Command cmd = event.getCommand();
                if (cmd instanceof ConnectionCreateCommand) {
                    ConnectionCreateCommand command = (ConnectionCreateCommand)cmd;
                    AbstractConnectionModel cnt = command.getConnection();
                    if (cnt instanceof Event2EventRelationship) {
                        Event2EventRelationship relationship = (Event2EventRelationship)cnt;
                        if (event.getDetail() == 1 || event.getDetail() == 2) {
                            AbstractEntityModel source = relationship.getSource();
                            AbstractEntityModel target = relationship.getTarget();
                            RelationshipEditDialog dialog = new RelationshipEditDialog(TMDEditor.this.getGraphicalViewer().getControl().getShell(), source.getName(), target.getName());
                            if (dialog.open() == 0) {
                                relationship.setSourceCardinality(dialog.getSourceCardinality());
                                relationship.setSourceNoInstance(dialog.isSourceNoInstance());
                                relationship.setTargetCardinality(dialog.getTargetCardinality());
                                relationship.setTargetNoInstance(dialog.isTargetNoInstance());
                            }
                        }
                    }
                } else {
                    return;
                }
            }
        });
    }

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            return new TMDContentOutlinePage();
        }
        return super.getAdapter(type);
    }

    private class ModelAddCommandStackEventListener
    implements CommandStackEventListener {
        private ModelAddCommandStackEventListener() {
        }

        public void stackChanged(CommandStackEvent event) {
            EntityCreateDialog dialog;
            ModelAddCommand command = null;
            if (!this.isModelAddCommand(event)) {
                return;
            }
            command = (ModelAddCommand)event.getCommand();
            logger.debug(String.valueOf(this.getClass().toString()) + "#stackChanged():PreChangeEvent");
            if (!(event.getDetail() != 1 && event.getDetail() != 2 || command.isModelAdded() || (dialog = new EntityCreateDialog(TMDEditor.this.getGraphicalViewer().getControl().getShell())).open() != 0)) {
                logger.debug(this.getClass() + "#stackChanged():dialog.open() == Dialog.OK)");
                command.setModel(dialog.getCreateModel());
            }
        }

        private boolean isModelAddCommand(CommandStackEvent event) {
            Command cmd = event.getCommand();
            return cmd instanceof ModelAddCommand;
        }
    }

    private class TMDContentOutlinePage
    extends ContentOutlinePage {
        private SashForm sash;
        private ScrollableThumbnail thumbnail;
        private DisposeListener disposeListener;

        public TMDContentOutlinePage() {
            super((EditPartViewer)new TreeViewer());
        }

        public void createControl(Composite parent) {
            this.sash = new SashForm(parent, 512);
            Canvas canvas = new Canvas((Composite)this.sash, 2048);
            LightweightSystem lws = new LightweightSystem(canvas);
            this.thumbnail = new ScrollableThumbnail((Viewport)((FreeformGraphicalRootEditPart)TMDEditor.this.getGraphicalViewer().getRootEditPart()).getFigure());
            this.thumbnail.setSource(((FreeformGraphicalRootEditPart)TMDEditor.this.getGraphicalViewer().getRootEditPart()).getLayer((Object)"Printable Layers"));
            lws.setContents((IFigure)this.thumbnail);
            this.disposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (TMDContentOutlinePage.this.thumbnail != null) {
                        TMDContentOutlinePage.this.thumbnail.deactivate();
                        TMDContentOutlinePage.this.thumbnail = null;
                    }
                }
            };
            TMDEditor.this.getGraphicalViewer().getControl().addDisposeListener(this.disposeListener);
        }

        public Control getControl() {
            return this.sash;
        }

        public void dispose() {
            if (TMDEditor.this.getGraphicalViewer().getControl() != null && !TMDEditor.this.getGraphicalViewer().getControl().isDisposed()) {
                TMDEditor.this.getGraphicalViewer().getControl().removeDisposeListener(this.disposeListener);
            }
            super.dispose();
        }
    }
}

