/*
    Text maid for Windows
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __GENERAL_H__
#define __GENERAL_H__


#include "tmaid.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
* ja:一般関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:キャレットの描画
    hWnd,ウインドウ                                                         */
VOID
DrawCaret (HWND hWnd);


/*  ja:メニューを設定する
    ptw,TXTウインドウ情報                                                   */
VOID
SetMenuBar (LPTEXTWND ptw);


/*  ja:指定範囲を再描画する
         hWnd,ウインドウ
    lpptStart,開始
      lpptEnd,終了                                                          */
VOID
ClearSel (HWND    hWnd,
          LPPOINT lpptStart,
          LPPOINT lpptEnd);


/*  ja:移動する
       hWnd,ウインドウ
    lpptTop,古い左上の座標                                                  */
VOID
MoveTextWindow (HWND    hWnd,
                LPPOINT lpptTop);


/*  ja:キャレット位置にデータを挿入/上書きする
        hWnd,ウインドウ
    lpszText,データを格納するポインタ
     nLength,データのバイト数
      fCaret,TRUE:移動する,FALSE:移動しない
     fSelect,TRUE:選択する,FALSE:選択しない
         RET,逆の操作を行うDOING構造体                                      */
LPDOING
EditOperation (HWND   hWnd,
               LPCSTR lpszText,
               int    nLength,
               BOOL   fCaret,
               BOOL   fSelect);


/*  ja:リストから削除する
    lpDo,リストの先頭
     RET,削除したリストの数                                                 */
int
DeleteList (DOING **lpDo);


/*  ja:右マージンで折り返す
    ptw,TXTウインドウ情報                                                   */
VOID
ModifyMargin (LPTEXTWND ptw);


/*  ja:プロパティを変更する
       hWnd,ウインドウ
    lpFType,ファイルタイプ                                                  */
VOID
ChangeProperty (HWND       hWnd,
                LPFILETYPE lpFType);


BOOL CALLBACK
PropertyEnumProc (HWND   hWnd,
                  LPARAM lParam);


/*  ja:レジストリへ書き込む                                                 */
VOID
RegWrite (VOID);


/******************************************************************************
*                                                                             *
* ja:高レベル関数群                                                           *
*                                                                             *
******************************************************************************/
/*  ja:編集履歴操作
     hWnd,ウインドウ
    fKind,TRUE:redo,FALSE:undo
      RET,TRUE:正常終了,FALSE:エラー                                        */
VOID
HistoryOperation (HWND hWnd,
                  BOOL fKind);


/*  ja:右マージンで改行する
    hWnd,ウインドウ                                                         */
VOID
MarginOperation (HWND hWnd);


/*  ja:タブをスペースに変換する
    hWnd,ウインドウ                                                         */
VOID
TabOperation (HWND hWnd);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GENERAL_H__ */
