/*
    Text maid for Windows
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __FILE_H__
#define __FILE_H__


#include "tmaid.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
* ja:ファイル入力関数群                                                       *
*                                                                             *
******************************************************************************/
/*  ja:TXTファイルを開く
           ptw,TXTウインドウ情報
     dwCharSet,キャラクターセットの自動判別候補
    fNegotiate,TRUE:自動改行判別,FALSE:デフォルト
      uRetCode,改行コード
       RET,TRUE:正常終了,FALSE:エラー                                       */
BOOL
OpenTextFile (LPTEXTWND ptw,
              DWORD     dwCharSet,
              BOOL      fNegotiate,
              UINT      uRetCode);


/******************************************************************************
*                                                                             *
* ja:ファイル出力関数群                                                       *
*                                                                             *
******************************************************************************/
/*  ja:TXTファイルを保存する
    szFile,ファイル名
       ptw,TXTウインドウ情報
       RET,TRUE:正常終了,FALSE:エラー                                       */
BOOL
SaveTextFile (LPCTSTR   lpszFile,
              LPTEXTWND ptw);


/******************************************************************************
*                                                                             *
* ja:ファイル関数群                                                           *
*                                                                             *
******************************************************************************/
/*  ja:ファイルを加える
        hWnd,加えようとするウインドウ
    lpszFile,加えようとするファイルのフルパス
     lpnSame,フルパスに付属する数値
         RET,加えようとするファイルのラベル                                 */
LPTSTR
AddEditFile (HWND     hWnd,
             LPCTSTR  lpszFile,
             int     *lpnSame);


/*  ja:ファイルを削除する
        hWnd,削除しようとするウインドウ
    lpszFile,削除しようとするファイルのフルパス                             */
VOID
DeleteEditFile (HWND    hWnd,
                LPCTSTR lpszFile);


/*  ja:ファイルを開く
    lpszFile,ファイル名
         RET,ウインドウ,NULL:エラー                                         */
HWND
OpenEditFile (LPCTSTR lpszFile);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __FILE_H__ */
