/*
    Text maid for Windows
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "auto.h"
#include "resource.h"
#include "wcommon.h"


/******************************************************************************
*                                                                             *
* ja:自動判別関数群                                                           *
*                                                                             *
******************************************************************************/
BOOL CALLBACK
AutoDlgProc (HWND   hDlg,
             UINT   uMsg,
             WPARAM wParam,
             LPARAM lParam)
{
  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          int i;
          BYTE bBit = 0;
          DWORD dwCharSet;
          LPDWORD lpdwCharSet;
          LPTSTR lpszText, *ppszArray;

          SetWindowLongPtr (hDlg, DWLP_USER, lParam);
          lpdwCharSet = (LPDWORD)lParam;
          /* ja:リストボックスの設定 */
          lpszText = LoadText (GetModuleHandle (NULL), IDS_FTYPE_CHARSET);
          ppszArray = StringSplitDelimiter (lpszText, _T(","));
          MemoryFree (lpszText);
          for (dwCharSet = *lpdwCharSet; dwCharSet & 15; dwCharSet >>= 4)
            {
              ListBoxItem_SetItemData (hDlg, IDC_LISTBOXC2,
                ListBoxItem_AddString (hDlg, IDC_LISTBOXC2,
                            ppszArray[(dwCharSet & 15) - 1]), dwCharSet & 15);
              bBit |= 1 << (dwCharSet & 15) - 1;
            }
          for (i = 0; i < 7; i++)
            if (!(bBit >> i & 1))
              ListBoxItem_SetItemData (hDlg, IDC_LISTBOXC1,
                ListBoxItem_AddString (hDlg, IDC_LISTBOXC1,
                                                        ppszArray[i]), i + 1);
          MemoryFree (ppszArray);
        }
        goto loop;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDOK:
              {
                int i;
                LPDWORD lpdwCharSet;

                lpdwCharSet = (LPDWORD)GetWindowLongPtr (hDlg, DWLP_USER);
                *lpdwCharSet = 0;
                for (i = ListBoxItem_GetCount (hDlg, IDC_LISTBOXC2) - 1;
                                                                i >= 0; i--)
                  *lpdwCharSet = *lpdwCharSet << 4
                            | ListBoxItem_GetItemData (hDlg, IDC_LISTBOXC2, i);
              }
            case IDCANCEL:
              EndDialog (hDlg, LOWORD (wParam));
              return TRUE;
            case IDC_LISTBOXC1:
            case IDC_LISTBOXC2:
              if (HIWORD (wParam) == LBN_SELCHANGE)
                EnableDlgItem (hDlg, LOWORD (wParam) == IDC_LISTBOXC1
                                        ? IDC_PUSHBUTTONC1 : IDC_PUSHBUTTONC2,
                        ListBoxItem_GetSelCount (hDlg, LOWORD (wParam)) > 0);
              return TRUE;
            case IDC_PUSHBUTTONC1:
            case IDC_PUSHBUTTONC2:
            case IDC_PUSHBUTTONC3:
            case IDC_PUSHBUTTONC4:
              {
                int nCount, nIDSrc, nIDDst;

                if (LOWORD (wParam) == IDC_PUSHBUTTONC1
                                        || LOWORD (wParam) == IDC_PUSHBUTTONC3)
                  {
                    nIDSrc = IDC_LISTBOXC1;
                    nIDDst = IDC_LISTBOXC2;
                  }
                else
                  {
                    nIDSrc = IDC_LISTBOXC2;
                    nIDDst = IDC_LISTBOXC1;
                  }
                nCount = LOWORD (wParam) <= IDC_PUSHBUTTONC2
                                    ? ListBoxItem_GetSelCount (hDlg, nIDSrc)
                                    : ListBoxItem_GetCount (hDlg, nIDSrc);
                if (nCount > 0)
                  {
                    int i, *p;

                    p = MemoryAlloc (nCount * sizeof (int));
                    if (LOWORD (wParam) <= IDC_PUSHBUTTONC2)
                      ListBoxItem_GetSelItems (hDlg, nIDSrc, nCount, p);
                    else
                      for (i = 0; i < nCount; i++)
                        p[i] = i;
                    for (i = 0; i < nCount; i++)
                      {
                        LPTSTR lpszText;

                        lpszText = ListBoxItem_GetTextNew (hDlg, nIDSrc, p[i]);
                        ListBoxItem_SetItemData (hDlg, nIDDst,
                                ListBoxItem_AddString (hDlg, nIDDst, lpszText),
                                ListBoxItem_GetItemData (hDlg, nIDSrc, p[i]));
                        MemoryFree (lpszText);
                      }
                    for (i = nCount - 1; i >= 0; i--)
                      ListBoxItem_DeleteString (hDlg, nIDSrc, p[i]);
                    MemoryFree (p);
                    loop:
                      {
                        BOOL fEnable;

                        EnableDlgItem (hDlg, IDC_PUSHBUTTONC1,
                            ListBoxItem_GetSelCount (hDlg, IDC_LISTBOXC1) > 0);
                        EnableDlgItem (hDlg, IDC_PUSHBUTTONC2,
                            ListBoxItem_GetSelCount (hDlg, IDC_LISTBOXC2) > 0);
                        EnableDlgItem (hDlg, IDC_PUSHBUTTONC3,
                            ListBoxItem_GetCount (hDlg, IDC_LISTBOXC1) > 0);
                        fEnable =
                            ListBoxItem_GetCount (hDlg, IDC_LISTBOXC2) > 0;
                        EnableDlgItem (hDlg, IDC_PUSHBUTTONC4, fEnable);
                        EnableDlgItem (hDlg, IDOK, fEnable);
                      }
                  }
              }
          }
        return TRUE;
    }
  return FALSE;
}
