/*
copyright (c) 2012-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
#include <windows.h>
#include <stdlib.h>
#include "iwmcrt.h"


#ifndef ATEXIT_MAX
# define ATEXIT_MAX 32
#endif /* not ATEXIT_MAX */


BOOL WINAPI DllMain (HANDLE, DWORD, LPVOID);
BOOL WINAPI
_DllMainCRTStartup (HANDLE hinstDLL,
                    DWORD  fdwReason,
                    LPVOID lpvReserved)
{
  BOOL fReturn;

  if (fdwReason == DLL_PROCESS_DETACH && !__onexitbegin)
    return FALSE;
  if (fdwReason == DLL_PROCESS_ATTACH)
    {
      if (__onexitbegin)
        return FALSE;
      __onexitbegin = __onexitend = malloc (ATEXIT_MAX * sizeof (_PVFV *));
      if (!__onexitbegin)
        return FALSE;
      *__onexitbegin = NULL;
      _initterm (__xc_a, __xc_z);
    }
  fReturn = DllMain (hinstDLL, fdwReason, lpvReserved);
  if (__onexitbegin && (fdwReason == DLL_PROCESS_ATTACH && !fReturn
                                        || fdwReason == DLL_PROCESS_DETACH))
    {
      while (--__onexitend >= __onexitbegin)
        if (*__onexitend)
          (**__onexitend)();
      free (__onexitbegin);
      __onexitbegin = __onexitend = NULL;
    }
  return fReturn;
}
