/*
    Text maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __TMAID_H__
#define __TMAID_H__


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


#include <gtk/gtk.h>
#include "intl.h"


#define MENUFILE 10


typedef struct ftype {
	gint ft_id;					/* ե륿פID */
	gboolean associate;			/* TRUE:ϢŤ */
	gboolean create;			/* TRUE:,FALSE:¸ե */
	gboolean edit;				/* TRUE:ԽѤ,FALSE:̤Խ */
	gboolean code;				/* TRUE:֤Υɤɽ */
	gboolean crlf;				/* TRUE:ԥɤɽ */
	gboolean eof;				/* TRUE:1Ahե˽񤭲ä */
	gboolean limit;				/* TRUE:ޡޤ֤ */
	gboolean overwrite;			/* TRUE:ե񤭤Ȥ˳ǧ */
	gboolean space;				/* TRUE:ڡ򳥿λͳѤɽ */
	gboolean syscol;			/* TRUE:ƥ࿧Ȥ */
	gboolean gline;				/* TRUE:åɽ */
	gboolean mline;				/* TRUE:ޡɽ */
	gboolean uline;				/* TRUE:ֲɽ */
	gboolean vline;				/* TRUE:ֽɽ */
	gchar *text,*ext;			/* ̾,ĥ */
	gchar *fontname;			/* ե̾ */
	gint margin;				/* ޡο */
	gint tab;					/* ֤ο */
	GdkColor color[12];			/*  */
} FTYPE;
typedef struct doing {
	gint length;				/* ʸ */
	gboolean caret;
	gchar *text;
	GdkPoint cursor,select;
	struct doing *next;
} DOING;
typedef struct linebuf {
	gboolean margin;			/* TRUE:ޡ,FALSE:̾β */
	gchar *text;
	gint length;				/* ʸ */
	struct linebuf *prev,*next;
} LINEBUF;
typedef struct textwnd {
	gchar *file;				/* ե̾ */
	gchar *fontname;			/* ե̾ */
	gboolean create;			/* TRUE:,FALSE:¸ե */
	gboolean edit;				/* TRUE:ԽѤ,FALSE:̤Խ */
	gboolean code;				/* TRUE:֤Υɤɽ */
	gboolean crlf;				/* TRUE:ԥɤɽ */
	gboolean eof;				/* TRUE:1Ahե˽񤭲ä */
	gboolean limit;				/* TRUE:ޡޤ֤ */
	gboolean overwrite;			/* TRUE:ե񤭤Ȥ˳ǧ */
	gboolean space;				/* TRUE:ڡ򳥿λͳѤɽ */
	gboolean syscol;			/* TRUE:ƥ࿧Ȥ */
	gboolean gline;				/* TRUE:åɽ */
	gboolean mline;				/* TRUE:ޡɽ */
	gboolean uline;				/* TRUE:ֲɽ */
	gboolean vline;				/* TRUE:ֽɽ */
	gint ft_id;					/* ե륿פID(-1:̵°) */
	gint fontsize;				/* եȤβ */
	gint fontascent;			/* եȤΥȤι⤵ */
	gint margin;				/* ޡο */
	gint max;					/* Կ */
	gint off;					/* startȤ */
	gint same;					/* -1:ʣʤ,0:ֹ */
	gint tab;					/* ֤ο */
	guint timer_id;				/* ѥ */
	DOING *undo,*redo;			/* Խ */
	LINEBUF *start;				/* ꥹ */
	GdkColor color[12];			/*  */
	GdkFont *font;				/* ե */
	GdkIC *ic;					/* XIM */
	GdkICAttr *ic_attr;			/* XIM° */
	GdkPoint top;				/* ɥƬ */
	GdkPoint cursor;			/* åȤΰ */
	GdkPoint select;			/* 򳫻ϰ,-1:ʤ */
	GtkWidget *drawing;			/* ΰ */
	GtkWidget *hscroll;			/* ʿС */
	GtkWidget *vscroll;			/* ľС */
	GtkWidget *menu_item;		/* ˥塼Υɥι */
} TEXTWND;
typedef struct comm {
	gchar *str;
	gint leng,init_line;
	gint32 pid;
	struct comm *prev,*next;
} COMM;


enum {
	TARGET_STRING,
	TARGET_TEXT,
	TARGET_COMPOUND_TEXT
};


extern gboolean caret;					/* åȤη */
extern gboolean ins;					/* TRUE:,FALSE: */
extern gboolean newfile;				/* TRUE:ե,FALSE:ʤ */
extern gboolean second;					/* TRUE:,FALSE:¸ */
extern gchar *clipboard_text;			/* åץܡɤΥƥ */
extern gchar *hisfile[10];				/* ե */
extern gint def_width,def_height;		/* ǥեȤΥɥΥ */
extern gint ftnum;						/* ե륿פο */
extern gint history;					/* ե */
extern gint instance;					/* ץ̿ѿ */
extern gint tcount;						/* ե륿פΥ */
extern guint timer_id;					/* ID */
extern COMM *comm;						/* ץ̿ѹ¤ */
extern FTYPE *ftype;					/* ե륿 */
extern GdkAtom atom_clipboard;			/* åץܡ */
extern GdkAtom atom_targets;			/* å */
extern GdkAtom atom_compound;			/* ѥ */
extern GdkAtom atom_text;				/* ƥ */
extern GdkAtom atom_textmaid;			/* ץ̿ѥȥ */
extern GtkWidget *window;				/* ɥ */
extern GtkWidget *notebook;				/* Ρȥ֥å */
extern GtkWidget *status;				/* ơɥ */
extern GtkPositionType n_pos;			/* Ρȥ֥åΰ */
extern GtkItemFactory *item_factory_menu;	/* ˥塼 */
extern GtkItemFactory *item_factory_popup;	/* ݥåץå */
extern GdkFont *system_font;
extern GdkColor system_color[12];


#endif
/*
ɽ
 0,ʸ
 1,ط
 2,ȥ륳
 3,ѥڡ
 4,ԥ
 5,ֲ
 6,ޡ
 7,å
 8,򤵤줿ʸ
 9,򤵤줿ط
10,ʸ()
11,ȥ륳()
*/
