/*
    Text maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <ctype.h>
#include <locale.h>
#include <stdlib.h>
#include <unistd.h>
#include "tmaid.h"
#include "charset.h"
#include "command.h"
#include "conf.h"
#include "file.h"
#include "find.h"
#include "format.h"
#include "general.h"
#include "jump.h"
#include "other.h"
#include "profile.h"
#include "replace.h"
#include "signal.h"
#include "toolbar.h"
#include "version.h"


gboolean caret=FALSE;				/* åȤη */
gboolean ins=TRUE;					/* TRUE:,FALSE: */
gboolean newfile=FALSE;				/* TRUE:ե,FALSE:ʤ */
gboolean second=FALSE;				/* TRUE:,FALSE:¸ */
gchar *hisfile[10];					/* ե */
gchar *clipboard_text=NULL;			/* åץܡɤΥƥ */
gint def_width,def_height;			/* ǥեȤΥɥΥ */
gint ftnum=0;						/* ե륿פο */
gint history=4;						/* ե */
gint instance=-1;					/* ץ̿ѿ */
gint tcount=0;						/* ե륿פΥ */
guint timer_id=0;					/* ID */
COMM *comm=NULL;					/* ץ̿ѹ¤ */
FTYPE *ftype=NULL;					/* ե륿 */
GdkAtom atom_clipboard;				/* åץܡ */
GdkAtom atom_targets;				/* å */
GdkAtom atom_compound;				/* ѥ */
GdkAtom atom_text;					/* ƥ */
GdkAtom atom_textmaid;				/* ץ̿ѥȥ */
GtkWidget *window;					/* ɥ */
GtkWidget *notebook;				/* Ρȥ֥å */
GtkWidget *status;					/* ơɥ */
GtkPositionType n_pos=GTK_POS_TOP;	/* Ρȥ֥åΰ */
GtkItemFactory *item_factory_menu;	/* ˥塼 */
GtkItemFactory *item_factory_popup;	/* ݥåץå */
GdkFont *system_font=NULL;
GdkColor system_color[12]={	{0,0x0000,0x0000,0x0000},{0,0xffff,0xffff,0xffff},
							{0,0x8000,0x8000,0x8000},{0,0x8000,0x8000,0x8000},
							{0,0x8000,0x8000,0x8000},{0,0x8000,0x8000,0x8000},
							{0,0x8000,0x8000,0x8000},{0,0xa000,0xa000,0xa000},
							{0,0xffff,0xffff,0xffff},{0,0x0000,0x0000,0x8000},
							{0,0x0000,0x0000,0x0000},{0,0x8000,0x8000,0x8000}};


/******************************************************************************
*                                                                             *
* ᥤؿ                                                                  *
*                                                                             *
******************************************************************************/
int main(int argc,char *argv[])
{
	gboolean *arg_files;
	gchar *arg,*endptr,*str,*section=NULL,*key=NULL,*lang,**charsetname;
	gint i,j,k,l,m,opt,leng;
	gint init_line=0;					/* ΥåȰ */
	COMM *p;
	PROFILE *profile;
	TEXTWND *ptw;
	GdkEventClient event;
	GdkBitmap *mask;
	GdkPixmap *pixmap;
	GtkAccelGroup *accel_group;
	GtkStyle *style;
	GtkWidget *menubar,*toolbar,*text,*handle,*vbox,*sub_menu,*menu_item;
	GtkItemFactoryEntry menu_items[]={
{N_("/ե(_F)"),                               NULL,         NULL,            0,"<Branch>"},
{N_("/ե(F)/(_N)"),                   "<control>N", command_new,     0,"<Item>"},
{N_("/ե(F)/(_O)..."),                    "<control>O", command_open,    0,"<Item>"},
{N_("/ե(F)/Ĥ(_C)"),                     "<control>W", command_close,   0,"<Item>"},
{N_("/ե(F)/¸(_S)"),                 "<control>S", command_save,    0,"<Item>"},
{N_("/ե(F)/̾Ĥ¸(_A)..."),        NULL,         command_saveas,  0,"<Item>"},
{N_("/ե(F)/¸Ƥ֤᤹(_R)..."),"<control>R", command_reload,  0,"<Item>"},
{N_("/ե(F)/Sep1"),                           NULL,         NULL,            0,"<Separator>"},
{N_("/ե(F)/ץѥƥ(_I)..."),              "<alt>Return",command_property,0,"<Item>"},
{N_("/ե(F)/Sep2"),                           NULL,         NULL,            0,"<Separator>"},
{N_("/ե(F)/λ(_X)"),                       "<control>Q", command_exit,    0,"<Item>"},
{N_("/Խ(_E)"),                                   NULL,         NULL,            0,"<Branch>"},
{N_("/Խ(E)/᤹(_U)"),                       "<control>Z", command_undo,    0,"<Item>"},
{N_("/Խ(E)/ľ(_R)"),                       "F4",         command_redo,    0,"<Item>"},
{N_("/Խ(E)/Sep1"),                               NULL,         NULL,            0,"<Separator>"},
{N_("/Խ(E)/ڤ(_T)"),                       "<control>X", command_cut,     0,"<Item>"},
{N_("/Խ(E)/ԡ(_C)"),                         "<control>C", command_copy,    0,"<Item>"},
{N_("/Խ(E)/Žդ(_P)"),                       "<control>V", command_paste,   0,"<Item>"},
{N_("/Խ(E)/(_L)"),                           NULL,         command_delete,  0,"<Item>"},
{N_("/Խ(E)/Sep2"),                               NULL,         NULL,            0,"<Separator>"},
{N_("/Խ(E)/ޡǲԤ(_M)"),           NULL,         command_margin,  0,"<Item>"},
{N_("/Խ(E)/֤򥹥ڡѴ(_B)"),       NULL,         command_tab,     0,"<Item>"},
{N_("/Խ(E)/Sep3"),                               NULL,         NULL,            0,"<Separator>"},
{N_("/Խ(E)/ʸ(_W)..."),              NULL,         command_valchr,  0,"<Item>"},
{N_("/Խ(E)/Ԥذư(_J)..."),                "<control>J", command_jump,    0,"<Item>"},
{N_("/Խ(E)/Sep4"),                               NULL,         NULL,            0,"<Separator>"},
{N_("/Խ(E)/٤(_A)"),                     "<control>A", command_all,     0,"<Item>"},
{N_("/(_S)"),                                   NULL,         NULL,            0,"<Branch>"},
{N_("/(S)/(_F)..."),                        "<control>F", command_find,    0,"<Item>"},
{N_("/(S)/򸡺(_N)"),                       "F3",         command_next,    0,"<Item>"},
{N_("/(S)/դ򸡺(_B)"),                       "<shift>F3",  command_next,    1,"<Item>"},
{N_("/(S)/ִ(_R)..."),                        "<control>H", command_replace, 0,"<Item>"},
{N_("/ץ(_O)"),                             NULL,         NULL,            0,"<Branch>"},
{N_("/ץ(O)/(_C)..."),                  NULL,         conf_dialog,     0,"<Item>"},
{N_("/ץ(O)/ե륿(_T)..."),        NULL,         format_dialog,   0,"<Item>"},
{N_("/ɥ(_W)"),                             NULL,         NULL,            0,"<Branch>"},
{N_("/إ(_H)"),                                 NULL,         NULL,            0,"<Branch>"},
{N_("/إ(H)/С(_A)..."),            NULL,         version_dialog,  0,"<Item>"}};
	GtkItemFactoryEntry popup_items[]={
{N_("/᤹(_U)"),                               "<control>Z", command_undo,    0,"<Item>"},
{N_("/Sep1"),                                       NULL,         NULL,            0,"<Separator>"},
{N_("/ڤ(_T)"),                               "<control>X", command_cut,     0,"<Item>"},
{N_("/ԡ(_C)"),                                 "<control>C", command_copy,    0,"<Item>"},
{N_("/Žդ(_P)"),                               "<control>V", command_paste,   0,"<Item>"},
{N_("/(_L)"),                                   NULL,         command_delete,  0,"<Item>"},
{N_("/Sep2"),                                       NULL,         NULL,            0,"<Separator>"},
{N_("/٤(_A)"),                             "<control>A", command_all,     0,"<Item>"}};
	/* Drag&Drop */
	GtkTargetEntry drag_types[1]={{"text/uri-list",0,0}};
	/* Text maid󶡲ǽʥ쥯 */
	GtkTargetEntry targets[]={
	{"STRING",       0,TARGET_STRING},
	{"TEXT",         0,TARGET_TEXT}, 
	{"COMPOUND_TEXT",0,TARGET_COMPOUND_TEXT}};
	/* ޥɥ饤  */
	struct arg_opt {
		const char *name;
		const int key;
		const char *arg;
		const char *doc;
	};
	const struct arg_opt arg_opts[]={
	{"history",'h',"NUM",         N_("ե")},
	{"line",   'l',"NUM",         N_("ΥåȰ")},
	{"new",    'n',"ON/OFF",      N_("ե򳫤")},
	{"size",   's',"WIDTH,HEIGHT",N_("ɥΥ")},
	{"second", 'x',"ON/OFF",      N_("ɥ򳫤")},
	{"version",'v',NULL,          N_("С")},
	{"help",   '?',NULL,          N_("إ")},
	{NULL,     0,  NULL,          NULL}};

	/*  */
	setlocale(LC_ALL,"");
	bindtextdomain(PACKAGE,LOCALEDIR);
	textdomain(PACKAGE);
	gtk_set_locale();
	gtk_init(&argc,&argv);

	/* Ķѿ */
	if ((str=g_getenv("LC_ALL"))!=NULL)
		while (*str!='\0')
			if (*str++=='.') {
				lang=g_strdup(str);
				for (i=0;lang[i]!='\0';i++)
					if (lang[i]=='@') {
						lang[i]='\0';
						break;
					}
				for (i=0;charsetlist[i].name!=NULL;i++) {
					charsetname=g_strsplit(charsetlist[i].name,",",G_MAXINT);
					for (j=0;charsetname[j]!=NULL;j++)
						if (g_strcasecmp(str,charsetname[j])==0) {
							charset=charsetlist+i;
							break;
						}
					g_strfreev(charsetname);
				}
				g_free(lang);
				break;
			}

	def_width=gdk_screen_width()*2/3;
	def_height=gdk_screen_height()*2/3;
	memset(hisfile,0,sizeof(gchar *)*10);
	/* 쥸ȥ꤫ɤ߽Ф */
	if ((profile=profile_open(".tmaid"))!=NULL) {
		if (!profile_get_value(profile,"tmaid","ftnum",
				(gpointer)&ftnum,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			ftnum=0;
		if (!profile_get_value(profile,"tmaid","history",
				(gpointer)&history,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			history=4;
		if (!profile_get_value(profile,"tmaid","newfile",
				(gpointer)&newfile,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL))
			newfile=FALSE;
		if (!profile_get_value(profile,"tmaid","second",
				(gpointer)&second,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL))
			second=FALSE;
		if (!profile_get_value(profile,"tmaid","def_width",
				(gpointer)&def_width,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			def_width=gdk_screen_width()*2/3;
		if (!profile_get_value(profile,"tmaid","def_height",
				(gpointer)&def_height,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			def_height=gdk_screen_height()*2/3;
		if (!profile_get_value(profile,"tmaid","n_pos",
				(gpointer)&n_pos,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			n_pos=GTK_POS_TOP;
		/* ե */
		for (i=0;i<history;i++) {
			key=g_strdup_printf("history%d",i);
			hisfile[i]=profile_get_string(profile,"tmaid",key);
			g_free(key);
			if (hisfile[i]==NULL)
				break;
			if (*hisfile[i]=='\0') {
				g_free(hisfile[i]);
				hisfile[i]=NULL;
				break;
			}
		}
		/*  */
		if (!profile_get_value(profile,"tmaid","find_arrow",
								(gpointer)&find_arrow,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
			find_arrow=TRUE;
		if (!profile_get_value(profile,"tmaid","find_ignorecase",
								(gpointer)&find_ignorecase,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
			find_ignorecase=FALSE;
		if (!profile_get_value(profile,"tmaid","find_num",
					(gpointer)&find_num,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			find_num=0;
		for (i=0;i<find_num;i++) {
			key=g_strdup_printf("find%02d",i);
			find_text[i]=profile_get_string(profile,"tmaid",key);
			g_free(key);
			if (find_text[i]==NULL)
				break;
		}
		find_num=i;
		/* ִ */
		if (!profile_get_value(profile,"tmaid","replace_arrow",
								(gpointer)&replace_arrow,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
			replace_arrow=TRUE;
		if (!profile_get_value(profile,"tmaid","replace_ignorecase",
								(gpointer)&replace_ignorecase,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
			replace_ignorecase=FALSE;
		if (!profile_get_value(profile,"tmaid","replace_num",
				(gpointer)&replace_num,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			replace_num=0;
		for (i=0;i<replace_num;i++) {
			key=g_strdup_printf("replace%02d",i);
			replace_text[i]=profile_get_string(profile,"tmaid",key);
			g_free(key);
			if (replace_text[i]==NULL)
				break;
		}
		replace_num=i;
		/* ե륿 */
		if (ftnum>0)
			ftype=g_malloc(ftnum*sizeof(FTYPE));
		for (i=0;i<ftnum;i++) {
			section=g_strdup_printf("filetype%04d",i);
			ftype[i].ft_id=tcount++;
			if ((ftype[i].text
							=profile_get_string(profile,section,"text"))==NULL)
				ftype[i].text=g_strdup("UNKNOW");
			if ((ftype[i].ext
							=profile_get_string(profile,section,"ext"))==NULL)
				ftype[i].ext=g_strdup("*");
			if (!profile_get_value(profile,section,"margin",
								(gpointer)&ftype[i].margin,sizeof(gint),
													PROFILE_VALUE_TYPE_INT))
				ftype[i].margin=80;
			if (!profile_get_value(profile,section,"tab",
								(gpointer)&ftype[i].tab,sizeof(gint),
													PROFILE_VALUE_TYPE_INT))
				ftype[i].tab=8;
			if (!profile_get_value(profile,section,"associate",
								(gpointer)&ftype[i].associate,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].associate=TRUE;
			if (!profile_get_value(profile,section,"code",
								(gpointer)&ftype[i].code,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].code=FALSE;
			if (!profile_get_value(profile,section,"crlf",
								(gpointer)&ftype[i].crlf,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].crlf=FALSE;
			if (!profile_get_value(profile,section,"eof",
								(gpointer)&ftype[i].eof,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].eof=FALSE;
			if (!profile_get_value(profile,section,"limit",
								(gpointer)&ftype[i].limit,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].limit=FALSE;
			if (!profile_get_value(profile,section,"overwrite",
								(gpointer)&ftype[i].overwrite,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].overwrite=FALSE;
			if (!profile_get_value(profile,section,"space",
								(gpointer)&ftype[i].space,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].space=FALSE;
			if (!profile_get_value(profile,section,"syscol",
								(gpointer)&ftype[i].syscol,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].syscol=TRUE;
			if (!profile_get_value(profile,section,"gline",
								(gpointer)&ftype[i].gline,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].gline=FALSE;
			if (!profile_get_value(profile,section,"mline",
								(gpointer)&ftype[i].mline,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].mline=FALSE;
			if (!profile_get_value(profile,section,"uline",
								(gpointer)&ftype[i].uline,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].uline=FALSE;
			if (!profile_get_value(profile,section,"vline",
								(gpointer)&ftype[i].vline,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].vline=FALSE;
			/* ե */
			if ((ftype[i].fontname
							=profile_get_string(profile,section,"font"))==NULL)
				ftype[i].fontname=NULL;
			/*  */
			if (!profile_get_value(profile,section,"color",
								(gpointer)&ftype[i].color,sizeof(GdkColor)*12,
													PROFILE_VALUE_TYPE_ARRAY))
				memcpy(ftype[i].color,system_color,sizeof(GdkColor)*12);
			g_free(section);
		}
		profile_close(profile);
	}

	/* ޥɥ饤β */
	arg_files=g_malloc(argc*sizeof(gboolean));
	memset(arg_files,0,argc*sizeof(gboolean));
	i=1;/* i:Υץ,j:iʸ,k:iʹߤarg */
	while (i<argc) {
		if ((argv[i])[0]=='-') {/* ץ */
			j=1;
			k=i;
			while ((argv[i])[j]!='\0' && (argv[i])[j]!='=') {
				if ((argv[i])[1]=='-') {	/* Ĺץ */
					opt=0;
					for (l=0;arg_opts[l].name!=NULL;l++) {
						leng=strlen(arg_opts[l].name);
						if (g_strncasecmp(argv[i]+2,arg_opts[l].name,leng)==0
											&& ((argv[i])[leng+2]=='\0'
												|| (argv[i])[leng+2]=='=')) {
							opt=arg_opts[l].key;
							j=leng+2;
							break;
						}
					}
				} else {					/* ûץ */
					opt=tolower((argv[i])[j++]);
				}
				arg=NULL;
				for (l=0;arg_opts[l].name!=NULL;l++)
					if (arg_opts[l].key==opt && arg_opts[l].arg!=NULL) {
						if (i==k) {
							for (m=2;(argv[i])[m]!='\0' && (argv[i])[m]!='=';
																		m++);
							arg=(argv[i])[m]=='\0'?argv[++k]:argv[i]+m+1;
							k++;
						} else {
							arg=argv[k++];
						}
						if (arg==NULL || *arg=='\0')
							opt=0;
						break;
					}
				switch (opt) {
					case 'h':
						strval(&history,arg,10,TRUE);
						if (history<0)
							history=0;
						else if (history>10)
							history=10;
						break;
					case 'l':
						strval(&init_line,arg,10,TRUE);
						break;
					case 'n':
						newfile=g_strcasecmp(arg,"OK")==0
												|| g_strcasecmp(arg,"ON")==0
												|| g_strcasecmp(arg,"TRUE")==0
												|| g_strcasecmp(arg,"YES")==0;
						break;
					case 's':
						def_height=strtol(arg,&endptr,0);
						def_width=strtol(++endptr,&endptr,0);
						break;
					case 'x':
						second=g_strcasecmp(arg,"OK")==0
												|| g_strcasecmp(arg,"ON")==0
												|| g_strcasecmp(arg,"TRUE")==0
												|| g_strcasecmp(arg,"YES")==0;
						break;
					case 'v':
						g_print(
"Text maid "VERSION"\n"
"Copyright (C) 1998-2002 Iwamoto,Kazuki\n"
"This is free software; see the source for copying conditions.  There is NO\n"
"warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n"
						);
						g_free(arg_files);
						return 0;
					default:
						g_print(
"Copyright (c) 1998-2002 Iwamoto,Kazuki\n\n"
"Usage: %s [OPTION...] [FILE...]\n\n",argv[0]);
						for (i=0;arg_opts[i].name;i++) {
							if (arg_opts[i].arg!=NULL)
								str=g_strdup_printf("  -%c, --%s=%s",
											arg_opts[i].key,arg_opts[i].name,
															arg_opts[i].arg);
							else
								str=g_strdup_printf("  -%c, --%s",
											arg_opts[i].key, arg_opts[i].name);
							g_print("%-26s %s\n",str,arg_opts[i].doc);
							g_free(str);
						}
						g_print("\n");
						g_free(arg_files);
						return 0;
				}
			}
			i=i<k?k:i+1;
		} else {/* ե */
			arg_files[i++]=TRUE;
		}
	}

	/* ե륿 */
	if (ftnum<=0) {
		ftnum=1;
		ftype=g_malloc(ftnum*sizeof(FTYPE));
		ftype[0].text=g_strdup(_("٤ƤΥե"));
		ftype[0].ext=g_strdup("*");
		ftype[0].margin=80;
		ftype[0].tab=8;
		ftype[0].associate=TRUE;
		ftype[0].code=FALSE;
		ftype[0].crlf=FALSE;
		ftype[0].eof=FALSE;
		ftype[0].limit=FALSE;
		ftype[0].overwrite=FALSE;
		ftype[0].space=FALSE;
		ftype[0].syscol=TRUE;
		ftype[0].gline=FALSE;
		ftype[0].mline=FALSE;
		ftype[0].uline=FALSE;
		ftype[0].vline=FALSE;
		/* ե */
		ftype[0].fontname=NULL;
		/*  */
		memcpy(ftype[0].color,system_color,sizeof(GdkColor)*12);
	}

	/* ᥤ󥦥ɥ */
	window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(window),"Text maid");
	gtk_window_set_default_size(GTK_WINDOW(window),def_width,def_height);
	gtk_signal_connect(GTK_OBJECT(window),"delete-event",
										GTK_SIGNAL_FUNC(signal_delete),NULL);
	gtk_signal_connect(GTK_OBJECT(window),"destroy",
												signal_destroy_window,NULL);
	gtk_widget_realize(window);
	/* Drag and Drop */
	gtk_drag_dest_set(window,GTK_DEST_DEFAULT_MOTION
						| GTK_DEST_DEFAULT_HIGHLIGHT | GTK_DEST_DEFAULT_DROP,
												drag_types,1,GDK_ACTION_COPY);
	gtk_signal_connect(GTK_OBJECT(window),"drag-data-received",
							GTK_SIGNAL_FUNC(signal_drag_data_received),NULL);
	/* åץܡ/ץ̿ */
	atom_clipboard=gdk_atom_intern("CLIPBOARD",FALSE);
	atom_targets=gdk_atom_intern("TARGETS",FALSE);
	atom_compound=gdk_atom_intern("COMPOUND_TEXT",FALSE);
	atom_text=gdk_atom_intern("TEXT",FALSE);
	atom_textmaid=gdk_atom_intern("Text maid InterProcess communication",
																		FALSE);
	gtk_selection_add_targets(window,GDK_SELECTION_PRIMARY,
							targets,sizeof(targets)/sizeof(GtkTargetEntry));
	gtk_selection_add_targets(window,atom_clipboard,
							targets,sizeof(targets)/sizeof(GtkTargetEntry));
	if (!second)
		gtk_selection_add_targets(window,atom_textmaid,targets,1);
	gtk_signal_connect(GTK_OBJECT(window),"selection-clear-event",
								GTK_SIGNAL_FUNC(signal_selection_clear),NULL);
	gtk_signal_connect(GTK_OBJECT(window),"selection-get",
											signal_selection_get,NULL);
	gtk_signal_connect(GTK_OBJECT(window),"selection-received",
											signal_selection_received,NULL);
	/* Ρȥ֥å */
	notebook=gtk_notebook_new();
	gtk_notebook_set_scrollable(GTK_NOTEBOOK(notebook),TRUE);
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook),n_pos);
	gtk_signal_connect(GTK_OBJECT(notebook),"switch-page",
								GTK_SIGNAL_FUNC(signal_switch_page),NULL);
	gtk_signal_connect(GTK_OBJECT(notebook),"destroy",
								GTK_SIGNAL_FUNC(signal_destroy_notebook),NULL);
	/* ݥåץå */
	accel_group=gtk_accel_group_new();
	item_factory_popup=gtk_item_factory_new(GTK_TYPE_MENU,
														"<main>",accel_group);
	gtk_item_factory_create_items(item_factory_popup,
			sizeof(popup_items)/sizeof(GtkItemFactoryEntry),popup_items,NULL);
	/* ˥塼 */
	accel_group=gtk_accel_group_new();
	item_factory_menu=gtk_item_factory_new(GTK_TYPE_MENU_BAR,
														"<main>",accel_group);
	gtk_item_factory_create_items(item_factory_menu,
			sizeof(menu_items)/sizeof(GtkItemFactoryEntry),menu_items,NULL);
	gtk_accel_group_attach(accel_group,GTK_OBJECT(window));
	menubar=gtk_item_factory_get_widget(item_factory_menu,"<main>");
	/* ġС */
	toolbar=gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL,GTK_TOOLBAR_ICONS);
	for (i=0;i<18;i++)
		if (toolbar_items[i].name==NULL) {
			gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));
		} else {
			pixmap=gdk_pixmap_create_from_xpm_d(window->window,
											&mask,NULL,toolbar_items[i].xpm);
			toolbar_items[i].item=gtk_toolbar_append_item(GTK_TOOLBAR(toolbar),
						NULL,toolbar_items[i].name,NULL,
						gtk_pixmap_new(pixmap,mask),
						toolbar_items[i].callback,toolbar_items[i].user_data);
		}
	/* ơС */
	status=gtk_statusbar_new();
	/* ƥ */
	text=gtk_text_new(NULL,NULL);
	gtk_signal_connect(GTK_OBJECT(text),"style-set",signal_style_set,NULL);
	/* ľܥå/ϥɥܥå */
	vbox=gtk_vbox_new(FALSE,0);
	handle=gtk_handle_box_new();
	gtk_container_set_border_width(GTK_CONTAINER(handle),2);
	gtk_container_add(GTK_CONTAINER(handle),menubar);
	gtk_box_pack_start(GTK_BOX(vbox),handle,FALSE,FALSE,0);
	handle=gtk_handle_box_new();
	gtk_container_set_border_width(GTK_CONTAINER(handle),2);
	gtk_container_add(GTK_CONTAINER(handle),toolbar);
	gtk_box_pack_start(GTK_BOX(vbox),handle,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),notebook,TRUE,TRUE,0);
	gtk_box_pack_end(GTK_BOX(vbox),status,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(vbox),text,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(window),vbox);
	/* ե */
	sub_menu=gtk_item_factory_get_widget(item_factory_menu,
													_("<main>/ե(F)"));
	for (i=0;i<history && hisfile[i]!=NULL;i++) {
		menu_item=gtk_menu_item_new_with_label(hisfile[i]);
		gtk_signal_connect(GTK_OBJECT(menu_item),"activate",
					GTK_SIGNAL_FUNC(signal_activate_menu_history),hisfile[i]);
		gtk_signal_connect(GTK_OBJECT(menu_item),"destroy",
					GTK_SIGNAL_FUNC(signal_destroy_menu_history),hisfile[i]);
		gtk_object_set_user_data(GTK_OBJECT(menu_item),hisfile[i]);
		gtk_menu_insert(GTK_MENU(sub_menu),menu_item,i+MENUFILE-1);
	}
	if (i>0)
		gtk_menu_insert(GTK_MENU(sub_menu),gtk_menu_item_new(),i+MENUFILE-1);
	/*  */
	timer_id=gtk_timeout_add(500,signal_timeout,NULL);

	/* ˥塼ɽ */
	set_menu_bar(NULL);

	/* ˵ưƤ뤫å */
	if (!second) {
		gtk_selection_convert(window,atom_textmaid,
								GDK_SELECTION_TYPE_STRING,GDK_CURRENT_TIME);
		while (instance<0)
			while (gtk_events_pending())
				gtk_main_iteration();
		if (instance>0) {
			/* ˵ưƤȤ */
			event.type=GDK_CLIENT_EVENT;
			event.window=window->window;
			event.send_event=TRUE;
			event.message_type=atom_textmaid;
			event.data_format=32;
			event.data.l[0]=init_line;
			event.data.l[4]=getpid();
			gdk_event_send_clientmessage_toall((GdkEvent *)&event);
			event.data_format=8;
			for (i=1;i<argc;i++)
				if (arg_files[i]) {
					str=get_full_path(argv[i]);
					leng=strlen(str)+1;
					for (j=0;j<leng;j+=16) {
						memcpy(event.data.b,str+j,MIN(leng-j,16));
						gdk_event_send_clientmessage_toall((GdkEvent *)&event);
					}
					g_free(str);
				}
			g_free(arg_files);
			gtk_exit(0);
		}
		gtk_signal_connect(GTK_OBJECT(window),"client-event",
									GTK_SIGNAL_FUNC(signal_client_event),NULL);
		gtk_selection_owner_set(window,atom_textmaid,GDK_CURRENT_TIME);
	}

	/* ɽ */
	gtk_widget_show_all(window);
	gtk_widget_hide_all(text);
	gtk_window_set_policy(GTK_WINDOW(window),TRUE,TRUE,TRUE);

	/* ƥ࿧ */
	style=gtk_widget_get_style(text);
	system_color[0]=style->text[0];
	system_color[1]=style->base[0];
	system_color[2]=style->dark[0];
	system_color[3]=style->dark[0];
	system_color[4]=style->dark[0];
	system_color[5]=style->dark[0];
	system_color[6]=style->dark[0];
	system_color[7]=style->mid[0];
	system_color[8]=style->fg[3];
	system_color[9]=style->bg[3];
	/* ƥե */
	system_font=gdk_font_ref(style->font);

	/* ɥ */
	j=0;
	for (i=1;i<argc;i++)
		if (arg_files[i]) {
			ptw=open_edit_file(argv[i]);
			if (init_line!=0)	/* Ԥ˰ư */
				jump_operation(ptw,init_line);
			j++;
		}
	g_free(arg_files);
	if (newfile && j<=0)
		open_edit_file(NULL);

	gtk_main();

	/* 쥸ȥ˽񤭹 */
	if ((profile=profile_open(".tmaid"))!=NULL) {
		profile_set_value(profile,"tmaid","ftnum",
				(gpointer)&ftnum,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		profile_set_value(profile,"tmaid","history",
				(gpointer)&history,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		profile_set_value(profile,"tmaid","newfile",
				(gpointer)&newfile,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL);
		profile_set_value(profile,"tmaid","second",
				(gpointer)&second,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL);
		profile_set_value(profile,"tmaid","def_width",
				(gpointer)&def_width,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		profile_set_value(profile,"tmaid","def_height",
				(gpointer)&def_height,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		profile_set_value(profile,"tmaid","n_pos",
				(gpointer)&n_pos,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		/* ե */
		for (i=0;i<history && hisfile[i]!=NULL;i++) {
			key=g_strdup_printf("history%d",i);
			profile_set_value(profile,"tmaid",key,(gpointer)hisfile[i],
										(strlen(hisfile[i])+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			g_free(key);
		}
		while (i<10) {
			key=g_strdup_printf("history%d",i++);
			profile_set_value(profile,"tmaid",key,(gpointer)"",sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			g_free(key);
		}
		/*  */
		profile_set_value(profile,"tmaid","find_arrow",
								(gpointer)&find_arrow,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
		profile_set_value(profile,"tmaid","find_ignorecase",
								(gpointer)&find_ignorecase,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
		profile_set_value(profile,"tmaid","find_num",
				(gpointer)&find_num,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		for (i=0;i<find_num;i++) {
			key=g_strdup_printf("find%02d",i);
			profile_set_value(profile,"tmaid",key,(gpointer)find_text[i],
										(strlen(find_text[i])+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			g_free(key);
		}
		while (i<32) {
			key=g_strdup_printf("find%02d",i++);
			profile_set_value(profile,"tmaid",key,(gpointer)"",sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			g_free(key);
		}
		/* ִ */
		profile_set_value(profile,"tmaid","replace_arrow",
								(gpointer)&replace_arrow,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
		profile_set_value(profile,"tmaid","replace_ignorecase",
								(gpointer)&replace_ignorecase,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
		profile_set_value(profile,"tmaid","replace_num",
				(gpointer)&replace_num,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		for (i=0;i<replace_num;i++) {
			key=g_strdup_printf("replace%02d",i);
			profile_set_value(profile,"tmaid",key,(gpointer)replace_text[i],
									(strlen(replace_text[i])+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			g_free(key);
		}
		while (i<32) {
			key=g_strdup_printf("replace%02d",i++);
			profile_set_value(profile,"tmaid",key,(gpointer)"",sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			g_free(key);
		}
		/* ե륿 */
		for (i=0;i<ftnum;i++) {
			section=g_strdup_printf("filetype%04d",i);
			profile_set_value(profile,section,"text",(gpointer)ftype[i].text,
									(strlen(ftype[i].text)+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			profile_set_value(profile,section,"ext",(gpointer)ftype[i].ext,
									(strlen(ftype[i].ext)+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			profile_set_value(profile,section,"margin",
								(gpointer)&ftype[i].margin,sizeof(gint),
													PROFILE_VALUE_TYPE_INT);
			profile_set_value(profile,section,"tab",
								(gpointer)&ftype[i].tab,sizeof(gint),
													PROFILE_VALUE_TYPE_INT);
			profile_set_value(profile,section,"associate",
								(gpointer)&ftype[i].associate,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"code",
								(gpointer)&ftype[i].code,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"crlf",
								(gpointer)&ftype[i].crlf,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"eof",
								(gpointer)&ftype[i].eof,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"limit",
								(gpointer)&ftype[i].limit,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"overwrite",
								(gpointer)&ftype[i].overwrite,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"space",
								(gpointer)&ftype[i].space,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"syscol",
								(gpointer)&ftype[i].syscol,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"gline",
								(gpointer)&ftype[i].gline,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"mline",
								(gpointer)&ftype[i].mline,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"uline",
								(gpointer)&ftype[i].uline,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"vline",
								(gpointer)&ftype[i].vline,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			/* ե */
			if (ftype[i].fontname!=NULL)
				profile_set_value(profile,section,"font",
								(gpointer)ftype[i].fontname,
								(strlen(ftype[i].fontname)+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			/*  */
			profile_set_value(profile,section,"color",
								(gpointer)&ftype[i].color,sizeof(GdkColor)*12,
													PROFILE_VALUE_TYPE_ARRAY);
		}
		do {
			g_free(section);
			section=g_strdup_printf("filetype%04d",i++);
		} while (profile_delete_section(profile,section));
		g_free(section);
		profile_close(profile);
	}
	gdk_font_unref(system_font);
	for (i=0;i<find_num;i++)
		g_free(find_text[i]);
	for (i=0;i<replace_num;i++)
		g_free(replace_text[i]);
	for (i=0;i<history;i++)
		g_free(hisfile[i]);
	for (i=0;i<ftnum;i++) {
		g_free(ftype[i].text);
		g_free(ftype[i].ext);
		g_free(ftype[i].fontname);
	}
	g_free(ftype);
	g_free(clipboard_text);
	while (comm!=NULL) {
		g_free(comm->str);
		p=comm->next;
		g_free(comm);
		comm=p;
	}
	return 0;
}
