/*
    Text maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <string.h>
#include <gdk/gdkkeysyms.h>
#include "charset.h"
#include "edit.h"
#include "file.h"
#include "general.h"
#include "jump.h"
#include "other.h"
#include "signal.h"


/******************************************************************************
*                                                                             *
* ʥ/٥ȴؿ()                                             *
*                                                                             *
******************************************************************************/
gboolean signal_timeout(gpointer data)
{
	gint page;
	GdkRectangle rc;
	TEXTWND *ptw;

	caret=!caret;
	if ((page=gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))>=0) {
		ptw=gtk_object_get_user_data(GTK_OBJECT(
					gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),page)));
		rc.x=(get_align_pos(&ptw->start,&ptw->off,ptw->cursor.x,ptw->cursor.y,
									ptw->tab,FALSE)-ptw->top.x)*ptw->fontsize;
		rc.y=(ptw->cursor.y-ptw->top.y)*ptw->fontsize*2;
		rc.width=ptw->fontsize;
		rc.height=ptw->fontsize*2;
		gtk_widget_draw(ptw->drawing,&rc);
	}
	return TRUE;
}


/******************************************************************************
*                                                                             *
* ʥ/٥ȴؿ(ƥ)                                           *
*                                                                             *
******************************************************************************/
gboolean signal_focus_in(GtkWidget *widget,GdkEventFocus *event,TEXTWND *ptw)
{
	GTK_WIDGET_SET_FLAGS(widget,GTK_HAS_FOCUS);
#ifdef USE_XIM
	if (ptw->ic!=NULL)
		gdk_im_begin(ptw->ic,widget->window);
#endif
	draw_caret(ptw,NULL);
	return FALSE;
}


gboolean signal_focus_out(GtkWidget *widget,GdkEventFocus *event,TEXTWND *ptw)
{
	GTK_WIDGET_UNSET_FLAGS(widget,GTK_HAS_FOCUS);
#ifdef USE_XIM
	gdk_im_end();
#endif
	draw_caret(ptw,NULL);
	return FALSE;
}


void signal_realize(GtkWidget *widget,TEXTWND *ptw)
{
	/*  */
	gdk_window_set_cursor(ptw->drawing->window,gdk_cursor_new(GDK_XTERM));
#ifdef USE_XIM
	if (gdk_im_ready() && (ptw->ic_attr=gdk_ic_attr_new())!=NULL) {
		gint width, height;
		GdkColormap *colormap;
		GdkICAttributesType attrmask=GDK_IC_ALL_REQ
					| GDK_IC_PREEDIT_FOREGROUND | GDK_IC_PREEDIT_BACKGROUND;
		GdkIMStyle supported_style=GDK_IM_PREEDIT_NONE
									| GDK_IM_PREEDIT_NOTHING
									| GDK_IM_STATUS_NONE
									| GDK_IM_STATUS_NOTHING;

		if (ptw->font->type==GDK_FONT_FONTSET)
			supported_style|=GDK_IM_PREEDIT_POSITION;
		ptw->ic_attr->style=gdk_im_decide_style(supported_style);
		ptw->ic_attr->client_window=ptw->drawing->window;
		if ((colormap=gtk_widget_get_colormap(ptw->drawing))
										!=gtk_widget_get_default_colormap()) {
			attrmask|=GDK_IC_PREEDIT_COLORMAP;
			ptw->ic_attr->preedit_colormap=colormap;
		}
		ptw->ic_attr->preedit_foreground=ptw->syscol
												?system_color[0]:ptw->color[0];
		ptw->ic_attr->preedit_background=ptw->syscol
												?system_color[1]:ptw->color[1];
		switch (ptw->ic_attr->style&GDK_IM_PREEDIT_MASK) {
			case GDK_IM_PREEDIT_POSITION:
				if (ptw->font->type==GDK_FONT_FONTSET) {
					attrmask|=GDK_IC_PREEDIT_POSITION_REQ;
					gdk_window_get_size(ptw->drawing->window,&width,&height);
					ptw->ic_attr->spot_location.x=0;
					ptw->ic_attr->spot_location.y=0;
					ptw->ic_attr->preedit_area.x=0;
					ptw->ic_attr->preedit_area.y=0;
					ptw->ic_attr->preedit_area.width=width;
					ptw->ic_attr->preedit_area.height=height;
					ptw->ic_attr->preedit_fontset=ptw->font;
				}
				break;
		}
		if ((ptw->ic=gdk_ic_new(ptw->ic_attr,attrmask))!=NULL) {
			gtk_widget_add_events(ptw->drawing,gdk_ic_get_events(ptw->ic));
			if (GTK_WIDGET_HAS_FOCUS(ptw->drawing))
				gdk_im_begin(ptw->ic,ptw->drawing->window);
		}
	}
#endif
}


void signal_unrealize(GtkWidget *widget,TEXTWND *ptw)
{
	if (ptw->ic!=NULL) {
		gdk_ic_destroy(ptw->ic);
		ptw->ic=NULL;
	}
	if (ptw->ic_attr!=NULL) {
		gdk_ic_attr_destroy(ptw->ic_attr);
		ptw->ic_attr=NULL;
	}
}


void signal_value_changed_hscroll(GtkAdjustment *adjust,TEXTWND *ptw)
{
	GdkPoint top;

	top=ptw->top;
	ptw->top.x=adjust->value;
	move_text_window(ptw,&top);
	draw_caret(ptw,NULL);
}


void signal_value_changed_vscroll(GtkAdjustment *adjust,TEXTWND *ptw)
{
	gint max,sx;
	GdkPoint top;

	top=ptw->top;
	ptw->top.y=adjust->value;
	sx=MAX(ptw->drawing->allocation.width/ptw->fontsize,1);
	max=get_width_max(ptw);
	if (ptw->top.x>max-sx+1)
		ptw->top.x=MAX(max-sx+1,0);
	move_text_window(ptw,&top);
	draw_caret(ptw,NULL);
}


gboolean signal_config(GtkWidget *widget,
										GdkEventConfigure *config,TEXTWND *ptw)
{
	gint max,sx,sy;

	sx=MAX(config->width/ptw->fontsize,1);
	sy=MAX(config->height/(ptw->fontsize*2),1);
	if (ptw->top.y>ptw->max-sy)
		ptw->top.y=MAX(ptw->max-sy,0);
	max=get_width_max(ptw);
	if (ptw->top.x>max-sx+1)
		ptw->top.x=MAX(max-sx+1,0);
	set_scroll_bar(ptw->hscroll,signal_value_changed_hscroll,ptw,
												0,max,sx,ptw->top.x);
	set_scroll_bar(ptw->vscroll,signal_value_changed_vscroll,ptw,
												0,ptw->max-1,sy,ptw->top.y);
#ifdef USE_XIM
	if (ptw->ic!=NULL
				&& (gdk_ic_get_style(ptw->ic)&GDK_IM_PREEDIT_POSITION)!=0) {
		gint width,height;

		gdk_window_get_size(widget->window,&width,&height);
		ptw->ic_attr->preedit_area.width=width;
		ptw->ic_attr->preedit_area.height=height;
		gdk_ic_set_attr(ptw->ic,ptw->ic_attr,GDK_IC_PREEDIT_AREA);
	}
#endif
	return TRUE;
}


gboolean signal_expose(GtkWidget *widget,GdkEventExpose *event,TEXTWND *ptw)
{
	gboolean select,space=FALSE;
	gint i,x,y,datapos,length,width;
	GdkGC *gc;
	GdkPoint start,end,cursor,pt[4];
	LINEBUF *p;

	gc=gdk_gc_new(widget->window);
	gdk_gc_set_line_attributes(gc,1,
								GDK_LINE_SOLID,GDK_CAP_BUTT,GDK_JOIN_MITER);
	for (i=0;i<10;i++)
		gdk_color_alloc(gdk_colormap_get_system(),
									(ptw->syscol?system_color:ptw->color)+i);
	cursor.x=get_align_pos(&ptw->start,&ptw->off,ptw->cursor.x,ptw->cursor.y,
															ptw->tab,FALSE);
	cursor.y=ptw->cursor.y;
	if (ptw->select.x==-1) {
		/* ϰϤʤȤ */
		start.x=-1;
	} else if (ptw->select.y<ptw->cursor.y
			|| (ptw->select.y==ptw->cursor.y && ptw->select.x<ptw->cursor.x)) {
		/* ϰϤȤ */
		start=ptw->select;
		end=cursor;
	} else {
		/* ϰϤȤ */
		start=cursor;
		end=ptw->select;
	}
	/* ط */
	gdk_gc_set_foreground(gc,(ptw->syscol?system_color:ptw->color)+1);
	gdk_draw_rectangle(widget->window,gc,TRUE,event->area.x,event->area.y,
										event->area.width,event->area.height);
	if (ptw->gline) {
		/* å */
		gdk_gc_set_foreground(gc,(ptw->syscol?system_color:ptw->color)+7);
		for (x=ptw->fontsize-1;x<widget->allocation.width;x+=ptw->fontsize)
			gdk_draw_line(widget->window,gc,x,event->area.y,
										x,event->area.y+event->area.height);
		for (y=ptw->fontsize*2-1;y<widget->allocation.height;
															y+=ptw->fontsize*2)
			gdk_draw_line(widget->window,gc,event->area.x,y,
										event->area.x+event->area.width,y);
	}
	if (ptw->vline) {
		/*  */
		gdk_gc_set_foreground(gc,(ptw->syscol?system_color:ptw->color)+7);
		for (x=(ptw->tab-ptw->top.x%ptw->tab)*ptw->fontsize-1;
						x<widget->allocation.width;x+=ptw->fontsize*ptw->tab)
			gdk_draw_line(widget->window,gc,x,event->area.y,
										x,event->area.y+event->area.height);
	}
	if (ptw->mline) {
		/* ޡ */
		gdk_gc_set_foreground(gc,(ptw->syscol?system_color:ptw->color)+6);
		x=(ptw->margin-ptw->top.x)*ptw->fontsize;
		gdk_draw_line(widget->window,gc,x,event->area.y,
										x,event->area.y+event->area.height);
	}

	for (y=0,p=get_line_buf(&ptw->start,&ptw->off,ptw->top.y);
								y<event->area.y+event->area.height && p!=NULL;
												y+=ptw->fontsize*2,p=p->next) {
		if (y+ptw->fontsize*2<event->area.y)
			continue;
		x=-ptw->top.x*ptw->fontsize;
		datapos=0;
		while (x<=event->area.x+event->area.width && datapos<p->length) {
			if (x+MAX(ptw->tab,2)*ptw->fontsize<event->area.x) {
				/* ¦ɽʤʬ׻ */
				if (p->text[datapos]=='\t') {
					x=(((x/ptw->fontsize+ptw->top.x)/ptw->tab+1)
										*ptw->tab-ptw->top.x)*ptw->fontsize;
					datapos++;
				} else if (datapos+charset->length[(gint)(guchar)
												p->text[datapos]]<=p->length) {
					/* Ⱦ/ */
					x+=ptw->fontsize
							*charset->width[(gint)(guchar)p->text[datapos]];
					datapos+=charset->length[(gint)(guchar)p->text[datapos]];
				} else {
					/* Ⱦ */
					x+=ptw->fontsize;
					datapos++;
				}
				continue;
			}
			/* ϰ */
			select=start.x!=-1 && (start.y==end.y?
								start.y==ptw->top.y+y/(ptw->fontsize*2)
										&& start.x<=ptw->top.x+x/ptw->fontsize
										&& ptw->top.x+x/ptw->fontsize<end.x
								:(start.y<ptw->top.y+y/(ptw->fontsize*2)
									&& ptw->top.y+y/(ptw->fontsize*2)<end.y)
									|| (start.y==ptw->top.y+y/(ptw->fontsize*2)
										&& start.x<=ptw->top.x+x/ptw->fontsize)
									|| (end.y==ptw->top.y+y/(ptw->fontsize*2)
										&& ptw->top.x+x/ptw->fontsize<end.x));
			if (p->text[datapos]=='\t') {
				/*  */
				width=(((x/ptw->fontsize+ptw->top.x)/ptw->tab+1)
										*ptw->tab-ptw->top.x)*ptw->fontsize-x;
				if (select) {
					/*  */
					gdk_gc_set_foreground(gc,
									(ptw->syscol?system_color:ptw->color)+9);
					gdk_draw_rectangle(widget->window,gc,TRUE,x,y,
														width,ptw->fontsize*2);
				}
				if (ptw->uline) {
					/*  */
					gdk_gc_set_foreground(gc,
									(ptw->syscol?system_color:ptw->color)+5);
					gdk_draw_line(widget->window,gc,x,y+ptw->fontsize*2-1,
												x+width,y+ptw->fontsize*2-1);
				}
				if (ptw->code) {
					/* ʸ */
					gdk_gc_set_foreground(gc,
									(ptw->syscol?system_color:ptw->color)+2);
					gdk_draw_rectangle(widget->window,gc,FALSE,
										x+ptw->fontsize/6,y+ptw->fontsize*2/3,
										ptw->fontsize*2/3,ptw->fontsize*2/3);
				}
				datapos++;
			} else if (datapos+charset->length[(gint)(guchar)p->text[datapos]]
																<=p->length) {
				/* Ⱦ/ */
				width=ptw->fontsize
							*charset->width[(gint)(guchar)p->text[datapos]];
				if (select) {
					/*  */
					gdk_gc_set_foreground(gc,
									(ptw->syscol?system_color:ptw->color)+9);
					gdk_draw_rectangle(widget->window,gc,TRUE,x,y,
														width,ptw->fontsize*2);
					gdk_gc_set_foreground(gc,
									(ptw->syscol?system_color:ptw->color)+8);
				} else {
					gdk_gc_set_foreground(gc,
									ptw->syscol?system_color:ptw->color);
				}
				if (ptw->space && charset->space!=NULL) {
					space=FALSE;/* ѥڡȽ */
					for (i=0;charset->space[i]!=0;i+=charset->space[i]+1)
						if (charset->length[(gint)(guchar)p->text[datapos]]
															==charset->space[i]
								&& memcmp(p->text+datapos,charset->space+i+1,
														charset->space[i])==0)
							space=TRUE;
				}
				if (space) {
					/* ѥڡ */
					gdk_gc_set_foreground(gc,
									(ptw->syscol?system_color:ptw->color)+3);
					gdk_draw_rectangle(widget->window,gc,TRUE,x+1,y+1,
													width-1,ptw->fontsize*2-1);
				} else {
					/* ʸ */
					gdk_draw_text(widget->window,ptw->font,gc,
										x,y+ptw->fontascent,p->text+datapos,
							charset->length[(gint)(guchar)p->text[datapos]]);
				}
				datapos+=charset->length[(gint)(guchar)p->text[datapos]];
			} else {
				/* Ⱦ */
				width=ptw->fontsize;
				if (select) {
					/*  */
					gdk_gc_set_foreground(gc,
									(ptw->syscol?system_color:ptw->color)+9);
					gdk_draw_rectangle(widget->window,gc,TRUE,x,y,
														width,ptw->fontsize*2);
					gdk_gc_set_foreground(gc,
									(ptw->syscol?system_color:ptw->color)+8);
				} else {
					gdk_gc_set_foreground(gc,
									ptw->syscol?system_color:ptw->color);
				}
				gdk_draw_text(widget->window,ptw->font,gc,
										x,y+ptw->fontascent,p->text+datapos,1);
				datapos++;
			}
			/* åȤ */
			if (caret && GTK_WIDGET_HAS_FOCUS(widget)
								&& cursor.x==ptw->top.x+x/ptw->fontsize
								&& cursor.y==ptw->top.y+y/(ptw->fontsize*2)) {
				gdk_gc_set_function(gc,GDK_INVERT);
				gdk_draw_rectangle(widget->window,gc,TRUE,x,y,
										ins?2:ptw->fontsize,ptw->fontsize*2);
				gdk_gc_set_function(gc,GDK_COPY);
			}
			x+=width;
		}
		if (datapos==p->length && ptw->crlf) {
			if (start.x>=0 && start.y<=ptw->top.y+y/(ptw->fontsize*2)
									&& ptw->top.y+y/(ptw->fontsize*2)<end.y) {
				/*  */
				gdk_gc_set_foreground(gc,
									(ptw->syscol?system_color:ptw->color)+9);
				gdk_draw_rectangle(widget->window,gc,TRUE,x,y,
												ptw->fontsize,ptw->fontsize*2);
			}
			gdk_gc_set_foreground(gc,
									(ptw->syscol?system_color:ptw->color)+4);
			if (p->next==NULL) {
				/* եκǸ */
				gdk_draw_arc(widget->window,gc,TRUE,
								x+ptw->fontsize/6,y+ptw->fontsize*2/3,
								ptw->fontsize*2/3,ptw->fontsize*2/3,0,360*64);
			} else {
				if (p->margin) {
					/* ޡˤ */
					pt[0].x=pt[3].x=x+ptw->fontsize/6;
					pt[0].y=pt[1].y=y+ptw->fontsize*2/3;
					pt[1].x=pt[2].x=x+ptw->fontsize*5/6;
					pt[2].y=pt[3].y=y+ptw->fontsize*4/3;
					length=4;
				} else {
					/* ̾β */
					pt[0].x=x+ptw->fontsize/6;
					pt[1].x=x+ptw->fontsize*5/6;
					pt[0].y=pt[1].y=y+ptw->fontsize*2/3;
					pt[2].x=x+ptw->fontsize/2;
					pt[2].y=y+ptw->fontsize*4/3;
					length=3;
				}
				gdk_draw_polygon(widget->window,gc,TRUE,pt,length);
			}
		}
		/* åȤ */
		if (caret && GTK_WIDGET_HAS_FOCUS(widget)
								&& cursor.x==ptw->top.x+x/ptw->fontsize
								&& cursor.y==ptw->top.y+y/(ptw->fontsize*2)) {
			gdk_gc_set_function(gc,GDK_INVERT);
			gdk_draw_rectangle(widget->window,gc,TRUE,x,y,
										ins?2:ptw->fontsize,ptw->fontsize*2);
			gdk_gc_set_function(gc,GDK_COPY);
		}
	}

	gdk_gc_destroy(gc);
	return TRUE;
}


gboolean signal_button_press(GtkWidget *widget,
											GdkEventButton *event,TEXTWND *ptw)
{
	if (!GTK_WIDGET_HAS_FOCUS(widget))
		gtk_widget_grab_focus(widget);
	switch (event->type) {
	case GDK_BUTTON_PRESS:
		switch (event->button) {
		case 1:/* å */
			{
				gboolean shift;
				GdkPoint cursor,select;

				cursor=ptw->cursor;
				select=ptw->select;
				ptw->cursor.x=ptw->top.x+event->x/ptw->fontsize;
				ptw->cursor.y=ptw->top.y+event->y/(ptw->fontsize*2);
				shift=(event->state&GDK_SHIFT_MASK)!=0;
				if (ptw->cursor.y<0)
					ptw->cursor.y=0;
				else if (ptw->cursor.y>ptw->max-1)
					ptw->cursor.y=ptw->max-1;
				if (ptw->cursor.x<get_width(&ptw->start,&ptw->off,
													ptw->cursor.y,ptw->tab))
					ptw->cursor.x=get_align_pos(&ptw->start,&ptw->off,
								ptw->cursor.x,ptw->cursor.y,ptw->tab,FALSE);
				if (ptw->select.x>=0
									&& (!shift || (ptw->cursor.x==ptw->select.x
										&& ptw->cursor.y==ptw->select.y))) {
					/*  */
					ptw->select.x=-1;
					clear_sel(ptw,&cursor,&select);
					set_menu_bar(ptw);
				} else if (shift && (ptw->cursor.x!=cursor.x
												|| ptw->cursor.y!=cursor.y)) {
					if (ptw->select.x<0) {
						/* 򤹤 */
						ptw->select.x=get_align_pos(&ptw->start,&ptw->off,
											cursor.x,cursor.y,ptw->tab,FALSE);
						ptw->select.y=cursor.y;
						gtk_selection_owner_set(window,GDK_SELECTION_PRIMARY,
															GDK_CURRENT_TIME);
					}
					clear_sel(ptw,&cursor,&ptw->cursor);
					set_menu_bar(ptw);
				}
				draw_caret(ptw,&cursor);
			}
			break;
		case 2:/* 楯å */
			{
				gchar *text=NULL;
				gint length;
				GdkPoint cursor,select;
				DOING *d;

				if (gdk_selection_owner_get(GDK_SELECTION_PRIMARY)
										==window->window && ptw->select.x>=0) {
					/* 쥯ΥʡʬΤȤ */
					/* ϰϤ */
					length=get_sel_byte(&ptw->start,&ptw->off,
										&ptw->select,&ptw->cursor,ptw->tab);
					text=g_malloc((length+1)*sizeof(gchar));
					cpy_sel_mem(&ptw->start,&ptw->off,
									&ptw->select,&ptw->cursor,ptw->tab,text);
					text[length]='\0';
				}
				/* åȰư */
				cursor=ptw->cursor;
				select=ptw->select;
				ptw->cursor.x=ptw->top.x+event->x/ptw->fontsize;
				ptw->cursor.y=ptw->top.y+event->y/(ptw->fontsize*2);
				if (ptw->cursor.y<0)
					ptw->cursor.y=0;
				else if (ptw->cursor.y>ptw->max-1)
					ptw->cursor.y=ptw->max-1;
				if (ptw->cursor.x<get_width(&ptw->start,&ptw->off,
													ptw->cursor.y,ptw->tab))
					ptw->cursor.x=get_align_pos(&ptw->start,&ptw->off,
								ptw->cursor.x,ptw->cursor.y,ptw->tab,FALSE);
				/*  */
				if (ptw->select.x>=0) {
					ptw->select.x=-1;
					clear_sel(ptw,&cursor,&select);
					if (text==NULL)
						set_menu_bar(ptw);
				}
				/* å */
				draw_caret(ptw,&cursor);
				if (text!=NULL) {
					/* Žդ */
					d=edit_operation(ptw,text,strlen(text),FALSE,TRUE);
					d->next=ptw->undo;
					ptw->undo=d;
					if (delete_list(&ptw->redo)>0 || d->next==NULL
																|| select.x<0)
						set_menu_bar(ptw);
					ptw->edit=TRUE;
					g_free(text);
				} else {
					/* 쥯ΥʡʬǤϤʤȤ */
					gtk_selection_convert(window,GDK_SELECTION_PRIMARY,
												atom_targets,GDK_CURRENT_TIME);
				}
			}
			break;
		case 3:/* å */
			gtk_widget_set_sensitive(gtk_item_factory_get_widget(
				item_factory_popup,_("<main>/᤹(U)")),ptw->undo!=NULL);
			gtk_widget_set_sensitive(gtk_item_factory_get_widget(
				item_factory_popup,_("<main>/ڤ(T)")),ptw->select.x>=0);
			gtk_widget_set_sensitive(gtk_item_factory_get_widget(
				item_factory_popup,_("<main>/ԡ(C)")),ptw->select.x>=0);
			gtk_widget_set_sensitive(gtk_item_factory_get_widget(
				item_factory_popup,_("<main>/(L)")),ptw->select.x>=0);
			gtk_menu_popup(GTK_MENU(
					gtk_item_factory_get_widget(item_factory_popup,"<main>")),
								NULL,NULL,NULL,NULL,event->button,event->time);
			break;
		case 4:/* ۥ */
		case 5:
			{
				gint max,sx,sy;
				GdkPoint top;

				top=ptw->top;
				ptw->top.y+=event->button==4?-4:4;
				sx=MAX(ptw->drawing->allocation.width/ptw->fontsize,1);
				sy=MAX(ptw->drawing->allocation.height/(ptw->fontsize*2),1);
				if (ptw->top.y<0)
					ptw->top.y=0;
				else if (ptw->top.y>ptw->max-sy)
					ptw->top.y=MAX(ptw->max-sy,0);
				max=get_width_max(ptw);
				if (ptw->top.x>max-sx+1)
					ptw->top.x=MAX(max-sx+1,0);
				move_text_window(ptw,&top);
				draw_caret(ptw,NULL);
			}
		}
		break;
	case GDK_2BUTTON_PRESS:
		{
			gint i,j,k,datapos,length,ct,ctype,*type;
			LINEBUF *p;
			GdkPoint cursor;

			if (event->button!=1)
				return FALSE;
			/* ֥륯åȤñ򤹤 */
			if (ptw->select.x>=0)
				break;
			p=get_line_buf(&ptw->start,&ptw->off,ptw->cursor.y);
			if (p->length<=0)
				break;
			cursor=ptw->cursor;
			i=0;
			j=datapos=get_data_pos(&ptw->start,&ptw->off,
								ptw->cursor.x,ptw->cursor.y,ptw->tab,FALSE);
			if (datapos>0) {
				type=g_malloc(datapos*sizeof(gint));
				/* 򳫻ϰ */
				while (i<datapos)
					if (i+charset->length[(gint)(guchar)p->text[i]]<=datapos) {
						for (k=0;k<charset->length[(gint)(guchar)p->text[i]];
																		k++)
							type[i+k]=k+1;
						i+=charset->length[(gint)(guchar)p->text[i]];
					} else {
						type[i++]=1;
					}
				if (i<p->length) {
					length=i+charset->length[(gint)(guchar)p->text[i]]
																	<=p->length
								?charset->length[(gint)(guchar)p->text[i]]:1;
					ctype=get_char_type(p->text+i,length);
					j+=length;
				} else {
					length=type[i-1];
					i-=length;
					ctype=get_char_type(p->text+i,length);
				}
				while (i>0 && (i-=(length=type[i-1]))>0) {
					ct=get_char_type(p->text+i,length);
					if (ctype!=ct) {
						i+=length;
						break;
					}
				}
				g_free(type);
			} else {
				length=charset->length[(gint)(guchar)p->text[0]]<=p->length
								?charset->length[(gint)(guchar)p->text[0]]:1;
				ctype=get_char_type(p->text,length);
				j+=length;
			}
			/* λ */
			while (j<p->length) {
				length=j+charset->length[(gint)(guchar)p->text[j]]
					<=p->length?charset->length[(gint)(guchar)p->text[j]]:1;
				ct=get_char_type(p->text+j,length);
				if (ctype!=ct)
					break;
				j+=length;
			}
			ptw->select.x=get_screen_pos(&ptw->start,&ptw->off,
													i,ptw->cursor.y,ptw->tab);
			ptw->cursor.x=get_screen_pos(&ptw->start,&ptw->off,
													j,ptw->cursor.y,ptw->tab);
			ptw->select.y=ptw->cursor.y;
			if (ptw->select.x==ptw->cursor.x) {
				/*  */
				ptw->select.x=-1;
			} else {
				/* 򤹤 */
				set_menu_bar(ptw);
				draw_caret(ptw,&cursor);
				clear_sel(ptw,&ptw->select,&ptw->cursor);
				gtk_selection_owner_set(window,GDK_SELECTION_PRIMARY,
															GDK_CURRENT_TIME);
			}
		}
		break;
	default:
		return FALSE;
	}
	return TRUE;
}


/*	ޥΰư˴ؤ
	  ptw,ƥȾ
	    x,Xɸ
	    y,Yɸ
	state,ơ
	  RET,TRUE:뤢,FALSE:ʤ							*/
static gboolean signal_motion_notify_draw(TEXTWND *ptw,gint x,gint y,
														GdkModifierType state)
{
	gint s,sx,sy;
	GdkPoint cursor,select,top,ps;

	cursor=ptw->cursor;
	select=ptw->select;
	top=ptw->top;
	sx=MAX(ptw->drawing->allocation.width/ptw->fontsize,1);
	sy=MAX(ptw->drawing->allocation.height/(ptw->fontsize*2),1);
	ps.x=x;
	ps.y=y;
	if (ps.x<0)
		ps.x=0;
	else if (ps.x>ptw->drawing->allocation.width)
		ps.x=ptw->drawing->allocation.width;
	if (ps.y<0)
		ps.y=0;
	else if (ps.y>ptw->drawing->allocation.height)
		ps.y=ptw->drawing->allocation.height;
	/* 뤬ˤȤ뤹 */
	if (sx>1) {
		if (x<0 && ptw->top.x>0)
			ptw->top.x--;
		else if (x>ptw->drawing->allocation.width
								&& ptw->top.x<get_width(&ptw->start,&ptw->off,
												ptw->cursor.y,ptw->tab)+1-sx)
			ptw->top.x++;
	}
	if (sy>1) {
		if (y<0 && ptw->top.y>0)
			ptw->top.y--;
		else if (y>ptw->drawing->allocation.height && ptw->top.y<ptw->max-sy)
			ptw->top.y++;
	}
	s=ps.x-((ptw->select.x<0?ptw->cursor.x:ptw->select.x)
													-ptw->top.x)*ptw->fontsize;
	if (s<ptw->fontsize/2 || ptw->fontsize<s
					|| (ptw->select.x<0?ptw->cursor.y:ptw->select.y)
										!=ps.y/(ptw->fontsize*2)+ptw->top.y) {
		if (ptw->select.x<0) {
			/* 򤹤 */
			ptw->select.x=get_align_pos(&ptw->start,&ptw->off,
								ptw->cursor.x,ptw->cursor.y,ptw->tab,FALSE);
			ptw->select.y=ptw->cursor.y;
		}
		ptw->cursor.x=ps.x/ptw->fontsize+ptw->top.x;
		ptw->cursor.y=ps.y/(ptw->fontsize*2)+ptw->top.y;
		if (ptw->cursor.y<0)
			ptw->cursor.y=0;
		else if (ptw->cursor.y>ptw->max-1)
			ptw->cursor.y=ptw->max-1;
		ptw->cursor.x=get_align_pos(&ptw->start,&ptw->off,
								ptw->cursor.x,ptw->cursor.y,ptw->tab,FALSE);
	} else if (ptw->select.x>=0) {
		/*  */
		ptw->cursor=ptw->select;
		ptw->select.x=-1;
	}
	if (ptw->select.x==ptw->cursor.x && ptw->select.y==ptw->cursor.y)
		ptw->select.x=-1;/* νȽ꤬ƱȤ */
	else if (select.x==-1)/* 򤹤 */
		gtk_selection_owner_set(window,GDK_SELECTION_PRIMARY,GDK_CURRENT_TIME);
	if (ptw->cursor.x!=cursor.x || ptw->cursor.y!=cursor.y
								|| ptw->top.x!=top.x || ptw->top.y!=top.y) {
		set_menu_bar(ptw);
		move_text_window(ptw,&top);
		draw_caret(ptw,&cursor);
		clear_sel(ptw,&ptw->cursor,&cursor);
	}
	return ptw->top.x!=top.x || ptw->top.y!=top.y;
}


static gboolean signal_timeout_draw(TEXTWND *ptw)
{
	gboolean result;
	gint x,y;
	GdkModifierType state;

	gdk_window_get_pointer(ptw->drawing->window,&x,&y,&state);
	if ((state&GDK_BUTTON1_MASK)!=0) {
		result=signal_motion_notify_draw(ptw,x,y,state);
		if (!result) {
			/* 뤬ä饿ޤϺ */
			gtk_timeout_remove(ptw->timer_id);
			ptw->timer_id=0;
		}
	} else {
		result=FALSE;
	}
	return result;
}


gboolean signal_motion_notify(GtkWidget *widget,
											GdkEventMotion *event,TEXTWND *ptw)
{
	gint x,y;
	GdkModifierType state;

	if (event->is_hint) {
		gdk_window_get_pointer(event->window,&x,&y,&state);
	} else {
		x=event->x;
		y=event->y;
		state=event->state;
	}
	if ((state&GDK_BUTTON1_MASK)!=0
			&& signal_motion_notify_draw(ptw,x,y,state) && ptw->timer_id==0)
		/* Ϥƥ뤷Ȥ */
		ptw->timer_id=gtk_timeout_add(1,(GtkFunction)signal_timeout_draw,ptw);
	return TRUE;
}


gboolean signal_button_release(GtkWidget *widget,
											GdkEventButton *event,TEXTWND *ptw)
{
	if (ptw->timer_id!=0) {
		gtk_timeout_remove(ptw->timer_id);
		ptw->timer_id=0;
	}
	return TRUE;
}


gboolean signal_key_press(GtkWidget *widget,GdkEventKey *event,TEXTWND *ptw)
{
	gboolean result=FALSE;/* TRUE:λ,FALSE:³ */

	switch (event->keyval) {
	case GDK_Home:
	case GDK_Left:
	case GDK_Up:
	case GDK_Right:
	case GDK_Down:
	case GDK_Page_Up:
	case GDK_Page_Down:
	case GDK_End:
	case GDK_comma:
	case GDK_period:
	case GDK_less:
	case GDK_greater:
	case GDK_H:
	case GDK_J:
	case GDK_K:
	case GDK_L:
	case GDK_h:
	case GDK_j:
	case GDK_k:
	case GDK_l:
		{
			gint sx,sy,width;
			gboolean alt,ctrl;
			GdkPoint cursor,top,select;

			cursor=ptw->cursor;
			top=ptw->top;
			sx=MAX(ptw->drawing->allocation.width/ptw->fontsize,1);
			sy=MAX(ptw->drawing->allocation.height/(ptw->fontsize*2),1);
			alt=(event->state&(GDK_MOD1_MASK|GDK_MOD2_MASK|GDK_MOD3_MASK
											|GDK_MOD4_MASK|GDK_MOD5_MASK))!=0;
			ctrl=(event->state&GDK_CONTROL_MASK)!=0;
			switch (event->keyval) {
			case GDK_Home:
				ptw->cursor.x=0;
				if (ctrl)
					ptw->cursor.y=0;
				break;
			case GDK_End:
				ptw->cursor.x=get_width(&ptw->start,&ptw->off,
						ctrl?ptw->cursor.y=ptw->max-1:ptw->cursor.y,ptw->tab);
				break;
			case GDK_H:
			case GDK_h:
				if (!alt)
					goto loop;
			case GDK_Left:
				ptw->cursor.x=get_align_pos(&ptw->start,&ptw->off,
								ptw->cursor.x,ptw->cursor.y,ptw->tab,FALSE);
				if (ptw->cursor.x>0) {
					ptw->cursor.x=ctrl?get_move_pos(&ptw->start,&ptw->off,
									ptw->cursor.x,ptw->cursor.y,ptw->tab,FALSE)
							:get_align_pos(&ptw->start,&ptw->off,
								ptw->cursor.x-1,ptw->cursor.y,ptw->tab,FALSE);
				} else if (ptw->cursor.y>0) {
					/* ιԤκǸ */
					ptw->cursor.y--;
					ptw->cursor.x=get_width(&ptw->start,&ptw->off,
													ptw->cursor.y,ptw->tab);
				}
				break;
			case GDK_L:
			case GDK_l:
				if (!alt)
					goto loop;
			case GDK_Right:
				width=get_width(&ptw->start,&ptw->off,ptw->cursor.y,ptw->tab);
				if (ptw->cursor.x<width) {
					ptw->cursor.x=ctrl?get_move_pos(&ptw->start,&ptw->off,
									ptw->cursor.x,ptw->cursor.y,ptw->tab,TRUE)
							:get_align_pos(&ptw->start,&ptw->off,
								ptw->cursor.x+1,ptw->cursor.y,ptw->tab,TRUE);
				} else if (ptw->cursor.y<ptw->max-1) {
					/* ιԤκǽ */
					ptw->cursor.x=0;
					ptw->cursor.y++;
				}
				break;
			case GDK_comma:
			case GDK_less:
				if (!ctrl)
					goto loop;
				ptw->cursor.x=get_align_pos(&ptw->start,&ptw->off,
								ptw->cursor.x,ptw->cursor.y,ptw->tab,FALSE);
				if (ptw->cursor.x>0) {
					ptw->cursor.x=get_move_pos(&ptw->start,&ptw->off,
								ptw->cursor.x,ptw->cursor.y,ptw->tab,FALSE);
				} else if (ptw->cursor.y>0) {
					/* ιԤκǸ */
					ptw->cursor.y--;
					ptw->cursor.x=get_width(&ptw->start,&ptw->off,
													ptw->cursor.y,ptw->tab);
				}
				break;
			case GDK_period:
			case GDK_greater:
				if (!ctrl)
					goto loop;
				width=get_width(&ptw->start,&ptw->off,ptw->cursor.y,ptw->tab);
				if (ptw->cursor.x<width) {
					ptw->cursor.x=get_move_pos(&ptw->start,&ptw->off,
									ptw->cursor.x,ptw->cursor.y,ptw->tab,TRUE);
				} else if (ptw->cursor.y<ptw->max-1) {
					/* ιԤκǽ */
					ptw->cursor.x=0;
					ptw->cursor.y++;
				}
				break;
			case GDK_K:
			case GDK_k:
				if (!alt)
					goto loop;
			case GDK_Up:
				if (!ctrl) {
					ptw->cursor.y--;
				} else if (ptw->top.y>0) {
					ptw->top.y--;
					if (ptw->cursor.y-sy+1>ptw->top.y)
						ptw->cursor.y--;
				}
				break;
			case GDK_J:
			case GDK_j:
				if (!alt)
					goto loop;
			case GDK_Down:
				if (!ctrl) {
					ptw->cursor.y++;
				} else if (ptw->top.y<ptw->max-sy) {
					ptw->top.y++;
					if (ptw->cursor.y<ptw->top.y)
						ptw->cursor.y++;
				}
				break;
			case GDK_Page_Up:
				if (ctrl) {
					ptw->cursor.y=ptw->top.y;
				} else {
					ptw->cursor.y-=sy;
					ptw->top.y-=sy;
				}
				break;
			case GDK_Page_Down:
				if (ctrl) {
					ptw->cursor.y=ptw->top.y+sy-1;
				} else {
					ptw->cursor.y+=sy;
					ptw->top.y+=sy;
				}
			}
			if (ptw->cursor.y<0)
				ptw->cursor.y=0;
			else if (ptw->cursor.y>ptw->max-1)
				ptw->cursor.y=ptw->max-1;
			if (ptw->top.y<0)
				ptw->top.y=0;
			else if (ptw->top.y>ptw->max-sy)
				ptw->top.y=MAX(ptw->max-sy,0);
			if (ptw->cursor.x<ptw->top.x)
				ptw->top.x=ptw->cursor.x;
			else if (ptw->cursor.x-sx+1>ptw->top.x)
				ptw->top.x=ptw->cursor.x-sx+1;
			if (ptw->cursor.y<ptw->top.y)
				ptw->top.y=ptw->cursor.y;
			else if (ptw->cursor.y-sy+1>ptw->top.y)
				ptw->top.y=ptw->cursor.y-sy+1;
			select=ptw->select;
			if ((event->state&GDK_SHIFT_MASK)==0) {
				/*  */
				ptw->select.x=-1;
			} else {
				if (ptw->select.x<0) {
					/*  */
					ptw->select.x=get_align_pos(&ptw->start,&ptw->off,
											cursor.x,cursor.y,ptw->tab,FALSE);
					ptw->select.y=cursor.y;
				}
				if (ptw->select.y==ptw->cursor.y
								&& ptw->select.x==get_align_pos(&ptw->start,
										&ptw->off,ptw->cursor.x,ptw->cursor.y,
															ptw->tab,FALSE))
					ptw->select.x=-1;/* ϰϤƱȤ */
				else
					gtk_selection_owner_set(window,GDK_SELECTION_PRIMARY,
															GDK_CURRENT_TIME);
			}
			if (ptw->cursor.x==cursor.x && ptw->cursor.y==cursor.y
						&& ptw->top.x==top.x && ptw->top.y==top.y
						&& ptw->select.x==select.x && ptw->select.y==select.y)
				break;
			if (ptw->select.x!=select.x)
				set_menu_bar(ptw);
			move_text_window(ptw,&top);
			draw_caret(ptw,&cursor);
			if (select.x>=0 && ptw->select.x<0)
				clear_sel(ptw,&select,&cursor);
			else if (ptw->select.x>=0)
				clear_sel(ptw,&ptw->cursor,&cursor);
		}
		result=TRUE;
		break;
	case GDK_BackSpace:
		{
			DOING *d;
			GdkPoint select;

			select=ptw->select;
			if (ptw->select.x<0) {
				ptw->cursor.x=get_align_pos(&ptw->start,&ptw->off,
								ptw->cursor.x,ptw->cursor.y,ptw->tab,FALSE);
				if (ptw->cursor.x>0) {
					ptw->select.x=(event->state&GDK_CONTROL_MASK)==0
							?get_align_pos(&ptw->start,&ptw->off,
								ptw->cursor.x-1,ptw->cursor.y,ptw->tab,FALSE)
							:get_move_pos(&ptw->start,&ptw->off,
								ptw->cursor.x,ptw->cursor.y,ptw->tab,FALSE);
					ptw->select.y=ptw->cursor.y;
				} else if (ptw->cursor.y>0) {
					/* 2ĤιԤ1Ĥˤ */
					ptw->select.y=ptw->cursor.y-1;
					ptw->select.x=get_width(&ptw->start,&ptw->off,
													ptw->select.y,ptw->tab);
				} else {
					break;
				}
			}
			d=edit_operation(ptw,NULL,0,FALSE,FALSE);
			d->next=ptw->undo;
			ptw->undo=d;
			if (delete_list(&ptw->redo)>0 || d->next==NULL || select.x>=0)
				set_menu_bar(ptw);
			ptw->edit=TRUE;
		}
		result=TRUE;
		break;
	case GDK_Return:
		{
			DOING *d;
			GdkPoint select;

			if ((event->state&GDK_MODIFIER_MASK)!=0)
				break;
			select=ptw->select;
			d=edit_operation(ptw,"\n",1,TRUE,FALSE);
			d->next=ptw->undo;
			ptw->undo=d;
			if (delete_list(&ptw->redo)>0 || d->next==NULL || select.x>=0)
				set_menu_bar(ptw);
			ptw->edit=TRUE;
		}
		result=TRUE;
		break;
	case GDK_Escape:
		{
			gint sx,sy;
			GdkPoint select,top;

			if (ptw->select.x<0)
				break;
			select=ptw->select;
			top=ptw->top;
			sx=MAX(ptw->drawing->allocation.width/ptw->fontsize,1);
			sy=MAX(ptw->drawing->allocation.height/(ptw->fontsize*2),1);
			if (ptw->cursor.x<ptw->top.x)
				ptw->top.x=ptw->cursor.x;
			else if (ptw->cursor.x-sx+1>ptw->top.x)
				ptw->top.x=ptw->cursor.x-sx+1;
			if (ptw->cursor.y<ptw->top.y)
				ptw->top.y=ptw->cursor.y;
			else if (ptw->cursor.y-sy+1>ptw->top.y)
				ptw->top.y=ptw->cursor.y-sy+1;
			ptw->select.x=-1;
			set_menu_bar(ptw);
			move_text_window(ptw,&top);
			clear_sel(ptw,&select,&ptw->cursor);
			draw_caret(ptw,NULL);
		}
		result=TRUE;
		break;
	case GDK_Delete:
		{
			gint width;
			DOING *d;
			GdkPoint select;

			select=ptw->select;
			if (ptw->select.x<0) {
				width=get_width(&ptw->start,&ptw->off,ptw->cursor.y,ptw->tab);
				ptw->cursor.x=get_align_pos(&ptw->start,&ptw->off,
								ptw->cursor.x,ptw->cursor.y,ptw->tab,FALSE);
				if (ptw->cursor.x<width) {
					ptw->select.x=(event->state&GDK_CONTROL_MASK)==0
						?get_align_pos(&ptw->start,&ptw->off,
								ptw->cursor.x+1,ptw->cursor.y,ptw->tab,TRUE)
						:get_move_pos(&ptw->start,&ptw->off,
								ptw->cursor.x,ptw->cursor.y,ptw->tab,TRUE);
					ptw->select.y=ptw->cursor.y;
				} else if (ptw->cursor.y<ptw->max-1) {
					/* 2ĤιԤ1Ĥˤ */
					ptw->select.x=0;
					ptw->select.y=ptw->cursor.y+1;
				} else {
					break;
				}
			}
			d=edit_operation(ptw,NULL,0,FALSE,FALSE);
			d->next=ptw->undo;
			ptw->undo=d;
			if (delete_list(&ptw->redo)>0 || d->next==NULL || select.x>=0)
				set_menu_bar(ptw);
			ptw->edit=TRUE;
		}
		result=TRUE;
		break;
	case GDK_Insert:
		ins=!ins;
		draw_caret(ptw,NULL);
		result=TRUE;
		break;
	case GDK_Y:
	case GDK_y:
		{
			DOING *d;
			GdkPoint select;

			if ((event->state&GDK_CONTROL_MASK)==0)
				goto loop;
			select=ptw->select;
			if (ptw->select.x<0) {
				if (ptw->max-1<=ptw->cursor.y) {
					ptw->cursor.x=0;
					ptw->select.x=get_width(&ptw->start,&ptw->off,
													ptw->cursor.y,ptw->tab);
					if (ptw->select.x<=0) {
						if (ptw->cursor.y<=0) {
							ptw->select.x=-1;
						return 0;
						}
						ptw->select.y=ptw->cursor.y-1;
					} else {
						ptw->select.y=ptw->cursor.y;
					}
				} else {
					ptw->cursor.x=ptw->select.x=0;
					ptw->select.y=ptw->cursor.y+1;
				}
			}
			d=edit_operation(ptw,NULL,0,FALSE,FALSE);
			d->next=ptw->undo;
			ptw->undo=d;
			if (delete_list(&ptw->redo)>0 || d->next==NULL || select.x>=0)
				set_menu_bar(ptw);
			ptw->edit=TRUE;
		}
		result=TRUE;
		break;
	default:
		loop:
		if (event->string!=NULL
				&& ((guchar)event->string[0]>=' ' || event->string[0]=='\t')
				&& (event->state&(GDK_MOD1_MASK|GDK_MOD2_MASK|GDK_MOD3_MASK
										|GDK_MOD4_MASK|GDK_MOD5_MASK))==0) {
			DOING *d;
			GdkPoint select;

			select=ptw->select;
			ptw->cursor.x=get_align_pos(&ptw->start,&ptw->off,
								ptw->cursor.x,ptw->cursor.y,ptw->tab,FALSE);
			if (ptw->select.x<0 && !ins) {
				ptw->select.x=get_align_pos(&ptw->start,&ptw->off,
								ptw->cursor.x+1,ptw->cursor.y,ptw->tab,TRUE);
				if (ptw->select.x<=ptw->cursor.x)
					ptw->select.x=-1;
				ptw->select.y=ptw->cursor.y;
			}
			d=edit_operation(ptw,event->string,event->length,TRUE,FALSE);
			d->next=ptw->undo;
			ptw->undo=d;
			if (delete_list(&ptw->redo)>0 || d->next==NULL || select.x>=0)
				set_menu_bar(ptw);
			ptw->edit=TRUE;
			result=TRUE;
		}
	}
	return result;
}


void signal_destroy_draw(GtkWidget *widget,TEXTWND *ptw)
{
	GList *glist;
	LINEBUF *p;
	GtkWidget *sub_menu;

	/* ե̾Ĵ٤ */
	delete_edit_file(ptw->file);
	/* ɥ˥塼 */
	sub_menu=gtk_item_factory_get_widget(item_factory_menu,
													_("<main>/ɥ(W)"));
	gtk_container_remove(GTK_CONTAINER(sub_menu),ptw->menu_item);
	/* ˥塼 */
	glist=gtk_container_children(GTK_CONTAINER(notebook));
	if (g_list_length(glist)<=1) {
		set_menu_bar(NULL);
		gtk_statusbar_pop(GTK_STATUSBAR(status),
				gtk_statusbar_get_context_id(GTK_STATUSBAR(status),"Status"));
	}
	g_list_free(glist);
	/*  */
	g_free(ptw->file);
	gdk_font_unref(ptw->font);
	if (ptw->timer_id!=0) {
		gtk_timeout_remove(ptw->timer_id);
		ptw->timer_id=0;
	}
	while (ptw->start->prev!=NULL)
		ptw->start=ptw->start->prev;
	while (ptw->start!=NULL) {
		p=ptw->start->next;
		if (ptw->start->text!=NULL)
			g_free(ptw->start->text);
		g_free(ptw->start);
		ptw->start=p;
	}
	delete_list(&ptw->undo);
	delete_list(&ptw->redo);
	g_free(ptw);
}


/******************************************************************************
*                                                                             *
* ʥ/٥ȴؿ(ƥ)                                           *
*                                                                             *
******************************************************************************/
void signal_style_set(GtkWidget *widget,GtkStyle *style,gpointer user_data)
{
	gint i,j,max,sx,sy,fontsize,ascent;
	GList *glist;
	TEXTWND *ptw;

	/* ƥ࿧ */
	style=gtk_widget_get_style(widget);
	system_color[0]=style->text[0];
	system_color[1]=style->base[0];
	system_color[2]=style->dark[0];
	system_color[3]=style->dark[0];
	system_color[4]=style->dark[0];
	system_color[5]=style->dark[0];
	system_color[6]=style->dark[0];
	system_color[7]=style->mid[0];
	system_color[8]=style->fg[3];
	system_color[9]=style->bg[3];
	if (system_font!=NULL)
		gdk_font_unref(system_font);
	/* ƥե */
	system_font=gdk_font_ref(style->font);
	glist=gtk_container_children(GTK_CONTAINER(notebook));
	for (i=g_list_length(glist)-1;i>=0;i--) {
		ptw=gtk_object_get_user_data(GTK_OBJECT(g_list_nth_data(glist,i)));
		if (ptw->syscol || ptw->fontname==NULL) {
			if (ptw->fontname==NULL) {
				/* եѹ */
				gdk_font_unref(ptw->font);
				ptw->font=gdk_font_ref(system_font);
				ptw->fontascent=ptw->fontsize=0;
				for (j=0x20;j<=0x7e;j++) {
					gdk_text_extents(ptw->font,(gchar *)&j,1,
												NULL,NULL,NULL,&ascent,NULL);
					if (ptw->fontascent<ascent)
						ptw->fontascent=ascent;
					fontsize=(gdk_char_height(ptw->font,j)+1)/2;
					if (ptw->fontsize<fontsize)
						ptw->fontsize=fontsize;
				}
				/* С */
				sx=MAX(ptw->drawing->allocation.width/ptw->fontsize,1);
				sy=MAX(ptw->drawing->allocation.height/(ptw->fontsize*2),1);
				if (ptw->top.y>ptw->max-sy)
					ptw->top.y=MAX(ptw->max-sy,0);
				max=get_width_max(ptw);
				if (ptw->top.x>max-sx+1)
					ptw->top.x=MAX(max-sx+1,0);
				set_scroll_bar(ptw->hscroll,signal_value_changed_hscroll,ptw,
												0,max,sx,ptw->top.x);
				set_scroll_bar(ptw->vscroll,signal_value_changed_vscroll,ptw,
												0,ptw->max-1,sy,ptw->top.y);
			}
			gtk_widget_draw(ptw->drawing,NULL);/*  */
#ifdef USE_XIM
			if (gdk_im_ready() && ptw->ic!=NULL
				&& (gdk_ic_get_style(ptw->ic)&GDK_IM_PREEDIT_POSITION)!=0) {
				gdk_ic_get_attr(ptw->ic,ptw->ic_attr,
					(ptw->fontname==NULL?GDK_IC_PREEDIT_FONTSET:0)
					| (ptw->syscol?GDK_IC_PREEDIT_FOREGROUND
											| GDK_IC_PREEDIT_BACKGROUND:0));
				if (ptw->syscol) {
					ptw->ic_attr->preedit_foreground=system_color[0];
					ptw->ic_attr->preedit_background=system_color[1];
				}
				if (ptw->fontname==NULL)
					ptw->ic_attr->preedit_fontset=ptw->font;
				gdk_ic_set_attr(ptw->ic,ptw->ic_attr,
					(ptw->fontname==NULL?GDK_IC_PREEDIT_FONTSET:0)
					| (ptw->syscol?GDK_IC_PREEDIT_FOREGROUND
											| GDK_IC_PREEDIT_BACKGROUND:0));
			}
#endif
		}
	}
	g_list_free(glist);
}


/******************************************************************************
*                                                                             *
* ʥ/٥ȴؿ(˥塼)                                           *
*                                                                             *
******************************************************************************/
void signal_activate_menu_window(GtkWidget *widget,GtkWidget *child)
{
	gtk_notebook_set_page(GTK_NOTEBOOK(notebook),
						gtk_notebook_page_num(GTK_NOTEBOOK(notebook),child));
}


void signal_activate_menu_history(GtkWidget *widget,gchar *file)
{
	open_edit_file(file);
}


void signal_destroy_menu_history(GtkWidget *widget,gchar *file)
{
	g_free(file);
}


/******************************************************************************
*                                                                             *
* ʥ/٥ȴؿ(Ρ)                                             *
*                                                                             *
******************************************************************************/
void signal_switch_page(GtkNotebook *notebook,GtkNotebookPage *page,
											gint page_num,gpointer user_data)
{
	TEXTWND *ptw;

	ptw=gtk_object_get_user_data(GTK_OBJECT(page->child));
	/* ˥塼ɽ */
	set_menu_bar(ptw);
}


void signal_destroy_notebook(GtkWidget *widget,gpointer user_data)
{
	gtk_timeout_remove(timer_id);
}


/******************************************************************************
*                                                                             *
* ʥ/٥ȴؿ(ᥤ)                                             *
*                                                                             *
******************************************************************************/
void signal_drag_data_received(GtkWidget *widget,GdkDragContext *context,
		gint x,gint y,GtkSelectionData *selection_data,guint info,guint time)
{
	gchar **files;
	gint i;

	files=g_strsplit(selection_data->data,"\r\n",G_MAXINT);
	for (i=0;files[i]!=NULL;i++)
		if (strncmp(files[i],"file:",5)==0)
			open_edit_file(files[i]+5);
	g_strfreev(files);
}


gboolean signal_selection_clear(GtkWidget *widget,GdkEventSelection *event,
															gpointer user_data)
{
	if (event->selection==atom_clipboard) {
		g_free(clipboard_text);
		clipboard_text=NULL;
	}
	return TRUE;
}


void signal_selection_get(GtkWidget *widget,GtkSelectionData *data,
									guint info,guint time,gpointer user_data)
{
	gchar *text=NULL;
	guchar *compound_text;
	gint length=0,compound_length,format,page;
	GdkAtom encoding;
	TEXTWND *ptw;

	if (data->selection==GDK_SELECTION_PRIMARY) {
		/* ץ饤ޥꥻ쥯 */
		page=gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
		if (page>=0) {
			ptw=gtk_object_get_user_data(GTK_OBJECT(
					gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),page)));
			if (ptw->select.x>=0) {
				length=get_sel_byte(&ptw->start,&ptw->off,
										&ptw->select,&ptw->cursor,ptw->tab);
				text=g_malloc((length+1)*sizeof(gchar));
				cpy_sel_mem(&ptw->start,&ptw->off,
									&ptw->select,&ptw->cursor,ptw->tab,text);
				text[length]='\0';
			}
		}
	} else if (data->selection==atom_clipboard) {
		/* åץܡ */
		if (clipboard_text!=NULL) {
			text=clipboard_text;
			length=strlen(clipboard_text);
		}
	} else if (data->selection==atom_textmaid) {
		/* ץ̿ */
		text="Text maid Selection";
		length=strlen(text);
	}
	if (text!=NULL) {
		if (info==TARGET_STRING) {
			gtk_selection_data_set(data,GDK_SELECTION_TYPE_STRING,
										8*sizeof(gchar),(guchar *)text,length);
		} else if (info==TARGET_TEXT || info==TARGET_COMPOUND_TEXT) {
			gdk_string_to_compound_text(text,&encoding,&format,
											&compound_text,&compound_length);
			gtk_selection_data_set(data,encoding,format,
												compound_text,compound_length);
			gdk_free_compound_text(compound_text);
		}
		if (data->selection==GDK_SELECTION_PRIMARY)
			g_free(text);
	}
}


void signal_selection_received(GtkWidget *widget,GtkSelectionData *data,
												guint time,gpointer user_data)
{
	gchar *text=NULL,*str,**list;
	gint i,count;
	DOING *d;
	TEXTWND *ptw;
	GdkAtom *atoms;
	GdkPoint select;

	if (data->selection==GDK_SELECTION_PRIMARY
										|| data->selection==atom_clipboard) {
		/* ץ饤ޥꥻ쥯/åץܡ */
		if (data->length>=0) {
			if (data->type==GDK_SELECTION_TYPE_ATOM) {
				atoms=(GdkAtom *)data->data;
				count=data->length/sizeof(GdkAtom);
				for (i=0;i<count;i++)
					if (atoms[i]==atom_compound || atoms[i]==atom_text)
						break;
				if (i>=count)
					for (i=0;i<count;i++)
						if (atoms[i]==GDK_TARGET_STRING)
							break;
				if (i<count)
					gtk_selection_convert(widget,data->selection,atoms[i],
															GDK_CURRENT_TIME);
			} else if (data->type==GDK_TARGET_STRING) {
				text=g_strdup(data->data);
			} else if (data->type==atom_compound || data->type==atom_text) {
				count=gdk_text_property_to_text_list(data->type,data->format,
												data->data,data->length,&list);
				if (count>0) {
					text=g_strdup(list[0]);
					for (i=1;i<count;i++) {
						str=g_strconcat(text,list[i],NULL);
						g_free(text);
						text=str;
					}
					gdk_free_text_list(list);
				}
			}
		}
		if (text!=NULL) {
			ptw=gtk_object_get_user_data(GTK_OBJECT(
					gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));
			select=ptw->select;
			d=edit_operation(ptw,text,strlen(text),
										data->selection==atom_clipboard,FALSE);
			d->next=ptw->undo;
			ptw->undo=d;
			if (delete_list(&ptw->redo)>0 || d->next==NULL || select.x>=0)
				set_menu_bar(ptw);
			ptw->edit=TRUE;
			g_free(text);
		}
	} else if (data->selection==atom_textmaid) {
		/* ץ̿ */
		instance=MAX(data->length,0);
	}
}


gboolean signal_client_event(GtkWidget *widget,GdkEventClient *event,
															gpointer user_data)
{
	gint i;
	COMM *p;
	TEXTWND *ptw;

	if (event->message_type==atom_textmaid) {
		for (p=comm;p!=NULL;p=p->next)
			if (p->pid==event->data.l[4])
				break;
		if (p==NULL) {
			p=g_malloc(sizeof(COMM));
			p->str=NULL;
			p->leng=0;
			p->init_line=0;
			p->pid=event->data.l[4];
			p->prev=NULL;
			p->next=comm;
			if (p->next!=NULL) {
				p->next->prev=p;
			}
			comm=p;
		}
		switch (event->data_format) {
			case 8:
				p->str=g_realloc(p->str,p->leng+16);
				memcpy(p->str+p->leng,event->data.b,16);
				p->leng+=16;
				for (i=0;i<16;i++)
					if (event->data.b[i]=='\0')
						break;
				if (i<16) {
					ptw=open_edit_file(p->str);
					if (p->init_line!=0)	/* Ԥ˰ư */
						jump_operation(ptw,p->init_line);
					g_free(p->str);
					if (p->prev!=NULL)
						p->prev->next=p->next;
					if (p->next!=NULL)
						p->next->prev=p->prev;
					if (comm==p)
						comm=comm->next;
					g_free(p);
				}
				break;
			case 32:
				p->init_line=event->data.l[0];
		}
		return TRUE;
	}
	return FALSE;
}


gboolean signal_delete(GtkWidget *widget,GdkEvent *event,gpointer user_data)
{
	gint page;
	TEXTWND *ptw;

	while ((page=gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))>=0) {
		ptw=gtk_object_get_user_data(GTK_OBJECT(
					gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),page)));
		if (!prompt_close(ptw))
			return TRUE;
		gtk_notebook_remove_page(GTK_NOTEBOOK(notebook),page);
	}
	return FALSE;
}


void signal_destroy_window(GtkWidget *widget,gpointer user_data)
{
	gint i;
	GList *glist;
	GtkWidget *sub_menu;

	memset(hisfile,0,sizeof(gchar *)*10);
	sub_menu=gtk_item_factory_get_widget(item_factory_menu,
													_("<main>/ե(F)"));
	glist=gtk_container_children(GTK_CONTAINER(sub_menu));
	for (i=0;i<(gint)g_list_length(glist)-MENUFILE-1;i++)
		hisfile[i]=g_strdup(gtk_object_get_user_data(
							GTK_OBJECT(g_list_nth_data(glist,i+MENUFILE-1))));
	g_list_free(glist);
	gtk_main_quit();
}
