/*
    Text maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <stdio.h>
#include <string.h>
#include "abort.h"
#include "file.h"
#include "other.h"
#include "signal.h"


/******************************************************************************
*                                                                             *
* եؿ                                                              *
*                                                                             *
******************************************************************************/
/*	ե˲ä
	file,ե̾															*/
void set_history(gchar *file)
{
	gchar *label;
	gint i,count;
	GList *glist;
	GtkWidget *sub_menu,*menu_item;

	sub_menu=gtk_item_factory_get_widget(item_factory_menu,
													_("<main>/ե(F)"));
	glist=gtk_container_children(GTK_CONTAINER(sub_menu));
	count=g_list_length(glist);
	for (i=0;i<count-MENUFILE-1;i++) {
		menu_item=g_list_nth_data(glist,i+MENUFILE-1);
		label=gtk_object_get_user_data(GTK_OBJECT(menu_item));
		if (strcmp(label,file)==0) {
			gtk_container_remove(GTK_CONTAINER(sub_menu),menu_item);
			break;
		}
	}
	g_list_free(glist);
	if (i>=history) {
		glist=gtk_container_children(GTK_CONTAINER(sub_menu));
		gtk_container_remove(GTK_CONTAINER(sub_menu),
								g_list_nth_data(glist,MENUFILE+history+1-3));
		g_list_free(glist);
	}
	if (count<=MENUFILE) {
		menu_item=gtk_menu_item_new();
		gtk_menu_insert(GTK_MENU(sub_menu),menu_item,MENUFILE-2);
		gtk_widget_show(menu_item);
	}
	label=g_strdup(file);
	menu_item=gtk_menu_item_new_with_label(label);
	gtk_signal_connect(GTK_OBJECT(menu_item),"activate",
						GTK_SIGNAL_FUNC(signal_activate_menu_history),label);
	gtk_signal_connect(GTK_OBJECT(menu_item),"destroy",
						GTK_SIGNAL_FUNC(signal_destroy_menu_history),label);
	gtk_object_set_user_data(GTK_OBJECT(menu_item),label);
	gtk_menu_insert(GTK_MENU(sub_menu),menu_item,MENUFILE-1);
	gtk_widget_show(menu_item);
}


/*	եä
	file,ä褦ȤեΥեѥ
	same,եѥ°
	 RET,ä褦ȤեΥ٥										*/
gchar *add_edit_file(gchar *file,gint *same)
{
	gchar *label,*name0,*name1;
	gint i;
	GList *glist;
	TEXTWND *ptw;
	GtkWidget *child;

	*same=-1;
	/* ե̾Ĵ٤ */
	glist=gtk_container_children(GTK_CONTAINER(notebook));
	/* Ʊ̾ƱѥĴ٤ */
	for (i=g_list_length(glist)-1;i>=0;i--) {
		child=g_list_nth_data(glist,i);
		ptw=gtk_object_get_user_data(GTK_OBJECT(child));
		if (strcmp(file,ptw->file)==0) {
			if (ptw->same<0) {
				ptw->same=0;
				label=g_strdup_printf("%s:%d",ptw->file,ptw->same);
				gtk_notebook_set_tab_label_text(GTK_NOTEBOOK(notebook),child,
																		label);
				g_free(label);
			}
			if (*same<=ptw->same)
				*same=ptw->same+1;
		}
	}
	if (*same>=0) {
		/* Ʊ̾ƱѥȤ */
		label=g_strdup_printf("%s:%d",file,*same);
	} else {
		/* Ʊ̾ƱѥϤʤȤ */
		/* Ʊ̾ۥѥĴ٤ */
		name0=g_basename(file);
		for (i=g_list_length(glist)-1;i>=0;i--) {
			child=g_list_nth_data(glist,i);
			ptw=gtk_object_get_user_data(GTK_OBJECT(child));
			name1=g_basename(ptw->file);
			if (strcmp(name0,name1)==0) {
				if (ptw->same<0)
					gtk_notebook_set_tab_label_text(GTK_NOTEBOOK(notebook),
															child,ptw->file);
				break;
			}
		}
		label=g_strdup(i>=0?file:name0);
	}
	g_list_free(glist);
	return label;
}


/*	ե
	file,褦ȤեΥեѥ									*/
void delete_edit_file(gchar *file)
{
	gchar *name0,*name1;
	gint i,count=0;
	GList *glist;
	TEXTWND *ptw;
	GtkWidget *child;

	/* ե̾Ĵ٤ */
	glist=gtk_container_children(GTK_CONTAINER(notebook));
	/* Ʊ̾ۥѥĴ٤ */
	name0=g_basename(file);
	for (i=g_list_length(glist)-1;i>=0;i--) {
		ptw=gtk_object_get_user_data(g_list_nth_data(glist,i));
		name1=g_basename(ptw->file);
		if (strcmp(name0,name1)==0)
			count++;
	}
	if (count<=2) {
		/* Ʊ̾ۥѥΥե̾ɽѹ */
		for (i=g_list_length(glist)-1;i>=0;i--) {
			child=g_list_nth_data(glist,i);
			ptw=gtk_object_get_user_data(GTK_OBJECT(child));
			name1=g_basename(ptw->file);
			if (strcmp(name0,name1)==0)
				gtk_notebook_set_tab_label_text(GTK_NOTEBOOK(notebook),child,
																		name1);
		}
	} else {
		/* Ʊ̾ƱѥĴ٤ */
		count=0;
		for (i=g_list_length(glist)-1;i>=0;i--) {
			ptw=gtk_object_get_user_data(g_list_nth_data(glist,i));
			if (strcmp(file,ptw->file)==0)
				count++;
		}
		if (count<=2)/* Ʊ̾ƱѥΥեեѥɽѹ */
			for (i=g_list_length(glist)-1;i>=0;i--) {
				child=g_list_nth_data(glist,i);
				ptw=gtk_object_get_user_data(GTK_OBJECT(child));
				if (strcmp(file,ptw->file)==0) {
					ptw->same=-1;
					gtk_notebook_set_tab_label_text(GTK_NOTEBOOK(notebook),
															child,ptw->file);
				}
			}
	}
}


/******************************************************************************
*                                                                             *
* եϴؿ                                                          *
*                                                                             *
******************************************************************************/
/*	TXTե򳫤
	ptw,TXTɥ													*/
void open_text_file(TEXTWND *ptw)
{
	int c;
	FILE *fp;
	LINEBUF *p,*q;
	GtkWidget *dialog;

	if ((fp=fopen(ptw->file,"rt"))==NULL)
		return;
	p=g_malloc(sizeof(LINEBUF));
	p->length=0;
	p->margin=FALSE;
	p->text=NULL;
	p->prev=p->next=NULL;
	ptw->max=1;
	ptw->off=0;
	ptw->start=p;
	/* ܥå */
	userbreak=TRUE;
	dialog=abort_dialog(_("եɤ߹"));
	gtk_grab_add(dialog);
	while ((c=fgetc(fp))!=EOF && userbreak) {
		while (gtk_events_pending())
			gtk_main_iteration();
		if (c=='\n') {
			q=g_malloc(sizeof(LINEBUF));
			q->text=NULL;
			q->length=0;
			q->margin=FALSE;
			q->prev=p;
			q->next=p->next;
			p->next=q;
			p=q;
			ptw->max++;
		} else {
			p->text=g_realloc(p->text,(p->length+1)*sizeof(gchar));
			p->text[p->length++]=c;
		}
	}
	/* λ */
	gtk_grab_remove(dialog);
    gtk_widget_destroy(dialog);
	fclose(fp);
}


/*	ե򳫤
	file,ե̾
	 RET,TXTɥ													*/
TEXTWND *open_edit_file(gchar *file)
{
	gchar *ext,*p,*label;
	gint i,leng0,leng1,fontsize,ascent;
	TEXTWND *ptw;
	GtkWidget *table,*sub_menu;
	static gint fcount=0;	/* եο */

	ptw=g_malloc(sizeof(TEXTWND));
	ptw->same=-1;
	ptw->edit=FALSE;
	ptw->start=NULL;
	ptw->undo=ptw->redo=NULL;
	ptw->top.x=ptw->top.y=ptw->cursor.x=ptw->cursor.y=0;
	ptw->select.x=-1;
	ptw->timer_id=0;
	ptw->ic=NULL;
	ptw->ic_attr=NULL;
	if (file==NULL) {
		/*  */
		ptw->file=g_strdup_printf("new%04d",fcount++%1000);
		ptw->create=TRUE;
		ptw->ft_id=ftype[0].associate?ftype[0].ft_id:-1;
		ptw->margin=ftype[0].margin;
		ptw->tab=ftype[0].tab;
		ptw->code=ftype[0].code;
		ptw->crlf=ftype[0].crlf;
		ptw->eof=ftype[0].eof;
		ptw->limit=ftype[0].limit;
		ptw->overwrite=ftype[0].overwrite;
		ptw->space=ftype[0].space;
		ptw->syscol=ftype[0].syscol;
		ptw->gline=ftype[0].gline;
		ptw->mline=ftype[0].mline;
		ptw->uline=ftype[0].uline;
		ptw->vline=ftype[0].vline;
		ptw->fontname=g_strdup(ftype[0].fontname);
		memcpy(ptw->color,ftype[0].color,sizeof(GdkColor)*12);
	} else {
		ptw->file=get_full_path(file);
		leng0=strlen(ptw->file);
		for (i=0;i<ftnum;i++) {
			if (strcmp(ftype[i].ext,"*")==0)
				break;
			ext=g_strdup(ftype[i].ext);
			for (p=strtok(ext,";");p!=NULL;p=strtok(NULL,";")) {
				leng1=strlen(p);
				if (leng0>=leng1 && strcmp(ptw->file+leng0-leng1,p)==0)
					goto loop;
			}
			g_free(ext);
		}
		loop:
		if (i>=ftnum)
			i=0;
		ptw->create=FALSE;
		ptw->ft_id=ftype[i].associate?ftype[i].ft_id:-1;
		ptw->margin=ftype[i].margin;
		ptw->tab=ftype[i].tab;
		ptw->code=ftype[i].code;
		ptw->crlf=ftype[i].crlf;
		ptw->eof=ftype[i].eof;
		ptw->limit=ftype[i].limit;
		ptw->overwrite=ftype[i].overwrite;
		ptw->space=ftype[i].space;
		ptw->syscol=ftype[i].syscol;
		ptw->gline=ftype[i].gline;
		ptw->mline=ftype[i].mline;
		ptw->uline=ftype[i].uline;
		ptw->vline=ftype[i].vline;
		ptw->fontname=g_strdup(ftype[i].fontname);
		memcpy(ptw->color,ftype[i].color,sizeof(GdkColor)*12);
		open_text_file(ptw);
	}
	if (ptw->start==NULL) {
		/* ե뤬0ХȤΤȤ */
		ptw->off=0;
		ptw->max=1;
		ptw->start=g_malloc(sizeof(LINEBUF));
		ptw->start->length=0;
		ptw->start->margin=FALSE;
		ptw->start->text=NULL;
		ptw->start->prev=ptw->start->next=NULL;
	}

	/* ե̾Ĵ٤ */
	label=add_edit_file(ptw->file,&ptw->same);

	/* ե */
	ptw->font=ptw->fontname==NULL?gdk_font_ref(system_font)
											:gdk_fontset_load(ptw->fontname);
	ptw->fontascent=ptw->fontsize=0;
	for (i=0x20;i<=0x7e;i++) {
		gdk_text_extents(ptw->font,(gchar *)&i,1,NULL,NULL,NULL,&ascent,NULL);
		if (ptw->fontascent<ascent)
			ptw->fontascent=ascent;
		fontsize=(gdk_char_height(ptw->font,i)+1)/2;
		if (ptw->fontsize<fontsize)
			ptw->fontsize=fontsize;
	}

	/* ɽꥢ */
	ptw->drawing=gtk_drawing_area_new();
	gtk_signal_connect(GTK_OBJECT(ptw->drawing),"focus-in-event",
									GTK_SIGNAL_FUNC(signal_focus_in),ptw);
	gtk_signal_connect(GTK_OBJECT(ptw->drawing),"focus-out-event",
									GTK_SIGNAL_FUNC(signal_focus_out),ptw);
	gtk_signal_connect(GTK_OBJECT(ptw->drawing),"realize",
									GTK_SIGNAL_FUNC(signal_realize),ptw);
	gtk_signal_connect(GTK_OBJECT(ptw->drawing),"unrealize",
									GTK_SIGNAL_FUNC(signal_unrealize),ptw);
	gtk_signal_connect(GTK_OBJECT(ptw->drawing),"configure-event",
									GTK_SIGNAL_FUNC(signal_config),ptw);
	gtk_signal_connect(GTK_OBJECT(ptw->drawing),"expose-event",
									GTK_SIGNAL_FUNC(signal_expose),ptw);
	gtk_signal_connect(GTK_OBJECT(ptw->drawing),"button-press-event",
									GTK_SIGNAL_FUNC(signal_button_press),ptw);
	gtk_signal_connect(GTK_OBJECT(ptw->drawing),"motion-notify-event",
									GTK_SIGNAL_FUNC(signal_motion_notify),ptw);
	gtk_signal_connect_after(GTK_OBJECT(ptw->drawing),"key-press-event",
									GTK_SIGNAL_FUNC(signal_key_press),ptw);
	gtk_signal_connect(GTK_OBJECT(ptw->drawing),"destroy",
									GTK_SIGNAL_FUNC(signal_destroy_draw),ptw);
	gtk_widget_add_events(ptw->drawing,GDK_FOCUS_CHANGE | GDK_BUTTON_PRESS_MASK
					| GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK);
	GTK_WIDGET_SET_FLAGS(ptw->drawing,GTK_CAN_FOCUS);
	/* С */
	ptw->hscroll=gtk_hscrollbar_new(
							GTK_ADJUSTMENT(gtk_adjustment_new(0,0,0,1,1,1)));
	ptw->vscroll=gtk_vscrollbar_new(
							GTK_ADJUSTMENT(gtk_adjustment_new(0,0,0,1,1,1)));
	/* ơ֥ */
	table=gtk_table_new(2,2,FALSE);
	gtk_table_attach(GTK_TABLE(table),ptw->drawing,0,1,0,1,
									GTK_EXPAND | GTK_SHRINK | GTK_FILL,
									GTK_EXPAND | GTK_SHRINK | GTK_FILL,0,0);
	gtk_table_attach(GTK_TABLE(table),ptw->hscroll,0,1,1,2,
							GTK_EXPAND | GTK_SHRINK | GTK_FILL,GTK_FILL,0,0);
	gtk_table_attach(GTK_TABLE(table),ptw->vscroll,1,2,0,1,
							GTK_FILL,GTK_EXPAND | GTK_SHRINK | GTK_FILL,0,0);
	gtk_object_set_user_data(GTK_OBJECT(table),ptw);
	/* ˥塼 */
	sub_menu=gtk_item_factory_get_widget(item_factory_menu,
													_("<main>/ɥ(W)"));
	ptw->menu_item=gtk_menu_item_new_with_label(ptw->file);
	gtk_signal_connect(GTK_OBJECT(ptw->menu_item),"activate",
						GTK_SIGNAL_FUNC(signal_activate_menu_window),table);
	gtk_menu_append(GTK_MENU(sub_menu),ptw->menu_item);
	gtk_widget_show(ptw->menu_item);
	/* ɽ */
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),table,
														gtk_label_new(label));
	g_free(label);
	gtk_widget_show_all(table);
	gtk_notebook_set_page(GTK_NOTEBOOK(notebook),
						gtk_notebook_page_num(GTK_NOTEBOOK(notebook),table));
	gtk_widget_grab_focus(ptw->drawing);

	/* ǤϤʤե뤬¸ߤˤ˲ä */
	if (file!=NULL && history>0 && isfile(ptw->file))
		set_history(ptw->file);

	return ptw;
}


/******************************************************************************
*                                                                             *
* եϴؿ                                                          *
*                                                                             *
******************************************************************************/
/*	TXTե¸
	file,ե̾
	 ptw,TXTɥ
	 RET,TRUE:ｪλ,FALSE:顼											*/
gboolean save_text_file(gchar *file,TEXTWND *ptw)
{
	gboolean eof=FALSE;
	FILE *fp;
	LINEBUF *p;
	GtkWidget *dialog;

	p=ptw->start;
	while (p->prev!=NULL)
		p=p->prev;
	/*  */
	if ((fp=fopen(file,"wt"))==NULL) {
		message_box("Text maid",_("ե뤬ޤ"),0,_("λ"),NULL);
		return FALSE;
	}
	/* ܥå */
	userbreak=TRUE;
	dialog=abort_dialog(_("ե˽񤭹"));
	gtk_grab_add(dialog);
	/*  */
	while (p!=NULL && userbreak) {
		while (gtk_events_pending())
			gtk_main_iteration();
		if (p->length>0 && fwrite(p->text,1,p->length,fp)!=p->length) {
			gtk_grab_remove(dialog);
			gtk_widget_destroy(dialog);
			message_box("Text maid",_("ե˽񤭹ߤǤޤ"),0,
															_("λ"),NULL);
			fclose(fp);
			return FALSE;
		}
		if (!p->margin && p->next!=NULL) {
			if (fputc('\n',fp)==EOF) {
				gtk_grab_remove(dialog);
				gtk_widget_destroy(dialog);
				message_box("Text maid",_("ե˽񤭹ߤǤޤ"),0,
															_("λ"),NULL);
				fclose(fp);
				return FALSE;
			}
			eof=FALSE;
		} else if (p->length>0) {
			eof=p->text[p->length-1]=='\x1a';
		}
		p=p->next;
	}
	/* Ǹ^Zդä */
	if (userbreak && !eof && ptw->eof && fputc('\x1a',fp)==EOF) {
		gtk_grab_remove(dialog);
		gtk_widget_destroy(dialog);
		message_box("Text maid",_("ե˽񤭹ߤǤޤ"),0,
															_("λ"),NULL);
		fclose(fp);
		return FALSE;
	}
	/* λ */
	gtk_grab_remove(dialog);
	gtk_widget_destroy(dialog);
	if (fclose(fp)!=0) {
		message_box("Text maid","fclose",0,_("λ"),NULL);
		return FALSE;
	}
	return TRUE;
}
