/*
    Text maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "ftype.h"
#include "prop.h"


/******************************************************************************
*                                                                             *
* ץѥƥؿ                                                            *
*                                                                             *
******************************************************************************/
static gboolean property_clicked_ok,color_list[12];
static gchar *fontname;
static GdkColor gdk_color[12];
static GtkWidget *dialog;
static GtkWidget *button0,*button3;
static GtkWidget *check0,*check1,*check2,*check3,*check4;
static GtkWidget *check5,*check6,*check7,*check8,*check9;
static GtkWidget *entry0,*entry1,*spin0,*spin1;


/* OKܥɽ/ɽȽ */
static void property_dialog_ok_sensitive(GtkWidget *widget,gpointer user_data)
{
	gtk_widget_set_sensitive(button3,
		(entry0==NULL || strlen(gtk_entry_get_text(GTK_ENTRY(entry0)))>0)
		&& (entry1==NULL || strlen(gtk_entry_get_text(GTK_ENTRY(entry1)))>0));
}


/* ꥹȥܥå */
static void property_dialog_select(GtkWidget *widget,gint pos)
{
	color_list[pos]=TRUE;
	gtk_widget_set_sensitive(button0,TRUE);
}


/* ꥹȥܥå */
static void property_dialog_deselect(GtkWidget *widget,gint pos)
{
	gint i;

	color_list[pos]=FALSE;
	for (i=0;i<12;i++)
		if (color_list[i])
			break;
	gtk_widget_set_sensitive(button0,i<12);
}


/* OK줿Ȥ */
static void property_dialog_clicked_color_ok(GtkWidget *widget,
													GtkWidget *dialog_color)
{
	gint i;
	gdouble color[4];

	gtk_color_selection_get_color(GTK_COLOR_SELECTION(
					GTK_COLOR_SELECTION_DIALOG(dialog_color)->colorsel),color);
	for (i=0;i<12;i++)
		if (color_list[i]) {
			gdk_color[i].red=color[0]*0xffff;
			gdk_color[i].green=color[1]*0xffff;
			gdk_color[i].blue=color[2]*0xffff;
		}
	property_dialog_ok_sensitive(NULL,NULL);
    gtk_widget_destroy(dialog_color);
}


/* ܥ󤬲줿 */
static void property_dialog_clicked_color(GtkWidget *widget,gpointer user_data)
{
	gint i;
	gdouble color[4];
	GtkWidget *dialog_color;

	dialog_color=gtk_color_selection_dialog_new(_(""));
	gtk_signal_connect(GTK_OBJECT(dialog_color),"destroy",gtk_main_quit,NULL);
	gtk_signal_connect(GTK_OBJECT(
					GTK_COLOR_SELECTION_DIALOG(dialog_color)->ok_button),
					"clicked",property_dialog_clicked_color_ok,dialog_color);
	gtk_signal_connect_object(
		GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(dialog_color)->cancel_button),
						"clicked",gtk_widget_destroy,GTK_OBJECT(dialog_color));
	for (i=0;i<12;i++)
		if (color_list[i]) {
			color[0]=(gdouble)gdk_color[i].red/0xffff;
			color[1]=(gdouble)gdk_color[i].green/0xffff;
			color[2]=(gdouble)gdk_color[i].blue/0xffff;
			color[3]=0;
			gtk_color_selection_set_color(GTK_COLOR_SELECTION(
					GTK_COLOR_SELECTION_DIALOG(dialog_color)->colorsel),color);
			break;
		}

	gtk_widget_show(dialog_color);
	gtk_grab_add(dialog_color);
	gtk_main();
}


/* եȤOK줿Ȥ */
static void property_dialog_clicked_font_ok(GtkWidget *widget,
														GtkWidget *dialog_font)
{
	gchar *name;

	name=gtk_font_selection_dialog_get_font_name(
									GTK_FONT_SELECTION_DIALOG(dialog_font));
	if (name!=NULL && name[0]!='\0') {
		g_free(fontname);
		fontname=name;
		property_dialog_ok_sensitive(NULL,NULL);
	}
    gtk_widget_destroy(dialog_font);
}


/* եȥܥ󤬲줿 */
static void property_dialog_clicked_font(GtkWidget *widget,gpointer user_data)
{
	GtkWidget *dialog_font;

	dialog_font=gtk_font_selection_dialog_new(_("ե"));
	gtk_signal_connect(GTK_OBJECT(dialog_font),"destroy",gtk_main_quit,NULL);
	gtk_signal_connect(GTK_OBJECT(
						GTK_FONT_SELECTION_DIALOG(dialog_font)->ok_button),
						"clicked",property_dialog_clicked_font_ok,dialog_font);
	gtk_signal_connect_object(
			GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(dialog_font)->cancel_button),
						"clicked",gtk_widget_destroy,GTK_OBJECT(dialog_font));
	gtk_font_selection_dialog_set_font_name(
							GTK_FONT_SELECTION_DIALOG(dialog_font),fontname);
	gtk_widget_show(dialog_font);
	gtk_grab_add(dialog_font);
	gtk_main();
}


/* ե륿ץܥ󤬲줿 */
static void property_dialog_clicked_ftype(GtkWidget *widget,gpointer user_data)
{
	gint pos;

	if (ftype_dialog(&pos)) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check0),
															ftype[pos].grid);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check1),
															ftype[pos].space);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check2),
															ftype[pos].crlf);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check3),
															ftype[pos].mline);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check4),
															ftype[pos].limit);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check5),
															ftype[pos].code);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check6),
															ftype[pos].uline);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check7),
															ftype[pos].vline);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check8),ftype[pos].eof);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check9),
														ftype[pos].overwrite);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin0),ftype[pos].margin);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin1),ftype[pos].tab);
		memcpy(gdk_color,ftype[pos].color,sizeof(GdkColor)*12);
		g_free(fontname);
		fontname=g_strdup(ftype[pos].fontname);
		gtk_widget_set_sensitive(button3,TRUE);
	}
}


/* OKܥ󤬲줿 */
static void property_dialog_clicked_ok(GtkWidget *widget,FTYPE *ft)
{
	if (entry0!=NULL) {
		g_free(ft->text);
		ft->text=g_strdup(gtk_entry_get_text(GTK_ENTRY(entry0)));
	}
	if (entry1!=NULL) {
		g_free(ft->ext);
		ft->ext=g_strdup(gtk_entry_get_text(GTK_ENTRY(entry1)));
	}
	ft->margin=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin0));
	ft->tab=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
	ft->grid=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check0));
	ft->space=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check1));
	ft->crlf=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check2));
	ft->mline=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check3));
	ft->limit=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check4));
	ft->code=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check5));
	ft->uline=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check6));
	ft->vline=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check7));
	ft->eof=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check8));
	ft->overwrite=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check9));
	memcpy(ft->color,gdk_color,sizeof(GdkColor)*12);
	g_free(ft->fontname);
	ft->fontname=fontname;
	fontname=NULL;
    gtk_widget_destroy(dialog);
	property_clicked_ok=TRUE;
}


/* ԥܥǥ꥿󤬲줿 */
static void property_dialog_activate(GtkWidget *widget,FTYPE *ft)
{
	if ((entry0==NULL || strlen(gtk_entry_get_text(GTK_ENTRY(entry0)))>0)
		&& (entry1==NULL || strlen(gtk_entry_get_text(GTK_ENTRY(entry1)))>0))
		property_dialog_clicked_ok(widget,ft);
}


/* ESC줿 */
static gboolean property_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
															gpointer user_data)
{
	if (event->keyval==GDK_Escape)
		gtk_widget_destroy(widget);
	return FALSE;
}


gboolean property_dialog(FTYPE *ft)
{
	gchar *color_name[12]={N_("ʸ"),N_("ط"),N_("ȥ륳"),
		N_("ѥڡ"),N_("ԥ"),N_("ֲ"),
		N_("ޡ"),N_("å"),N_("򤵤줿ʸ"),
		N_("򤵤줿ط"),N_("ʸ()"),N_("ȥ륳()")};
	gint i;
	GtkWidget *button1,*button2,*button4;
	GtkWidget *list,*item,*scroll,*hbox,*tbox,*vbox;
	GtkWidget *frame0,*frame1,*frame2,*frame3,*frame4;

	/* ᥤ󥦥ɥ */
	dialog=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(dialog),ft->text==NULL || ft->ext==NULL
								?_("ץѥƥ"):_("ե륿פξܺ"));
	gtk_signal_connect_after(GTK_OBJECT(dialog),"key-press-event",
							GTK_SIGNAL_FUNC(property_dialog_key_press),NULL);
	gtk_signal_connect(GTK_OBJECT(dialog),"destroy",gtk_main_quit,NULL);

	/* ܥ */
	button0=gtk_button_new_with_label(_("ѹ"));
	button1=gtk_button_new_with_label(_("ե"));
	button2=ft->text==NULL && ft->ext==NULL
						?gtk_button_new_with_label(_("ե륿")):NULL;
	button3=gtk_button_new_with_label(_("λ"));
	button4=gtk_button_new_with_label(_(""));
	gtk_signal_connect(GTK_OBJECT(button0),"clicked",
										property_dialog_clicked_color,NULL);
	gtk_signal_connect(GTK_OBJECT(button1),"clicked",
										property_dialog_clicked_font,NULL);
	if (button2!=NULL)
		gtk_signal_connect(GTK_OBJECT(button2),"clicked",
										property_dialog_clicked_ftype,NULL);
	gtk_signal_connect(GTK_OBJECT(button3),"clicked",
										property_dialog_clicked_ok,ft);
	gtk_signal_connect_object(GTK_OBJECT(button4),"clicked",
										gtk_widget_destroy,GTK_OBJECT(dialog));
	/* åܥ */
	check0=gtk_check_button_new_with_label(_("å"));
	check1=gtk_check_button_new_with_label(_("ѥڡ"));
	check2=gtk_check_button_new_with_label(_("ԥ"));
	check3=gtk_check_button_new_with_label(_("ޡɽ"));
	check4=gtk_check_button_new_with_label(_("ޤ֤"));
	check5=gtk_check_button_new_with_label(_("ʸ"));
	check6=gtk_check_button_new_with_label(_(""));
	check7=gtk_check_button_new_with_label(_(""));
	check8=gtk_check_button_new_with_label(
										_("եκǸ^Z(1A)դ"));
	check9=gtk_check_button_new_with_label(_("¸ǧ"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check0),ft->grid);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check1),ft->space);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check2),ft->crlf);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check3),ft->mline);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check4),ft->limit);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check5),ft->code);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check6),ft->uline);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check7),ft->vline);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check8),ft->eof);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check9),ft->overwrite);
	gtk_signal_connect(GTK_OBJECT(check0),"toggled",
											property_dialog_ok_sensitive,NULL);
	gtk_signal_connect(GTK_OBJECT(check1),"toggled",
											property_dialog_ok_sensitive,NULL);
	gtk_signal_connect(GTK_OBJECT(check2),"toggled",
											property_dialog_ok_sensitive,NULL);
	gtk_signal_connect(GTK_OBJECT(check3),"toggled",
											property_dialog_ok_sensitive,NULL);
	gtk_signal_connect(GTK_OBJECT(check4),"toggled",
											property_dialog_ok_sensitive,NULL);
	gtk_signal_connect(GTK_OBJECT(check5),"toggled",
											property_dialog_ok_sensitive,NULL);
	gtk_signal_connect(GTK_OBJECT(check6),"toggled",
											property_dialog_ok_sensitive,NULL);
	gtk_signal_connect(GTK_OBJECT(check7),"toggled",
											property_dialog_ok_sensitive,NULL);
	gtk_signal_connect(GTK_OBJECT(check8),"toggled",
											property_dialog_ok_sensitive,NULL);
	gtk_signal_connect(GTK_OBJECT(check9),"toggled",
											property_dialog_ok_sensitive,NULL);
	/* ȥ꡼ */
	if (ft->text!=NULL && ft->ext!=NULL) {
		entry0=gtk_entry_new_with_max_length(256);
		entry1=gtk_entry_new_with_max_length(256);
		gtk_entry_set_text(GTK_ENTRY(entry0),ft->text);
		gtk_entry_set_text(GTK_ENTRY(entry1),ft->ext);
		gtk_signal_connect(GTK_OBJECT(entry0),"changed",
											property_dialog_ok_sensitive,NULL);
		gtk_signal_connect(GTK_OBJECT(entry1),"changed",
											property_dialog_ok_sensitive,NULL);
		gtk_signal_connect(GTK_OBJECT(entry0),"activate",
												property_dialog_clicked_ok,ft);
		gtk_signal_connect(GTK_OBJECT(entry1),"activate",
												property_dialog_clicked_ok,ft);

	} else {
		entry0=entry1=NULL;
	}
	/* ꥹȥܥå */
	list=gtk_list_new();
	gtk_list_set_selection_mode(GTK_LIST(list),GTK_SELECTION_MULTIPLE);
	for (i=0;i<12;i++) {
		item=gtk_list_item_new_with_label(color_name[i]);
		gtk_container_add(GTK_CONTAINER(list),item);
		gtk_signal_connect(GTK_OBJECT(item),"select",
										property_dialog_select,(gpointer)i);
		gtk_signal_connect(GTK_OBJECT(item),"deselect",
										property_dialog_deselect,(gpointer)i);
		color_list[i]=FALSE;
	}
	/* 륦ɥ */
	scroll=gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll),
									GTK_POLICY_NEVER,GTK_POLICY_AUTOMATIC);
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scroll),list);
	/* ԥܥ */
	spin0=gtk_spin_button_new(
		GTK_ADJUSTMENT(gtk_adjustment_new(ft->margin,1,G_MAXINT,1,5,0)),0,0);
	spin1=gtk_spin_button_new(
		GTK_ADJUSTMENT(gtk_adjustment_new(ft->tab,1,G_MAXINT,1,5,0)),0,0);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin0),TRUE);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin1),TRUE);
	gtk_spin_button_set_shadow_type(GTK_SPIN_BUTTON(spin0),GTK_SHADOW_IN);
	gtk_spin_button_set_shadow_type(GTK_SPIN_BUTTON(spin1),GTK_SHADOW_IN);
	gtk_signal_connect(GTK_OBJECT(spin0),"activate",
												property_dialog_activate,ft);
	gtk_signal_connect(GTK_OBJECT(spin1),"activate",
												property_dialog_activate,ft);
	gtk_signal_connect(GTK_OBJECT(spin0),"changed",
											property_dialog_ok_sensitive,NULL);
	gtk_signal_connect(GTK_OBJECT(spin1),"changed",
											property_dialog_ok_sensitive,NULL);

	/* ե졼ȥܥå */
	if (entry0!=NULL && entry1!=NULL) {
		tbox=gtk_hbox_new(FALSE,0);
		hbox=gtk_hbox_new(FALSE,0);
		gtk_box_pack_start(GTK_BOX(hbox),
									gtk_label_new(_("ʸ")),FALSE,FALSE,0);
		gtk_box_pack_start(GTK_BOX(hbox),entry0,TRUE,TRUE,0);
		gtk_box_pack_start(GTK_BOX(tbox),hbox,TRUE,TRUE,8);

		hbox=gtk_hbox_new(FALSE,0);
		gtk_box_pack_start(GTK_BOX(hbox),
									gtk_label_new(_("ĥ")),FALSE,FALSE,0);
		gtk_box_pack_start(GTK_BOX(hbox),entry1,TRUE,TRUE,0);
		gtk_box_pack_start(GTK_BOX(tbox),hbox,TRUE,TRUE,8);
	} else {
		tbox=NULL;
	}

	frame0=gtk_frame_new(_("ɽ"));
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),check0,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),check1,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),check2,FALSE,FALSE,8);
	vbox=gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,8);
	gtk_container_add(GTK_CONTAINER(frame0),vbox);

	frame1=gtk_frame_new(_("ޡ"));
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),spin0,TRUE,TRUE,8);
	gtk_box_pack_start(GTK_BOX(hbox),check3,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),check4,FALSE,FALSE,8);
	vbox=gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,TRUE,TRUE,8);
	gtk_container_add(GTK_CONTAINER(frame1),vbox);

	frame2=gtk_frame_new(_(""));
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),spin1,TRUE,TRUE,8);
	gtk_box_pack_start(GTK_BOX(hbox),check5,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),check6,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),check7,FALSE,FALSE,8);
	vbox=gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,TRUE,TRUE,8);
	gtk_container_add(GTK_CONTAINER(frame2),vbox);

	frame3=gtk_frame_new(_("¸"));
	vbox=gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),check8,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(vbox),check9,FALSE,FALSE,8);
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),vbox,FALSE,FALSE,8);
	gtk_container_add(GTK_CONTAINER(frame3),hbox);

	frame4=gtk_frame_new(_(""));
	vbox=gtk_vbox_new(FALSE,0);
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),scroll,TRUE,TRUE,8);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,TRUE,TRUE,8);
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_end(GTK_BOX(hbox),button0,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,7);
	gtk_container_add(GTK_CONTAINER(frame4),vbox);

	vbox=gtk_vbox_new(FALSE,8);
	gtk_box_pack_start(GTK_BOX(vbox),frame0,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),frame1,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),frame2,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),frame3,FALSE,FALSE,0);

	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),vbox,TRUE,TRUE,8);
	gtk_box_pack_start(GTK_BOX(hbox),frame4,TRUE,TRUE,8);

	vbox=gtk_vbox_new(FALSE,0);
	if (tbox!=NULL)
		gtk_box_pack_start(GTK_BOX(vbox),tbox,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,TRUE,TRUE,8);
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),button1,FALSE,FALSE,8);
	if (button2!=NULL)
		gtk_box_pack_start(GTK_BOX(hbox),button2,FALSE,FALSE,8);
	gtk_box_pack_end(GTK_BOX(hbox),button4,FALSE,FALSE,8);
	gtk_box_pack_end(GTK_BOX(hbox),button3,FALSE,FALSE,8);
	gtk_box_pack_end(GTK_BOX(vbox),hbox,FALSE,FALSE,8);

	gtk_container_add(GTK_CONTAINER(dialog),vbox);

	/* ɽ */
	gtk_widget_set_sensitive(button0,FALSE);
	gtk_widget_set_sensitive(button3,FALSE);
	gtk_widget_grab_focus(button4);

	memcpy(gdk_color,ft->color,sizeof(GdkColor)*12);
	fontname=g_strdup(ft->fontname);
	property_clicked_ok=FALSE;

	gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,TRUE,FALSE);
	gtk_grab_add(dialog);
	gtk_widget_show_all(dialog);
	gtk_main();

	g_free(fontname);

	return property_clicked_ok;
}
