/*
    Text maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <stdlib.h>
#include "argument.h"


static error_t parse_opt __P ((int key,char *arg,struct argp_state *state));


/* ޥɥ饤  */
static const struct argp_option options[]={
	{NULL,			0,	NULL, 			0,N_("ץ:"),		0},
	{"history",		'h',"NUM",			0,N_("ե"),		0},
	{"new",			'n',"ON/OFF",		0,N_("ե򳫤"),	0},
	{"size",		's',"WIDTH,HEIGHT",	0,N_("ɥΥ"),	0},
	{"version",		'v',NULL,			0,N_("С"),		0},
	{NULL,			0,	NULL,			0,NULL,						0}};


/* argpؿѤι¤  */
struct argp argp={
	options,
	parse_opt,
	"[FILE...]",
	N_("ƥȥǥ"),
	NULL,
	NULL,
	NULL
};


/******************************************************************************
*                                                                             *
* եؿ                                                        *
*                                                                             *
******************************************************************************/
void arg_version(void)
{
	g_print("Text maid %s\n",VERSION);
	g_print(_("Copyright (C) 1998-2001 Iwamoto,Kazuki\n"
		"This is free software; see the source for copying conditions.  There is NO\n"
		"warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n"));
	gtk_exit(0);
	return;
}


/*	ޥɥ饤β													*/
static error_t parse_opt(int key,char *arg,struct argp_state *state)
{
	gchar *endptr;

	switch (key) {
		case 'h':
			history=atoi(arg);
			break;
		case 'n':
			newfile=g_strcasecmp(arg,"OK")==0 || g_strcasecmp(arg,"TRUE")==0
												|| g_strcasecmp(arg,"YES")==0;
			break;
		case 's':
			def_height=strtol(arg,&endptr,0);
			def_width=strtol(++endptr,&endptr,0);
			break;
		case 'v':
			arg_version();
			break;
		default:
			return ARGP_ERR_UNKNOWN;
	}
	return 0;
}
