/*
    Text maid
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "command.h"
#include "icons.h"
#include "menu.h"


/******************************************************************************
*                                                                             *
* ja:メニュー                                                                 *
*                                                                             *
******************************************************************************/
MiscCreateMenuEntry menu_entries[] = {
{"/",                   NULL,                          NULL,          NULL,             MISC_CREATE_MENU_BAR,                               NULL,             NULL,                    NULL},
{"/file",               N_("_File"),                   NULL,          NULL,             MISC_CREATE_MENU_ITEM,                              NULL,             NULL,                    NULL},
{"/file/",              NULL,                          NULL,          NULL,             MISC_CREATE_MENU_SHELL,                             NULL,             NULL,                    NULL},
{"/file/new",           GTK_STOCK_NEW,                 NULL,          NULL,             MISC_CREATE_MENU_STOCK,                             command_new,      NULL,                    NULL},
{"/file/open",          GTK_STOCK_OPEN,                NULL,          NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_ELLIPSIS, command_open,     NULL,                    NULL},
{"/file/close",         GTK_STOCK_CLOSE,               NULL,          NULL,             MISC_CREATE_MENU_STOCK,                             command_close,    NULL,                    NULL},
{"/file/save",          GTK_STOCK_SAVE,                NULL,          NULL,             MISC_CREATE_MENU_STOCK,                             command_save,     NULL,                    NULL},
{"/file/saveas",        GTK_STOCK_SAVE_AS,             NULL,          NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_ELLIPSIS, command_saveas,   NULL,                    NULL},
{"/file/reload",        GTK_STOCK_REVERT_TO_SAVED,     "<control>R",  NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_ELLIPSIS, command_reload,   NULL,                    NULL},
{"/file/sep1",          NULL,                          NULL,          NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,             NULL,                    NULL},
{"/file/print",         GTK_STOCK_PRINT,               "<control>P",  NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_ELLIPSIS, command_print,    NULL,                    NULL},
{"/file/sep2",          NULL,                          NULL,          NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,             NULL,                    NULL},
{"/file/properties",    GTK_STOCK_PROPERTIES,          "<alt>Return", NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_ELLIPSIS, command_property, NULL,                    NULL},
{"/file/sep3",          NULL,                          NULL,          NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,             NULL,                    NULL},
{"/file/exit",          GTK_STOCK_QUIT,                NULL,          NULL,             MISC_CREATE_MENU_STOCK,                             command_exit,     NULL,                    NULL},
#if GTK_CHECK_VERSION(2,6,0)
{"/edit",               GTK_STOCK_EDIT,                NULL,          NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_NOIMAGE,  NULL,             NULL,                    NULL},
#else /* not GTK_CHECK_VERSION(2,6,0) */
{"/edit",               N_("_Edit"),                   NULL,          NULL,             MISC_CREATE_MENU_ITEM,                              NULL,             NULL,                    NULL},
#endif /* not GTK_CHECK_VERSION(2,6,0) */
{"/edit/",              NULL,                          NULL,          NULL,             MISC_CREATE_MENU_SHELL,                             NULL,             NULL,                    NULL},
{"/edit/undo",          GTK_STOCK_UNDO,                "<control>Z",  NULL,             MISC_CREATE_MENU_STOCK,                             command_undo,     NULL,                    NULL},
{"/edit/redo",          GTK_STOCK_REDO,                "F4",          NULL,             MISC_CREATE_MENU_STOCK,                             command_redo,     NULL,                    NULL},
{"/edit/sep1",          NULL,                          NULL,          NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,             NULL,                    NULL},
{"/edit/cut",           GTK_STOCK_CUT,                 NULL,          NULL,             MISC_CREATE_MENU_STOCK,                             command_cut,      NULL,                    NULL},
{"/edit/copy",          GTK_STOCK_COPY,                NULL,          NULL,             MISC_CREATE_MENU_STOCK,                             command_copy,     NULL,                    NULL},
{"/edit/paste",         GTK_STOCK_PASTE,               NULL,          NULL,             MISC_CREATE_MENU_STOCK,                             command_paste,    NULL,                    NULL},
{"/edit/delete",        GTK_STOCK_DELETE,              NULL,          NULL,             MISC_CREATE_MENU_STOCK,                             command_delete,   NULL,                    NULL},
{"/edit/sep2",          NULL,                          NULL,          NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,             NULL,                    NULL},
{"/edit/return",        N_("Return at Right _Margin"), NULL,          return16_xpm,     MISC_CREATE_MENU_ITEM,                              command_margin,   NULL,                    NULL},
{"/edit/tab",           N_("Convert Ta_b to Space"),   NULL,          tab16_xpm,        MISC_CREATE_MENU_ITEM,                              command_tab,      NULL,                    NULL},
{"/edit/sep3",          NULL,                          NULL,          NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,             NULL,                    NULL},
{"/edit/character",     N_("Character by _Value"),     NULL,          character16_xpm,  MISC_CREATE_MENU_ITEM | MISC_CREATE_MENU_ELLIPSIS,  command_valchr,   NULL,                    NULL},
{"/edit/jump",          GTK_STOCK_JUMP_TO,             "<control>J",  NULL,             MISC_CREATE_MENU_STOCK,                             command_jump,     NULL,                    NULL},
{"/edit/sep4",          NULL,                          NULL,          NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,             NULL,                    NULL},
#if GTK_CHECK_VERSION(2,10,0)
{"/edit/all",           GTK_STOCK_SELECT_ALL,          "<control>A",  NULL,             MISC_CREATE_MENU_STOCK,                             command_all,      NULL,                    NULL},
#else /* not GTK_CHECK_VERSION(2,10,0) */
{"/edit/all",           N_("_All"),                    "<control>A",  select_all16_xpm, MISC_CREATE_MENU_ITEM,                              command_all,      NULL,                    NULL},
#endif /* not GTK_CHECK_VERSION(2,10,0) */
{"/search",             N_("_Search"),                 NULL,          NULL,             MISC_CREATE_MENU_ITEM,                              NULL,             NULL,                    NULL},
{"/search/",            NULL,                          NULL,          NULL,             MISC_CREATE_MENU_SHELL,                             NULL,             NULL,                    NULL},
{"/search/find",        GTK_STOCK_FIND,                NULL,          NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_ELLIPSIS, command_find,     NULL,                    NULL},
{"/search/next",        N_("_Next"),                   "F3",          next16_xpm,       MISC_CREATE_MENU_ITEM,                              command_next,     GINT_TO_POINTER (TRUE),  NULL},
{"/search/previous",    N_("_Previous"),               "<shift>F3",   previous16_xpm,   MISC_CREATE_MENU_ITEM,                              command_next,     GINT_TO_POINTER (FALSE), NULL},
{"/search/next",        GTK_STOCK_FIND_AND_REPLACE,    "<control>H",  NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_ELLIPSIS, command_replace,  NULL,                    NULL},
{"/option",             N_("_Option"),                 NULL,          NULL,             MISC_CREATE_MENU_ITEM,                              NULL,             NULL,                    NULL},
{"/option/",            NULL,                          NULL,          NULL,             MISC_CREATE_MENU_SHELL,                             NULL,             NULL,                    NULL},
{"/option/preferences", GTK_STOCK_PREFERENCES,         NULL,          NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_ELLIPSIS, command_pref,     NULL,                    NULL},
{"/option/file",        N_("File _Type"),              NULL,          filetype16_xpm,   MISC_CREATE_MENU_ITEM | MISC_CREATE_MENU_ELLIPSIS,  command_format,   NULL,                    NULL},
{"/window",             N_("_Window"),                 NULL,          NULL,             MISC_CREATE_MENU_ITEM,                              NULL,             NULL,                    NULL},
{"/window/",            NULL,                          NULL,          NULL,             MISC_CREATE_MENU_SHELL,                             NULL,             NULL,                    NULL},
{"/help",               GTK_STOCK_HELP,                NULL,          NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_NOIMAGE,  NULL,             NULL,                    NULL},
{"/help/",              NULL,                          NULL,          NULL,             MISC_CREATE_MENU_SHELL,                             NULL,             NULL,                    NULL},
#if GTK_CHECK_VERSION(2,6,0)
{"/help/about",         GTK_STOCK_ABOUT,               NULL,          NULL,             MISC_CREATE_MENU_STOCK,                             command_version,  NULL,                    NULL},
#else /* not GTK_CHECK_VERSION(2,6,0) */
{"/help/about",         N_("_About"),                  NULL,          about16_xpm,      MISC_CREATE_MENU_ITEM,                              command_version,  NULL,                    NULL},
#endif /* not GTK_CHECK_VERSION(2,6,0) */
{NULL,                  NULL,                          NULL,          NULL,             MISC_CREATE_MENU_TERMINAL,                          NULL,             NULL,                    NULL}};
MiscCreateMenuEntry popup_entries[] = {
{"/",                   NULL,                          NULL,          NULL,             MISC_CREATE_MENU_SHELL,                             NULL,             NULL,                    NULL},
{"/undo",               GTK_STOCK_UNDO,                "<control>Z",  NULL,             MISC_CREATE_MENU_STOCK,                             command_undo,     NULL,                    NULL},
{"/sep1",               NULL,                          NULL,          NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,             NULL,                    NULL},
{"/cut",                GTK_STOCK_CUT,                 NULL,          NULL,             MISC_CREATE_MENU_STOCK,                             command_cut,      NULL,                    NULL},
{"/copy",               GTK_STOCK_COPY,                NULL,          NULL,             MISC_CREATE_MENU_STOCK,                             command_copy,     NULL,                    NULL},
{"/paste",              GTK_STOCK_PASTE,               NULL,          NULL,             MISC_CREATE_MENU_STOCK,                             command_paste,    NULL,                    NULL},
{"/delete",             GTK_STOCK_DELETE,              NULL,          NULL,             MISC_CREATE_MENU_STOCK,                             command_delete,   NULL,                    NULL},
{"/sep2",               NULL,                          NULL,          NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,             NULL,                    NULL},
#if GTK_CHECK_VERSION(2,10,0)
{"/all",                GTK_STOCK_SELECT_ALL,          "<control>A",  NULL,             MISC_CREATE_MENU_STOCK,                             command_all,      NULL,                    NULL},
#else /* not GTK_CHECK_VERSION(2,10,0) */
{"/all",                N_("_All"),                    "<control>A",  select_all16_xpm, MISC_CREATE_MENU_ITEM,                              command_all,      NULL,                    NULL},
#endif /* not GTK_CHECK_VERSION(2,10,0) */
{"/sep3",               NULL,                          NULL,          NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,             NULL,                    NULL},
{"/input",              N_("_Input Methods"),          NULL,          NULL,             MISC_CREATE_MENU_ITEM,                              NULL,             NULL,                    NULL},
{NULL,                  NULL,                          NULL,          NULL,             MISC_CREATE_MENU_TERMINAL,                          NULL,             NULL,                    NULL}};
MiscCreateToolbarEntry toolbar_entries[] = {
{"new",        GTK_STOCK_NEW,              NULL, command_new,      NULL, NULL},
{"open",       GTK_STOCK_OPEN,             NULL, command_open,     NULL, NULL},
{"save",       GTK_STOCK_SAVE,             NULL, command_save,     NULL, NULL},
{"sep1",       NULL,                       NULL, NULL,             NULL, NULL},
{"properties", GTK_STOCK_PROPERTIES,       NULL, command_property, NULL, NULL},
{"sep2",       NULL,                       NULL, NULL,             NULL, NULL},
{"print",      GTK_STOCK_PRINT,            NULL, command_print,    NULL, NULL},
{"sep3",       NULL,                       NULL, NULL,             NULL, NULL},
{"cut",        GTK_STOCK_CUT,              NULL, command_cut,      NULL, NULL},
{"copy",       GTK_STOCK_COPY,             NULL, command_copy,     NULL, NULL},
{"paste",      GTK_STOCK_PASTE,            NULL, command_paste,    NULL, NULL},
{"delete",     GTK_STOCK_DELETE,           NULL, command_delete,   NULL, NULL},
{"sep4",       NULL,                       NULL, NULL,             NULL, NULL},
{"undo",       GTK_STOCK_UNDO,             NULL, command_undo,     NULL, NULL},
{"redo",       GTK_STOCK_REDO,             NULL, command_redo,     NULL, NULL},
{"sep5",       NULL,                       NULL, NULL,             NULL, NULL},
{"find",       GTK_STOCK_FIND,             NULL, command_find,     NULL, NULL},
{"replace",    GTK_STOCK_FIND_AND_REPLACE, NULL, command_replace,  NULL, NULL},
{NULL,         NULL,                       NULL, NULL,             NULL, NULL}};
