/*
    gcommon
    copyright (c) 1998-2013 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __GLIBCHECKSUM_H__
#define __GLIBCHECKSUM_H__


#include "gcommon.h"


G_BEGIN_DECLS


/******************************************************************************
* Data Checksums                                                              *
******************************************************************************/
#if ! GLIB_CHECK_VERSION(2,16,0)
typedef enum {
  G_CHECKSUM_MD5,
  G_CHECKSUM_SHA1,
  G_CHECKSUM_SHA256
} GChecksumType;
typedef struct _GChecksum GChecksum;


gssize g_checksum_type_get_length (GChecksumType checksum_type);
GChecksum *g_checksum_new (GChecksumType checksum_type);
GChecksum *g_checksum_copy (const GChecksum *checksum);
void g_checksum_free (GChecksum *checksum);
void g_checksum_reset (GChecksum *checksum);
void g_checksum_update (GChecksum *checksum, const guchar *data, gssize length);
const gchar *g_checksum_get_string (GChecksum *checksum);
void g_checksum_get_digest (GChecksum *checksum, guint8 *buffer, gsize *digest_len);
gchar *g_compute_checksum_for_data (GChecksumType  checksum_type, const guchar *data, gsize length);
gchar *g_compute_checksum_for_string (GChecksumType checksum_type, const gchar *str, gssize length);
#endif /* not GLIB_CHECK_VERSION(2,16,0) */


G_END_DECLS


#endif /* __GLIBCHECKSUM_H__ */
