/*
    Text maid
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __JUMP_H__
#define __JUMP_H__


#include "tmaid.h"


G_BEGIN_DECLS


typedef struct _JumpConfig
{
  gint cursor, max;
} JumpConfig;


/******************************************************************************
*                                                                             *
* ja:ジャンプ関数群                                                           *
*                                                                             *
******************************************************************************/
/*  ja:指定行へ移動
    tmaid,ウインドウ情報
     line,新しい行(1...)                                                    */
void
jump_operation (TmaidWindow *tmaid,
                const gint   line);


/******************************************************************************
*                                                                             *
* ja:ジャンプダイアログ関数群                                                 *
*                                                                             *
******************************************************************************/
/*  ジャンプダイアログ表示
    jmpcfg,ジャンプ情報
       RET,TRUE:OK,FALSE:Cancel                                             */
gboolean jump_dialog (JumpConfig *jmpcfg);


G_END_DECLS


#endif /* __JUMP_H__ */
