/*
    Text maid
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __EDIT_H__
#define __EDIT_H__


#include "tmaid.h"


G_BEGIN_DECLS


/******************************************************************************
*                                                                             *
* ja:編集関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:ラインバッファを求める
    start,ラインバッファ
      off,現在のy座標
        y,y座標
      RET,ラインバッファ                                                    */
LineBuffer *
edit_get_line_buf (LineBuffer **start,
                   gint        *off,
                   const gint   y);


/*  ja:桁数を取得する
    tmaid,ウインドウ情報
        y,行
      RET,桁数                                                              */
gint
edit_get_width (TmaidWindow *tmaid,
                const gint   y);


/*  ja:最大桁数を取得する
    tmaid,ウインドウ情報
      RET,桁数                                                              */
gint
edit_get_width_max (TmaidWindow *tmaid);


/*  ja:キャレットのアライメントされたx座標を求める
    tmaid,ウインドウ情報
        x,x座標
        y,y座標
    align,TRUE:右に寄せる,FALSE:左に寄せる
      RET,座標                                                              */
gint
edit_get_align_pos (TmaidWindow    *tmaid,
                    const gint      x,
                    const gint      y,
                    const gboolean  align);


/*  ja:画面上の座標からラインバッファ上のアドレスを求める
    tmaid,ウインドウ情報
        x,x座標
        y,y座標
    align,TRUE:右に寄せる,FALSE:左に寄せる
      RET,アドレス                                                          */
gint
edit_get_data_pos (TmaidWindow    *tmaid,
                   const gint      x,
                   const gint      y,
                   const gboolean  align);


/*  ja:ラインバッファ上のアドレスから画面上の座標を求める
    tmaid,ウインドウ情報
        x,x座標
        y,y座標
      RET,座標                                                              */
gint
edit_get_screen_pos (TmaidWindow *tmaid,
                     const gint   x,
                     const gint   y);


/*  ja:区切りを求める
    tmaid,ウインドウ情報
        x,x座標
        y,y座標
     move,TRUE:右に移動する,FALSE:左に移動する
      RET,座標                                                              */
gint
edit_get_move_pos (TmaidWindow *tmaid, const gint x, const gint y,
                                                        const gboolean move);


/*  ja:単語を選択する
    tmaid,ウインドウ情報
      RET,TRUE:単語あり,FALSE:単語なし                                      */
gboolean
edit_select_word (TmaidWindow *tmaid);


/*  指定範囲のバイト数を求める
       tmaid,ウインドウ情報
     start_p,選択範囲
       end_p,選択範囲
         RET,バイト数                                                       */
gint edit_get_sel_bytes(TmaidWindow *tmaid,GdkPoint *start_p,GdkPoint *end_p);


/*  指定範囲をメモリにコピーする
      tmaid,ウインドウ情報
    start_p,選択範囲
      end_p,選択範囲
       text,メモリ                                                          */
void edit_cpy_sel_mem(TmaidWindow *tmaid,GdkPoint *start_p,GdkPoint *end_p,
                                                                gchar *text);


/*  メモリの内容を貼り付ける
     tmaid,ウインドウ情報
       put,貼り付ける座標
       new,新しい座標
      text,メモリ
    length,バイト数
       RET,挿入された行数                                                   */
gint edit_put_mem(TmaidWindow *tmaid,GdkPoint *put,GdkPoint *new,
                                        const gchar *text,const gint length);


/*  指定範囲を削除する
      tmaid,ウインドウ情報
    start_p,選択範囲
      end_p,選択範囲
        RET,削除された行数                                                  */
gint edit_del_sel_mem(TmaidWindow *tmaid,GdkPoint *start_p,GdkPoint *end_p);


G_END_DECLS


#endif /* __EDIT_H__ */
