/*
    Text maid
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "command.h"
#include "toolbar.h"


/******************************************************************************
*                                                                             *
* ja:ツールバー関数群                                                         *
*                                                                             *
******************************************************************************/
/* XPM */
const static gchar *tb_new_xpm[] = {
"16 16 4 1",
"   c None",
".  c #000000",
"+  c #FF0000",
"@  c #FFFFFF",
"          +     ",
" ......+..+..+  ",
" .@@@@@@+@+@+   ",
" .@@@@@@@+++.   ",
" .@@@@+++++++++ ",
" .@@@@@@@+++.   ",
" .@@@@@@+@+@+   ",
" .@@@@@+@@+@.+  ",
" .@@@@@@@@+@.   ",
" .@@@@@@@@@@.   ",
" .@@@@@@@@@@.   ",
" .@@@@@@@@@@.   ",
" .@@@@@@@@@@.   ",
" .@@@@@@@@@@.   ",
" ............   ",
"                "};


/* XPM */
const static gchar *tb_open_xpm[] = {
"16 16 5 1",
"   c None",
".  c #000000",
"=  c #808080",
">  c #FFFF00",
"!  c #FFFFFF",
"  ......        ",
" .!>!>!>.       ",
".!>!>!>!>.......",
".>!>!>!>!>!>!>!.",
".!============>.",
".>=!!!!!!!!!!=!.",
".!=!!!!!!.......",
".>=!!!!!.>!>!>!.",
"........>!>!>!>.",
".>!>!>!>!>!>!>!.",
".!>!>!>!>!>!>!>.",
".>!>!>!>!>!>!>!.",
".!>!>!>!>!>!>!>.",
".>!>!>!>!>!>!>!.",
".!>!>!>!>!>!>!>.",
"................"};


/* XPM */
const static gchar *tb_save_xpm[] = {
"16 16 5 1",
"  c None",
". c #000000",
"+ c #808000",
"@ c #808080",
"# c #CCCCCC",
"                ",
" .............. ",
" .@@####@@##@@. ",
" .@@####@@##@@. ",
" .@@####@@##@@. ",
" .@@########@@. ",
" .@@@@@@@@@@@@. ",
" .@..........@. ",
" .@.++++++++.@. ",
" .@.++++++++.@. ",
" .@.++++++++.@. ",
" .@.++++++++.@. ",
" .@.++++++++.@. ",
" .@.++++++++.@. ",
" .............. ",
"                "};


const static gchar *tb_prop_xpm[] = {
"16 16 4 1",
"  c None",
". c #000000",
"+ c #808080",
"@ c #FFFFFF",
"                ",
"  ............  ",
"  .@@@@@@@@@@.  ",
"  .@+++@@@@@@.  ",
"  .@@@@@@@@@@.  ",
"  .@@@@@@@@@@.  ",
"  .@++++++++@.  ",
"  .@@@@@@@@@@.  ",
"  .@++++++++@.  ",
"  .@@@@@@@@@@.  ",
"  .@++++++++@.  ",
"  .@@@@@@@@@@.  ",
"  .@@@@@++++@.  ",
"  .@@@@@@@@@@.  ",
"  ............  ",
"                "};


const static gchar *tb_print_xpm[] = {
"16 16 7 1",
"   c None",
".  c #000000",
"#  c #808000",
"*  c #C0C0C0",
"=  c #808080",
";  c #00FF00",
"!  c #FFFFFF",
"     .......... ",
"     .!!!!!!!!. ",
"     .!*****!!. ",
"    .!!!!!!!!.  ",
"    .!******!.  ",
"    .!!!!!!!!.  ",
"   .!!*****!.   ",
"   .!!!!!!!!... ",
"  .==========#..",
" .###########.#.",
" ............##.",
".###########.##.",
".#######;;;#.##.",
".###########.#. ",
".###########..  ",
" ...........    "};


/* XPM */
const static gchar *tb_cut_xpm[] = {
"16 16 5 1",
"   c None",
".  c #000000",
"-  c #FF0000",
",  c #0000FF",
"!  c #FFFFFF",
"                ",
"....         ,, ",
"!!!.        ,  ,",
"......,,    ,  ,",
".!!!!.,,,    ,, ",
".!!!!.  ,,,,,   ",
".!!!!.,,,, ,,   ",
".!!,,,,,    ,,, ",
".,,,,,     ,   ,",
".!!!!.     ,   ,",
"......      ,,, ",
"-   -           ",
"--  --          ",
" ------         ",
"    --          ",
"    -           "};


/* XPM */
const static gchar *tb_copy_xpm[] = {
"16 16 4 1",
"   c None",
".  c #000000",
"-  c #FF0000",
"!  c #FFFFFF",
"    .........   ",
"    .!!!!!!!.   ",
"    .!!!!!!!.   ",
"    .!!.........",
"    .!!.!!!!!!!.",
"    .!!.!!!!!!!.",
"    .!!.!!!!!!!.",
"    .!!.!!!!!!!.",
"-   .!!.!!!!!!!.",
"-   .!!.!!!!!!!.",
"-   ....!!!!!!!.",
"-  -   .!!!!!!!.",
"-- --  .!!!!!!!.",
" ----- .........",
"   --           ",
"   -            "};


/* XPM */
const static gchar *tb_paste_xpm[] = {
"16 16 5 1",
"   c None",
".  c #000000",
"*  c #C0C0C0",
"=  c #808080",
"!  c #FFFFFF",
"                ",
"     .........  ",
"     .!!!!!!!.  ",
"     .!!!!!!!.  ",
"  ....!!!!!!!.  ",
"  .!!=!!!!!!!.  ",
"  .!!=!!!!!!!.  ",
"  .!!=====!!!.  ",
"  .!!!*!!=!!!.  ",
"  .!!!!*!=!!!.  ",
"  .!!!!!*=!!!.  ",
"  .!!!!!!=....  ",
"  .!!!!!!!.     ",
"  .!!!!!!!.     ",
"  .........     ",
"                "};


/* XPM */
const static gchar *tb_delete_xpm[] = {
"16 16 2 1",
"   c None",
",  c #0000FF",
"                ",
"                ",
"                ",
"             ,, ",
" ,,,,       ,  ,",
"   ,,,,,    ,  ,",
"     ,,,,    ,, ",
"        ,,,,,   ",
"      ,,,, ,,   ",
"   ,,,,,    ,,, ",
" ,,,,,     ,   ,",
"           ,   ,",
"            ,,, ",
"                ",
"                ",
"                "};


/* XPM */
const static gchar *tb_undo_xpm[] = {
"16 16 2 1",
"   c None",
"-  c #FF0000",
"                ",
"      ---       ",
"    -------     ",
"   ---   ---    ",
"   --     --    ",
"  --       --   ",
"  --       --   ",
"  --       --   ",
"  --       --   ",
"  --       --   ",
"  --       --   ",
"  --       --   ",
"  --     ------ ",
"  --      ----  ",
"  --       --   ",
"  --            "};


/* XPM */
const static gchar *tb_redo_xpm[] = {
"16 16 2 1",
"   c None",
",  c #0000FF",
"            ,,  ",
"   ,,       ,,  ",
"  ,,,,      ,,  ",
" ,,,,,,     ,,  ",
"   ,,       ,,  ",
"   ,,       ,,  ",
"   ,,       ,,  ",
"   ,,       ,,  ",
"   ,,       ,,  ",
"   ,,       ,,  ",
"   ,,       ,,  ",
"    ,,     ,,   ",
"    ,,,   ,,,   ",
"     ,,,,,,,    ",
"       ,,,      ",
"                "};


/* XPM */
const static gchar *tb_find_xpm[] = {
"16 16 5 1",
"   c None",
".  c #000000",
"$  c #000080",
",  c #0000FF",
"!  c #FFFFFF",
"         ....   ",
"        .    .  ",
"       .    !!. ",
"      .      !!.",
"      .       !.",
"      .       !.",
"      .        .",
"      ,.      . ",
"     ,,$.    .  ",
"    ,,$!,....   ",
"   ,,$!,        ",
"  ,,$!,         ",
" ,,$!,          ",
",,$!,           ",
" $!,            ",
"  ,             "};


/* XPM */
const static gchar *tb_replace_xpm[] = {
"16 16 5 1",
"   c None",
".  c #000000",
"-  c #FF0000",
",  c #0000FF",
"!  c #FFFFFF",
"                ",
"   -----        ",
"       --       ",
"  -     -       ",
" ---  -----     ",
"-----  ---      ",
"  -     -  ...  ",
"  --      .   . ",
"   ----- .   !!.",
"         .    !.",
"         .     .",
"         ,.   . ",
"        ,,,...  ",
"       ,,,      ",
"      ,,,       ",
"       ,        "};


MiscCreateToolbarEntry toolbar_entries[] = {
{"new",        N_("New"),        tb_new_xpm,     command_new,      NULL, NULL},
{"open",       N_("Open"),       tb_open_xpm,    command_open,     NULL, NULL},
{"save",       N_("Save"),       tb_save_xpm,    command_save,     NULL, NULL},
{"sep1",       NULL,             NULL,           NULL,             NULL, NULL},
{"properties", N_("Properties"), tb_prop_xpm,    command_property, NULL, NULL},
{"sep2",       NULL,             NULL,           NULL,             NULL, NULL},
{"print",      N_("Print"),      tb_print_xpm,   command_print,    NULL, NULL},
{"sep3",       NULL,             NULL,           NULL,             NULL, NULL},
{"cut",        N_("Cut"),        tb_cut_xpm,     command_cut,      NULL, NULL},
{"copy",       N_("Copy"),       tb_copy_xpm,    command_copy,     NULL, NULL},
{"paste",      N_("Paste"),      tb_paste_xpm,   command_paste,    NULL, NULL},
{"delete",     N_("Delete"),     tb_delete_xpm,  command_delete,   NULL, NULL},
{"sep4",       NULL,             NULL,           NULL,             NULL, NULL},
{"undo",       N_("Undo"),       tb_undo_xpm,    command_undo,     NULL, NULL},
{"redo",       N_("Redo"),       tb_redo_xpm,    command_redo,     NULL, NULL},
{"sep5",       NULL,             NULL,           NULL,             NULL, NULL},
{"find",       N_("Find"),       tb_find_xpm,    command_find,     NULL, NULL},
{"replace",    N_("Replace"),    tb_replace_xpm, command_replace,  NULL, NULL},
{NULL,         NULL,             NULL,           NULL,             NULL, NULL}};
