/*
 * Copyright (c) 2010-2014 Yuichi Watanabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of Yuichi Watanabe nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _CORE_APIC_REGS_H
#define _CORE_APIC_REGS_H

#include "vcpu.h"

#define APIC_BASE	0xFEE00000
#define APIC_LEN	0x1000

#define APIC_ID		0xFEE00020
#define APIC_ID_AID_SHIFT	24
#define APIC_APIC_ID_OFFSET		0x20
#define APIC_ID_MASK			0xff000000
#define APIC_VERSION_OFFSET		0x30
#define APIC_TPR_OFFSET			0x80
#define APIC_EOI_OFFSET			0xb0
#define APIC_LOGICAL_APIC_ID_OFFSET	0xd0
#define APIC_SPURIOUS_INTR_VECT_OFFSET 	0xf0
#define APIC_SOFTWARE_ENABLE_BIT 	0x100

#define APIC_ICR_LOW			0xFEE00300
#define APIC_ISR_OFFSET			0x100
#define APIC_ICR_LOW_OFFSET		0x300
#define APIC_ICR_LOW_VEC_MASK		0xFF
#define APIC_ICR_LOW_MT_MASK		0x700
#define APIC_ICR_LOW_MT_FIXED		0x000
#define APIC_ICR_LOW_MT_LOWEST_PRI	0x100
#define APIC_ICR_LOW_MT_NMI		0x400
#define APIC_ICR_LOW_MT_STARTUP		0x600
#define APIC_ICR_LOW_MT_INIT		0x500
#define APIC_ICR_LOW_DM_LOGICAL_BIT	0x800
#define APIC_ICR_LOW_DSH_MASK		0xC0000
#define APIC_ICR_LOW_DSH_DEST		0x00000
#define APIC_ICR_LOW_DSH_SELF		0x40000
#define APIC_ICR_LOW_DSH_ALL		0x80000
#define APIC_ICR_LOW_DSH_OTHERS		0xC0000
#define APIC_ICR_LOW_VECTOR_SHIFT	0
#define APIC_ICR_LOW_VECTOR_MASK	0x0ff
#define APIC_ICR_LOW_STATUS_BIT		0x1000
#define APIC_ICR_LOW_STATUS_IDLE	0x0000
#define APIC_ICR_LOW_STATUS_PENDING	0x1000
#define APIC_ICR_LOW_LEVEL_BIT		0x4000
#define APIC_ICR_LOW_LEVEL_DEASSERT	0x0000
#define APIC_ICR_LOW_LEVEL_ASSERT	0x4000
#define APIC_ICR_LOW_TRIGGER_BIT	0x8000
#define APIC_ICR_LOW_TRIGGER_EDGE	0x0000
#define APIC_ICR_LOW_TRIGGER_LEVEL	0x8000

#define APIC_ICR_HIGH			0xFEE00310
#define APIC_ICR_HIGH_OFFSET		0x310
#define APIC_ICR_HIGH_DES_SHIFT		24
#define APIC_ICR_HIGH_DEST_MASK		0xff000000
#define APIC_ICR_HIGH_DEST_SHIFT	24

#define APIC_LVT_TIMER_OFFSET		0x320
#define APIC_LVT_CMCI_OFFSET		0x2f0
#define APIC_LVT_LINT0_OFFSET		0x350
#define APIC_LVT_LINT1_OFFSET		0x360
#define APIC_LVT_ERROR_OFFSET		0x370
#define APIC_LVT_PEFOR_MON_OFFSET	0x340
#define APIC_LVT_THERMAL_SENSOR_OFFSET	0x330
#define APIC_LVT_MASK_BIT		0x10000

inline static apic_id_t apic_get_apic_id (u32 icr_high)
{
	return (icr_high & APIC_ICR_HIGH_DEST_MASK) >> APIC_ICR_HIGH_DEST_SHIFT;
}

inline static bool apic_is_logical_dest_mode (u32 icr_low)
{
	return (icr_low & APIC_ICR_LOW_DM_LOGICAL_BIT);
}

inline static vector_t apic_get_vector (u32 icr_low)
{
	return (icr_low & APIC_ICR_LOW_VECTOR_MASK) >> APIC_ICR_LOW_VECTOR_SHIFT;
}

#endif
