/*
 * Copyright (c) 2007, 2008 University of Tsukuba
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the University of Tsukuba nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * Copyright (c) 2010-2013 Yuichi Watanabe
 */

#ifndef __CORE_INITFUNC_H
#define __CORE_INITFUNC_H

#define INITFUNC(id, func) struct initfunc_data __initfunc_##func \
	__attribute__ ((__section__ (".initfunc"), aligned (1))) = { id, func }

#define RM_INIT(func)			INITFUNC ("driver0", func)
#define INTR_INIT2(func)		INITFUNC ("driver2", func)
#define BUS_INIT(func)			INITFUNC ("driver3", func)
#define DRIVER_INIT(func)		INITFUNC ("driver4", func)

#define INTR_SETUPVM1(func)		INITFUNC ("setupvm5", func)
#define RM_SETUPVM(func)		INITFUNC ("setupvm6", func)
#define BUS_SETUPVM(func)		INITFUNC ("setupvm7", func)
#define DRIVER_SETUPVM(func)		INITFUNC ("setupvm8", func)
#define DRIVER_START(func)		INITFUNC ("start4", func)

#define INTR_RESET1(func)		INITFUNC ("resetvm1", func)
#define INTR_RESET2(func)		INITFUNC ("resetvm2", func)
#define BUS_RESET(func)			INITFUNC ("resetvm3", func)
#define DRIVER_RESET(func)		INITFUNC ("resetvm4", func)
#define INTR_UNMASK(func)		INITFUNC ("resetvm5", func)

#ifdef __x86_64__
struct initfunc_data {
	char id[8];
	void (*func) (void);
} __attribute__ ((packed));
#else
struct initfunc_data {
	char id[8];
	void (*func) (void);
	void *padding;
} __attribute__ ((packed));
#endif

void call_initfunc (char *id);

#endif
