#!/bin/sh
test ! -t 0 && exit
cd `dirname $0`
RUN_DIR=`pwd`
LANG=C; export LANG

. /etc/init.d/tc-functions

LIST=`busybox --list`
for i in $LIST; do
	alias $i="busybox $i"
done

KERNELVER=$(uname -r)

install_ext(){
	local app source dest depapp
	app="${1//-KERNEL.tcz/-${KERNELVER}.tcz}"
	source=/etc/sysconfig/tcedir/optional
	dest=iso/cde/optional
	
	[ -f "$dest/$app" ] && return
	
	[ ! -f "$source/$app" ] && tce-load -w `basename $app .tcz`
	[ ! -f "$source/$app" ] && echo "[Warning] $app not found."
	
	cp -a "$source/$app" "$dest" 2>/dev/null
	cp -a "$source/$app.dep" "$dest" 2>/dev/null
	cp -a "$source/$app.md5.txt" "$dest" 2>/dev/null
	cp -a "$source/$app.zsync" "$dest" 2>/dev/null
	cp -a "$source/$app.tree" "$dest" 2>/dev/null

	if [ -f $source/$app.dep ]; then
		for depapp in `cat $source/$app.dep`; do
			install_ext $depapp
		done
	fi
}


LIST="$@"
for i in $LIST; do
	echo $i
	if [ -f "$i.iso" ]; then
		mkdir -p mnt
		sudo mount "$i.iso" mnt
		[ -d iso ] && sudo rm -rf iso
		mkdir -p iso
		sudo cp -a mnt/* iso
		sudo install -o root -g root -m 444 core.gz iso/boot/core.gz
		sudo find iso/cde -name "*.lst" -exec sed -i -f sed.rules.txt {} \;
		sudo find iso/cde -name "*.instlist" -exec sed -i -f sed.rules.txt {} \;
		cat <<EOS | sudo tee -a iso/cde/onboot.lst > /dev/null
kmap-jp106.tcz
tz-jst-9.tcz
locale-ja.tcz
scim-anthy.tcz
rxvt-unicode.tcz
EOS
		sudo rm -rf iso/cde/optional
		sudo install -o root -g root -m 777 -d iso/cde/optional
		while read j; do
			install_ext $j
		done < iso/cde/onboot.lst
		sudo find iso/cde/optional -name "*.dep" -exec sed -i -e s/Xlibs.tcz/Xlibs-ja.tcz/ {} \;
		sudo rm -f iso/cde/optional/Xlibs.tcz iso/cde/optional/Xlibs.tcz.*
		sudo mkisofs -l -J -r -V "TinyCore-ja" -no-emul-boot -boot-load-size 4 -boot-info-table -b boot/isolinux/isolinux.bin -c boot/isolinux/boot.cat -o $i-ja.iso iso
		sudo chown $USER.staff $i-ja.iso
		sudo umount mnt
		rm -rf mnt
	fi
done
