/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.awt.Toolkit;
import java.rmi.server.UID;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.table.DefaultTableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class SBDTableModel
extends DefaultTableModel {
    static final String[] columnNames = new String[]{"\u30ab\u30c3\u30c8", "\u753b\u9762", "\u5185\u5bb9", "\u97f3\u58f0", "\u79d2", "\u5408\u8a08\u6642\u9593", ""};
    static final int CUT = 0;
    static final int IMG = 1;
    static final int DESC = 2;
    static final int WORDS = 3;
    static final int SEC = 4;
    static final int TOTAL = 5;
    static final int KEY = 6;
    static final int COLMNNUMBERS = 7;
    static final int ROWINITNUMBERS = 100;
    final String S_ROOT = "storyboard";
    final String S_TITLE = "title";
    final String S_DOCID = "docid";
    final String S_SIZE = "size";
    final String S_TABLE = "table";
    final String S_RECORD = "tr";
    final String S_CUT = "cut";
    final String S_IMG = "img";
    final String S_DESC = "desc";
    final String S_WORDS = "words";
    final String S_SEC = "sec";
    final String S_TOTAL = "total";
    final String S_KEY = "key";
    final String S_BOOKMARKS = "bookmarks";
    final String S_MARK = "mark";
    final String S_NAME = "name";
    final String S_POINT = "point";
    final String S_CURX = "cur_x";
    final String S_CURY = "cur_y";
    final String S_ICON_SMALL = "small";
    final String S_ICON_MIDDLE = "middle";
    final String S_ICON_LARGE = "large";
    static final int ICON_SMALL = 0;
    static final int ICON_MIDDLE = 1;
    static final int ICON_LARGE = 2;
    String docid;
    String title = null;
    Hashtable icons;
    int iconsize = 0;
    TreeMap bookmarks;
    Integer cur_x;
    Integer cur_y;
    ImageIcon simg;

    SBDTableModel(Object[][] rowData) {
        super(rowData, columnNames);
        this.docid = sbedit.makeKeyUID();
        if (this.icons == null) {
            this.icons = new Hashtable(100);
        } else {
            this.icons.clear();
        }
        if (this.bookmarks != null) {
            this.bookmarks.clear();
        }
        this.cur_x = new Integer(1);
        this.cur_y = new Integer(0);
        this.simg = new ImageIcon();
    }

    SBDTableModel() {
        super(columnNames, 0);
        UID uid = new UID();
        this.docid = uid.toString();
        if (this.icons == null) {
            this.icons = new Hashtable(100);
        } else {
            this.icons.clear();
        }
        if (this.bookmarks != null) {
            this.bookmarks.clear();
        }
        this.cur_x = new Integer(1);
        this.cur_y = new Integer(0);
        this.simg = new ImageIcon();
    }

    public boolean isCellEditable(int row, int column) {
        return column != 5 && column != 6;
    }

    public Class getColumnClass(int column) {
        if (column == 1) {
            return this.simg.getClass();
        }
        return super.getColumnClass(column);
    }

    public void setValueAt(Object aValue, int row, int column) {
        String imgfile;
        super.setValueAt(aValue, row, column);
        if (column == 1 && (imgfile = aValue.toString()) != null && imgfile.length() > 0) {
            String key = (String)this.getValueAt(row, 6);
            if (this.icons.containsKey(key)) {
                this.icons.remove(key);
            }
            ImageIcon icon = this.getIcon(imgfile);
            this.icons.put(key, icon);
        }
    }

    public Object getValueAt(int row, int column) {
        if (column == 1) {
            String imgfile = (String)super.getValueAt(row, column);
            if (imgfile != null) {
                if (imgfile.length() > 0) {
                    String key = (String)this.getValueAt(row, 6);
                    ImageIcon icon = (ImageIcon)this.icons.get(key);
                    if (icon == null) {
                        icon = this.getIcon(imgfile);
                        this.icons.put(key, icon);
                    }
                    return icon;
                }
                return new String("");
            }
            return new String("");
        }
        return super.getValueAt(row, column);
    }

    public void removeRow(int row, boolean dummy) {
        if (this.icons != null && row <= this.getRowCount() - 1) {
            String key = (String)this.getValueAt(row, 6);
            this.icons.remove(key);
        }
        this.removeRow(row);
    }

    public void removeRow(int row) {
        super.removeRow(row);
    }

    ImageIcon getIcon(String filename) {
        ImageIcon reticon;
        try {
            int y;
            int x;
            Image image = Toolkit.getDefaultToolkit().getImage(filename);
            switch (this.iconsize) {
                case 2: {
                    x = 640;
                    y = 480;
                    break;
                }
                case 1: {
                    x = 320;
                    y = 240;
                    break;
                }
                default: {
                    x = 160;
                    y = 120;
                }
            }
            image = image.getScaledInstance(x, y, 4);
            reticon = new ImageIcon(image, filename);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            reticon = new ImageIcon();
            reticon.setDescription("\u30a4\u30e1\u30fc\u30b8\u53d6\u5f97\u5931\u6557:" + filename);
        }
        return reticon;
    }

    void renumTotalTime() {
        int max = this.getRowCount();
        double total = 0.0;
        int i = 0;
        while (i < max) {
            double cursec;
            try {
                Double Fr = new Double(this.getValueAt(i, 4).toString());
                cursec = Fr;
            }
            catch (Exception e) {
                cursec = -1.0;
            }
            if (cursec >= 0.0) {
                this.setValueAt(new Double(total += cursec), i, 5);
            } else {
                this.setValueAt("", i, 4);
                this.setValueAt("", i, 5);
            }
            ++i;
        }
    }

    void renumCutNumber(int row) {
        int max = this.getRowCount();
        int last = 0;
        int i = 0;
        while (i < max) {
            int cur;
            try {
                Integer Ir = new Integer(this.getValueAt(i, 0).toString());
                cur = Ir;
            }
            catch (Exception e) {
                cur = -1;
            }
            if (cur > 0) {
                this.setValueAt(new Integer(++last), i, 0);
            } else {
                this.setValueAt("", i, 0);
            }
            ++i;
        }
    }

    public void changeIconSize(int psize) {
        if (psize != this.iconsize && (psize == 0 || psize == 1 || psize == 2)) {
            this.clearIcons();
            this.iconsize = psize;
        }
    }

    public int getIconSize() {
        return this.iconsize;
    }

    void setIconSize(int i) {
        switch (i) {
            case 1: 
            case 2: {
                this.iconsize = i;
                break;
            }
            default: {
                this.iconsize = 0;
            }
        }
    }

    public void clearIcons() {
        if (this.icons == null) {
            this.icons = new Hashtable(100);
        } else {
            this.icons.clear();
        }
    }

    public Document getDocument() throws Exception {
        String s;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document retdoc = builder.newDocument();
        Element root = retdoc.createElement("storyboard");
        root.setAttribute("xmlns", "http://www.mapletown.net/~nekora/sbedit");
        retdoc.appendChild(root);
        Element e = retdoc.createElement("title");
        if (this.title == null) {
            this.title = "\u7121\u984c";
        }
        e.appendChild(retdoc.createTextNode(this.title));
        root.appendChild(e);
        e = retdoc.createElement("docid");
        e.appendChild(retdoc.createTextNode(this.docid));
        root.appendChild(e);
        e = retdoc.createElement("size");
        switch (this.iconsize) {
            case 2: {
                s = "large";
                break;
            }
            case 1: {
                s = "middle";
                break;
            }
            default: {
                s = "small";
            }
        }
        e.appendChild(retdoc.createTextNode(s));
        root.appendChild(e);
        e = retdoc.createElement("cur_x");
        e.appendChild(retdoc.createTextNode(this.cur_x.toString()));
        root.appendChild(e);
        e = retdoc.createElement("cur_y");
        e.appendChild(retdoc.createTextNode(this.cur_y.toString()));
        root.appendChild(e);
        Element tbltag = retdoc.createElement("table");
        root.appendChild(tbltag);
        int i = 0;
        while (i < this.getRowCount()) {
            Float Fr;
            Element li = retdoc.createElement("tr");
            e = retdoc.createElement("cut");
            try {
                Integer Ir = new Integer(this.getValueAt(i, 0).toString());
                e.appendChild(retdoc.createTextNode(Ir.toString()));
            }
            catch (Exception ex) {
                e.appendChild(retdoc.createTextNode(""));
            }
            li.appendChild(e);
            e = retdoc.createElement("img");
            e.appendChild(retdoc.createTextNode(this.getValueAt(i, 1).toString()));
            li.appendChild(e);
            e = retdoc.createElement("desc");
            e.appendChild(retdoc.createTextNode(this.getValueAt(i, 2).toString()));
            li.appendChild(e);
            e = retdoc.createElement("words");
            e.appendChild(retdoc.createTextNode(this.getValueAt(i, 3).toString()));
            li.appendChild(e);
            e = retdoc.createElement("sec");
            try {
                Fr = new Float(this.getValueAt(i, 4).toString());
                e.appendChild(retdoc.createTextNode(Fr.toString()));
            }
            catch (Exception ex) {
                e.appendChild(retdoc.createTextNode(""));
            }
            li.appendChild(e);
            e = retdoc.createElement("total");
            try {
                String str;
                Fr = new Float(this.getValueAt(i, 5).toString());
                if (Fr.doubleValue() >= 60.0) {
                    int ss;
                    int m = Fr.intValue() / 60;
                    double sec = Fr.doubleValue() - (double)(m * 60);
                    str = sec - (double)(ss = Fr.intValue() - m * 60) <= 0.0 ? String.valueOf(m) + "\u5206" + ss + "\u79d2" : String.valueOf(m) + "\u5206" + s + "\u79d2";
                } else {
                    int ss;
                    double sec;
                    str = Fr.doubleValue() >= 0.0 ? ((sec = Fr.doubleValue()) - (double)(ss = Fr.intValue()) <= 0.0 ? String.valueOf(ss) + "\u79d2" : String.valueOf(s) + "\u79d2") : "";
                }
                e.appendChild(retdoc.createTextNode(str));
            }
            catch (Exception ex) {
                e.appendChild(retdoc.createTextNode(""));
            }
            li.appendChild(e);
            e = retdoc.createElement("key");
            e.appendChild(retdoc.createTextNode(this.getValueAt(i, 6).toString()));
            li.appendChild(e);
            tbltag.appendChild(li);
            ++i;
        }
        Element booktag = retdoc.createElement("bookmarks");
        root.appendChild(booktag);
        if (this.bookmarks != null) {
            Set keys = this.bookmarks.keySet();
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                System.out.println("BOOKMARK KEY=" + key);
                Element li = retdoc.createElement("mark");
                e = retdoc.createElement("name");
                e.appendChild(retdoc.createTextNode(key));
                li.appendChild(e);
                String point = (String)this.bookmarks.get(key);
                e = retdoc.createElement("point");
                e.appendChild(retdoc.createTextNode(point));
                li.appendChild(e);
                booktag.appendChild(li);
            }
        }
        retdoc.getDocumentElement().normalize();
        return retdoc;
    }

    public void setDocument(Document pdoc) throws Exception {
        Element booktag;
        String value;
        Element fileElement;
        Element tbltag;
        NodeList list;
        if (pdoc == null) {
            return;
        }
        Element root = pdoc.getDocumentElement();
        try {
            list = root.getElementsByTagName("table");
            tbltag = (Element)list.item(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        list = tbltag.getElementsByTagName("tr");
        int lis = list.getLength();
        int i = 0;
        while (i < lis) {
            NodeList itemList;
            Object[] rec = new Object[7];
            Element element = (Element)list.item(i);
            try {
                itemList = element.getElementsByTagName("cut");
                fileElement = (Element)itemList.item(0);
                value = fileElement.getFirstChild().getNodeValue();
                rec[0] = new Integer(value);
            }
            catch (Exception ex) {
                rec[0] = new Integer(-1);
            }
            try {
                itemList = element.getElementsByTagName("img");
                fileElement = (Element)itemList.item(0);
                value = fileElement.getFirstChild().getNodeValue();
                rec[1] = new String(value);
            }
            catch (Exception ex) {
                rec[1] = new String("");
            }
            try {
                itemList = element.getElementsByTagName("desc");
                fileElement = (Element)itemList.item(0);
                value = fileElement.getFirstChild().getNodeValue();
                rec[2] = new String(value);
            }
            catch (Exception ex) {
                rec[2] = new String("");
            }
            try {
                itemList = element.getElementsByTagName("words");
                fileElement = (Element)itemList.item(0);
                value = fileElement.getFirstChild().getNodeValue();
                rec[3] = new String(value);
            }
            catch (Exception ex) {
                rec[3] = new String("");
            }
            try {
                itemList = element.getElementsByTagName("sec");
                fileElement = (Element)itemList.item(0);
                value = fileElement.getFirstChild().getNodeValue();
                rec[4] = new Float(value);
            }
            catch (Exception ex) {
                rec[4] = new String("");
            }
            try {
                itemList = element.getElementsByTagName("key");
                fileElement = (Element)itemList.item(0);
                value = fileElement.getFirstChild().getNodeValue();
                rec[6] = new String(value);
            }
            catch (Exception ex) {
                rec[6] = new String("");
            }
            this.addRow(rec);
            ++i;
        }
        try {
            list = root.getElementsByTagName("bookmarks");
            booktag = (Element)list.item(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        list = booktag.getElementsByTagName("mark");
        if (list.getLength() > 0) {
            this.bookmarks = new TreeMap();
            int i2 = 0;
            while (i2 < list.getLength()) {
                block36: {
                    String point;
                    String key;
                    NodeList itemList;
                    Element element = (Element)list.item(i2);
                    try {
                        itemList = element.getElementsByTagName("name");
                        fileElement = (Element)itemList.item(0);
                        value = fileElement.getFirstChild().getNodeValue();
                        key = new String(value);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        break block36;
                    }
                    try {
                        itemList = element.getElementsByTagName("point");
                        fileElement = (Element)itemList.item(0);
                        value = fileElement.getFirstChild().getNodeValue();
                        point = new String(value);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        break block36;
                    }
                    this.bookmarks.put(key, point);
                }
                ++i2;
            }
        }
        try {
            list = root.getElementsByTagName("size");
            fileElement = (Element)list.item(0);
            value = fileElement.getFirstChild().getNodeValue();
            this.iconsize = "large".equalsIgnoreCase(value) ? 2 : ("middle".equalsIgnoreCase(value) ? 1 : 0);
        }
        catch (Exception ex) {
            this.iconsize = 0;
        }
        try {
            list = root.getElementsByTagName("title");
            fileElement = (Element)list.item(0);
            this.title = fileElement.getFirstChild().getNodeValue();
        }
        catch (Exception ex) {
            this.title = "\u7121\u984c";
        }
        try {
            list = root.getElementsByTagName("cur_x");
            fileElement = (Element)list.item(0);
            value = fileElement.getFirstChild().getNodeValue();
            this.cur_x = new Integer(value);
            if (this.cur_x < 0) {
                this.cur_x = new Integer(0);
            }
            if (this.cur_x > 4) {
                this.cur_x = new Integer(4);
            }
        }
        catch (Exception ex) {
            this.cur_x = new Integer(0);
        }
        try {
            list = root.getElementsByTagName("cur_y");
            fileElement = (Element)list.item(0);
            value = fileElement.getFirstChild().getNodeValue();
            this.cur_y = new Integer(value);
            if (this.cur_y < 0) {
                this.cur_y = new Integer(0);
            }
            if (this.cur_y > lis - 1) {
                this.cur_y = new Integer(lis - 1);
            }
        }
        catch (Exception ex) {
            this.cur_y = new Integer(0);
        }
        this.renumCutNumber(0);
        this.renumTotalTime();
    }

    public void addBookmark(int row, String keyword) {
        String point = new String((String)this.getValueAt(row, 6));
        if (this.bookmarks == null) {
            this.bookmarks = new TreeMap();
        }
        this.bookmarks.put(keyword, point);
    }

    public int getBookmarkRow(String keyword) {
        String point;
        int row = -1;
        if (this.bookmarks != null && (point = (String)this.bookmarks.get(keyword)) != null) {
            int max = this.getRowCount();
            int i = 0;
            while (i < max) {
                String key = (String)this.getValueAt(i, 6);
                if (point.equals(key)) {
                    row = i;
                    break;
                }
                ++i;
            }
        }
        return row;
    }

    Set getBookmarkKeys() {
        Set ret = this.bookmarks == null ? null : this.bookmarks.keySet();
        return ret;
    }

    int getBookMarkSize() {
        if (this.bookmarks == null) {
            return 0;
        }
        return this.bookmarks.size();
    }

    void clearBookmark() {
        if (this.bookmarks != null) {
            this.bookmarks.clear();
        }
    }

    void setTitle(String s) {
        if (s != null) {
            this.title = s;
        }
    }

    String getTitle() {
        return this.title;
    }

    void setPos(int x, int y) {
        this.cur_x = new Integer(x);
        this.cur_y = new Integer(y);
    }

    int getPosX() {
        if (this.cur_x == null) {
            return 1;
        }
        return this.cur_x;
    }

    int getPosY() {
        if (this.cur_y == null) {
            return 0;
        }
        return this.cur_y;
    }

    String getDocID() {
        return this.docid;
    }

    int removeSpace() {
        int lastrow = this.getRowCount() - 1;
        while (lastrow >= 0) {
            if (this.getValueAt(lastrow, 1).toString().length() > 0 || this.getValueAt(lastrow, 2).toString().length() > 0 || this.getValueAt(lastrow, 3).toString().length() > 0 || this.getValueAt(lastrow, 4).toString().length() > 0) break;
            --lastrow;
        }
        if (lastrow < this.getRowCount() - 1) {
            this.setRowCount(lastrow + 1);
        }
        if (lastrow < this.cur_y) {
            this.cur_y = new Integer(lastrow);
        }
        return lastrow;
    }
}

