<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @copyright  2013 NPO CCC-TIES <info@cccties.org>
 * @author Codia <system.info@codia.co.jp>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
**/

defined('MOODLE_INTERNAL') || die();

function xmldb_local_ties_upgrade($oldversion) {
    global $CFG, $DB, $OUTPUT;

    $dbman = $DB->get_manager();
    $newversion = 2013052701;

    if ($oldversion < $newversion) {
        // インストールが完了したら、データを登録する
        upgrade_plugin_savepoint(true, 2013052701, 'local', 'ties');
    }

    // モジュール管理テーブル更新
    require(dirname(__FILE__) . '/../version.php');
    if(!empty($module->version)){
        $version = $module->version;
    }else if(!empty($plugin->version)){
        $version = $plugin->version;
    }

    if(!empty($module->dispversion)){
        $dispversion = $module->dispversion;
    }else if(!empty($plugin->dispversion)){
        $dispversion = $plugin->dispversion;
    }

    $module_result = $DB->get_records_select("local_ties_modules", "name = ?", array('ties'));
    if(empty($module_result)) {
        $module_info               = new stdClass();
        $module_info->version      = $version;
        $module_info->dispversion  = $dispversion;
        $module_info->name         = "ties";
        $DB->insert_record('local_ties_modules', $module_info);
    }else{
        $module_info               = reset($module_result);
        $module_info->version      = $version;
        $module_info->dispversion  = $dispversion;
        $DB->update_record('local_ties_modules', $module_info);
    }

    if(!empty($module->tiesversion)){
        $version = $module->tiesversion;
    }else if(!empty($plugin->tiesversion)){
        $version = $plugin->tiesversion;
    }

    if(!empty($module->tiesdispversion)){
        $dispversion = $module->tiesdispversion;
    }else if(!empty($plugin->tiesdispversion)){
        $dispversion = $plugin->tiesdispversion;
    }
    $module_result = $DB->get_records_select("local_ties_modules", "name = ?", array('TIES V8'));
    if(empty($module_result)) {

        $module_info           = new stdClass();
        $module_info->name     = "TIES v8";
        $module_info->version  = $version;
        $module_info->dispversion  = $dispversion;
        $DB->insert_record('local_ties_modules', $module_info);
    }else{
        $module_info               = reset($module_result);
        $module_info->version      = $version;
        $module_info->dispversion  = $dispversion;
        $DB->update_record('local_ties_modules', $module_info);
    }

    return true;
}
