#!/usr/bin/env python3

import os
import sys
import urllib.parse
import html
import ast

from socketserver import ThreadingTCPServer, BaseRequestHandler
from http.server import BaseHTTPRequestHandler
from http.server import HTTPServer
from http import HTTPStatus

PORT = 8000
FILE1 = "./target.jpg"
FILE2 = "./target.jpg"

class StubHttpRequestHandler(BaseHTTPRequestHandler):
    server_version = "HTTP Stub/0.1"
    protocol_version = "HTTP/1.1"

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)

    def do_GET(self):
        enc = sys.getfilesystemencoding()
        title = "HTTP Stub"

        r = []
        r.append('<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" '
                 '"http://www.w3.org/TR/html4/strict.dtd">')
        r.append('<html>\n<head>')
        r.append('<meta http-equiv="Content-Type" '
                 'content="text/html; charset=%s">' % enc)
        r.append('<title>%s</title>\n</head>' % title)
        r.append('<body>\n<h1>%s</h1>' % title)
        r.append('<hr>\n<ul>')
        r.append("Stub Opened.")
        r.append('</ul>\n<hr>\n</body>\n</html>\n')
        encoded = '\n'.join(r).encode(enc, 'surrogateescape')

        self.send_response(HTTPStatus.OK)
        self.send_header("Content-type", "text/html; charset=%s" % enc)
        self.send_header("Content-Length", str(len(encoded)))
        self.end_headers()

        self.wfile.write(encoded)     

    def do_POST(self):
        print("Receiving request.")
        enc = sys.getfilesystemencoding()

        length = self.headers.get('content-length')
        nbytes = int(length)
        print(nbytes)
        rawPostData = self.rfile.read(nbytes)
        print(rawPostData)
        decodedPostData = rawPostData.decode(enc)
        print(decodedPostData)
        postData = ast.literal_eval(decodedPostData)
        fileName = ""
        if postData["Type"] == 1:
            fileName = FILE1
        else:
            fileName = FILE2
        print(postData["Type"])

        self.send_response(HTTPStatus.OK)
        self.send_header("Content-type", "image/jpg")
        self.send_header("Transfer-Encoding", "chunked")
        self.send_header("Connection", "close")
        self.end_headers()

        CHUNK_SIZE = 8167
        size = 0
        with open(fileName, "rb") as f:
            while True:
                binary = f.read(CHUNK_SIZE)
                #print("now={}, next={}.".format(size, size+len(binary)))
                self.wfile.write(b"%X\r\n%s\r\n" % (len(binary), binary))
                #print(b"%X\r\n" % (len(binary)))
                if not binary:
                   break
                size = size + CHUNK_SIZE
            print("finish now={}.".format(size))
            self.wfile.flush()

ThreadingTCPServer.allow_reuse_address = True
httpd = ThreadingTCPServer(('0.0.0.0', PORT), StubHttpRequestHandler)
httpd.serve_forever()

