<?php
/*----------------------------------------------------

  Calendar.plugin.phpThreadWiki֥ɽPlugin
   Copyright(C) 2003 by FLATz Co , LTd.
  
  Release note
  
  ThreadWiki's Support
    thread_wiki@flatz.jp
    http://wiki.flatz.jp
  
         Ρޥ
  ǽ       ɽ˥ִ
  ƤӽФ #Calendar(YYYYMM,NAMESPACE);
  
               YYYYMM  ǯʾάȸߤη
               
               NAMESPACE : ֤̾ꤹȡо̾YYYY-MM-DD
                           ڡ̾¸ߤСФ󥯤롣
               
------------------------------------------------------*/

require_once("Wiki/PluginBase.php");

class Calendar extends PluginBase
{


/*----------------------------------------------------

  Calendar(&$core,&$config,&$wiki_db)󥹥ȥ饯

------------------------------------------------------*/
function Calendar(&$core,&$config,&$wiki_db)
{
	parent::PluginBase($core,$config,$wiki_db);
}
//-----------------------------------------------------

/*----------------------------------------------------

  runtime_function($line_number,&$row_line_array,$argument_array)
    ¹Իե󥯥WikiText˸ƤӽФ

  $line_number    ץ饰󤬼¹Ԥ줿Կ
  $row_line_array ƤӽФȤνΥڡǡ
  $argument_array ƤӽФΰä
  $page_data      ƤӽФڡPageData֥
  return          HTMLǡ

------------------------------------------------------*/
function runtime_function($line_number,&$row_line_array,$argument_array,&$page_data)
{
	$year = $month = "";
	if( preg_match("/^([0-9]{4})-?([0-9]{1,2})$/",$argument_array[0],$hit_str) )
	{
		$year  = $hit_str[1];
		$month = $hit_str[2];
	}
	else
	{
		$year  = date( "Y" );
		$month = date( "n" );
	}
	
	$diary_link_list = array();
	if( $argument_array[1] )
	{
		$diary_link_list = $this->diary_page_list( $year,$month,$argument_array[1] );
	}
	
	return $this->calendar_render( $year,$month,$diary_link_list );
}
//-----------------------------------------------------


//////////////////////////////////////////
// о֤̾ǳYYYY-MM-DDΥڡ̾Υ󥯥ꥹȤ
function diary_page_list( $year,$month,$namespace )
{
	$last_day  = date( "t",mktime(0,0,0,$month,1,$year) );
	$link_list = array();
	
	for( $i=1;$i<=$last_day;$i++ )
	{
		$pagename = sprintf( "%04d-%02d-%02d", $year, $month, $i ); 
		if( $this->wiki_db->check_exist($pagename,$namespace) == "hit" )
		{
			$link_list[$i] = WikiCommonLib::make_myself_url("read",$pagename,$namespace);
		}
	}
	
	return $link_list;
}


/*----------------------------------------------------

  calendar_render( $year,$month,$link_array )
    HTML

------------------------------------------------------*/
function calendar_render( $year,$month,$link_array )
{
	$first_day_of_week = date( "w",mktime(0,0,0,$month,1,$year) );
	$last_day          = date( "t",mktime(0,0,0,$month,1,$year) );
	$caption           = date( "F Y",mktime(0,0,0,$month,1,$year) );
	
	$html = <<<DAT
<div class="calendar">
<table summary="calendar">
<caption>${caption}</caption>
<tr>
<th abbr="Sunday"><span class="calendar">Sun</span></th>
<th abbr="Monday"><span class="calendar">Mon</span></th>
<th abbr="Tuesday"><span class="calendar">Tue</span></th>
<th abbr="Wednesday"><span class="calendar">Wed</span></th>
<th abbr="Thursday"><span class="calendar">Thu</span></th>
<th abbr="Friday"><span class="calendar">Fri</span></th>
<th abbr="Saturday"><span class="calendar">Sat</span></th>
</tr>
DAT;
	
	$first_week_flag = true;
	$day = 1;
	while( $day <= $last_day )
	{
		$html .= "<tr>\n";
		for( $i=0;$i<7;$i++ )
		{
			if( $first_week_flag )
			{
				if( $first_day_of_week > $i )
				{
					$html .= "<td>&nbsp;</td>\n";
				}
				else
				{
					$first_week_flag = false;
				}
				
			}
			
			if( !$first_week_flag )
			{
				if( $day <= $last_day )
				{
					if( $link_array[$day] )
					{
						$html .= "<td><a href=\"".$link_array[$day]."\">${day}</a></td>\n";
					}
					else
					{
						$html .= "<td>${day}</td>\n";
					}
					$day++;
				}
				else
				{
					$html .= "<td>&nbsp;</td>\n";
				}
			}
		}
		$html .= "</tr>\n";
	}
	$html .= "</table>\n</div>\n";
	
	return $html;
}
//-----------------------------------------------------



}
//-----------------------------------------------------
?>
