<?php
/*----------------------------------------------------

  FileManagerClass For ThreadWiki

  ThreadWiki : WikiEngine with Namespace
    Copyright(C) 2004 by FLATz Co , LTd.

------------------------------------------------------*/

require_once( 'FLATz/FileControlLib.php' );
require_once( 'Wiki/BasicDefinition.php' );

class FileManager
{

var $config;
var $file_dir;

//////////////////////////////////////////
// 󥹥ȥ饯
function FileManager(&$config_obj)
{
	$this->config   = &$config_obj;
	$this->file_dir = $this->config->get('file_upload_dir');
}

//////////////////////////////////////////
// ե˥åץ
function upload( $name,$target_dir="" )
{
	$target = $this->get_dir_name($target_dir)."/".$this->get_valid_name($_FILES[$name]['name']);
	if( move_uploaded_file($_FILES[$name]['tmp_name'],$target) )
	{
		return chmod($target,0644);
	}
	return false;
}

//////////////////////////////////////////
// оݥե
function delete_file( $target )
{
	$target_file =  $this->get_dir_name("")."/". $target ;
	
	if( is_file($target_file) )
	{
		if( unlink($target_file) )
		{
			return true;
		}
	}
	
	return false;
}


//////////////////////////////////////////
// ǥ쥯ȥΥեꥹȤ֤
function get_file_list( $target_dir="" )
{
	$target_dir = $this->get_dir_name($target_dir);
	$file_list = FileControlLib::search_dir($target_dir);
	sort($file_list);
	return $file_list;
}

//////////////////////////////////////////
// ХեꥹȤ
function get_relative_file_list( $target_dir="" )
{
	$filelist = $this->get_file_list( $target_dir );
	
	$offset = strlen($this->file_dir)+1;
	$relative_list = array();
	for( $i=0;$i<count($filelist);$i++ )
	{
		array_push($relative_list,substr($filelist[$i],$offset));
	}
	
	return $relative_list;
}

//////////////////////////////////////////
// åץɥǥ쥯ȥ꤫лѴ
function get_dir_name( $relative_dir )
{
	if($relative_dir)
	{
		return $this->file_dir."/".$relative_dir;
	}
	else
	{
		return $this->file_dir;
	}
}

//////////////////////////////////////////
// ASCIIʸʳޤޤƤ͡
function get_valid_name( $name )
{
	$valid = ASCII_FILENAME_VALID_CODE;
	if( preg_match("/$valid/",$name) )
	{
		return $name;
	}
	else
	{
		$tmp_name = time();
		$ext  = "unknown";
		if( preg_match("/\.([A-Za-z0-9]+)$/",$name,$match_str) )
		{
			$ext = $match_str[1];
		}
		return "file".$tmp_name.".".$ext;
	}
}

}
?>
