#
# --- grubmenu ---
#
# create_menu.py
#
# This is the creating function group of menu.lst.
#
# Copyright (c) 2003 by kaepapa <kaepapa@kaepapa.dip.jp>

import utils, copy

from StringIO import StringIO

from utils import dev_name_exchange

# main fanction
def write_menu(conf):

    entrylist = utils.make_entry_list(conf)

    # create menu.lst
    st = StringIO()

    _header = ("# /boot/grub/menu.lst\n"
               "#\n"
               "# This file is create with grubmenu python script.\n"
               "#\n\n"
               )

    st.write(_header)

    _default = ("## Default\n"
                "# Set a default boot kernel entry\n"
                )

    if conf.DEFAULT == "":
        _default = _default+"defalut\t\t0\n\n"
    else:
        img = []
        for entry in entrylist:
            img.append(entry[0])
        
        _default = _default+"default\t\t"+utils.getNumberFromList(conf.DEFAULT,img,conf.WIN)+"\n\n"

    st.write(_default)

    _timeout = ("## Timeout sec\n"
                "# Set a timeout, in SEC seconds, before automatically booting the default entry\n"
                )

    _timeout = _timeout + "timeout\t\t" + conf.TIME + "\n\n"

    st.write(_timeout)

    _color = ("## Screen ornament\n"
              "# Color ornament\n"
              )

    if conf.COLOR != "":
        _color = _color +"color\t\t" + conf.COLOR +"\n\n"
        st.write(_color)

    _splash = ("# Splash ornamunet\n"
               )

    if conf.SPLASH != "":
        _splash += "splashimage\t" + conf.SPLASH + "\n\n"
        st.write(_splash)
    
    _keyboard = ("## jp106 keyboard entry\n"
                 "# grub command line is not use in jp106 keyboard\n"
                 "setkey doublequote at\n"
                 "setkey ampersand caret\n"
                 "setkey quote ampersand\n"
                 "setkey parenleft asterisk\n"
                 "setkey parenright parenleft\n"
                 "setkey tilde parenright\n"
                 "setkey equal underscore\n"
                 "setkey plus colon\n"
                 "setkey colon quote\n"
                 "setkey asterisk doublequote\n"
                 "setkey bracketleft bracketright\n"
                 "setkey braceleft braceright\n"
                 "setkey bracketright backslash\n"
                 "setkey braceright bar\n"
                 "setkey backslash equal\n"
                 "setkey underscore plus\n"
                 "setkey backslash bracketleft\n"
                 "setkey bar braceleft\n"
                 "setkey F9 equal\n"
                 "setkey F10 bracketleft\n"
                 "setkey equal k73\n"
                 "setkey bracketleft k7d\n"
                 "\n"
                 )

    if conf.JP == "yes":
        st.write(_keyboard)

    # boot entry create
    _kernel_entry = "## kernel entries created by grubmenu. Please don't touch!\n"

    st.write(_kernel_entry)

    for entry in entrylist:
        
        _kernel_entry = "title "+conf.DIST_NAME+", "

	if entry[0].startswith('kernel'):
            _kernel_entry += entry[0][7:len(entry[0])]
        else:
            _kernel_entry += entry[0][8:len(entry[0])]

        if entry[2] == 'yes':
            _kernel_entry += " (recovery mode)"

        _kernel_entry += "\nroot\t"+dev_name_exchange(conf.GRUB_ROOT_DEV)+"\n"

        if conf.ROOT_DEV == conf.GRUB_ROOT_DEV:
            _kernel_entry += "kernel\t/boot/"
        else:
            _kernel_entry += "kernel\t/"

        _kernel_entry += entry[0] +" root=" + conf.ROOT_DEV + " ro "

        if entry[2] == 'yes':
            _kernel_entry += "single "
        
        for z in entry[3]:
            if z != 'none':
                _kernel_entry += z + " "

        _kernel_entry += "\n"

        if entry[1][0] == 'yes':
            if conf.ROOT_DEV == conf.GRUB_ROOT_DEV:
                _kernel_entry += "initrd\t/boot/"+ entry[1][1] +"\n"
            else:
                _kernel_entry += "initrd\t/"+ entry[1][1] +"\n"

        _kernel_entry += "savedefault\nboot\n\n"

        st.write(_kernel_entry)

    # Windows entry create
    _win_entry = "# for Windows entry\n"

    if conf.WIN != "":
        _win_entry += ("title\t\tWindows 95/98/NT/2000\n"
                       "rootnoverify\t" + utils.dev_name_exchange(conf.WIN) +"\n"
                       "makeactive\n"
                       "chainloader\t\t+1\n"
                       )

        st.write(_win_entry)


    return st







