#
# --- grubmenugui ---
#
# aboutDialog.py
#
# This class displayed the about dialog and uses wxPython.
#
# Copyright(c) 2003 kaepapa <kaepapa@kaepapa.dip.jp>

from wxPython.wx import *

ID_BTN_OK = wxNewId()

## The about dialog class which inherited wxDialog
class aboutDialog(wxDialog):

    # constracter method
    def __init__(self, parent, id, title):
        
        wxDialog.__init__(self, parent, id, title,
                          style = wxDEFAULT_DIALOG_STYLE)
        self.label_copyright = wxStaticText(self, -1,
                                            "grubmenu GUI Ver. 0.2.4\ncopyright(c) 2003 Shigeyuki INOUE")
        self.label_email = wxStaticText(self, -1,
                                        "kaepapa@kaepapa.dip.jp")
        self.text_ctrl_help = wxTextCtrl(self, -1,
                                         _("Refer to man grubmenu\nfor the details of this application."),
                                         style=wxTE_MULTILINE|wxTE_READONLY)
        self.button_ok = wxButton(self, ID_BTN_OK, "OK")

        self.__set_properties()
        self.__do_layout()

        # Event definition
        EVT_BUTTON(self, ID_BTN_OK, self.OnBtnOkClick)

    # method of set a propertied
    def __set_properties(self):
        self.SetTitle("About")
        self.SetSize((280, 200))

    # method of each gui parts layout
    def __do_layout(self):
        sizer_about_whole = wxBoxSizer(wxHORIZONTAL)
        sizer_about_main = wxBoxSizer(wxVERTICAL)
        sizer_about_main.Add(self.label_copyright, 0, wxLEFT|wxRIGHT, 10)
        sizer_about_main.Add(self.label_email, 0, wxALIGN_RIGHT, 0)
        sizer_about_main.Add(self.text_ctrl_help, 1, wxEXPAND, 0)
        sizer_about_main.Add(self.button_ok, 0, wxTOP|wxALIGN_RIGHT, 10)
        sizer_about_whole.Add(sizer_about_main, 0, wxALL|wxEXPAND, 15)
        self.SetAutoLayout(1)
        self.SetSizer(sizer_about_whole)
        self.Layout()

    # onClick event method of the OK button
    def OnBtnOkClick(self, event):
        self.Close(true)











