#
# --- grubmenugui ---
#
# ui_wxPython.py
#
# This class displayed the main window and uses wxPython
#
# Copyright(c) 2003 by kaepapa <kaepapa@kaepapa.dip.jp>

import re, gettext

from wxPython.wx import *
from wxPython.grid import *

from aboutDialog import *

from common import config
from common import constants
from common import create_menu
from common import utils

ID_MENU_EXIT = wxNewId()
ID_MENU_ABOUT = wxNewId()
ID_MENU_MEDIA = wxNewId()
ID_MENU_OTHER = wxNewId()

ID_BTN_APPLY = wxNewId()
ID_BTN_CREATE = wxNewId()
ID_BTN_EXIT = wxNewId()
ID_BTN_OPTIONS = wxNewId()

ID_CHKBOX_SPLASH = wxNewId()
ID_CHKBOX_COLOR = wxNewId()

# the main window class which inherited wxFrame
class ui_wxPython(wxFrame):
    __conf = config.config()
    __single_img_list = ["ALL kernel-image"]+__conf.VM_LIST

    # constructor method
    def __init__(self, parent, id, title):
        
        wxFrame.__init__(self, parent, id, "grubmenuGUI",
                         pos=wxPoint(80, 50),
                         size=wxSize(580, 350),
                         name="",
                         style=wxDEFAULT_FRAME_STYLE)

        # tab
        self.notebook_guiconfig = wxNotebook(self, -1, style=0)
        self.notebook_view = wxPanel(self.notebook_guiconfig, -1)
        self.notebook_entry = wxPanel(self.notebook_guiconfig, -1)
        self.notebook_appearance = wxPanel(self.notebook_guiconfig, -1)
        self.notebook_common = wxPanel(self.notebook_guiconfig, -1)
        
        # Menu Bar
        self.menubar = wxMenuBar()
        self.SetMenuBar(self.menubar)
        self.gmenu = wxMenu()
        self.gmenu.Append(ID_MENU_MEDIA,
                          _("&Create Grub Media"),
                          _("creattion of grub fd and/or iso image."),
                          wxITEM_NORMAL)
        self.gmenu.Append(ID_MENU_OTHER,
                          _("&Other OS setup"),
                          _("make other os entry."),
                          wxITEM_NORMAL)
        self.gmenu.AppendSeparator()
        self.gmenu.Append(ID_MENU_EXIT,
                          "E&xit\tctrl+X",
                          _("application is exit."),
                          wxITEM_NORMAL)
        self.menubar.Append(self.gmenu, "&Grubmenu")

        # under constract
        self.gmenu.Enable(ID_MENU_MEDIA, false)
        self.gmenu.Enable(ID_MENU_OTHER, false)

        self.help = wxMenu()
        self.help.Append(ID_MENU_ABOUT,
                         "&About...",
                         _("about this application."),
                         wxITEM_NORMAL)
        self.menubar.Append(self.help, "&Help")

        # status bar
        self.statusbar = self.CreateStatusBar(1)

        # various gui parts
        self.label_timeout = wxStaticText(self.notebook_common, -1, _("Timeout"))
        self.text_ctrl_timeout = wxTextCtrl(self.notebook_common, -1, "")
        self.label_kblayout = wxStaticText(self.notebook_common, -1, _("Keyboad Layout"))
        self.combo_box_kblayout = wxComboBox(self.notebook_common, -1, choices=["US", "JP106"],
                                             style=wxCB_DROPDOWN|wxCB_READONLY)
        self.label_defaultboot = wxStaticText(self.notebook_common, -1, _("Default Boot Kernel"))
        self.combo_box_defaultboot = wxComboBox(self.notebook_common, -1,
                                               choices=self.__conf.VM_LIST,
                                               style=wxCB_DROPDOWN|wxCB_READONLY)
        self.label_windows = wxStaticText(self.notebook_common, -1, _("Windows Entry (ex. /dev/hda1)"))
        self.text_ctrl_windows = wxTextCtrl(self.notebook_common, -1, "")
        self.checkbox_splash = wxCheckBox(self.notebook_appearance, ID_CHKBOX_SPLASH, _("Splash"))
        self.text_ctrl_splash = wxTextCtrl(self.notebook_appearance, -1, "")
        self.button_splash = wxButton(self.notebook_appearance, ID_BTN_OPTIONS, "...")
        self.checkbox_color = wxCheckBox(self.notebook_appearance, ID_CHKBOX_COLOR, _("Color"))
        self.label_strcolor = wxStaticText(self.notebook_appearance, -1, _("String Color"))
        self.combo_box_strcolor = wxComboBox(self.notebook_appearance, -1,
                                             choices=constants.STR_COLOR,
                                             style=wxCB_DROPDOWN)
        self.label_bgcolor = wxStaticText(self.notebook_appearance, -1, _("Background Color"))
        self.combo_box_bgcolor = wxComboBox(self.notebook_appearance, -1,
                                            choices=constants.BG_COLOR,
                                            style=wxCB_DROPDOWN)
        self.label_sel_strcolor = wxStaticText(self.notebook_appearance, -1, _("Selected String Color"))
        self.combo_box_sel_strcolor = wxComboBox(self.notebook_appearance, -1,
                                                 choices=constants.STR_COLOR,
                                                 style=wxCB_DROPDOWN)
        self.label_sel_bgcolor = wxStaticText(self.notebook_appearance, -1, _("Selected Background Color"))
        self.combo_box_sel_bgcolor = wxComboBox(self.notebook_appearance, -1,
                                                choices=constants.BG_COLOR,
                                                style=wxCB_DROPDOWN)
        self.grid_entry = wxGrid(self.notebook_entry, -1)
        self.label_single_mode = wxStaticText(self.notebook_entry, -1, _("Single Mode Entry"))
        self.combo_box_single_mode = wxComboBox(self.notebook_entry, -1,
                                                choices=self.__single_img_list,
                                                style=wxCB_DROPDOWN|wxCB_READONLY)
        self.text_ctrl_view = wxTextCtrl(self.notebook_view, -1, "",
                                         style=wxTE_MULTILINE|wxTE_READONLY|wxHSCROLL)
        self.button_apply = wxButton(self, ID_BTN_APPLY, _("Apply"))
        self.button_create = wxButton(self, ID_BTN_CREATE, _("Create"))
        self.button_exjt = wxButton(self, ID_BTN_EXIT, _("Exit"))

        self.__set_properties()
        self.__do_layout()

        # create event
        EVT_MENU(self, ID_MENU_EXIT, self.OnMenuExitClick)
        EVT_MENU(self, ID_MENU_ABOUT, self.OnMenuAboutClick)

        EVT_BUTTON(self, ID_BTN_APPLY, self.OnBtnApplyClick)
        EVT_BUTTON(self, ID_BTN_CREATE, self.OnBtnCreateClick)
        EVT_BUTTON(self, ID_BTN_EXIT, self.OnBtnExitClick)
        EVT_BUTTON(self, ID_BTN_OPTIONS, self.OnBtnOptionsClick)

        EVT_CHECKBOX(self, ID_CHKBOX_SPLASH, self.OnChkBoxSplashClick)
        EVT_CHECKBOX(self, ID_CHKBOX_COLOR, self.OnChkBoxColorClick)

        # setup is load
        self.loadConf()

    # method of set a properties
    def __set_properties(self):
        
        self.statusbar.SetStatusWidths([-1])
        statusbar_fields = [""]
        for i in range(len(statusbar_fields)):
            self.statusbar.SetStatusText(statusbar_fields[i], i)
        self.combo_box_kblayout.SetSelection(0)
        self.combo_box_defaultboot.SetSize((250,24))
        self.combo_box_defaultboot.SetSelection(0)
        self.text_ctrl_splash.SetSize((270, 24))
        self.text_ctrl_splash.Enable(0)
        self.text_ctrl_splash.SetEditable(false)
        self.button_splash.SetSize((24, 24))
        self.button_splash.Enable(false)
        self.combo_box_strcolor.SetSize((200, 24))
        self.combo_box_strcolor.Enable(0)
        self.combo_box_strcolor.SetSelection(0)
        self.combo_box_bgcolor.SetSize((200, 24))
        self.combo_box_bgcolor.Enable(0)
        self.combo_box_bgcolor.SetSelection(0)
        self.combo_box_sel_strcolor.SetSize((200, 24))
        self.combo_box_sel_strcolor.Enable(0)
        self.combo_box_sel_strcolor.SetSelection(0)
        self.combo_box_sel_bgcolor.SetSize((200, 24))
        self.combo_box_sel_bgcolor.Enable(0)
        self.combo_box_sel_bgcolor.SetSelection(0)
        self.grid_entry.CreateGrid(0, 2)
        font = wxFont(10,wxDEFAULT, wxNORMAL, wxBOLD, FALSE, '', wxFONTENCODING_ISO8859_1)
        self.grid_entry.SetLabelFont(font)
        self.grid_entry.SetRowLabelSize(20)
        self.grid_entry.SetColLabelSize(20)
        self.grid_entry.SetColLabelValue(0, "Kernel Image")
        self.grid_entry.SetColSize(0, 250)
        self.grid_entry.SetColLabelValue(1, "Boot Option")
        self.grid_entry.SetColSize(1, 250)
        self.combo_box_single_mode.SetSize((300, 24))
        self.combo_box_single_mode.SetSelection(0)

    # method of each gui parts layout
    def __do_layout(self):
        sizer_main = wxBoxSizer(wxVERTICAL)
        sizer_button = wxBoxSizer(wxHORIZONTAL)
        sizer_view = wxBoxSizer(wxHORIZONTAL)
        sizer_entry_whole = wxBoxSizer(wxHORIZONTAL)
        sizer_entry_main = wxBoxSizer(wxVERTICAL)
        sizer_single_mode = wxBoxSizer(wxHORIZONTAL)
        sizer_appearance_whole = wxBoxSizer(wxHORIZONTAL)
        sizer_appearance_main = wxBoxSizer(wxVERTICAL)
        sizer_color_detail_2 = wxBoxSizer(wxHORIZONTAL)
        sizer_sel_bgcolor = wxBoxSizer(wxVERTICAL)
        sizer_sel_strcolor = wxBoxSizer(wxVERTICAL)
        sizer_color_detail_1 = wxBoxSizer(wxHORIZONTAL)
        sizer_bgcolor = wxBoxSizer(wxVERTICAL)
        sizer_strcolor = wxBoxSizer(wxVERTICAL)
        sizer_color = wxBoxSizer(wxHORIZONTAL)
        sizer_splash = wxBoxSizer(wxHORIZONTAL)
        sizer_common_whole = wxBoxSizer(wxHORIZONTAL)
        sizer_common_main = wxBoxSizer(wxVERTICAL)
        sizer_windows = wxBoxSizer(wxHORIZONTAL)
        sizer_defaultboot = wxBoxSizer(wxHORIZONTAL)
        sizer_kblayout = wxBoxSizer(wxHORIZONTAL)
        sizer_timeout = wxBoxSizer(wxHORIZONTAL)
        sizer_timeout.Add(self.label_timeout, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL, 155)
        sizer_timeout.Add(self.text_ctrl_timeout, 0, wxALIGN_CENTER_VERTICAL, 0)
        sizer_common_main.Add(sizer_timeout, 1, wxEXPAND, 0)
        sizer_common_main.Add(20, 20, 0, 0, 0)
        sizer_kblayout.Add(self.label_kblayout, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL, 102)
        sizer_kblayout.Add(self.combo_box_kblayout, 0, wxALIGN_CENTER_VERTICAL, 0)
        sizer_common_main.Add(sizer_kblayout, 1, wxEXPAND, 0)
        sizer_common_main.Add(20, 20, 0, 0, 0)
        sizer_defaultboot.Add(self.label_defaultboot, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL, 82)
        sizer_defaultboot.Add(self.combo_box_defaultboot, 0, wxALIGN_CENTER_VERTICAL, 0)
        sizer_common_main.Add(sizer_defaultboot, 1, wxEXPAND, 0)
        sizer_common_main.Add(20, 20, 0, 0, 0)
        sizer_windows.Add(self.label_windows, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL, 11)
        sizer_windows.Add(self.text_ctrl_windows, 0, wxALIGN_CENTER_VERTICAL, 0)
        sizer_common_main.Add(sizer_windows, 1, wxEXPAND, 0)
        sizer_common_whole.Add(sizer_common_main, 0, wxALL, 15)
        self.notebook_common.SetAutoLayout(1)
        self.notebook_common.SetSizer(sizer_common_whole)
        sizer_common_whole.Fit(self.notebook_common)
        sizer_common_whole.SetSizeHints(self.notebook_common)
        sizer_splash.Add(self.checkbox_splash, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL, 80)
        sizer_splash.Add(self.text_ctrl_splash, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL, 10)
        sizer_splash.Add(self.button_splash, 0, wxALIGN_CENTER_VERTICAL, 0)
        sizer_appearance_main.Add(sizer_splash, 0, wxBOTTOM|wxEXPAND, 15)
        sizer_color.Add(self.checkbox_color, 0, wxALIGN_CENTER_VERTICAL, 0)
        sizer_appearance_main.Add(sizer_color, 0, wxBOTTOM|wxEXPAND, 15)
        sizer_strcolor.Add(self.label_strcolor, 0, 0, 0)
        sizer_strcolor.Add(self.combo_box_strcolor, 0, wxRIGHT, 10)
        sizer_color_detail_1.Add(sizer_strcolor, 1, wxEXPAND, 0)
        sizer_bgcolor.Add(self.label_bgcolor, 0, 0, 0)
        sizer_bgcolor.Add(self.combo_box_bgcolor, 0, 0, 0)
        sizer_color_detail_1.Add(sizer_bgcolor, 1, wxEXPAND, 0)
        sizer_appearance_main.Add(sizer_color_detail_1, 1, wxEXPAND, 0)
        sizer_sel_strcolor.Add(self.label_sel_strcolor, 0, 0, 0)
        sizer_sel_strcolor.Add(self.combo_box_sel_strcolor, 0, wxRIGHT, 10)
        sizer_color_detail_2.Add(sizer_sel_strcolor, 1, wxEXPAND, 0)
        sizer_sel_bgcolor.Add(self.label_sel_bgcolor, 0, 0, 0)
        sizer_sel_bgcolor.Add(self.combo_box_sel_bgcolor, 0, 0, 0)
        sizer_color_detail_2.Add(sizer_sel_bgcolor, 1, wxEXPAND, 0)
        sizer_appearance_main.Add(sizer_color_detail_2, 1, wxEXPAND, 0)
        sizer_appearance_whole.Add(sizer_appearance_main, 0, wxALL, 15)
        self.notebook_appearance.SetAutoLayout(1)
        self.notebook_appearance.SetSizer(sizer_appearance_whole)
        sizer_appearance_whole.Fit(self.notebook_appearance)
        sizer_appearance_whole.SetSizeHints(self.notebook_appearance)
        sizer_entry_main.Add(self.grid_entry, 1, wxEXPAND, 0)
        sizer_single_mode.Add(self.label_single_mode, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL, 10)
        sizer_single_mode.Add(self.combo_box_single_mode, 0, wxALIGN_CENTER_VERTICAL, 0)
        sizer_entry_main.Add(sizer_single_mode, 0, wxTOP|wxEXPAND, 15)
        sizer_entry_whole.Add(sizer_entry_main, 1, wxALL|wxEXPAND, 15)
        self.notebook_entry.SetAutoLayout(1)
        self.notebook_entry.SetSizer(sizer_entry_whole)
        sizer_entry_whole.Fit(self.notebook_entry)
        sizer_entry_whole.SetSizeHints(self.notebook_entry)
        sizer_view.Add(self.text_ctrl_view, 1, wxALL|wxEXPAND, 15)
        self.notebook_view.SetAutoLayout(1)
        self.notebook_view.SetSizer(sizer_view)
        sizer_view.Fit(self.notebook_view)
        sizer_view.SetSizeHints(self.notebook_view)
        self.notebook_guiconfig.AddPage(self.notebook_common, _("Common"))
        self.notebook_guiconfig.AddPage(self.notebook_appearance, _("Appearance"))
        self.notebook_guiconfig.AddPage(self.notebook_entry, _("Entry"))
        self.notebook_guiconfig.AddPage(self.notebook_view, _("View"))
        sizer_main.Add(wxNotebookSizer(self.notebook_guiconfig), 1, wxEXPAND, 0)
        sizer_button.Add(self.button_apply, 0, 0, 0)
        sizer_button.Add(20, 24, 0, 0, 0)
        sizer_button.Add(self.button_create, 0, 0, 0)
        sizer_button.Add(20, 24, 0, 0, 0)
        sizer_button.Add(self.button_exjt, 0, 0, 0)
        sizer_main.Add(sizer_button, 0, wxRIGHT|wxTOP|wxBOTTOM|wxALIGN_RIGHT, 4)
        self.SetAutoLayout(1)
        self.SetSizer(sizer_main)
        self.Layout()
        
    # onClick event method of exit menu
    def OnMenuExitClick(self, event):
        self.Close(true)

    # onClick event method of about menu
    def OnMenuAboutClick(self, event):
        dlg = aboutDialog(None, -1, "")
        dlg.ShowModal()
        dlg.Destroy()

    # onClick event method of apply button
    def OnBtnApplyClick(self, event):

        # warning dialog display method when an invalid device is specified
        def badDevice():
            dlg = wxMessageDialog(self, _("The device name of a Windows entry is invalid."),
                                  "Caution!", wxOK | wxICON_EXCLAMATION)
            dlg.ShowModal()
            dlg.Destroy()
            self.text_ctrl_windows.SetValue(self.__conf.WIN)
            self.notebook_guiconfig.SetSelection(0)
            
        # save timeout
        time = self.text_ctrl_timeout.GetValue()
        if re.match("[0-9]", time) != None:
            self.__conf.TIME = time
        else:
            dlg = wxMessageDialog(self, _("Invalid character sequence into timeout."),
                                  "Caution!", wxOK | wxICON_EXCLAMATION)
            dlg.ShowModal()
            dlg.Destroy()
            self.text_ctrl_timeout.SetValue(self.__conf.TIME)
            self.notebook_guiconfig.SetSelection(0)
            
        # save kblayout
        if self.combo_box_kblayout.GetValue() == "JP106":
            result = 'yes'
        else:
            result = 'no'
        self.__conf.JP = result
            
        # save default boot image
        self.__conf.DEFAULT = self.combo_box_defaultboot.GetValue()
    
        # save default boot image
        self.__conf.DEFAULT = self.combo_box_defaultboot.GetValue()

        # save windows entry
        dev = self.text_ctrl_windows.GetValue()
        if re.match("^/dev/.*", dev) != None:
            try:
                __dev = utils.dev_name_exchange(dev)
                self.__conf.WIN = dev
            except:
                badDevice()
        elif dev == '':
            self.__conf.WIN = dev
        else:
            badDevice()
                    
        # save splash
        if self.checkbox_splash.GetValue():
            self.__conf.SPLASH = self.text_ctrl_splash.GetValue()
            self.__conf.COLOR = ''
            
        # save color
        if self.checkbox_color.GetValue():
            self.__conf.COLOR = self.combo_box_strcolor.GetValue()+'/'+self.combo_box_bgcolor.GetValue()+' '+ \
                                self.combo_box_sel_strcolor.GetValue()+'/'+self.combo_box_sel_bgcolor.GetValue()
            self.__conf.SPLASH = ''
            
        # save kernel boot option
        option = []
        for img in self.__conf.VM_LIST:
            img_option = []
            img_option.append(img)
            img_option.extend(self.grid_entry.GetCellValue(self.__conf.VM_LIST.index(img), 1).split())
            option.append(img_option)
            
        self.__conf.OPTION = option
            
        # save single mode boot image
        self.__conf.SINGLE = self.combo_box_single_mode.GetValue()

        # write conf file
        self.__conf.writeconf()
        conf = config.config()
        
        # recreate view
        st = create_menu.write_menu(conf)
        self.text_ctrl_view.SetValue(st.getvalue())
        

    # onClick event method of Create button
    def OnBtnCreateClick(self, event):
        try:
            f = file(self.__conf.GRUB_DIR+'menu.lst', 'w')
            st = create_menu.write_menu(self.__conf)
            f.write(st.getvalue())
        finally:
            f.close()


    # onClick event method of exit button
    def OnBtnExitClick(self, event):
        self.Close(true)

    # onClick event method of options button
    def OnBtnOptionsClick(self, event):
        dlg = wxFileDialog(self, "Choose a file", "/", "", "*.xpm", wxOPEN)
        if dlg.ShowModal() == wxID_OK:
            filename = dlg.GetFilename()
            directory = dlg.GetDirectory()
            self.text_ctrl_splash.SetValue(directory+"/"+filename)
            dlg.Destroy()

    # method of loaded configuration
    def loadConf(self):
        # set timeout
        self.text_ctrl_timeout.SetValue(self.__conf.TIME)
        
        # set keylayout
        if self.__conf.JP == "yes":
            idx = 1
        else:
            idx = 0
        self.combo_box_kblayout.SetSelection(idx)
            
        # set default boot
        for img in self.__conf.VM_LIST:
            if img == self.__conf.DEFAULT:
                self.combo_box_defaultboot.SetSelection(self.__conf.VM_LIST.index(img))
                
        # set windows entry
        if self.__conf.WIN != '':
            self.text_ctrl_windows.SetValue(self.__conf.WIN)
            
        # set splash
        if self.__conf.SPLASH != '':
            self.checkbox_splash.SetValue(1)
            self.changeValueDeviceSplash(1)
            self.text_ctrl_splash.SetValue(self.__conf.SPLASH)
            
        # set color
        if self.__conf.COLOR != '':
            self.checkbox_color.SetValue(1)
            self.changeValueDeviceColor(1)
            color_list = self.__conf.COLOR.replace('/', ' ').split()
            self.combo_box_strcolor.SetSelection(constants.STR_COLOR.index(color_list[0]))
            self.combo_box_bgcolor.SetSelection(constants.BG_COLOR.index(color_list[1]))
            self.combo_box_sel_strcolor.SetSelection(constants.STR_COLOR.index(color_list[2]))
            self.combo_box_sel_bgcolor.SetSelection(constants.BG_COLOR.index(color_list[3]))
            
        # set single mode
        for img in self.__conf.VM_LIST:
            if img == self.__conf.SINGLE:
                self.combo_box_single_mode.SetSelection(self.__conf.VM_LIST.index(img)+1)
                
        # set boot option
        for opt_list in self.__conf.OPTION_LIST:
            self.grid_entry.AppendRows(1,false)
            self.grid_entry.SetCellValue(self.__conf.VM_LIST.index(opt_list[0]), 0, opt_list[0])
            self.grid_entry.SetReadOnly(self.__conf.VM_LIST.index(opt_list[0]), 0, True)
            option = ''
            for opt in opt_list:
                if opt != opt_list[0]:
                    if opt != 'none':
                        option += opt + ' '
                    else:
                        pass
                    
            self.grid_entry.SetCellValue(self.__conf.VM_LIST.index(opt_list[0]), 1, option)
                    
        # create view
        st = create_menu.write_menu(self.__conf)
        self.text_ctrl_view.SetValue(st.getvalue())
        
        # set common tab
        self.notebook_guiconfig.SetSelection(0)

    # onClick event method of the checkbox splash
    def OnChkBoxSplashClick(self, event):
        if self.checkbox_splash.GetValue():
            self.changeValueDeviceSplash(1)
            self.checkbox_splash.SetValue(1)
            self.checkbox_color.SetValue(0)
            self.changeValueDeviceColor(0)
        else:
            self.changeValueDeviceSplash(0)
            self.checkbox_splash.SetValue(0)

    # onClick event method of the checkbox color
    def OnChkBoxColorClick(self, event):
        if self.checkbox_color.GetValue():
            self.changeValueDeviceColor(1)
            self.checkbox_color.SetValue(1)
            self.checkbox_splash.SetValue(0)
            self.changeValueDeviceSplash(0)
        else:
            self.changeValueDeviceColor(0)
            self.checkbox_color.SerValue(0)

    # package conversion method of splash
    def changeValueDeviceSplash(self, value):
        self.text_ctrl_splash.Enable(value)
        self.button_splash.Enable(value)

    # package conversion method of color
    def changeValueDeviceColor(self, value):
        self.combo_box_strcolor.Enable(value)
        self.combo_box_bgcolor.Enable(value)
        self.combo_box_sel_strcolor.Enable(value)
        self.combo_box_sel_bgcolor.Enable(value)






