#
# --- grubmenu ---
#
# config.py
#
# This class loads the various information on grubmenu, and records and offers it.
#
# Copyright (c) 2003 by kaepapa <kaepapa@kaepapa.dip.jp>

import os, sys, re

import constants
import utils

from ConfigParser import ConfigParser

from os.path import isfile

class config:
    # Constructor function
    def __init__(self):
        if isfile(constants.CONF_FILE):
            self.readconf()
        else:
            self.defaultset()
        
        if self.OPTION != "":
            self.OPTION_LIST = eval(self.OPTION)
        else:
            self.OPTION_LIST = []

        self.VM_LIST = utils.ext_vm('linuz')
        self.IMG_LIST = utils.ext_vm('list')

        if (len(self.VM_LIST) == 0) | (len(self.IMG_LIST) == 0):
            raise noExistVMImage

        self.refresh_vm_list()


    # This function reads setting from a configuration file.
    def readconf(self):
        cp = ConfigParser()
        cp.read(constants.CONF_FILE)

        self.GRUB_DIR = cp.get('grub', 'grub_dir')
        self.GRUB_ROOT_DEV = cp.get('grub', 'grub_root_dev')
        self.ROOT_DEV = cp.get('grub', 'root_dev')
        self.TIME = cp.get('grub', 'time')
        self.DEFAULT = cp.get('grub', 'default')
        self.SINGLE = cp.get('grub', 'single')
        self.OPTION = cp.get('grub', 'option')
        self.SPLASH = cp.get('grub', 'splash')
        self.COLOR = cp.get('grub', 'color')
        self.JP = cp.get('grub', 'jp')
        __tmp_win = cp.get('grub', 'win')
        if re.match("^/dev/.*", __tmp_win) != None:
            self.WIN = __tmp_win
        else:
            self.WIN = ""
        self.SWSUSP = cp.get('grub', 'swsusp')
        self.STIME = cp.get('grub', 'stime')
        try:
            self.DIST_NAME = cp.get('grub', 'dist_name')
        except:
            self.DIST_NAME = ""
            
    # This function sets up a default value.
    def defaultset(self):
        self.GRUB_DIR = ""
        self.GRUB_ROOT_DEV = ""
        self.ROOT_DEV = ""
        self.TIME = "15"
        self.DEFAULT = "0"
        self.SINGLE = "ALL kernel-image"
        self.OPTION = ""
        self.SPLASH = ""
        self.COLOR = ""
        self.JP = "no"
        self.WIN = ""
        self.SWSUSP = ""
        self.STIME = ""
        self.DIST_NAME = ""

    # This function writes the present setup in a configuration file.
    def writeconf(self):

        cp = ConfigParser()
        cp.add_section('grub')

        cp.set('grub','grub_dir',self.GRUB_DIR)
        cp.set('grub','grub_root_dev',self.GRUB_ROOT_DEV)
        cp.set('grub','root_dev',self.ROOT_DEV)
        cp.set('grub','time',self.TIME)
        cp.set('grub','default',self.DEFAULT)
        cp.set('grub','single',self.SINGLE)
        cp.set('grub','option',self.OPTION)
        cp.set('grub','splash',self.SPLASH)
        cp.set('grub','color',self.COLOR)
        cp.set('grub','jp',self.JP)
        cp.set('grub','win',self.WIN)
        cp.set('grub','swsusp',self.SWSUSP)
        cp.set('grub','stime',self.STIME)
        try:
            cp.set('grub','dist_name',self.DIST_NAME)
        except:
            cp.set('grub','dist_name',"")
            
        cp.write(file(constants.CONF_FILE,'w'))

    # This function is refreshed for record of the starting option of a kernel image.
    def refresh_vm_list(self):
        # The option of the kernel image which does not exist is deleted.
        for opt in self.OPTION_LIST:
            try:
                self.VM_LIST.index(opt[0])
            except ValueError:
                self.OPTION_LIST.remove(opt)

        # Adding a option of the kernel image which does not exist in OPTION_LIST.
        tmp = []

        for img in self.VM_LIST:
            flug = 'off'
            for opt in self.OPTION_LIST:
                if opt[0] == img:
                    flug = 'on'
            if flug == 'off':
                tmp.append([img, 'none'])

        self.OPTION_LIST.extend(tmp)

        self.OPTION = self.OPTION_LIST

        self.writeconf()

