/*
 * Copyright 2009- kensir0u.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/*
 * 쐬 (creation date)  F2009/02/11
 * pbP[W  (package name) Fnet.sf.thirdi.jdbc.meta
 * t@C  (file name)    FFieldDesc.java
 */
package net.sf.thirdi.jdbc.meta;

import java.lang.reflect.Field;

import net.sf.thirdi.jdbc.exception.InvokeException;

/**
 * <i>Tv(abstract)</i>F tB[h킷B
 *@.<p>
 * tB[h킷B
 * 
 *
 * @author  kensir0u
 * @version 1.0
 * @since   JDK 5.0
 *
 */
public class FieldDesc implements ElementDesc{
	
	private static final ElementType elementtype= ElementType.FIELD;
	
	private String fieldName;
	
	private String name;
	
	private String aliasname;
	
	private String id;
	
	private int index = Short.MIN_VALUE;
	
	private Field field;
	
	private Class<?> type;

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.meta.ElementDesc#getAliasName()
	 */
	@Override
	public String getAliasName() {
		return this.aliasname;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.meta.ElementDesc#getElementType()
	 */
	@Override
	public ElementType getElementType() {
		return elementtype;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.meta.ElementDesc#getId()
	 */
	@Override
	public String getId() {
		return this.id;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.meta.ElementDesc#getName()
	 */
	@Override
	public String getName() {
		return this.name;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.meta.ElementDesc#getType()
	 */
	@Override
	public Class<?> getType() {
		return this.type;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.meta.ElementIndexable#getIndex()
	 */
	@Override
	public int getIndex() {
		return this.index;
	}

	public String getFieldName() {
		return fieldName;
	}

	public void setFieldName(String fieldName) {
		this.fieldName = fieldName;
	}

	public Field getField() {
		return field;
	}

	public void setField(Field field) {
		this.field = field;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setAliasname(String aliasname) {
		this.aliasname = aliasname;
	}

	public void setId(String id) {
		this.id = id;
	}

	public void setIndex(int index) {
		this.index = index;
	}

	public void setType(Class<?> type) {
		this.type = type;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.meta.ElementDesc#invoke(java.lang.Object, java.lang.Object)
	 */
	@Override
	public void invoke(Object bean, Object value) {
		try {
			field.set(bean, value);
		} catch (IllegalArgumentException e) {
			throw new InvokeException(e);
		} catch (IllegalAccessException e) {
			throw new InvokeException(e);
		} 
	}

}
