/*
 * Copyright 2009- kensir0u.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/*
 * 쐬 (creation date)  F2009/02/11
 * pbP[W  (package name) Fnet.sf.thirdi.jdbc.meta
 * t@C  (file name)    FBeanDesc.java
 */
package net.sf.thirdi.jdbc.meta;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.thirdi.jdbc.annotation.Include;

/**
 * <i>Tv(abstract)</i>F Bean̏i[B
 *@.<p>
 * Bean̏i[B
 * 
 *
 * @author  kensir0u
 * @version 1.0
 * @since   JDK 5.0
 *
 */
public class BeanDesc {

	private Map<String,ElementDesc> nameMap = new HashMap<String,ElementDesc>();
	
	private List<ElementDesc> list;
	
	private BeanDesc superbeandesc;
	
	private Class<?> beanclass;
	
	private boolean includeType;
	
	BeanDesc(Class<?> beanclass) {
		this.beanclass = beanclass;
		this.includeType = this.beanclass.isAnnotationPresent(Include.class);
	}

	public Map<String, ElementDesc> getNameMap() {
		if (nameMap == null) nameMap = new HashMap<String,ElementDesc>();
		return nameMap;
	}

	public void setNameMap(Map<String, ElementDesc> nameMap) {
		this.nameMap = nameMap;
	}

	public List<ElementDesc> getList() {
		return list;
	}

	public void setList(List<ElementDesc> list) {
		this.list = list;
	}

	public BeanDesc getSuperbeandesc() {
		return superbeandesc;
	}

	public void setSuperbeandesc(BeanDesc superbeandesc) {
		this.superbeandesc = superbeandesc;
	}

	public Class<?> getBeanclass() {
		return beanclass;
	}

	public void setBeanclass(Class<?> beanclass) {
		this.beanclass = beanclass;
	}

	public boolean isIncludeType() {
		return includeType;
	}

	public void setIncludeType(boolean includeType) {
		this.includeType = includeType;
	}
}
