/*
 * Copyright 2009- kensir0u.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/*
 * 쐬 (creation date)  F2009/02/16
 * pbP[W  (package name) Fnet.sf.thirdi.jdbc.impl
 * t@C  (file name)    FCSVFormatInfoImpl.java
 */
package net.sf.thirdi.jdbc.impl;

import net.sf.thirdi.jdbc.CSVFormatInfo;

/**
 * <i>Tv(abstract)</i>F CSVFormatInfo
 *@.<p>
 * CSVFormatInfo<BR>
 * {@link net.sf.thirdi.jdbc.CSVFormatInfo}
 * 
 *
 * @author  kensir0u
 * @version 1.0
 * @since   JDK 5.0
 *
 */
class CSVFormatInfoImpl implements CSVFormatInfo{
	
	private char fieldseparatorchar = ',';
	
	private String recordseparatorchar = "\r\n";
	
	private boolean removereturn = false;;
	
	private boolean escapedoublequotation = false;;

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVFormatInfo#getFieldSeparator()
	 */
	@Override
	public char getFieldSeparator() {
		return this.fieldseparatorchar;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVFormatInfo#getRecordSeparator()
	 */
	@Override
	public String getRecordSeparator() {
		return this.recordseparatorchar;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVFormatInfo#isEscapeDoubleQuotation()
	 */
	@Override
	public boolean isEscapeDoubleQuotation() {
		return this.escapedoublequotation;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVFormatInfo#isRemoveReturn()
	 */
	@Override
	public boolean isRemoveReturn() {
		return this.removereturn;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVFormatInfo#setEscapeDoubleQuotation(boolean)
	 */
	@Override
	public void setEscapeDoubleQuotation(boolean flag) {
		this.escapedoublequotation = flag;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVFormatInfo#setFieldSeparatorChar(char)
	 */
	@Override
	public void setFieldSeparatorChar(char separator)
			throws IllegalArgumentException {
		if ('\u0000' <= separator && '\u0020' > separator){
			// TODO message move to property file.
			throw new IllegalArgumentException("field separator must not be illegal character.");
		}
		
		this.fieldseparatorchar=separator;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVFormatInfo#setRecordSeparatorChar(java.lang.String)
	 */
	@Override
	public void setRecordSeparatorChar(String separator)
			throws IllegalArgumentException {
		if (separator == null || "".equals(separator)){
			
			// TODO message move to property file.
			throw new IllegalArgumentException("Record separator must not be null or blank.");
		}
		
		this.recordseparatorchar = separator;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVFormatInfo#setRemoveReturnMode(boolean)
	 */
	@Override
	public void setRemoveReturnMode(boolean flag) {
		this.removereturn = flag;
	}

}
