
#pragma once

#include "ParserCtrlView.h"
#include "Document/Document.h"

using namespace icubic;
using namespace document;

/**************************************************************************************************
"CParserToolBar" class 
**************************************************************************************************/
class CParserToolBar : public CMFCToolBar
{
	virtual void OnUpdateCmdUI(CFrameWnd* pTarget , BOOL bDisableIfNoHndler)
	{
		CMFCToolBar::OnUpdateCmdUI((CFrameWnd*) GetOwner(), bDisableIfNoHndler);
	}
	virtual BOOL AllowShowOnList() const { return FALSE; }
};
/**************************************************************************************************
"CParserView" class 
**************************************************************************************************/
class CParserView : public CDockablePane
{
// member variable
private:
	CParserToolBar				m_toolbar;
	CParserCtrlView				m_treeview;

// private functions
private:
//=================================================================================================
void AdjustLayout();
//=================================================================================================
void OnChangeVisualStyle();

// public functions
public:
//=================================================================================================
CParserView();
//=================================================================================================
virtual ~CParserView();

// MFC functions
public:

// MFC override
public:
//=================================================================================================
virtual BOOL PreTranslateMessage(MSG* pMsg);

// MFC event handler
protected:
	DECLARE_MESSAGE_MAP()
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnNewFolder();
	afx_msg void OnNewParser();
	afx_msg void OnRename();
	afx_msg void OnDelete();
	afx_msg void OnSetStart();
	afx_msg void OnNewFolderUpdate(CCmdUI* pCmdUI);
	afx_msg void OnNewParserUpdate(CCmdUI* pCmdUI);
	afx_msg void OnRenameUpdate(CCmdUI* pCmdUI);
	afx_msg void OnDeleteUpdate(CCmdUI* pCmdUI);
	afx_msg void OnSetStartUpdate(CCmdUI* pCmdUI);
	afx_msg void OnPaint();
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg LRESULT OnChangeActiveTab(WPARAM, LPARAM);
};

