// ParseEditCtrlView.h : CParseEditCtrlView NX̃C^[tFCX
//
#pragma once

#include	<Richole.h>


/**************************************************************************************************
"CRichEditOleCallback" class 
**************************************************************************************************/
class CDescEditRichEditOleCallback : 
		public IRichEditOleCallback , 
		public virtual ComBase
{
	cb_combase_begin()
	cb_combase_interface( IID_IRichEditOleCallback , IRichEditOleCallback )
	cb_combase_end( ComBase )

// "IRichEditOleCallback" interface functions
//=================================================================================================
HRESULT cb_comcall ContextSensitiveHelp
		(
		BOOL fEnterMode
		)
{
	return S_FALSE;
}
//=================================================================================================
HRESULT cb_comcall DeleteObject
		(
		LPOLEOBJECT lpoleobj
		)
{
	return S_FALSE;
}
//=================================================================================================
HRESULT cb_comcall GetClipboardData
		(
		CHARRANGE*		lpchrg,
		DWORD			reco,
		LPDATAOBJECT*	lplpdataobj
		)
{
	return S_FALSE;
}
//=================================================================================================
HRESULT cb_comcall GetContextMenu
		(
		WORD		seltype,
		LPOLEOBJECT	lpoleobj,
		CHARRANGE*	lpchrg,
		HMENU*		lphmenu
		)
{
	return S_FALSE;
}
//=================================================================================================
HRESULT cb_comcall GetDragDropEffect
		(
		BOOL		fDrag,
		DWORD		grfKeyState,
		LPDWORD		pdwEffect
		)
{
	return S_FALSE;
}
//=================================================================================================
HRESULT cb_comcall GetInPlaceContext
		(
		LPOLEINPLACEFRAME*		lplpFrame ,
		LPOLEINPLACEUIWINDOW*	lplpDoc,
		LPOLEINPLACEFRAMEINFO	lpFrameInfo
		)
{
	return S_FALSE;
}
//=================================================================================================
HRESULT cb_comcall GetNewStorage
		(
		LPSTORAGE*		lplpstg
		)
{
	return S_FALSE;
}
//=================================================================================================
HRESULT cb_comcall QueryAcceptData
		(
		LPDATAOBJECT	lpdataobj,
		CLIPFORMAT*		lpcfFormat,
		DWORD			reco,
		BOOL			fReally,
		HGLOBAL			hMetaPict
		)
{
	ATLASSERT( lpcfFormat != NULL );
	if( !fReally )
		return S_OK;
	if ( *lpcfFormat == CF_TEXT )
		return S_OK;
	CComPtr<IDataObject>	data( lpdataobj );
	FORMATETC fe;
	fe.cfFormat	= CF_TEXT;
	fe.ptd		= NULL;
	fe.dwAspect = DVASPECT_CONTENT;
	fe.lindex	= -1;
	fe.tymed	= TYMED_HGLOBAL;
	if ( S_OK == data->QueryGetData( &fe ) ) 
	{
		*lpcfFormat = CF_TEXT;
		return S_OK;
	}
	return S_FALSE;
}
//=================================================================================================
HRESULT cb_comcall QueryInsertObject
		(
		LPCLSID		lpclsid,
		LPSTORAGE	lpstg,
		LONG		cp
		)
{
	return S_FALSE;
}
//=================================================================================================
HRESULT cb_comcall ShowContainerUI
		(
		BOOL		fShow
		)
{
	return S_FALSE;
}
// public functions
public:
};

/**************************************************************************************************
"CDescEdit" class 
**************************************************************************************************/
class CDescEdit : public CRichEditCtrl
{

	DECLARE_DYNAMIC(CDescEdit)

// member variable
private:
	CDescEditRichEditOleCallback	p;
	wstring		m_facename;
	int			m_height;
	isize		m_min;
	ivector2	m_pos;
	rgb			m_color;
	rgb			m_bkcolor;
	
// public functions
public:
//=================================================================================================
CDescEdit();
//=================================================================================================
virtual ~CDescEdit();
//=================================================================================================
void CDescEdit::Initialize
		(
		const wstring&	facename , 
		int				height , 
		const rgb&		c , 
		const rgb&		bkc , 
		const isize&	min
		);
//=================================================================================================
void CDescEdit::SetPos
		(
		const ivector2&		pos
		);

// MFC event handler
protected:
	DECLARE_MESSAGE_MAP()
protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
public:
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnEnRequestresize(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnContextMenu(CWnd* /*pWnd*/, CPoint /*point*/);
};
/**************************************************************************************************
"CParseEditCtrlView" class 
**************************************************************************************************/
class TransParam
{
public:
	ivector2	m_pos;
	isize		m_resize;
	TransParam(){}
	TransParam( const ivector2& p ) : m_pos( p ){}
	TransParam( const isize& s ) : m_resize( s ){}
	TransParam( const ivector2& p , const isize& s ) : m_pos( p ) , m_resize( s ){}
};
class CParseEditCtrlView : public CWnd , public ICallback , public StaticStateTrans<TransParam>
{
	enum TransEvent
	{
		ev_ReconnectInput , 
		ev_ReconnectOutput , 
		ev_LinkbarCtrl , 
		ev_Item , 
		ev_InputPin , 
		ev_OutputPin , 
		ev_None , 
		ev_Next , 
		ev_LButtonDown , 
		ev_MouseMove , 
		ev_LButtonUp , 
		ev_MoveStart , 
		ev_SelectStart , 
		ev_CancelMode , 
		ev_Timer , 
		ev_LDblClick , 
		ev_EditDesc , 
		ev_EditDescEnd , 
		ev_EditDescChange , 
		ev_EditDescResize , 
	};
	begin_sst_map();
	event_sst_map( ev_LButtonDown	, 0 , 0 , ts_0to0_select );
	event_sst_map( ev_LDblClick		, 0 , 0 , ts_0to0_dblclick );
	event_sst_map( ev_MouseMove		, 0 , 0 , ts_0to0 );
	event_sst_map( ev_LinkbarCtrl	, 0 , 1 , ts_0to1 );
	event_sst_map( ev_Item			, 0 , 3 , ts_0to3 );
	event_sst_map( ev_None			, 0 , 5 , ts_0to5 );
	event_sst_map( ev_InputPin		, 0 , 7 , ts_0to7 );
	event_sst_map( ev_OutputPin		, 0 , 8 , ts_0to8 );
	event_sst_map( ev_ReconnectInput, 0 , 9 , ts_0to9 );
	event_sst_map( ev_ReconnectOutput, 0 , 11 , ts_0to11 );
	event_sst_map( ev_EditDesc		, 0 , 13 , ts_0to13 );
	event_sst_map( ev_LButtonUp		, 1 , 0 , ts_1to0 );
	event_sst_map( ev_MouseMove		, 1 , 1 , ts_1to1 );
	event_sst_map( ev_Next			, 1 , 2 , ts_1to2 );
	event_sst_map( ev_MouseMove		, 2 , 2 , ts_2to2 );
	event_sst_map( ev_Timer			, 2 , 2 , ts_2to2_timer );
	event_sst_map( ev_LButtonUp		, 2 , 0 , ts_2to0 );
	event_sst_map( ev_CancelMode	, 2 , 0 , ts_2to0_canel );
	event_sst_map( ev_MouseMove		, 3 , 3 , ts_3to3 );
	event_sst_map( ev_LButtonUp		, 3 , 0 , ts_3to0 );
	event_sst_map( ev_Next			, 3 , 4 , ts_3to4 );
	event_sst_map( ev_MouseMove		, 4 , 4 , ts_4to4 );
	event_sst_map( ev_Timer			, 4 , 4 , ts_4to4_timer );
	event_sst_map( ev_LButtonUp		, 4 , 0 , ts_4to0 );
	event_sst_map( ev_CancelMode	, 4 , 0 , ts_4to0_cancel );
	event_sst_map( ev_MouseMove		, 5 , 5 , ts_5to5 );
	event_sst_map( ev_LButtonUp		, 5 , 0 , ts_5to0 );
	event_sst_map( ev_Next			, 5 , 6 , ts_5to6 );
	event_sst_map( ev_MouseMove		, 6 , 6 , ts_6to6 );
	event_sst_map( ev_Timer			, 6 , 6 , ts_6to6_timer );
	event_sst_map( ev_LButtonUp		, 6 , 0 , ts_6to0 );
	event_sst_map( ev_CancelMode	, 6 , 0 , ts_6to0_cancel );
	event_sst_map( ev_MouseMove		, 7 , 7 , ts_7to7 );
	event_sst_map( ev_Timer			, 7 , 7 , ts_7to7_timer );
	event_sst_map( ev_LButtonUp		, 7 , 0 , ts_7to0 );
	event_sst_map( ev_CancelMode	, 7 , 0 , ts_7to0_cancel );
	event_sst_map( ev_MouseMove		, 8 , 8 , ts_8to8 );
	event_sst_map( ev_Timer			, 8 , 8 , ts_8to8_timer );
	event_sst_map( ev_LButtonUp		, 8 , 0 , ts_8to0 );
	event_sst_map( ev_CancelMode	, 8 , 0 , ts_8to0_cancel );
	event_sst_map( ev_LButtonUp		, 9 , 0 , ts_9to0 );
	event_sst_map( ev_MouseMove		, 9 , 9 , ts_9to9 );
	event_sst_map( ev_Next			, 9 , 10, ts_9to10 );
	event_sst_map( ev_MouseMove		, 10 ,10, ts_10to10 );
	event_sst_map( ev_Timer			, 10 ,10, ts_10to10_timer );
	event_sst_map( ev_LButtonUp		, 10 ,0 , ts_10to0 );
	event_sst_map( ev_CancelMode	, 10 ,0 , ts_10to0_canel );
	event_sst_map( ev_LButtonUp		, 11 , 0 , ts_11to0 );
	event_sst_map( ev_MouseMove		, 11 , 11 , ts_11to11 );
	event_sst_map( ev_Next			, 11 , 12, ts_11to12 );
	event_sst_map( ev_MouseMove		, 12 ,12, ts_12to12 );
	event_sst_map( ev_Timer			, 12 ,12, ts_12to12_timer );
	event_sst_map( ev_LButtonUp		, 12 ,0 , ts_12to0 );
	event_sst_map( ev_CancelMode	, 12 ,0 , ts_12to0_canel );
	event_sst_map( ev_EditDescEnd	, 13 , 0 , ts_13to0 );
	event_sst_map( ev_EditDescChange , 13 , 13 , ts_13to13_change );
	event_sst_map( ev_EditDescResize , 13 , 13 , ts_13to13_resize );
	end_sst_map();
	
	enum AreaType
	{
		None = 0 , 
		Node , 
		InputPin , 
		OutputPin , 
		Link , 
		InputReconnectPin , 
		OutputReconnectPin , 
		LinkBarCtrl
	};
	class ObjectArea
	{
	public:
		unsigned int	m_item_id;
		AreaType		m_type;
		int				m_rect_num;
		irect			m_rect[11];
	};
	class PasteItems : public IPasteItems
	{
	public:
		Array<iParserItem>	m_items;
		void cb_call AddItem
				(
				iParserItem&	item
				)
		{
			m_items[ m_items.Add() ]	= item;
		}
	};
	enum
	{
		ID_DESC_EDIT	= 100 , 
	};
// member variable
protected:
	unsigned int				m_item_id;
	iDocument					m_document;

private:
	instance<CallbackListener>	m_listener;
	
	// trans parameter
	bool						m_add_mode;
	unsigned int				m_edit_item;
	int							m_select_num;
	int							m_linkbar_start;
	int							m_linkbar_mov;
	IUndoList*					m_undo;
	
	Array<unsigned int>			m_select;
	Array<ObjectArea>			m_drawed;
	ivector2					m_drag_start;
	
	// desc edit
	CDescEdit					m_desc_edit;
	
	// draw control
	irect						m_view_area;
	isize						m_wndsize;
	ivector2					m_scroll_pos;
	
	// draw
	instance<Surface>			m_surface;
	instance<Graphics_gp>		m_graphics;
	instance<Path>				m_path_link;
	
	// draw elemnt
	iPaint_gp					m_paint_back;
	iPaint_gp					m_paint_grid;
	iPaint_gp					m_paint_frame_node;
	iPaint_gp					m_paint_frame_node_stroke;
	iPaint_gp					m_paint_frame_link;
	iPaint_gp					m_paint_frame_link_stroke;
	iPaint_gp					m_paint_select;
	iPaint_gp					m_paint_select_stroke;
	iPaint_gp					m_paint_pin_stroke;
	iPaint_gp					m_paint_pin;
	iPaint_gp					m_paint_linkbar_stroke;
	iPaint_gp					m_paint_linkbar;
	iPaint_gp					m_paint_desc_node;
	iPaint_gp					m_paint_desc_node_stroke;
	
	
	iPaint_gp					m_paint_edit_link;
	iPaint_gp					m_paint_link;
	iPaint_gp					m_paint_link_info;
	iFont_gp					m_font_function;
	iFont_gp					m_font_regular;
	iFont_gp					m_font_desc;
	
	// extra
	instance<OutlineGenStroke>	m_gen;
	instance<PathToOutline>		m_pathto;
	instance<Outline>			m_outline;
	instance<EdgemapCell>		m_edgemap;
	instance<RendererCell>		m_render;
	instance<BlenderOverlap>	m_blender;
	
	// size
	const int					m_grid_draw_num;
	const int					m_page_margin;
	const int					m_scroll_line;
	const int					m_select_frame_width;
	const int					m_drag_len;
	const int					m_autoscroll_interval;
	const isize					m_pin_size;
	const isize					m_linkbar_ctrl_size;
	const int					m_pin_margin;
	const isize					m_link_info_margin;
	const int					m_link_r;
	const int					m_link_ih;
	const float					m_link_w;
	const float					m_linkbar_w;
	const rgba					m_color_function;
	const rgba					m_color_regular;
	const int					m_key_scroll_margin;
	const int					m_link_area_w;
	const isize					m_desc_margin;
	const rgb					m_color_desc;
	const int					m_desc_min;
	const int					m_font_desc_h;
	const int					m_font_function_h;
	const int					m_font_regular_h;
	
	// images
	static
	iTexture					m_node_start_img;
	static
	iTexture					m_node_end_img;
	static
	iTexture					m_node_none_img;
	static
	iTexture					m_node_cleartext_img;
	static
	iTexture					m_node_pushtag_img;
	static
	iTexture					m_node_poptag_img;
	static
	iTexture					m_node_setattr_img;
	static
	iTexture					m_node_setattrtext_img;
	static
	iTexture					m_node_settext_img;
	static
	iTexture					m_node_pushtext_img;
	static
	iTexture					m_node_poptext_img;

protected:
	const int					m_grid_size;
	enum KeyDir
	{
		Up , Down , Left , Right
	};
// trans functions
private:
	bool ts_0to0_select(void*p);
	bool ts_0to0_dblclick(void*p);
	bool ts_0to0(void*p);
	bool ts_0to1(void*p);
	bool ts_0to3(void*p);
	bool ts_0to5(void*p);
	bool ts_0to7(void*p);
	bool ts_0to8(void*p);
	bool ts_0to9(void*p);
	bool ts_0to11(void*p);
	bool ts_0to13(void*p);
	bool ts_1to0(void*p);
	bool ts_1to1(void*p);
	bool ts_1to2(void*p);
	bool ts_2to2(void*p);
	bool ts_2to2_timer(void*p);
	bool ts_2to0(void*p);
	bool ts_2to0_canel(void*p);
	bool ts_3to3(void*p);
	bool ts_3to0(void*p);
	bool ts_3to4(void*p);
	bool ts_4to4(void*p);
	bool ts_4to4_timer(void*p);
	bool ts_4to0(void*p);
	bool ts_4to0_cancel(void*p);
	bool ts_5to5(void*p);
	bool ts_5to0(void*p);
	bool ts_5to6(void*p);
	bool ts_6to6(void*p);
	bool ts_6to6_timer(void*p);
	bool ts_6to0(void*p);
	bool ts_6to0_cancel(void*p);
	bool ts_7to7(void*p);
	bool ts_7to7_timer(void*p);
	bool ts_7to0(void*p);
	bool ts_7to0_cancel(void*p);
	bool ts_8to8(void*p);
	bool ts_8to8_timer(void*p);
	bool ts_8to0(void*p);
	bool ts_8to0_cancel(void*p);
	bool ts_9to0(void*p);
	bool ts_9to9(void*p);
	bool ts_9to10(void*p);
	bool ts_10to10(void*p);
	bool ts_10to10_timer(void*p);
	bool ts_10to0(void*p);
	bool ts_10to0_canel(void*p);
	bool ts_11to0(void*p);
	bool ts_11to11(void*p);
	bool ts_11to12(void*p);
	bool ts_12to12(void*p);
	bool ts_12to12_timer(void*p);
	bool ts_12to0(void*p);
	bool ts_12to0_canel(void*p);
	bool ts_13to0(void*p);
	bool ts_13to13_change(void*p);
	bool ts_13to13_resize(void*p);
	
// private functions
private:
//=================================================================================================
void cb_call Callback
		(
		Type	type , 
		object&	obj , 
		void*	param
		);
//=================================================================================================
AreaType CParseEditCtrlView::HitArea
		(
		const ivector2&	pos , 
		unsigned int*	id
		);
//=================================================================================================
bool CParseEditCtrlView::IsEnablePin
		(
		unsigned int	item , 
		AreaType		type
		);
//=================================================================================================
bool CParseEditCtrlView::AutoScroll
		(
		ivector2*	curpos
		);
//=================================================================================================
void CParseEditCtrlView::UpdateSelect();
//=================================================================================================
bool CParseEditCtrlView::IsAddMode();
//=================================================================================================
iTexture CParseEditCtrlView::LoadImage
		(
		const wchar_t*		name , 
		const wchar_t*		type
		);
//=================================================================================================
void CParseEditCtrlView::InitializeImgs();
//=================================================================================================
irect CParseEditCtrlView::GetLinkBoundbox
		(
		iParserLink&		link
		);
//=================================================================================================
irect CParseEditCtrlView::GetNodeBoundbox
		(
		iParserNode&		node
		);
//=================================================================================================
irect CParseEditCtrlView::GetItemsBoundbox
		(
		iGraph&	graph
		);
//=================================================================================================
bool CParseEditCtrlView::GetSelectItemsBoundbox
		(
		irect*	bbx
		);
//=================================================================================================
void CParseEditCtrlView::MoveItemsCenter
		(
		iGraph&		graph , 
		IUndoList*	undo
		);
//=================================================================================================
void CParseEditCtrlView::InitializeViewArea
		(
		const isize&	wndsize
		);
//=================================================================================================
void CParseEditCtrlView::UpdateViewArea
		(
		const isize&	wndsize
		);
//=================================================================================================
void CParseEditCtrlView::UpdateViewArea();
//=================================================================================================
void CParseEditCtrlView::UpdateScroll
		(
		int		dir		//!< [in] SB_HORZ / SB_VERT
		);
//=================================================================================================
bool CParseEditCtrlView::UpdateViewAreaInKey
		(
		KeyDir	dir
		);
//=================================================================================================
irect CParseEditCtrlView::GetWindowArea();
//=================================================================================================
iParserNode CParseEditCtrlView::SearchNodeId
		(
		unsigned int	item
		);
//=================================================================================================
iParserItem CParseEditCtrlView::SearchItemId
		(
		unsigned int	item
		);
//=================================================================================================
int CParseEditCtrlView::SearchSelect
		(
		unsigned int	item
		);
//=================================================================================================
bool CParseEditCtrlView::ResetSelect();
//=================================================================================================
bool CParseEditCtrlView::ToggleSelect
		(
		unsigned int	item
		);
//=================================================================================================
bool CParseEditCtrlView::SetSelect
		(
		unsigned int	item
		);
//=================================================================================================
bool CParseEditCtrlView::AddSelect
		(
		unsigned int	item
		);
//=================================================================================================
void CParseEditCtrlView::SetSelect
		(
		const irect&	r
		);
//=================================================================================================
void CParseEditCtrlView::AddSelect
		(
		const irect&	r
		);
//=================================================================================================
unsigned int CParseEditCtrlView::SearchDrawed
		(
		const ivector2&		pt
		);
//=================================================================================================
bool CParseEditCtrlView::AddLink
		(
		iGraphNode&	snode , 
		iGraphNode&	tnode , 
		bool		grid
		);
//=================================================================================================
bool CParseEditCtrlView::SetLinkbarWidth
		(
		unsigned int	edit_id , 
		int				w , 
		bool			grid , 
		IUndoList*		undo
		);
//=================================================================================================
bool CParseEditCtrlView::MoveSelectItem
		(
		unsigned int	edit_id , 
		ivector2		move , 
		bool			grid
		);
//=================================================================================================
void CParseEditCtrlView::DrawBack();
//=================================================================================================
void CParseEditCtrlView::DrawGrid();
//=================================================================================================
ivector2 CParseEditCtrlView::GetPinPos
		(
		unsigned int	item , 
		AreaType		type
		);
//=================================================================================================
ivector2 CParseEditCtrlView::GetPinPos
		(
		iParserNode&	node , 
		AreaType		type
		);
//=================================================================================================
void CParseEditCtrlView::DrawEditLink
		(
		unsigned int	item , 
		AreaType		type , 
		const ivector2	tgt
		);
//=================================================================================================
iTexture CParseEditCtrlView::GetNodeImg
		(
		IParserNode::Property::Type	type
		);
//=================================================================================================
isize CParseEditCtrlView::GetNodeSize
		(
		const IParserNode::Property&	prop
		);
//=================================================================================================
fvector2 CParseEditCtrlView::SetPathArcXY
		(
		const fvector2&	sp , 
		int				p[2] , 
		iPath&			path
		);
//=================================================================================================
fvector2 CParseEditCtrlView::SetPathArcYX
		(
		const fvector2&	sp , 
		int				p[2] , 
		iPath&			path
		);
//=================================================================================================
void CParseEditCtrlView::StrokePath
		(
		iPath&			path , 
		float			width , 
		iPaint_gp&		paint , 
		uint8			alpha
		);
//=================================================================================================
void CParseEditCtrlView::DrawConnectLine
		(
		fvector2		sp , 
		int				p[12] , 
		iPaint_gp&		paint , 
		uint8			alpha
		);
//=================================================================================================
void CParseEditCtrlView::AddObjectAreaX
		(
		const fvector2&		sp , 
		int					l , 
		ObjectArea*			area
		);
//=================================================================================================
void CParseEditCtrlView::AddObjectAreaY
		(
		const fvector2&		sp , 
		int					l , 
		ObjectArea*			area
		);
//=================================================================================================
void CParseEditCtrlView::DrawConnectLine
		(
		fvector2		sp , 
		int				p1[13] , 
		fvector2		cp , 
		int				p2[13] , 
		uint8			alpha , 
		ObjectArea*		area
		);
//=================================================================================================
void CParseEditCtrlView::GetLinkInfo
		(
		iParserLink&			link , 
		const ivector2&			move , 
		ivector2*				sp , 
		ivector2*				tp , 
		irect*					bbx , 
		ivector2*				linkpos , 
		wstring*				str , 
		int*					linkbar , 
		IParserLink::Property*	rprop
		);
//=================================================================================================
void CParseEditCtrlView::DrawLinkInfo
		(
		const irect&					bbx , 
		const wstring&					info , 
		IParserLink::Property::Type		type , 
		IParserLink::Property::Align	align , 
		uint8							alpha , 
		ObjectArea*						area
		);
//=================================================================================================
void CParseEditCtrlView::InverseP
		(
		int			p[12]
		);
//=================================================================================================
void CParseEditCtrlView::DrawLink
		(
		iParserLink&		link , 
		const ivector2		move , 
		uint8				alpha , 
		bool				drawed , 
		const ivector2*		spp = 0 , 
		const ivector2*		tpp = 0
		);
//=================================================================================================
void CParseEditCtrlView::DrawNodeLink
		(
		iParserNode&	node , 
		bool			drawed
		);
//=================================================================================================
void CParseEditCtrlView::GetNodePos
		(
		iParserNode&			node , 
		ivector2*				ppos , 
		isize*					psize , 
		IParserNode::Property*	pprop 
		);
//=================================================================================================
void CParseEditCtrlView::DrawNode
		(
		iParserNode&	node , 
		const ivector2&	move , 
		uint8			alpha , 
		bool			drawed
		);
//=================================================================================================
void CParseEditCtrlView::DrawNodeFrame
		(
		iParserNode&	node , 
		const ivector2&	move , 
		uint8			alpha
		);
//=================================================================================================
void CParseEditCtrlView::DrawSelectPin
		(
		const ivector2&		in , 
		const ivector2&		out , 
		unsigned int		item_id , 
		bool				drawed
		);
//=================================================================================================
void CParseEditCtrlView::DrawSelectLinkbar
		(
		const ivector2&		pos , 
		unsigned int		itemid , 
		bool				drawed
		);
//=================================================================================================
void CParseEditCtrlView::DrawLinkFrame
		(
		iParserLink&	link , 
		const ivector2&	move , 
		uint8			alpha , 
		bool			drawed
		);
//=================================================================================================
void CParseEditCtrlView::DrawItemFrame
		(
		unsigned int	item_id , 
		const ivector2&	move , 
		uint8			alpha
		);
//=================================================================================================
void CParseEditCtrlView::DrawAllNode();
//=================================================================================================
void CParseEditCtrlView::DrawSelectFrame();
//=================================================================================================
ivector2 CParseEditCtrlView::MoveNodeToGrid
		(
		iParserNode&		node , 
		const ivector2&		move
		);
//=================================================================================================
ivector2 CParseEditCtrlView::MoveLinkToGrid
		(
		iParserLink&		link , 
		const ivector2&		move
		);
//=================================================================================================
int CParseEditCtrlView::LinkbarToGrid
		(
		iParserLink&		link , 
		int					w
		);
//=================================================================================================
void CParseEditCtrlView::DrawMoveItem
		(
		unsigned int	edit_id , 
		ivector2		move , 
		bool			grid
		);
//=================================================================================================
void CParseEditCtrlView::PaintRect
		(
		const irect&		r , 
		iPaint_gp&			paint
		);
//=================================================================================================
void CParseEditCtrlView::StrokeRect
		(
		const irect&		r , 
		iPaint_gp&			paint , 
		int					size
		);
//=================================================================================================
void CParseEditCtrlView::DrawRect
		(
		const irect&		r , 
		iPaint_gp&			paint , 
		iPaint_gp&			stroke
		);
//=================================================================================================
void CParseEditCtrlView::DrawFrame
		(
		const irect&		r , 
		iPaint_gp&			paint , 
		iPaint_gp&			stroke
		);
//=================================================================================================
void CParseEditCtrlView::DrawSurface();
//=================================================================================================
void CParseEditCtrlView::SurfaceBlt
		(
		HDC		hdc
		) ;
//=================================================================================================
void CParseEditCtrlView::SurfaceBlt();

// protected functions
protected:
//=================================================================================================
int CParseEditCtrlView::ToGrid
		(
		int		v
		);
//=================================================================================================
ivector2 CParseEditCtrlView::ToGrid
		(
		const ivector2&		v
		);
//=================================================================================================
ivector2 CParseEditCtrlView::WorldToClient
		(
		const ivector2&	pos
		);
//=================================================================================================
ivector2 CParseEditCtrlView::ClientToWorld
		(
		const ivector2&	pos
		);
//=================================================================================================
irect CParseEditCtrlView::WorldToClient
		(
		const irect&	r
		);
//=================================================================================================
irect CParseEditCtrlView::ClientToWorld
		(
		const irect&	r
		);
//=================================================================================================
bool CParseEditCtrlView::CanDelete();
//=================================================================================================
void CParseEditCtrlView::Delete();
//=================================================================================================
bool CParseEditCtrlView::CanCopy();
//=================================================================================================
bool CParseEditCtrlView::Copy();
//=================================================================================================
bool CParseEditCtrlView::CanPaste();
//=================================================================================================
bool CParseEditCtrlView::Paste();
//=================================================================================================
bool CParseEditCtrlView::CanSelectAll();
//=================================================================================================
void CParseEditCtrlView::SelectAll();
//=================================================================================================
void CParseEditCtrlView::MoveSelectItem
		(
		KeyDir				key , 
		int					len
		);
		
// public functions
public:
//=================================================================================================
CParseEditCtrlView();
//=================================================================================================
virtual ~CParseEditCtrlView();
//=================================================================================================
unsigned int CParseEditCtrlView::GetTargetItemId();
//=================================================================================================
void CParseEditCtrlView::Initialize
		(
		unsigned int	item_id
		);
//=================================================================================================
object CParseEditCtrlView::GetPropertyItem();
//=================================================================================================
unsigned int CParseEditCtrlView::GetParserId();
//=================================================================================================
unsigned int CParseEditCtrlView::GetPropertyId();

// MFC oevrride functions	
protected:
//=================================================================================================
virtual BOOL PreCreateWindow(CREATESTRUCT& cs);

// MFC event handler
protected:
	DECLARE_MESSAGE_MAP()
	afx_msg void OnPaint();
public:
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnMouseHWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnCancelMode();
	afx_msg void OnTimer(UINT_PTR nIDEvent);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg	void OnKillFocusDescEdit();
	afx_msg void OnChangeDescEdit();
	afx_msg void OnRequestResizeDescEdit(NMHDR *pNMHDR, LRESULT *pResult);
};

