// OutputXmlWnd.cpp : t@C
//

#include "stdafx.h"
#include "Texml.h"
#include "OutputXmlWnd.h"


/**************************************************************************************************
"COutputXmlWnd" class define
**************************************************************************************************/
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC event map
IMPLEMENT_DYNAMIC(COutputXmlWnd, CDockablePane)

BEGIN_MESSAGE_MAP(COutputXmlWnd, CDockablePane)
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_WM_PAINT()
	ON_WM_SETFOCUS()
	ON_COMMAND(ID_OUTPUTXML_EXPANDALL, OnExpandAll)
	ON_UPDATE_COMMAND_UI(ID_OUTPUTXML_EXPANDALL , OnExpandAllUpdate )
	ON_COMMAND(ID_OUTPUTXML_COLLAPSEALL, OnCollapseAll)
	ON_UPDATE_COMMAND_UI(ID_OUTPUTXML_COLLAPSEALL , OnCollapseAllUpdate )
END_MESSAGE_MAP()

///////////////////////////////////////////////////////////////////////////////////////////////////
// private functions
//=================================================================================================
void cb_call COutputXmlWnd::Callback
		(
		ICallback::Type	type , 
		object&			obj , 
		void*			param
		)
{
	if( type == ICallback::OutputXml )
	{
		Show();
	}
}
//=================================================================================================
void COutputXmlWnd::Show()
{
	CDockablePane*	panel	= this;//DYNAMIC_DOWNCAST(CDockablePane, GetOwner());
	CMDIFrameWndEx* frame	= DYNAMIC_DOWNCAST(CMDIFrameWndEx, GetTopLevelFrame());

	if (frame != NULL && panel != NULL)
	{
		frame->ShowPane(panel, TRUE, FALSE, TRUE);
		frame->RecalcLayout();
//		m_outputwnd.SetFocus();
	}
}
//=================================================================================================
void COutputXmlWnd::AdjustLayout()
{
	if (GetSafeHwnd() == NULL)
		return;

	CRect rectClient;
	GetClientRect(rectClient);

	int cyTlb = m_toolbar.CalcFixedLayout(FALSE, TRUE).cy;

	m_toolbar.SetWindowPos(NULL, rectClient.left, rectClient.top, rectClient.Width(), cyTlb, SWP_NOACTIVATE | SWP_NOZORDER);
	m_xmlwnd.SetWindowPos(NULL, rectClient.left + 1, rectClient.top + cyTlb + 1, rectClient.Width() - 2, rectClient.Height() - cyTlb - 2, SWP_NOACTIVATE | SWP_NOZORDER);
}
//=================================================================================================
void COutputXmlWnd::OnChangeVisualStyle()
{
	m_toolbar.CleanUpLockedImages();
	m_toolbar.LoadBitmap( theApp.m_bHiColorIcons ? IDB_OUTPUTXML_TOOLBAR_24 : IDR_OUTPUTXML_TOOLBAR , 0, 0, TRUE );
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// public functions
//=================================================================================================
COutputXmlWnd::COutputXmlWnd()
{
	m_document = GetDocument();
	m_listener->SetCallback( this );
	m_document->AddCallback( (rCallback)m_listener );
}
//=================================================================================================
COutputXmlWnd::~COutputXmlWnd()
{
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC event handler
//=================================================================================================
int COutputXmlWnd::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CDockablePane::OnCreate(lpCreateStruct) == -1)
		return -1;

	// create treeview
	CRect rect;
	rect.SetRectEmpty();
	if ( !m_xmlwnd.Create
			( 
			WS_CHILD | WS_VISIBLE | TVS_HASLINES | TVS_LINESATROOT | TVS_HASBUTTONS | WS_CLIPSIBLINGS | WS_CLIPCHILDREN , 
			rect , 
			this , 
			2 
			) )
	{
		TRACE0("Class view create error.\n");
		return -1;
	}

	// create toolbar
	m_toolbar.Create( this , AFX_DEFAULT_TOOLBAR_STYLE , IDR_OUTPUTXML_TOOLBAR );
	m_toolbar.LoadToolBar( IDR_OUTPUTXML_TOOLBAR, 0, 0, TRUE );
	OnChangeVisualStyle();
	m_toolbar.SetPaneStyle( m_toolbar.GetPaneStyle() | CBRS_TOOLTIPS | CBRS_FLYBY );
	m_toolbar.SetPaneStyle( m_toolbar.GetPaneStyle() & ~(CBRS_GRIPPER | CBRS_SIZE_DYNAMIC | CBRS_BORDER_TOP | CBRS_BORDER_BOTTOM | CBRS_BORDER_LEFT | CBRS_BORDER_RIGHT ) );
	m_toolbar.SetOwner( this );

	// ׂẴR}hAet[oRł͂Ȃ̃Rg[oRœn܂:
	m_toolbar.SetRouteCommandsViaFrame( FALSE );

	return 0;
}
//=================================================================================================
void COutputXmlWnd::OnSize(UINT nType, int cx, int cy)
{
	CDockablePane::OnSize(nType, cx, cy);
	AdjustLayout();
}
//=================================================================================================
void COutputXmlWnd::OnPaint()
{
	CPaintDC dc(this);
	CRect rectTree;
	m_xmlwnd.GetWindowRect(rectTree);
	ScreenToClient(rectTree);

	rectTree.InflateRect(1, 1);
	dc.Draw3dRect(rectTree, ::GetSysColor(COLOR_3DSHADOW), ::GetSysColor(COLOR_3DSHADOW));
}
//=================================================================================================
void COutputXmlWnd::OnSetFocus(CWnd* pOldWnd)
{
	CDockablePane::OnSetFocus(pOldWnd);
	m_xmlwnd.SetFocus();
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC command handler
//=================================================================================================
void COutputXmlWnd::OnExpandAll()
{
	m_xmlwnd.ExpandAll( true );
}
//=================================================================================================
void COutputXmlWnd::OnExpandAllUpdate(CCmdUI* pCmdUI)
{
	pCmdUI->Enable( TRUE );
}
//=================================================================================================
void COutputXmlWnd::OnCollapseAll()
{
	m_xmlwnd.ExpandAll( false );
}
//=================================================================================================
void COutputXmlWnd::OnCollapseAllUpdate(CCmdUI* pCmdUI)
{
	pCmdUI->Enable( TRUE );
}
