#pragma once

#include	"Document/Document.h"

using namespace document;
using namespace icubic;

/**************************************************************************************************
"COutputList" class 
**************************************************************************************************/
class COutputList : public CListBox , public ICallback
{
	class ListData
	{
	public:
		int		m_row , m_column;
		ListData() : m_row(-1) , m_column(-1){}
	};
// member variable
private:
	iDocument					m_document;
	instance<CallbackListener>	m_listener;
	
	CFont						m_font;
	Array<ListData>				m_listdata;

// private functions
private:
//=================================================================================================
void cb_call COutputList::Callback
		(
		ICallback::Type	type , 
		object&	obj , 
		void*	param
		);
		
// public functions
public:
//=================================================================================================
COutputList();
//=================================================================================================
virtual ~COutputList();

// MFC event handler
protected:
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnClear();
//	afx_msg void OnViewOutput();

	DECLARE_MESSAGE_MAP()
public:
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
};

/**************************************************************************************************
"COutputWnd" class 
**************************************************************************************************/
class COutputWnd : public CDockablePane , public ICallback
{
// member variable
private:
	iDocument					m_document;
	instance<CallbackListener>	m_listener;

	CMFCTabCtrl					m_tab;
	COutputList					m_outputwnd;

// private functions
private:
//=================================================================================================
void cb_call COutputWnd::Callback
		(
		ICallback::Type	type , 
		object&	obj , 
		void*	param
		);
//=================================================================================================
void COutputWnd::Show();

// public functions
public:
//=================================================================================================
COutputWnd();
//=================================================================================================
virtual ~COutputWnd();

// MFC event handler
protected:
	DECLARE_MESSAGE_MAP()
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
public:
	afx_msg void OnSetFocus(CWnd* pOldWnd);
};

