
#include "stdafx.h"

#include "OutputWnd.h"
#include "Resource.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/**************************************************************************************************
"COutputWnd" class define
**************************************************************************************************/
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC event map
BEGIN_MESSAGE_MAP(COutputList, CListBox)
	ON_WM_CONTEXTMENU()
	ON_COMMAND(ID_OUTPUT_VIEW_CLEAR, OnClear)
//	ON_COMMAND(ID_VIEW_OUTPUTWND, OnViewOutput)
	ON_WM_WINDOWPOSCHANGING()
	ON_WM_CREATE()
	ON_WM_LBUTTONDBLCLK()
END_MESSAGE_MAP()

///////////////////////////////////////////////////////////////////////////////////////////////////
// private functions
//=================================================================================================
void cb_call COutputList::Callback
		(
		ICallback::Type	type , 
		object&			obj , 
		void*			param
		)
{
	if( type == ICallback::OutputMsg )
	{
		ICallback::OutputMsgParam*	p = (ICallback::OutputMsgParam*)param;
		if( p->m_cmd == ICallback::OutputMsgParam::Set )
		{
			ResetContent();
			m_listdata.Resize( 0 );
		}
		int	off , num = p->m_list.GetDatanum();
		for( off = 0 ; off < num ; off++ )
		{
			int	index = AddString( p->m_list[off].m_msg );
			if( p->m_list[off].m_row >=0 && p->m_list[off].m_column >= 0 )
			{
				int		off = m_listdata.Add();
				m_listdata[off].m_row		= p->m_list[off].m_row;
				m_listdata[off].m_column	= p->m_list[off].m_column;
				SetItemData( index , off );
			}
			else
			{
				SetItemData( index , -1 );
			}
		}
	}
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// public functions
//=================================================================================================
COutputList::COutputList()
{
	m_document = GetDocument();
	m_listener->SetCallback( this );
	m_document->AddCallback( (rCallback)m_listener );
}
//=================================================================================================
COutputList::~COutputList()
{
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC event handler
//=================================================================================================
int COutputList::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CListBox::OnCreate(lpCreateStruct) == -1)
		return -1;

	m_font.CreateStockObject(DEFAULT_GUI_FONT);
	SetFont(&m_font);
	return 0;
}
//=================================================================================================
void COutputList::OnContextMenu(CWnd* /*pWnd*/, CPoint point)
{
	CMenu menu;
	menu.LoadMenu( IDR_OUTPUT_VIEW_CONTEXT );

	CMenu* pSumMenu = menu.GetSubMenu(0);

	if (AfxGetMainWnd()->IsKindOf(RUNTIME_CLASS(CMDIFrameWndEx)))
	{
		CMFCPopupMenu* pPopupMenu = new CMFCPopupMenu;

		if (!pPopupMenu->Create(this, point.x, point.y, (HMENU)pSumMenu->m_hMenu, FALSE, TRUE))
			return;

		((CMDIFrameWndEx*)AfxGetMainWnd())->OnShowPopupMenu(pPopupMenu);
		UpdateDialogControls(this, FALSE);
	}
	SetFocus();
}
//=================================================================================================
void COutputList::OnClear()
{
	ResetContent();
}
/**************************************************************************************************
"COutputWnd" class define
**************************************************************************************************/
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC event map

BEGIN_MESSAGE_MAP(COutputWnd, CDockablePane)
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_WM_SETFOCUS()
END_MESSAGE_MAP()

///////////////////////////////////////////////////////////////////////////////////////////////////
// private functions
//=================================================================================================
void cb_call COutputWnd::Callback
		(
		ICallback::Type	type , 
		object&			obj , 
		void*			param
		)
{
	if( type == ICallback::OutputMsg )
	{
		ICallback::OutputMsgParam*	p = (ICallback::OutputMsgParam*)param;
		if( p->m_show == ICallback::OutputMsgParam::Show )
		{
			Show();
		}
	}
}
//=================================================================================================
void COutputWnd::Show()
{
	CDockablePane*	panel	= this;//DYNAMIC_DOWNCAST(CDockablePane, GetOwner());
	CMDIFrameWndEx* frame	= DYNAMIC_DOWNCAST(CMDIFrameWndEx, GetTopLevelFrame());

	if (frame != NULL && panel != NULL)
	{
		frame->ShowPane(panel, TRUE, FALSE, TRUE);
		frame->RecalcLayout();
//		m_outputwnd.SetFocus();
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// public functions
//=================================================================================================
COutputWnd::COutputWnd()
{
	m_document = GetDocument();
	m_listener->SetCallback( this );
	m_document->AddCallback( (rCallback)m_listener );
}
//=================================================================================================
COutputWnd::~COutputWnd()
{
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC event handler
//=================================================================================================
int COutputWnd::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CDockablePane::OnCreate(lpCreateStruct) == -1)
		return -1;

	CRect		r;
	r.SetRectEmpty();

	// create tab
	if (!m_tab.Create( CMFCTabCtrl::STYLE_FLAT , r , this, 1 ) )
	{
		TRACE0("fail to create tab.\n");
		return -1;
	}

	// create output
	if ( !m_outputwnd.Create
			(
			LBS_NOINTEGRALHEIGHT | WS_CHILD | WS_VISIBLE | WS_HSCROLL | WS_VSCROLL , 
			r, 
			&m_tab, 
			2
			) )
	{
		TRACE0("fail to create output\n");
		return -1;
	}
	m_tab.AddTab( &m_outputwnd, LoadText( IDS_OUTPUT_TITLE ) , (UINT)0 );

	return 0;
}
//=================================================================================================
void COutputWnd::OnSize(UINT nType, int cx, int cy)
{
	CDockablePane::OnSize(nType, cx, cy);
	m_tab.SetWindowPos (NULL, -1, -1, cx, cy, SWP_NOMOVE | SWP_NOACTIVATE | SWP_NOZORDER);
}
//=================================================================================================
void COutputWnd::OnSetFocus(CWnd* pOldWnd)
{
	__super::OnSetFocus(pOldWnd);

	m_outputwnd.SetFocus();
}
//=================================================================================================
void COutputList::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	int	index = GetCurSel( );
	if( index != LB_ERR )
	{
		int		dataoff = GetItemData( index );
		if( 0 <= dataoff && dataoff < m_listdata.GetDatanum() )
		{
			( (CMainFrame*)AfxGetMainWnd() )->OpenTestCodeEditor( m_listdata[dataoff].m_row , m_listdata[dataoff].m_column );
		}
	}
	__super::OnLButtonDblClk(nFlags, point);
}
