#pragma once

#include	"Document/Document.h"

using namespace icubic;
using namespace document;

/**************************************************************************************************
"CNodePropertyWnd" class define
**************************************************************************************************/
class CNodePropertyWnd : public CMFCPropertyGridCtrl , public ICallback
{
	DECLARE_DYNAMIC(CNodePropertyWnd)

	enum PropId
	{
		Group1 , 
		Group2 ,
		XPos , 
		YPos , 
		CmdType , 
		PushTag_name , 
		SetAttr_name , 
		SetAttr_value , 
		SetAttrText_name , 
		
		PropNum
	};
// member variable
private:
	iDocument					m_document;
	instance<CallbackListener>	m_listener;
	
	unsigned int				m_parser_id;
	unsigned int				m_item_id;

	CMFCPropertyGridProperty*	m_props[PropNum];
	Array<CString>				m_nodetype_list;
	CFont						m_fntPropList;

// private functions
private:
//=================================================================================================
void cb_call Callback
		(
		ICallback::Type	type , 
		object&			obj , 
		void*			param
		);
//=================================================================================================
iParserDoc CNodePropertyWnd::GetParser();
//=================================================================================================
iParserNode CNodePropertyWnd::GetNode();
//=================================================================================================
void CNodePropertyWnd::InitCmdArg_ClearText
		(
		CMFCPropertyGridProperty*				group
		);
//=================================================================================================
void CNodePropertyWnd::InitCmdArg_PushTag
		(
		CMFCPropertyGridProperty*			group
		);
//=================================================================================================
void CNodePropertyWnd::UpdateCmdArg
		(
		IParserNode::Property::PushTagProp&	prop	
		);
//=================================================================================================
void CNodePropertyWnd::InitCmdArg_PopTag
		(
		CMFCPropertyGridProperty*			group
		);
//=================================================================================================
void CNodePropertyWnd::InitCmdArg_SetAttr
		(
		CMFCPropertyGridProperty*			group
		);
//=================================================================================================
void CNodePropertyWnd::UpdateCmdArg
		(
		IParserNode::Property::SetAttrProp&	prop	
		);
//=================================================================================================
void CNodePropertyWnd::InitCmdArg_SetAttrText
		(
		CMFCPropertyGridProperty*				group
		);
//=================================================================================================
void CNodePropertyWnd::UpdateCmdArg
		(
		IParserNode::Property::SetAttrTextProp&	prop	
		);
//=================================================================================================
void CNodePropertyWnd::InitCmdArg_SetText
		(
		CMFCPropertyGridProperty*				group
		);
//=================================================================================================
void CNodePropertyWnd::InitProperty();
//=================================================================================================
void CNodePropertyWnd::UpdateProperty();
//=================================================================================================
void CNodePropertyWnd::UpdatePropertyShow();
//=================================================================================================
void CNodePropertyWnd::SetPropListFont();
//=================================================================================================
void CNodePropertyWnd::PropertyChanged
		(
		CMFCPropertyGridProperty* pProp 
		);

// public functions
public:
	CNodePropertyWnd();
	virtual ~CNodePropertyWnd();

// MFC override functions
protected:
//=================================================================================================
void CNodePropertyWnd::OnPropertyChanged
		(
		CMFCPropertyGridProperty* pProp 
		)const;

// MFC event handler
protected:
	DECLARE_MESSAGE_MAP()
public:
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSettingChange(UINT uFlags, LPCTSTR lpszSection);
	afx_msg void OnDestroy();
};


