// ExternalEditorPage.cpp : t@C
//

#include "stdafx.h"
#include "Texml.h"
#include "ExternalEditorPage.h"


/**************************************************************************************************
"CExternalEditorPage" class define
**************************************************************************************************/
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC message map
IMPLEMENT_DYNAMIC(CExternalEditorPage, CPropertyPage)
BEGIN_MESSAGE_MAP(CExternalEditorPage, CPropertyPage)
	ON_BN_CLICKED(IDC_BUTTON_EDITORPATH, &CExternalEditorPage::OnBnClickedButtonEditorpath)
END_MESSAGE_MAP()

///////////////////////////////////////////////////////////////////////////////////////////////////
// private functions

///////////////////////////////////////////////////////////////////////////////////////////////////
// public functions
//=================================================================================================
CExternalEditorPage::CExternalEditorPage() : 
	CPropertyPage(CExternalEditorPage::IDD) , 
	m_editor_encode( ShiftJis )
{

}
//=================================================================================================
CExternalEditorPage::~CExternalEditorPage()
{
}
//=================================================================================================
void CExternalEditorPage::Initialize
		(
		const SettingData&	data
		)
{
	m_editor_path		= data.m_editor_path.c_str();
	m_editor_args		= data.m_editor_args.c_str();
	m_editor_args_row	= data.m_editor_args_row.c_str();
	m_editor_encode		= data.m_editor_encode;
}
//=================================================================================================
void CExternalEditorPage::GetData
		(
		SettingData&	data
		)
{
	data.m_editor_path		= m_editor_path;
	data.m_editor_args		= m_editor_args;
	data.m_editor_args_row	= m_editor_args_row;
	data.m_editor_encode	= (EncodeType)m_editor_encode;
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC override functions
//=================================================================================================
BOOL CExternalEditorPage::OnInitDialog()
{
	CComboBox*	ctrl = (CComboBox*)GetDlgItem(IDC_COMBO_EDITORENCODE);
	ctrl->AddString( L"ShiftJIS" );
	ctrl->AddString( L"UTF-8" );

	CPropertyPage::OnInitDialog();
	return TRUE;
}
//=================================================================================================
void CExternalEditorPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);

	DDX_Text( pDX , IDC_EDIT_EDITORPATH , m_editor_path );
	DDX_Text( pDX , IDC_EDIT_EDITORARGS , m_editor_args );
	DDX_Text( pDX , IDC_EDIT_EDITORARGSROW , m_editor_args_row );
	DDX_CBIndex( pDX , IDC_COMBO_EDITORENCODE , m_editor_encode );
}
//=================================================================================================
void CExternalEditorPage::OnOK()
{
	UpdateData();
	CPropertyPage::OnOK();
}
//=================================================================================================
void CExternalEditorPage::OnBnClickedButtonEditorpath()
{
	CFileDialog		dlg
			(
			TRUE ,
			NULL ,
			NULL ,
			OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT | OFN_NOCHANGEDIR | OFN_EXPLORER | OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST ,
			L"Executable File (*.exe)|*.exe|All Files (*.*)|*.*||"
			);
	if( IDOK != dlg.DoModal() )
		return;

	CEdit*	ctrl = (CEdit*)GetDlgItem(IDC_EDIT_EDITORPATH);
	ctrl->SetWindowText(dlg.GetPathName());
}

