/*************************************************************************************************/
/*!
   	@file		XmlParserProcessGen.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"Document.h"
#include	"../resource.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"XmlParserProcessGen" class 
**************************************************************************************************/
class XmlParserProcessGen
{
// variable member
private:
	Array<iParserDoc>		m_parsers;
	
// private functions
private:
//=================================================================================================
int SearchParserNameInList
		(
		const wstring&	name
		)
{
	int		parseroff , parsernum = m_parsers.GetDatanum();
	for( parseroff = 0 ; parseroff < parsernum ; parseroff++ )
	{
		if( m_parsers[parseroff]->GetName() == name )
			return parseroff;
	}
	return -1;
}
//=================================================================================================
int SearchParserInList
		(
		iParserDoc&		parser
		)
{
	int		parseroff , parsernum = m_parsers.GetDatanum();
	for( parseroff = 0 ; parseroff < parsernum ; parseroff++ )
	{
		if( m_parsers[parseroff] == parser )
			return parseroff;
	}
	return -1;
}
//=================================================================================================
void SearchParserNameInTree
		(
		const wstring&			name , 
		treedata::iTreeNode&	item , 
		Array<iParserDoc>&		parselist
		)
{
	iParserDoc	parse = (iParserDoc)item;
	if( parse == true && parse->GetName() == name )
		parselist[ parselist.Add() ]	= parse;
	
	int	coff , cnum = item->GetChildnum();
	for( coff = 0 ; coff < cnum ; coff++ )
		SearchParserNameInTree( name , item->GetChild( coff ) , parselist );
}
//=================================================================================================
bool CreateParserList
		(
		treedata::iTreeNode&	root , 
		iGraph&					parse , 
		Array<wstring>*			errlist
		)
{
	int		nodeoff , nodenum = parse->GetNodeNum();
	for( nodeoff = 0 ; nodeoff < nodenum ; nodeoff++ )
	{
		iGraphNode	node = parse->GetNode( nodeoff );
		
		int		linkoff , linknum = node->GetOutputNum();
		for( linkoff = 0 ; linkoff < linknum ; linkoff++ )
		{
			iParserLink	link = node->GetOutput( linkoff );
			IParserLink::Property	prop = link->GetProperty();
			if( prop.m_type == IParserLink::Property::Function )
			{
				if( prop.m_function_prop.m_parser_name == L"" )
				{
					if( errlist != 0 )
						(*errlist)[ errlist->Add() ]	= Replace( IDS_GENERROR_5 , &(iParserDoc)parse , &(((iParserNode)node)->GetProperty()) , &prop );
					return false;
				}
				Array<iParserDoc>	parserlist;
				SearchParserNameInTree( prop.m_function_prop.m_parser_name , root , parserlist );
				if( parserlist.GetDatanum() == 0 )
				{
					if( errlist != 0 )
						(*errlist)[ errlist->Add() ]	= Replace( IDS_GENERROR_3 , &(iParserDoc)parse , &(((iParserNode)node)->GetProperty()) , &prop );
					return false;
				}
				else if( parserlist.GetDatanum() >= 2 )
				{
					if( errlist != 0 )
						(*errlist)[ errlist->Add() ]	= Replace( IDS_GENERROR_2 , &parserlist[0] , 0 , 0 );
					return false;
				}
				if( -1 == SearchParserInList( parserlist[0] ) )
					m_parsers[ m_parsers.Add() ] = parserlist[ 0 ];
			}
			else if( prop.m_type == IParserLink::Property::RegularExp )
			{
				try
				{
					boost::wregex	reg( prop.m_regular_prop.m_exp );
				}
				catch(...)
				{
					if( errlist != 0 )
						(*errlist)[ errlist->Add() ]	= Replace( IDS_GENERROR_6 , &(iParserDoc)parse , &(((iParserNode)node)->GetProperty()) , &prop );
					return false;
				}
			}
		}
	}
	return true;
}
//=================================================================================================
bool CreateParserList
		(
		iDocument&			doc , 
		Array<wstring>*		errlist
		)
{
	m_parsers.Resize( 0 );
	iParserDoc	start = doc->GetStartParser();
	if( start == false )
	{
		if( errlist != 0 )
			(*errlist)[ errlist->Add() ]	= LoadText( IDS_GENERROR_0 );
		return false;
	}
	m_parsers[m_parsers.Add()] = start;
	
	int		off;
	for( off = 0 ; off < m_parsers.GetDatanum() ; off++ )
	{
		if( false == CreateParserList( doc->GetRoot() , (iGraph)m_parsers[off] , errlist ) )
			return false;
	}
	return true;
}
//=================================================================================================
wstring LinkToName
		(
		const IParserLink::Property&		prop
		)
{
	if( prop.m_type == IParserLink::Property::RegularExp )
	{
		return prop.m_regular_prop.m_exp;//wstring( (const wchar_t*)LoadText( IDS_LINKPROP_REGULAR ) ) + L":" + prop.m_regular_prop.m_exp;
	}
	else if( prop.m_type == IParserLink::Property::Function )
	{
		return prop.m_function_prop.m_parser_name;//wstring( (const wchar_t*)LoadText( IDS_LINKPROP_FUNCTION ) ) + L":" + prop.m_function_prop.m_parser_name;
	}
	else if( prop.m_type == IParserLink::Property::None )
	{
		return wstring( (const wchar_t*)LoadText( IDS_LINKPROP_NONE ) );
	}
	else
		return L"unknown";
}
//=================================================================================================
wstring Replace
		(
		int								resid , 
		iParserDoc*						parser , 
		const IParserNode::Property*	nodeprop , 
		const IParserLink::Property*	linkprop
		)
{
	wstring		result = ( const wchar_t* )LoadText( resid );
	if( parser != 0 )
		result	= ReplaceAllPattern( result , L"[%parsename]" , (*parser)->GetName() );
	if( nodeprop != 0 )
		result	= ReplaceAllPattern( result , L"[%nodename]" , NodeTypeToName( nodeprop->m_type ) );
	if( linkprop != 0 )
		result	= ReplaceAllPattern( result , L"[%linkname]" , LinkToName( *linkprop ) );
	return result;
}
//=================================================================================================
void CheckParserList
		(
		Array<wstring>&		errlist
		)
{
	int		off , num = m_parsers.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		wstring	name = m_parsers[off]->GetName();
		if( name == L"" )
			errlist[ errlist.Add() ]	= LoadText( IDS_GENERROR_1 );
		else
		{
			int		soff;
			for( soff = off + 1 ; soff < num ; soff++ )
			{
				if( m_parsers[soff]->GetName() == name )
				{
					errlist[ errlist.Add() ]	= Replace( IDS_GENERROR_2 , &m_parsers[off] , 0 , 0 );
					break;
				}
			}
		}
	}
}
//=================================================================================================
/*
void CheckParserLink
		(
		Array<wstring>&		errlist
		)
{
	int		parseoff , parsenum = m_parsers.GetDatanum();
	for( parseoff = 0 ; parseoff < parsenum ; parseoff++ )
	{
		iGraph	parse = (iGraph)m_parsers[parseoff];
		int		nodeoff , nodenum = parse->GetNodeNum();
		for( nodeoff = 0 ; nodeoff < nodenum ; nodeoff++ )
		{
			iGraphNode	node = parse->GetNode( nodeoff );
			int			linkoff , linknum = node->GetOutputNum();
			for( linkoff = 0 ; linkoff < linknum ; linkoff++ )
			{
				iParserLink	link = (iParserLink)node->GetOutput( linkoff );
				IParserLink::Property	prop = link->GetProperty();
				if( prop.m_type == IParserLink::Property::Function )
				{
					if( -1 == SearchParserNameInList( prop.m_function_prop.m_parser_name ) )
						errlist[ errlist.Add() ]	= Replace( IDS_GENERROR_3 , &m_parsers[parseoff] , &(((iParserNode)node)->GetProperty()) , &prop );
				}
				else if( prop.m_type == IParserLink::Property::RegularExp )
				{
				}
			}
		}
	}
}
*/
//=================================================================================================
bool CheckParserRute
		(
		iGraph&			parse , 
		iGraphNode&		node , 
		Array<bool>&	list , 
		int				end
		)
{
	int		nodeoff	= ((iParserDoc)parse)->SearchNode( (iParserNode)node );
	if( list[nodeoff] == true )
		return false;
	if( end == nodeoff )
		return true;

	list[nodeoff]	= true;
	int		linkoff , linknum = node->GetOutputNum();
	for( linkoff = 0 ; linkoff < linknum ; linkoff++ )
	{
		if( true == CheckParserRute( parse , node->GetOutput( linkoff )->GetOutput() , list , end ) )
			return true;
	}
	return false;
}
//=================================================================================================
bool CheckParserRute
		(
		iGraph&		parse
		)
{
	Array<bool>		nodelist( parse->GetNodeNum());
	int		nodeoff , nodenum = nodelist.GetDatanum();
	for( nodeoff = 0 ; nodeoff < nodenum ; nodeoff++ )
		nodelist[nodeoff]	= false;
	
	int		startnode	= ((iParserDoc)parse)->SearchNodeType( IParserNode::Property::Start );
	int		endnode		= ((iParserDoc)parse)->SearchNodeType( IParserNode::Property::End );
	if( startnode == -1 || endnode == -1 )
		return false;
	return CheckParserRute( parse , parse->GetNode( startnode ) , nodelist , endnode );
}
//=================================================================================================
void CheckParserRute
		(
		Array<wstring>&		errlist
		)
{
	int		parseoff , parsenum = m_parsers.GetDatanum();
	for( parseoff = 0 ; parseoff < parsenum ; parseoff++ )
	{
		if( false == CheckParserRute( (iGraph)m_parsers[parseoff] ) )
			errlist[ errlist.Add() ] = Replace( IDS_GENERROR_4 , &m_parsers[parseoff] , 0 , 0 );
	}
}
//=================================================================================================
bool CreateParserListWithCheck
		(
		iDocument&			doc , 
		Array<wstring>&		errlist
		)
{
	errlist.Resize( 0 );

	if( false == CreateParserList( doc , &errlist ) )
		return false;

	// check same name
	CheckParserList( errlist );

	// check function link
//	CheckParserLink( errlist );

	// check rute
	CheckParserRute( errlist );

	if( errlist.GetDatanum() != 0 )
		return false;
	return true;
}
//=================================================================================================
iParserCmd CreateParserCmd
		(
		IParserNode::Property&	prop
		)
{
	if( prop.m_type == IParserNode::Property::Start )
		return iParserCmd();
	else if( prop.m_type == IParserNode::Property::End )
		return iParserCmd();
	else if( prop.m_type == IParserNode::Property::None )
		return iParserCmd();
	else if( prop.m_type == IParserNode::Property::ClearText )
		return (iParserCmd)instance<ClearTextParserCmd>();
	else if( prop.m_type == IParserNode::Property::PushTag )
	{
		instance<PushTagParserCmd>	cmd;
		cmd->m_tag	= prop.m_pushtag_prop.m_tag;
		return (iParserCmd)cmd;
	}
	else if( prop.m_type == IParserNode::Property::PopTag )
		return (iParserCmd)instance<PopTagParserCmd>();
	else if( prop.m_type == IParserNode::Property::SetAttr )
	{
		instance<SetAttrParserCmd>	cmd;
		cmd->m_name		= prop.m_setattr_prop.m_name;
		cmd->m_value	= prop.m_setattr_prop.m_value;
		return (iParserCmd)cmd;
	}
	else if( prop.m_type == IParserNode::Property::SetAttrText )
	{
		instance<SetAttrTextParserCmd>	cmd;
		cmd->m_name		= prop.m_setattrtext_prop.m_name;
		return (iParserCmd)cmd;
	}
	else if( prop.m_type == IParserNode::Property::SetText )
		return (iParserCmd)instance<SetTextParserCmd>();
	else if( prop.m_type == IParserNode::Property::PushText )
		return (iParserCmd)instance<PushTextParserCmd>();
	else if( prop.m_type == IParserNode::Property::PopText )
		return (iParserCmd)instance<PopTextParserCmd>();
	else if( prop.m_type == IParserNode::Property::Desc )
	{
		instance<DescParserCmd>	cmd;
		cmd->m_desc		= prop.m_desc_prop.m_desc;
		return (iParserCmd)cmd;
	}
	else
		return iParserCmd();
}
//=================================================================================================
bool CreateParserCond
		(
		iParserDoc&				parser , 
		iGraphLink&				link , 
		iParserCond*			cond , 
		int*					jump_parser , 
		int*					jump_node 
		)
{
	IParserLink::Property	prop	= ((iParserLink)link )->GetProperty();

	// cond , jump_parser
	store( jump_parser , -1 );
	store( cond , iParserCond() );
	if( prop.m_type == IParserLink::Property::None )
	{
	}
	else if( prop.m_type == IParserLink::Property::RegularExp )
	{
		instance<RegularParserCond>	cmd;
		cmd->m_regular	= prop.m_regular_prop.m_exp;
		cmd->m_seqtype	= (RegularParserCond::SeqType)prop.m_regular_prop.m_seqtype;
		store( cond , (iParserCond)cmd );
	}
	else if( prop.m_type == IParserLink::Property::Function )
	{
		int	func = SearchParserNameInList( prop.m_function_prop.m_parser_name );
		if( func == -1 )
			return false;
		store( jump_parser , func );
	}
	// jump node
	iParserNode		tgt_node		= (iParserNode)link->GetOutput();
	int				tgt_node_off	= parser->SearchNode( tgt_node );
	if( tgt_node_off == -1 )
		return false;
	store( jump_node , tgt_node_off );
	return true;
}
//=================================================================================================
bool SetLink
		(
		instance<XmlParserProcess>&	pp , 
		int							parser , 
		int							node , 
		int							link
		)
{
	iParserCond		cond;
	int				jump_parser	= -1;
	int				jump_node	= -1;
	if( false == CreateParserCond
			(
			m_parsers[parser] , 
			((iGraph)m_parsers[parser])->GetNode( node )->GetOutput( link ) , 
			&cond , 
			&jump_parser , 
			&jump_node
			) )
			return false;
	return pp->SetLinkProp
			(
			parser , 
			node , 
			link , 
			jump_parser , 
			jump_node , 
			cond
			);
}
//=================================================================================================
bool SetNode
		(
		instance<XmlParserProcess>&	pp , 
		int							parser , 
		int							node
		)
{
	iGraphNode	pnode = ((iGraph)m_parsers[parser])->GetNode( node );
	int			linkoff , linknum = pnode->GetOutputNum();
	if( false == pp->SetNodeProp
			( 
			parser , 
			node , 
			linknum , 
			CreateParserCmd( ( (iParserNode)pnode )->GetProperty() ) 
			) )
			return false;
	for( linkoff = 0 ; linkoff < linknum ; linkoff++ )
	{
		if( false == SetLink( pp , parser , node , linkoff ) )
			return false;
	}
	return true;
}
//=================================================================================================
bool SetParsr
		(
		instance<XmlParserProcess>&	pp , 
		int							parser
		)
{
	int		start_node	= m_parsers[parser]->SearchNodeType( IParserNode::Property::Start );
	int		end_node	= m_parsers[parser]->SearchNodeType( IParserNode::Property::End );
	if( start_node == -1
	||  end_node == -1 )
		return false;
	int		nodeoff , nodenum = ((iGraph)m_parsers[parser])->GetNodeNum();
	if( false == pp->SetParserProp( parser , nodenum , start_node , end_node ) )
		return false;
	for( nodeoff = 0 ; nodeoff < nodenum ; nodeoff++ )
	{
		if( false == SetNode( pp , parser , nodeoff ) )
			return false;
	}
	return true;
}
// public functions
public:
//=================================================================================================
iXmlParserProcess CreateXmlParserProcess
		(
		iDocument&			doc , 
		Array<wstring>&		errlist
		)
{
	if( false == CreateParserListWithCheck( doc , errlist ) )
		return iXmlParserProcess();

	instance<XmlParserProcess>	pp;
	int		parseroff , parsernum = m_parsers.GetDatanum();
	pp->SetParserNum( parsernum , 0 );
	for( parseroff = 0 ; parseroff < parsernum ; parseroff++ )
	{
		if( false == SetParsr( pp , parseroff ) )
			return iXmlParserProcess();
	}
	return (iXmlParserProcess)pp;
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define


};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
