/*************************************************************************************************/
/*!
   	@file		Undo.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{
using namespace std;
using namespace icubic;

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
 "IUndoCmd" interface 
***************************************************************************************************/
cb_guid_define( IUndoCmd_IID , 0xB9E47C34 , 0x270143f6 , 0xADB4933B , 0x999C49D3 );
class IUndoCmd;
typedef icubic::iface_object< IUndoCmd , IUndoCmd_IID >		iUndoCmd;
typedef icubic::iface_reference< IUndoCmd , IUndoCmd_IID >	rUndoCmd;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IUndoCmd
{
public:
//=================================================================================================
virtual
void cb_call Execute() = 0;
};
/**************************************************************************************************
 "IUndoList" interface 
***************************************************************************************************/
cb_guid_define( IUndoList_IID , 0xEEF80C74 , 0xC2754329 , 0x9811A025 , 0xB4BC2BCF );
class IUndoList;
typedef icubic::iface_object< IUndoList , IUndoList_IID >		iUndoList;
typedef icubic::iface_reference< IUndoList , IUndoList_IID >	rUndoList;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IUndoList
{
public:
//=================================================================================================
virtual
void cb_call AddRedoCmd
		(
		iUndoCmd&	cmd
		) = 0;
//=================================================================================================
virtual
void cb_call AddUndoCmd
		(
		iUndoCmd&	cmd
		) = 0;
};
/**************************************************************************************************
 "IUndo" interface 
***************************************************************************************************/
cb_guid_define( IUndo_IID , 0xEC074295 , 0x2B2047f2 , 0xA114A232 , 0xA60B1183 );
class IUndo;
typedef icubic::iface_object< IUndo , IUndo_IID >		iUndo;
typedef icubic::iface_reference< IUndo , IUndo_IID >	rUndo;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IUndo
{
public:
//=================================================================================================
virtual
bool cb_call IsUndo() = 0;
//=================================================================================================
virtual
bool cb_call IsRedo() = 0;
//=================================================================================================
virtual
bool cb_call Undo() = 0;
//=================================================================================================
virtual
bool cb_call Redo() = 0;
};
/**************************************************************************************************
"UndoCmd" class 
**************************************************************************************************/
class UndoCmd : 
	virtual public object_base , 
	public IUndoCmd
{
	query_begin();
	iface_hook( IUndoCmd , IUndoCmd_IID )
	query_end( object_base );
};
/**************************************************************************************************
"UndoList_bs" class 
**************************************************************************************************/
class UndoList_bs : 
	public IUndoList
{
// variable member
private:
	Straightdata<iUndoCmd>	m_redo;
	Straightdata<iUndoCmd>	m_undo;
	
// "IUndoList" interface functions
public:
//=================================================================================================
void cb_call AddRedoCmd
		(
		iUndoCmd&	cmd
		)
{
	m_redo[ m_redo.Add() ]	= cmd;
}
//=================================================================================================
void cb_call AddUndoCmd
		(
		iUndoCmd&	cmd
		)
{
	m_undo[ m_undo.Add() ]	= cmd;
}
// public functions
public:
//=================================================================================================
UndoList_bs()
{
}
//=================================================================================================
void Redo()
{
	int		off , num = m_redo.GetDatanum();
	for( off = 0 ; off < num ; off++ )
		m_redo[ off ]->Execute();
}
//=================================================================================================
void Undo()
{
	int		off , num = m_undo.GetDatanum();
	for( off = num - 1 ; off >= 0 ; off-- )
		m_undo[ off ]->Execute();
}
};
/**************************************************************************************************
"Undo_bs" class 
**************************************************************************************************/
class Undo_bs : 
	public IUndo
{
// variable member
private:
	class UndoNode
	{
	public:
		UndoNode*	m_prev;
		UndoNode*	m_next;
		UndoList_bs	m_undo;
		UndoNode() : m_prev( 0 ) , m_next( 0 ){}
	};
	UndoNode*	m_first;
	UndoNode*	m_current;
	
// private functions
private:
//=================================================================================================
UndoNode* PushNode()
{
	UndoNode*	p = ( m_current == 0 ) ? m_first : m_current->m_next;
	
	if( p != 0 && p->m_prev != 0 )
		p->m_prev->m_next = 0;
	while( p != 0 )
	{
		UndoNode*	n = p->m_next;
		delete p;
		p = n;
	}
	// push
	if( m_current == 0 )
	{
		m_current	= new UndoNode();
		m_first		= m_current;
	}
	else
	{
		UndoNode*	t = new UndoNode();
		m_current->m_next = t;
		t->m_prev	= m_current;
		m_current	= t;
	}
	return m_current;
}
// "IUndo" interface functions
public:
//=================================================================================================
bool cb_call IsUndo()
{
	if( m_current == 0 )
		return false;
	return true;
}
//=================================================================================================
bool cb_call IsRedo()
{
	if( m_current == 0 )
	{
		if( m_first == 0 )
			return false;
		else
			return true;
	}
	else
	{
		if( m_current->m_next == 0 )
			return false;
		else
			return true;
	}
}
//=================================================================================================
bool cb_call Undo()
{
	if( false == IsUndo() )
		return false;
	m_current->m_undo.Undo();
	m_current	= m_current->m_prev;
	return true;
}
//=================================================================================================
bool cb_call Redo()
{
	if( false == IsRedo() )
		return false;
	if( m_current == 0 )
	{
		m_first->m_undo.Redo();
		m_current = m_first;
	}
	else
	{
		m_current->m_next->m_undo.Redo();
		m_current = m_current->m_next;
	}
	return true;
}
// public functions
public:
//=================================================================================================
Undo_bs() : m_first( 0 ) , m_current( 0 )
{
}
//=================================================================================================
~Undo_bs()
{
	Reset();
}
//=================================================================================================
void Reset()
{
	UndoNode*	p = m_first;
	while( p != 0 )
	{
		UndoNode*	n = p->m_next;
		delete p;
		p	= n;
	}
	m_first		= 0;
	m_current	= 0;
}
//=================================================================================================
IUndoList* Recode()
{
	return &PushNode()->m_undo;
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
