/*************************************************************************************************/
/*!
   	@file		TextFile.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define
enum EncodeType
{
	ShiftJis , 
	UTF8 , 
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

//=================================================================================================
cb_inline
wstring MultiToWide
		(
		const void*	pdata , 
		int			size , 
		EncodeType	type
		)
{
	const unsigned char	*src;
	UINT		code;
	if( type == ShiftJis )
	{
		code	= CP_ACP;
		src		= (const unsigned char*)pdata;
	}
	else if( type == UTF8 )
	{
		code	= CP_UTF8;
		src		= (const unsigned char*)pdata;
		if( size >= 3 && src[0] == 0xEF && src[1] == 0xBB && src[2] == 0xBF )
			src += 3;
 	}
	else
		return wstring();

	int			wnum = ::MultiByteToWideChar( code , 0 , (LPCSTR)src , size , 0 , 0 );
	wchar_t*	p = new wchar_t[ wnum + 1 ];
	::MultiByteToWideChar( code , 0 , (LPCSTR)src , size , p , wnum );
	p[wnum]	= L'\0';

	wstring text( p );
	delete []p;
	return text;
}
//=================================================================================================
cb_inline
bool LoadTextfile
		(
		const wchar_t*	path , 
		EncodeType		encode , 
		wstring&		text
		)
{
	FILE*	fp = 0;
	if( 0 != _wfopen_s( &fp , path , L"rb" ) )
		return false;
	
	// get size
	fseek(fp, 0L, SEEK_END);
	long	size = ftell(fp);
	fseek(fp, 0L, SEEK_SET);

	// read
	unsigned char*	p = new unsigned char[ size ];
	if( size != fread( p , 1 , size , fp ) )
	{
		delete	[]p;
		fclose( fp );
		return false;
	}
	fclose( fp );
  
	// convert encode
	text = MultiToWide( p , size , encode );
	
	// release
	delete []p;
	return true;
}
};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
