#!/usr/bin/env ruby
#
#=TestLinkClient UnitTest
#
# Author::    garyo  (mailto:garyohosu@gmail.com)
# Copyright:: Copyright (c) 2008 garyo
# License::   GPL

$LOAD_PATH << File.dirname(__FILE__) + '/..'
#require 'rubygems'

require 'test/unit'
require '../lib/TestLinkClient.rb'
#require 'TestLinkClient'

ServerURL="http://xxx.xxx.xx.xxx/testlink_18RC1"
Dev_key="413a5f43341axxx76591f166501740ec"

#TestLinkClient̃eXg
class Test_TestLinkClient < Test::Unit::TestCase

  def setup
    @obj = TestLinkClient.new(ServerURL,Dev_key)
    @rtl = TestLinkClient.new(ServerURL,Dev_key)
  end



  # tltestcase:: reportTCResult
  # tlsummary:: call reportTCResult
  # tlsteps:: call reportTCResult
  # tlexpectedresults:: return OK or NG
  # tlkeyword:: API
  # tlnotes:: reportTCResult
  def test_reportTCResult()
    @rtl.reportTCResultByTCName("reportTCResult","Test_TestLinkClient","f")

    pid = @obj.getProjectID
    tpid = @obj.getTestPlanID(pid)
    bid = @obj.getBuildID(tpid)

    ret = @obj.getTestCasesForTestPlan(tpid)
    ret.each{|key,val|
    	tcid = key
	    ret2 = @obj.reportTCResult(tpid,tcid,"p",bid)
      ret2.each{|prj|
        assert_not_nil(prj["message"])
        assert_not_nil(prj["status"])
        assert_not_nil(prj["id"])
      }
      ret2 = @obj.reportTCResult(tpid,tcid,"f",bid,"notes")
      ret2.each{|prj|
        assert_not_nil(prj["message"])
        assert_not_nil(prj["status"])
        assert_not_nil(prj["id"])
      }
      ret2 = @obj.reportTCResult(tpid,tcid,"b",bid,"notes",false)
      ret2.each{|prj|
        assert_not_nil(prj["message"])
        assert_not_nil(prj["status"])
        assert_not_nil(prj["id"])
      }
		}
    @rtl.reportTCResultByTCName("reportTCResult","Test_TestLinkClient","p")
  end



  # tltestcase:: getProjects
  # tlsummary:: call getProjects
  # tlsteps:: call getProjects
  # tlexpectedresults:: return Project Info
  # tlkeyword:: API
  # tlnotes:: getProjects
  def test_getProjects()
    @rtl.reportTCResultByTCName("getProjects","Test_TestLinkClient","f")

    ret = @obj.getProjects
    ret.each{|prj|
      assert_not_nil(prj["name"])
      assert_not_nil(prj["prefix"])
      assert_not_nil(prj["tc_counter"])
      assert_not_nil(prj["option_automation"])
      assert_not_nil(prj["option_priority"])
      assert_not_nil(prj["notes"])
      assert_not_nil(prj["id"])
      assert_not_nil(prj["color"])
      assert_not_nil(prj["option_reqs"])
      assert_not_nil(prj["active"])
	  }
    @rtl.reportTCResultByTCName("getProjects","Test_TestLinkClient","p")
  end

  # tltestcase:: getProjectTestPlans
  # tlsummary:: call getProjectTestPlans
  # tlsteps:: call getProjectTestPlans(pid)
  # tlexpectedresults:: return TestPlans Info
  # tlkeyword:: API
  # tlnotes:: getProjectTestPlans
  def test_getProjectTestPlans()
    @rtl.reportTCResultByTCName("getProjectTestPlans","Test_TestLinkClient","f")

    ret = @obj.getProjects
    ret.each{|prj|
      pid = prj["id"]
      ret1 = @obj.getProjectTestPlans(pid)
      ret1.each{|tpln|
        tpln.each{|key,val|
          assert_not_nil(key)
          assert_not_nil(val["name"])
          assert_not_nil(val["notes"])
          assert_not_nil(val["id"])
          assert_not_nil(val["active"])
        }
      }
	  }
    @rtl.reportTCResultByTCName("getProjectTestPlans","Test_TestLinkClient","p")
  end

  # tltestcase:: createBuild
  # tlsummary:: call createBuild
  # tlsteps:: call getProjects
  # tlexpectedresults:: return Build Info
  # tlkeyword:: API
  # tlnotes:: createBuild
  def test_createBuild()
    @rtl.reportTCResultByTCName("createBuild","Test_TestLinkClient","f")

    day = Time.now

    pid = @obj.getProjectID
    tpid = @obj.getTestPlanID(pid)

    ret = @obj.createBuild(tpid,"build " + day.to_s ,"comment")
    prj=ret[0]
    assert_not_nil(prj["message"])
    assert_not_nil(prj["status"])
    assert_not_nil(prj["id"])

    @rtl.reportTCResultByTCName("createBuild","Test_TestLinkClient","p")
  end

  # tltestcase:: getBuildsForTestPlan
  # tlsummary:: call getBuildsForTestPlan
  # tlsteps:: call getBuildsForTestPlan(tpid)
  # tlexpectedresults:: return Build Info
  # tlkeyword:: API
  # tlnotes:: getBuildsForTestPlan
  def test_getBuildsForTestPlan()
    @rtl.reportTCResultByTCName("getBuildsForTestPlan","Test_TestLinkClient","f")

    ret = @obj.getProjects
    ret.each{|prj|
      pid = prj["id"]
      ret1 = @obj.getProjectTestPlans(pid)
      ret1.each{|tpln|
        tpln.each{|key,val|
          tpid = val["id"]
          ret2 = @obj.getBuildsForTestPlan(tpid)
          ret2.each{|bld|
            assert_not_nil(bld["name"])
            assert_not_nil(bld["notes"])
            assert_not_nil(bld["id"])
            assert_not_nil(bld["testplan_id"])
            assert_not_nil(bld["active"])
          }
        }
      }
	  }
    @rtl.reportTCResultByTCName("getBuildsForTestPlan","Test_TestLinkClient","p")
  end

  # tltestcase:: getTestSuitesForTestPlan
  # tlsummary:: call getTestSuitesForTestPlan
  # tlsteps:: call getTestSuitesForTestPlan(tpid)
  # tlexpectedresults:: return TestSuite Info
  # tlkeyword:: API
  # tlnotes:: getTestSuitesForTestPlan
  def test_getTestSuitesForTestPlan()
    @rtl.reportTCResultByTCName("getTestSwiteID","Test_TestLinkClient","f")

    ret = @obj.getProjects
    ret.each{|prj|
      pid = prj["id"]
      ret1 = @obj.getProjectTestPlans(pid)
      ret1.each{|tpln|
        tpln.each{|key,val|
          tpid = val["id"]
          ret2 = @obj.getTestSuitesForTestPlan(tpid)
          ret2.each{|tsut|
            assert_not_nil(tsut["name"])
            assert_not_nil(tsut["id"])
          }
        }
      }
	  }
    @rtl.reportTCResultByTCName("getTestSwiteID","Test_TestLinkClient","p")
  end


  # tltestcase:: getTestCasesForTestSuite
  # tlsummary:: call getTestCasesForTestSuite
  # tlsteps:: call getTestCasesForTestSuite(ts)
  # tlexpectedresults:: return TestCase Info
  # tlkeyword:: API
  # tlnotes:: getTestCasesForTestSuite
  def test_getTestCasesForTestSuite()
    @rtl.reportTCResultByTCName("getTestCasesForTestSuite","Test_TestLinkClient","f")

    pid = @obj.getProjectID
    tpid = @obj.getTestPlanID(pid)
    bid = @obj.getBuildID(tpid)

    ts = @obj.getTestSuitesForTestPlan(tpid)
    
    ts.each{|t|
      ret = @obj.getTestCasesForTestSuite(t["id"])
      ret.each{|tc|
        assert_not_nil(tc["name"])
        assert_not_nil(tc["id"])
        assert_not_nil(tc["node_type_id"])
        assert_not_nil(tc["parent_id"])
        assert_not_nil(tc["node_order"])
      }
    }
    @rtl.reportTCResultByTCName("getTestCasesForTestSuite","Test_TestLinkClient","p")
  end


  # tltestcase:: getTestCasesForTestPlan
  # tlsummary:: call getTestCasesForTestPlan
  # tlsteps:: call getTestCasesForTestPlan(tpid)
  # tlexpectedresults:: return TestCase Info
  # tlkeyword:: API
  # tlnotes:: getTestCasesForTestPlan
  def test_getTestCasesForTestPlan()
    @rtl.reportTCResultByTCName("test_getTestCasesForTestPlan","Test_TestLinkClient","f")

    ret = @obj.getProjects
    ret.each{|prj|
      pid = prj["id"]
      ret1 = @obj.getProjectTestPlans(pid)
      ret1.each{|tpln|
        tpln.each{|key,val|
          tpid = val["id"]
          ret2 = @obj.getTestCasesForTestPlan(tpid)
          ret2.each{|key,val|
            assert_not_nil(val["exec_status"])
            assert_not_nil(val["status"])
            assert_not_nil(val["name"])
            assert_not_nil(val["assigner_id"])
            assert_not_nil(val["urgency"])
            assert_not_nil(val["exec_id"])
            assert_not_nil(val["type"])
            assert_not_nil(val["exec_on_tplan"])
            assert_not_nil(val["executed"])
            assert_not_nil(val["external_id"])
            assert_not_nil(val["z"])
            assert_not_nil(val["tc_id"])
            assert_not_nil(val["version"])
            assert_not_nil(val["tcversion_id"])
            assert_not_nil(val["execution_order"])
            assert_not_nil(val["user_id"])
            assert_not_nil(val["feature_id"])
            assert_not_nil(val["tcversion_number"])
            assert_not_nil(val["testsuite_id"])
            assert_not_nil(val["active"])
          }
        }
      }
	  }
    @rtl.reportTCResultByTCName("test_getTestCasesForTestPlan","Test_TestLinkClient","p")
  end

  # tltestcase:: getTestCaseIDByName
  # tlsummary:: call getTestCaseIDByName
  # tlsteps:: call getTestCaseIDByName(name)
  # tlexpectedresults:: return TestCase ID
  # tlkeyword:: API
  # tlnotes:: getTestCaseIDByName
  def test_getTestCaseIDByName()
    @rtl.reportTCResultByTCName("getTestCaseIDByName","Test_TestLinkClient","f")

    ret = @obj.getProjects
    ret.each{|prj|
      pid = prj["id"]
      ret1 = @obj.getProjectTestPlans(pid)
      ret1.each{|tpln|
        tpln.each{|key,val|
          tpid = val["id"]
          ret2 = @obj.getTestCasesForTestPlan(tpid)
          ret2.each{|key,val|

            tcID= @obj.getTestCaseIDByName(val["name"])
            tcID.each{|tc1|
              if tc1["id"] then
                if tc1["id"] == val["tc_id"] then
                  assert(true)
                end
              end
            }
          }
        }
      }
	  }

    @rtl.reportTCResultByTCName("getTestCaseIDByName","Test_TestLinkClient","p")
  end

  # tltestcase:: createTestCase
  # tlsummary:: call createTestCase
  # tlsteps:: call createTestCase()
  # tlexpectedresults:: return 
  # tlkeyword:: API
  # tlnotes:: createTestCase
  def test_createTestCase()
    @rtl.reportTCResultByTCName("createTestCase","Test_TestLinkClient","f")

    ret = @obj.createTestCase #
    p ret
    assert(false)

    @rtl.reportTCResultByTCName("createTestCase","Test_TestLinkClient","p")
  end
  
  # tltestcase:: createTestProject
  # tlsummary:: call createTestProject
  # tlsteps:: call createTestProject()
  # tlexpectedresults:: return 
  # tlkeyword:: API
  # tlnotes:: createTestProject
  def test_createTestProject()
    @rtl.reportTCResultByTCName("createTestProject","Test_TestLinkClient","f")

    ret = @obj.createTestProject #
    p ret
    assert(false)

    @rtl.reportTCResultByTCName("createTestProject","Test_TestLinkClient","p")
  end
  

  # tltestcase:: getTestCaseCustomFieldDesignValue
  # tlsummary:: call getTestCaseCustomFieldDesignValue
  # tlsteps:: call getTestCaseCustomFieldDesignValue()
  # tlexpectedresults:: return 
  # tlkeyword:: API
  # tlnotes:: getTestCaseCustomFieldDesignValue
  def test_getTestCaseCustomFieldDesignValue()
    @rtl.reportTCResultByTCName("getTestCaseCustomFieldDesignValue","Test_TestLinkClient","f")

    ret = @obj.getTestCaseCustomFieldDesignValue
    p ret
    assert(false)

    @rtl.reportTCResultByTCName("getTestCaseCustomFieldDesignValue","Test_TestLinkClient","p")
  end

  # tltestcase:: about
  # tlsummary:: call about
  # tlsteps:: call about
  # tlexpectedresults:: return about message
  # tlkeyword:: API
  # tlnotes:: about
  def test_about()
    @rtl.reportTCResultByTCName("about","Test_TestLinkClient","f")

    ret = @obj.about
    assert_equal(" Testlink API Version: 1.0 Beta 3 written by Asiel Brumfield\n contribution by TestLink development Team",ret)

    @rtl.reportTCResultByTCName("about","Test_TestLinkClient","p")
  end

  # tltestcase:: sayHello
  # tlsummary:: call sayHello
  # tlsteps:: call sayHello
  # tlexpectedresults:: return "Hello!"
  # tlkeyword:: API
  # tlnotes:: sayHello
  def test_sayHello()
    @rtl.reportTCResultByTCName("sayHello","Test_TestLinkClient","f")

    ret = @obj.sayHello
    assert_equal("Hello!",ret)

    @rtl.reportTCResultByTCName("sayHello","Test_TestLinkClient","p")
  end

  # tltestcase:: repeat
  # tlsummary:: call repeat
  # tlsteps:: call repeat("message")
  # tlexpectedresults:: return "message"
  # tlkeyword:: API
  # tlnotes:: repeat
  def test_repeat()
    @rtl.reportTCResultByTCName("repeat","Test_TestLinkClient","f")

    ret = @obj.repeat("message")
    assert_equal("You said: message",ret)

    @rtl.reportTCResultByTCName("repeat","Test_TestLinkClient","p")
  end

  # tltestcase:: getProjectID
  # tlsummary:: call getProjectID
  # tlsteps:: call getProjectID()
  # tlexpectedresults:: return ProjectID
  # tlkeyword:: API
  # tlnotes:: getProjectID
  def test_getProjectID()
    @rtl.reportTCResultByTCName("getProjectID","Test_TestLinkClient","f")

    ret = @obj.getProjectID()
    assert_not_nil(ret)

    @rtl.reportTCResultByTCName("getProjectID","Test_TestLinkClient","p")
  end

  # tltestcase:: getTestPlanID
  # tlsummary:: call getTestPlanID
  # tlsteps:: call getTestPlanID()
  # tlexpectedresults:: return TestPlanID
  # tlkeyword:: API
  # tlnotes:: getTestPlanID
  def test_getTestPlanID()
    @rtl.reportTCResultByTCName("getTestPlanID","Test_TestLinkClient","f")

    pid = @obj.getProjectID()
    ret = @obj.getTestPlanID(pid)
    assert_not_nil(ret)

    @rtl.reportTCResultByTCName("getTestPlanID","Test_TestLinkClient","p")
  end

  # tltestcase:: getBuildID
  # tlsummary:: call getBuildID
  # tlsteps:: call getBuildID()
  # tlexpectedresults:: return getBuildID
  # tlkeyword:: API
  # tlnotes:: getBuildID
  def test_getBuildID()
    @rtl.reportTCResultByTCName("getBuildID","Test_TestLinkClient","f")
    
    pid = @obj.getProjectID
    tpid = @obj.getTestPlanID(pid)
    bid = @obj.getBuildID(tpid)

    assert_not_nil(bid)

    @rtl.reportTCResultByTCName("getBuildID","Test_TestLinkClient","p")
  end

  # tltestcase:: reportTCResultByTCName
  # tlsummary:: call reportTCResultByTCName
  # tlsteps:: call reportTCResultByTCName()
  # tlexpectedresults:: return OK or NG
  # tlkeyword:: API
  # tlnotes:: reportTCResultByTCName
  def test_reportTCResultByTCName()
    @rtl.reportTCResultByTCName("reportTCResultByTCName","Test_TestLinkClient","f")

    ret = @obj.reportTCResultByTCName("sayHello","Test_TestLinkClient","p")
    assert_not_nil(ret[0]["message"])
    assert_not_nil(ret[0]["status"])
    assert_not_nil(ret[0]["id"])

    @rtl.reportTCResultByTCName("reportTCResultByTCName","Test_TestLinkClient","p")
  end

  # tltestcase:: getStatusByTCName
  # tlsummary:: call getStatusByTCName
  # tlsteps:: call getStatusByTCName()
  # tlexpectedresults:: return status
  # tlkeyword:: API
  # tlnotes:: getStatusByTCName
  def test_getStatusByTCName()
    @rtl.reportTCResultByTCName("getStatusByTCName","Test_TestLinkClient","f")

    ret = @obj.reportTCResultByTCName("sayHello","Test_TestLinkClient","f")
    ret = @obj.getStatusByTCName("sayHello","Test_TestLinkClient")
    assert_equal("f",ret)

    ret = @obj.reportTCResultByTCName("sayHello","Test_TestLinkClient","p")
    ret = @obj.getStatusByTCName("sayHello","Test_TestLinkClient")
    assert_equal("p",ret)

    @rtl.reportTCResultByTCName("getStatusByTCName","Test_TestLinkClient","p")
  end
  
end
