#!/usr/bin/env ruby 

require 'xmlrpc/client'
class TestlinkAPIClient  

  def initialize(server_url,dev_key)
    @server = XMLRPC::Client.new2(server_url + "/lib/api/xmlrpc.php")
    @devKey = dev_key
  end

  def getProjectID
    args = {"devKey"=>@devKey}
    ret = @server.call("tl.getProjects",args)
    ret.each{|prj|
      if prj["active"] == "1" then
         return prj["id"]
      end
    }
    raise "ProjectID error"
  end

  def getTestPlanID(pid)
    args = {"devKey"=>@devKey,"testprojectid"=>pid}     
    ret = @server.call("tl.getProjectTestPlans",args)
    ret.each{|tp|
      tp.each{|id,val|
        if val["active"] == "1" then
          return val["id"]
        end
      }
    }
    raise "TestPlanID error"
  end

  def getBuildID(tpid)
    args = {"devKey"=>@devKey,"testplanid"=>tpid}     
    ret = @server.call("tl.getBuildsForTestPlan",args)
    ret.each{|val|
      if val["active"] == "1" then
        return val["id"]
      end
    }
    raise "BuildID error"
  end  

  def getTestSwiteID(tpid)
    args = {"devKey"=>@devKey,"testplanid"=>tpid}     
    ret = @server.call("tl.getTestSuitesForTestPlan",args)
  end  

  def getTestSuitesForTestPlan(tpid)
    args = {"devKey"=>@devKey,"testplanid"=>tpid}     
    ret = @server.call("tl.getTestSuitesForTestPlan",args)
  end  

  def getTestCasesForTestSuite(ts)
    args = {"devKey"=>@devKey,"testsuiteid"=>ts}     
    ret = @server.call("tl.getTestCasesForTestSuite",args)
  end  

  def getTestCasesForTestPlan(tpid)
    args = {"devKey"=>@devKey,"testplanid"=>tpid}     
    ret = @server.call("tl.getTestCasesForTestPlan",args)
  end  

  def getTestCaseIDByName(name)
    args = {"devKey"=>@devKey,"testcasename"=>name}     
    ret = @server.call("tl.getTestCaseIDByName",args)
  end  

  def getTestCaseIDByNameWithSuiteName(name,testsuitename)
    args = {"devKey"=>@devKey,"testcasename"=>name,"testsuitename"=>testsuitename}
    ret = @server.call("tl.getTestCaseIDByName",args)
  end  

  def reportTCResult(tpid,bid,tcid,status)
    args = {"devKey"=>@devKey,"testcaseid"=>tcid.to_i,"testplanid"=>tpid,"status"=>status,"buildid"=>bid}
    ret = @server.call("tl.reportTCResult",args)
  end  

end

SERVER_URL = 0
DEV_KEY = 1
TESTCASE_STATUS = 2
TESTCASE_NAME = 3
TESTSUITE_NAME = 4

if ARGV.size == TESTCASE_NAME + 1 or ARGV.size == TESTSUITE_NAME + 1 then

  client = TestlinkAPIClient.new(ARGV[SERVER_URL],ARGV[DEV_KEY])
  pid = client.getProjectID
  tpid = client.getTestPlanID(pid)
  bid = client.getBuildID(tpid)

  if ARGV.size == TESTSUITE_NAME + 1 then
    ret = client.getTestCaseIDByNameWithSuiteName(ARGV[TESTCASE_NAME],ARGV[TESTSUITE_NAME])
  else
    ret = client.getTestCaseIDByName(ARGV[TESTCASE_NAME])
  end
  tcInfo = ret[0]
  tcid = tcInfo["id"]
  ret = client.reportTCResult(tpid,bid,tcid,ARGV[TESTCASE_STATUS])
 	p ret
	
  if ret[0]["status"] == true then
    exit(0)
  else
    exit(1)
  end
else
  puts "USAGE #{File::basename($0)} serverURL dev_key status(p or f or b) testcase_name [testsuite_name]"
  exit(2)
end
