#
#=RubyToXML UnitTest
#
# Author::    garyo  (mailto:garyohosu@gmail.com)
# Copyright:: Copyright (c) 2007 garyo
# License::   GPL
$LOAD_PATH << File.dirname(__FILE__) + '/..'
require 'test/unit'
require '../rubytoxml'

#RubyToXML̃eXg
class Test_RubyToXML < Test::Unit::TestCase

	def setup
		@obj = RubyToXML.new
	end

	# @tltestcase ǂݍ݃t@CmF
	# @tlsummary t@Cǂݍ
	# @tlsteps t@Cw肵t@Cǂݍ
	# @tlexpectedresults t@Cݒ肳邱
	# @tlkeyword FILE
	# @tlnotes t@C֘A
	def test_load_file_title()
    tf="testfile.txt"
    open(tf,"w"){|f|
      f.puts "test"
    }
    @obj.load_file(tf)
    assert_equal(tf,@obj.filename)
	end

	# @tltestcase ǂݍ݃t@CmF
	# @tlsummary t@Cǂݍ
	# @tlsteps t@Cw肵t@Cǂݍ
	# @tlexpectedresults ǂݍ񂾃t@C̒l
	# @tlkeyword FILE
	# @tlnotes t@C֘A
	def test_load_file()
    tf="testfile.txt"
    tt="test\ntest2"
    open(tf,"w"){|f|
      f.puts tt
    }
    @obj.load_file(tf)
    assert_equal(tt,@obj.file.chop)
	end

	# @tltestcase eXgP[XϊmFP
	# @tlsummary eXgP[Xǂ݂
	# @tlsteps ϊeLXg^
	# @tlexpectedresults eXgP[XԂ邱
	# @tlkeyword CONVERT
	# @tlnotes ϊ֘A
	def test_convert_1()
    a=[]

    a[0]="tltestcase1"
    a[1]="tlsummary1"
    a[2]="tlsteps1"
    a[3]="tlexpectedresults1"
    a[4]="tlkeyword1"
    a[5]="tlnotes1"

    pf="@"

    testString="# #{pf}tltestcase #{a[0]}\n# #{pf}tlsummary #{a[1]}\n# #{pf}tlsteps  #{a[2]}\n# #{pf}tlexpectedresults #{a[3]}\n# #{pf}tlkeyword #{a[4]}\n# #{pf}tlnotes #{a[5]}\n"
    bb=@obj.convert(testString)

    if bb then
      bb.each{|b|
        a.each_with_index{|c,i|
          assert_equal(c,b.getdata(i))
        }
      }
    end
  end

	# @tltestcase eXgP[XϊmFPO
	# @tlsummary eXgP[Xǂ݂
	# @tlsteps ϊeLXg^
	# @tlexpectedresults eXgP[XԂ邱
	# @tlkeyword CONVERT
	# @tlnotes ϊ֘A
	def test_convert_n()

    n=10

    testString=""
    aa=[]
    n.times{|i|
      a=[]

      a[0]="tltestcase#{i}"
      a[1]="tlsummary#{i}"
      a[2]="tlsteps#{i}"
      a[3]="tlexpectedresults#{i}"
      a[4]="tlkeyword#{i}"
      a[5]="tlnotes#{i}"

      pf="@"

      testString += "# #{pf}tltestcase #{a[0]}\n# #{pf}tlsummary #{a[1]}\n# #{pf}tlsteps  #{a[2]}\n# #{pf}tlexpectedresults #{a[3]}\n# #{pf}tlkeyword #{a[4]}\n# #{pf}tlnotes #{a[5]}\n"
      aa << a
    }
    bb=@obj.convert(testString)

    aabb=aa.zip(bb)

    aabb.each{|a,b|
      a.each_with_index{|c,i|
        assert_equal(c,b.getdata(i))
      }
    }
  end

	# @tltestcase t@C̕ۑmF
	# @tlsummary t@Cۑ邱
	# @tlsteps t@Cۑ
	# @tlexpectedresults t@Cۑ邱
	# @tlkeyword FILE
	# @tlnotes t@C֘A
	def test_save_file()
    testString="TESTMessage"
    filename="testprog"
    
    b=@obj.save_file("#{filename}.rb",testString)
    open("#{filename}.xml"){|f|
      while s=f.gets
        assert_equal(testString,s)
      end
    }
  end
  
	# @tltestcase t@CϊmF
	# @tlsummary t@Cϊ邱
	# @tlsteps ϊt@Cݒ
	# @tlexpectedresults t@CϊEۑ邱
	# @tlkeyword FILE
	# @tlnotes t@C֘A
	def test_conv_name_file()
    @obj.main("test_rubytoxml.rb")
    r = FileTest.exist? "test_rubytoxml.xml"
    assert(r)
  end  

	# @tltestcase t@CϊmF
	# @tlsummary t@Cϊ邱
	# @tlsteps ϊt@Cݒ
	# @tlexpectedresults t@CϊEۑ邱
	# @tlkeyword FILE
	# @tlnotes t@C֘A
	def test_conv_name_file()
    @obj.main("sample.rb")
    r = FileTest.exist? "sample.xml"
    assert(r)
  end  


end
