/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action.handler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.terasoluna.fw.web.struts.form.ValidatorActionFormEx;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.springframework.web.context.WebApplicationContext;

public class ProcessActionFormStub implements ProcessActionForm {

    private ActionForm actionForm = new ValidatorActionFormEx();
    
    public ActionForm processActionForm(HttpServletRequest req,
            HttpServletResponse res, ActionMapping mapping,
            ActionServlet servlet, WebApplicationContext wac) {
        return getActionForm();
    }

    public boolean supports(HttpServletRequest req, HttpServletResponse res,
            ActionMapping mapping, ActionServlet servlet,
            WebApplicationContext wac) {
        return true;
    }

    public int getOrder() {
        return 0;
    }

    /**
     * @return the actionForm
     */
    public ActionForm getActionForm() {
        return actionForm;
    }

    /**
     * @param actionForm the actionForm to set
     */
    public void setActionForm(ActionForm actionForm) {
        this.actionForm = actionForm;
    }

}
